/* DUPLICATOR MYSQL SCRIPT CREATED ON : January 7, 2015, 11:05 pm */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=511 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=156 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `name` (`name`),
  KEY `slug` (`slug`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20150107_carsblogeverythingyoushould", "54adbba95381c4249150107230513", "20", "2015-01-07 23:05:27", "admin", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:1;s:4:\"Name\";s:36:\"20150107_carsblogeverythingyoushould\";s:4:\"Hash\";s:29:\"54adbba95381c4249150107230513\";s:8:\"NameHash\";s:66:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513\";s:7:\"Version\";s:6:\"0.5.10\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/home1/anton241/public_html/demobay.info/cars/wp-snapshots/tmp\";s:8:\"StoreURL\";s:38:\"http://demobay.info/cars/wp-snapshots/\";s:8:\"ScanFile\";s:76:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";s:78:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/home1/anton241/public_html/demobay.info/cars\";s:4:\"Size\";i:0;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:36:\"20150107_carsblogeverythingyoushould\";s:4:\"Hash\";s:29:\"54adbba95381c4249150107230513\";s:8:\"NameHash\";s:66:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513\";s:7:\"Version\";s:6:\"0.5.10\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/home1/anton241/public_html/demobay.info/cars/wp-snapshots/tmp\";s:8:\"StoreURL\";s:38:\"http://demobay.info/cars/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:80:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:30;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:79:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";r:45;s:8:\"Database\";r:57;}");

/* INSERT TABLE DATA: wp_links */
INSERT INTO `wp_links` VALUES("1", "http://codex.wordpress.org/", "Documentation", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("2", "http://wordpress.org/news/", "WordPress Blog", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "http://wordpress.org/news/feed/");
INSERT INTO `wp_links` VALUES("3", "http://wordpress.org/extend/ideas/", "Suggest Ideas", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("4", "http://wordpress.org/support/", "Support Forum", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("5", "http://wordpress.org/extend/plugins/", "Plugins", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("6", "http://wordpress.org/extend/themes/", "Themes", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");
INSERT INTO `wp_links` VALUES("7", "http://planet.wordpress.org/", "WordPress Planet", "", "", "", "Y", "1", "0", "0000-00-00 00:00:00", "", "", "");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://demobay.info/cars", "yes");
INSERT INTO `wp_options` VALUES("2", "blogname", "Cars Blog | Everything You should Know about Cars", "yes");
INSERT INTO `wp_options` VALUES("3", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("4", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("5", "admin_email", "plrboy@plrtruoi654boy.com", "yes");
INSERT INTO `wp_options` VALUES("6", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("7", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("8", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("9", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("12", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("13", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("17", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("18", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("19", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("29", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("30", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("31", "permalink_structure", "", "yes");
INSERT INTO `wp_options` VALUES("32", "gzipcompression", "0", "yes");
INSERT INTO `wp_options` VALUES("33", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("34", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("35", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("36", "active_plugins", "a:7:{i:0;s:19:\"akismet/akismet.php\";i:1;s:48:\"clickbank-ads-clickbank-widget/clickbank-ads.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:44:\"featured-content-gallery/content-gallery.php\";i:4;s:33:\"privacy-policy/privacy-policy.php\";i:5;s:23:\"tubepress/tubepress.php\";i:6;s:34:\"wp-contact-form/wp-contactform.php\";}", "yes");
INSERT INTO `wp_options` VALUES("37", "home", "http://demobay.info/cars", "yes");
INSERT INTO `wp_options` VALUES("38", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("39", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("40", "advanced_edit", "0", "yes");
INSERT INTO `wp_options` VALUES("41", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("42", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("45", "template", "Cars", "yes");
INSERT INTO `wp_options` VALUES("46", "stylesheet", "Cars", "yes");
INSERT INTO `wp_options` VALUES("47", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("49", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("51", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("52", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("53", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("54", "db_version", "30133", "yes");
INSERT INTO `wp_options` VALUES("55", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "upload_path", "wp-content/uploads", "yes");
INSERT INTO `wp_options` VALUES("57", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("58", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("59", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("60", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("61", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("62", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("63", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("64", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("65", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("66", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("67", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("68", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("69", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("72", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("73", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("74", "image_default_link_type", "file", "yes");
INSERT INTO `wp_options` VALUES("75", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("76", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("77", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("78", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("79", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("80", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("81", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("83", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("84", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("85", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("86", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("87", "widget_text", "a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("88", "widget_rss", "a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("89", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("91", "embed_size_w", "", "yes");
INSERT INTO `wp_options` VALUES("92", "embed_size_h", "600", "yes");
INSERT INTO `wp_options` VALUES("93", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("94", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("95", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:7:{i:0;s:7:\"pages-2\";i:1;s:10:\"calendar-2\";i:2;s:7:\"links-2\";i:3;s:6:\"text-2\";i:4;s:5:\"rss-2\";i:5;s:11:\"tag_cloud-2\";i:6;s:10:\"nav_menu-2\";}s:19:\"primary-widget-area\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_pages", "a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_calendar", "a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_links", "a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_tag_cloud", "a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_nav_menu", "a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("175", "current_theme", "Revolution Lifestyle", "yes");
INSERT INTO `wp_options` VALUES("135", "cron", "a:5:{i:1420673663;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1420673689;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1420679041;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"32b7e32f14df1bb8be86a2080c8859d5\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:65;}}}}i:1420701960;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("439", "WPLANG", "", "yes");
INSERT INTO `wp_options` VALUES("440", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("498", "_site_transient_timeout_theme_roots", "1420673609", "yes");
INSERT INTO `wp_options` VALUES("499", "_site_transient_theme_roots", "a:8:{s:4:\"Cars\";s:7:\"/themes\";s:7:\"classic\";s:7:\"/themes\";s:7:\"default\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:9:\"twentyten\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}", "yes");
INSERT INTO `wp_options` VALUES("184", "privacy_policy_contact", "plrboy@plrtruoi654boy.com", "yes");
INSERT INTO `wp_options` VALUES("185", "privacy_policy_title", "Privacy Policy", "yes");
INSERT INTO `wp_options` VALUES("186", "privacy_policy_slug", "privacy-policy", "yes");
INSERT INTO `wp_options` VALUES("187", "privacy_policy_pp_help", "1", "yes");
INSERT INTO `wp_options` VALUES("188", "privacy_policy_browser_help", "1", "yes");
INSERT INTO `wp_options` VALUES("189", "privacy_policy_credit", "1", "yes");
INSERT INTO `wp_options` VALUES("190", "tubepress-version", "200", "yes");
INSERT INTO `wp_options` VALUES("142", "dashboard_widget_options", "a:4:{s:25:\"dashboard_recent_comments\";a:1:{s:5:\"items\";i:5;}s:24:\"dashboard_incoming_links\";a:5:{s:4:\"home\";s:30:\"http://mywaytoprofits.com/cars\";s:4:\"link\";s:106:\"http://blogsearch.google.com/blogsearch?scoring=d&partner=wordpress&q=link:http://mywaytoprofits.com/cars/\";s:3:\"url\";s:139:\"http://blogsearch.google.com/blogsearch_feeds?scoring=d&ie=utf-8&num=10&output=rss&partner=wordpress&q=link:http://mywaytoprofits.com/cars/\";s:5:\"items\";i:10;s:9:\"show_date\";b:0;}s:17:\"dashboard_primary\";a:7:{s:4:\"link\";s:26:\"http://wordpress.org/news/\";s:3:\"url\";s:31:\"http://wordpress.org/news/feed/\";s:5:\"title\";s:14:\"WordPress Blog\";s:5:\"items\";i:2;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;}s:19:\"dashboard_secondary\";a:7:{s:4:\"link\";s:28:\"http://planet.wordpress.org/\";s:3:\"url\";s:33:\"http://planet.wordpress.org/feed/\";s:5:\"title\";s:20:\"Other WordPress News\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("174", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("191", "tubepress-playerColor", "999999", "yes");
INSERT INTO `wp_options` VALUES("192", "tubepress-playerHighlight", "FFFFFF", "yes");
INSERT INTO `wp_options` VALUES("179", "privacy_policy_sitename", "plrboy.com", "yes");
INSERT INTO `wp_options` VALUES("180", "privacy_policy_before_heading", "<h2>", "yes");
INSERT INTO `wp_options` VALUES("181", "privacy_policy_after_heading", "</h2>", "yes");
INSERT INTO `wp_options` VALUES("182", "privacy_policy_before_paragraph", "<p>", "yes");
INSERT INTO `wp_options` VALUES("183", "privacy_policy_after_paragraph", "</p>", "yes");
INSERT INTO `wp_options` VALUES("193", "tubepress-mode", "playlist", "yes");
INSERT INTO `wp_options` VALUES("194", "tubepress-dateFormat", "M j, Y", "yes");
INSERT INTO `wp_options` VALUES("195", "tubepress-keyword", "tubepress", "yes");
INSERT INTO `wp_options` VALUES("196", "tubepress-videoBlacklist", "", "yes");
INSERT INTO `wp_options` VALUES("197", "tubepress-favoritesValue", "mrdeathgod", "yes");
INSERT INTO `wp_options` VALUES("198", "tubepress-playlistValue", "PL3B4866B62FAACC60", "yes");
INSERT INTO `wp_options` VALUES("199", "tubepress-tagValue", "stewart daily show", "yes");
INSERT INTO `wp_options` VALUES("200", "tubepress-userValue", "3hough", "yes");
INSERT INTO `wp_options` VALUES("201", "tubepress-developerKey", "AI39si5uUzupiQW9bpzGqZRrhvqF3vBgRqL-I_28G1zWozmdNJlskzMDQEhpZ-l2RqGf_6CNWooL96oJZRrqKo-eJ9QO_QppMg", "yes");
INSERT INTO `wp_options` VALUES("202", "tubepress-widget-title", "TubePress", "yes");
INSERT INTO `wp_options` VALUES("203", "tubepress-widget-tagstring", "[tubepress thumbHeight=\'105\' thumbWidth=\'135\']", "yes");
INSERT INTO `wp_options` VALUES("204", "tubepress-vimeoUploadedByValue", "mattkaar", "yes");
INSERT INTO `wp_options` VALUES("205", "tubepress-vimeoLikesValue", "coiffier", "yes");
INSERT INTO `wp_options` VALUES("206", "tubepress-vimeoAppearsInValue", "royksopp", "yes");
INSERT INTO `wp_options` VALUES("207", "tubepress-vimeoSearchValue", "cats playing piano", "yes");
INSERT INTO `wp_options` VALUES("208", "tubepress-vimeoCreditedToValue", "patricklawler", "yes");
INSERT INTO `wp_options` VALUES("209", "tubepress-vimeoChannelValue", "splitscreenstuff", "yes");
INSERT INTO `wp_options` VALUES("210", "tubepress-vimeoGroupValue", "hdxs", "yes");
INSERT INTO `wp_options` VALUES("211", "tubepress-vimeoAlbumValue", "140484", "yes");
INSERT INTO `wp_options` VALUES("212", "tubepress-debugging_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("213", "tubepress-randomize_thumbnails", "1", "yes");
INSERT INTO `wp_options` VALUES("214", "tubepress-relativeDates", "", "yes");
INSERT INTO `wp_options` VALUES("215", "tubepress-paginationAbove", "1", "yes");
INSERT INTO `wp_options` VALUES("216", "tubepress-paginationBelow", "1", "yes");
INSERT INTO `wp_options` VALUES("217", "tubepress-ajaxPagination", "", "yes");
INSERT INTO `wp_options` VALUES("218", "tubepress-hqThumbs", "", "yes");
INSERT INTO `wp_options` VALUES("219", "tubepress-autoplay", "", "yes");
INSERT INTO `wp_options` VALUES("220", "tubepress-border", "", "yes");
INSERT INTO `wp_options` VALUES("221", "tubepress-genie", "", "yes");
INSERT INTO `wp_options` VALUES("222", "tubepress-loop", "", "yes");
INSERT INTO `wp_options` VALUES("223", "tubepress-showInfo", "", "yes");
INSERT INTO `wp_options` VALUES("224", "tubepress-showRelated", "1", "yes");
INSERT INTO `wp_options` VALUES("225", "tubepress-fullscreen", "1", "yes");
INSERT INTO `wp_options` VALUES("226", "tubepress-hd", "", "yes");
INSERT INTO `wp_options` VALUES("227", "tubepress-author", "", "yes");
INSERT INTO `wp_options` VALUES("228", "tubepress-category", "", "yes");
INSERT INTO `wp_options` VALUES("229", "tubepress-description", "", "yes");
INSERT INTO `wp_options` VALUES("230", "tubepress-id", "", "yes");
INSERT INTO `wp_options` VALUES("231", "tubepress-length", "1", "yes");
INSERT INTO `wp_options` VALUES("232", "tubepress-rating", "", "yes");
INSERT INTO `wp_options` VALUES("233", "tubepress-ratings", "", "yes");
INSERT INTO `wp_options` VALUES("234", "tubepress-tags", "", "yes");
INSERT INTO `wp_options` VALUES("235", "tubepress-title", "1", "yes");
INSERT INTO `wp_options` VALUES("236", "tubepress-uploaded", "", "yes");
INSERT INTO `wp_options` VALUES("237", "tubepress-url", "", "yes");
INSERT INTO `wp_options` VALUES("238", "tubepress-views", "1", "yes");
INSERT INTO `wp_options` VALUES("239", "tubepress-likes", "", "yes");
INSERT INTO `wp_options` VALUES("240", "tubepress-cacheEnabled", "", "yes");
INSERT INTO `wp_options` VALUES("241", "tubepress-embeddableOnly", "1", "yes");
INSERT INTO `wp_options` VALUES("242", "tubepress-descriptionLimit", "80", "yes");
INSERT INTO `wp_options` VALUES("243", "tubepress-resultsPerPage", "20", "yes");
INSERT INTO `wp_options` VALUES("244", "tubepress-thumbHeight", "90", "yes");
INSERT INTO `wp_options` VALUES("245", "tubepress-thumbWidth", "120", "yes");
INSERT INTO `wp_options` VALUES("246", "tubepress-embeddedHeight", "350", "yes");
INSERT INTO `wp_options` VALUES("247", "tubepress-embeddedWidth", "425", "yes");
INSERT INTO `wp_options` VALUES("248", "tubepress-resultCountCap", "300", "yes");
INSERT INTO `wp_options` VALUES("249", "tubepress-most_viewedValue", "today", "yes");
INSERT INTO `wp_options` VALUES("250", "tubepress-top_ratedValue", "today", "yes");
INSERT INTO `wp_options` VALUES("251", "tubepress-orderBy", "viewCount", "yes");
INSERT INTO `wp_options` VALUES("252", "tubepress-playerLocation", "normal", "yes");
INSERT INTO `wp_options` VALUES("253", "tubepress-filter_racy", "moderate", "yes");
INSERT INTO `wp_options` VALUES("254", "tubepress-playerImplementation", "default", "yes");
INSERT INTO `wp_options` VALUES("255", "gallery-width", "590", "yes");
INSERT INTO `wp_options` VALUES("256", "gallery-height", "200", "yes");
INSERT INTO `wp_options` VALUES("257", "gallery-info", "75", "yes");
INSERT INTO `wp_options` VALUES("258", "gallery-items", "3", "yes");
INSERT INTO `wp_options` VALUES("259", "gallery-border-color", "", "yes");
INSERT INTO `wp_options` VALUES("260", "gallery-bg-color", "", "yes");
INSERT INTO `wp_options` VALUES("261", "gallery-text-color", "", "yes");
INSERT INTO `wp_options` VALUES("262", "gallery-use-featured-content", "", "yes");
INSERT INTO `wp_options` VALUES("263", "gallery-use-thumb-image", "", "yes");
INSERT INTO `wp_options` VALUES("264", "gallery-way", "old", "yes");
INSERT INTO `wp_options` VALUES("265", "gallery-items-pages", "", "yes");
INSERT INTO `wp_options` VALUES("266", "gallery-category", "Featured", "yes");
INSERT INTO `wp_options` VALUES("267", "gallery-fcg-button", "", "yes");
INSERT INTO `wp_options` VALUES("268", "gallery-fade-duration", "", "yes");
INSERT INTO `wp_options` VALUES("269", "gallery-delay", "", "yes");
INSERT INTO `wp_options` VALUES("270", "gallery-randomize-pages", "", "yes");
INSERT INTO `wp_options` VALUES("271", "gallery-rss-word-quantity", "", "yes");
INSERT INTO `wp_options` VALUES("272", "gallery-default-transaction", "fade", "yes");
INSERT INTO `wp_options` VALUES("275", "revlifestyle_ad_468", "<a href=\\\"http://anton343.hop.clickbank.net/\\\"><img\r\nsrc=\\\"http://startacardetailingbusiness.com/index_files/banner1.jpg\\\" alt=\\\"\\\"\r\nborder=\\\"0\\\" /></a>", "yes");
INSERT INTO `wp_options` VALUES("276", "revlifestyle_ad_120", " <a href=\\\"http://a5f9e6zmwdeq7rdcthqvz3jj76.hop.clickbank.net/\\\">\r\n  <img src=\\\"http://demobay.info/cars/wp-content/uploads/2015/01/120x600.spraypaint.jpg\\\" alt=\\\"demobay\\\" style=\\\"width:120px;height:600px;border:0\\\">\r\n</a> ", "yes");
INSERT INTO `wp_options` VALUES("277", "revlifestyle_adsense_468", "<script type=\\\"text/javascript\\\"><!--\r\ngoogle_ad_client = \\\"pub-8258784798728859\\\";\r\ngoogle_ad_width = 468;\r\ngoogle_ad_height = 60;\r\ngoogle_ad_format = \\\"468x60_as\\\";\r\ngoogle_ad_type = \\\"text_image\\\";\r\ngoogle_ad_channel = \\\"\\\";\r\ngoogle_color_border = \\\"ffffff\\\";\r\ngoogle_color_bg = \\\"FFFFFF\\\";\r\ngoogle_color_link = \\\"0000FF\\\";\r\ngoogle_color_text = \\\"000000\\\";\r\ngoogle_color_url = \\\"008000\\\";\r\n//--></script>\r\n<script type=\\\"text/javascript\\\"\r\nsrc=\\\"http://pagead2.googlesyndication.com/pagead/show_ads.js\\\">\r\n</script>		", "yes");
INSERT INTO `wp_options` VALUES("278", "revlifestyle_adsense_300", "<iframe src=\\\"http://rcm-na.amazon-adsystem.com/e/cm?t=xxadsense-20&o=1&p=12&l=ur1&category=autolong&banner=00J1B6WA8W04Y981EM82&f=ifr&linkID=YHGHDAXSZD4UAJ6B\\\" width=\\\"300\\\" height=\\\"250\\\" scrolling=\\\"no\\\" border=\\\"0\\\" marginwidth=\\\"0\\\" style=\\\"border:none;\\\" frameborder=\\\"0\\\"></iframe>\r\n", "yes");
INSERT INTO `wp_options` VALUES("279", "revlifestyle_video", "<object width=\\\"300\\\" height=\\\"250\\\"><param name=\\\"movie\\\" value=\\\"http://www.youtube.com/v/QibDTrZirBE?fs=1&hl=en_GB&color1=0x3a3a3a&color2=0x999999\\\"></param><param name=\\\"allowFullScreen\\\" value=\\\"true\\\"></param><param name=\\\"allowscriptaccess\\\" value=\\\"always\\\"></param><embed src=\\\"http://www.youtube.com/v/QibDTrZirBE?fs=1&hl=en_GB&color1=0x3a3a3a&color2=0x999999\\\" type=\\\"application/x-shockwave-flash\\\" allowscriptaccess=\\\"always\\\" allowfullscreen=\\\"true\\\" width=\\\"300\\\" height=\\\"250\\\"></embed></object>", "yes");
INSERT INTO `wp_options` VALUES("435", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("436", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("437", "link_manager_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("438", "initial_db_version", "15477", "yes");
INSERT INTO `wp_options` VALUES("432", "auto_core_update_notified", "a:4:{s:4:\"type\";s:6:\"manual\";s:5:\"email\";s:25:\"plrboy@plrtruoi654boy.com\";s:7:\"version\";s:5:\"4.0.1\";s:9:\"timestamp\";i:1420669835;}", "yes");
INSERT INTO `wp_options` VALUES("494", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1420671902;s:7:\"checked\";a:8:{s:4:\"Cars\";s:3:\"1.0\";s:7:\"classic\";s:3:\"1.5\";s:7:\"default\";s:3:\"1.6\";s:13:\"twentyfifteen\";s:3:\"1.0\";s:14:\"twentyfourteen\";s:3:\"1.3\";s:9:\"twentyten\";s:3:\"1.8\";s:14:\"twentythirteen\";s:3:\"1.4\";s:12:\"twentytwelve\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("497", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_options` VALUES("462", "tubepress-https", "", "yes");
INSERT INTO `wp_options` VALUES("463", "tubepress-httpMethod", "GET", "yes");
INSERT INTO `wp_options` VALUES("464", "tubepress-cacheCleaningFactor", "20", "yes");
INSERT INTO `wp_options` VALUES("465", "tubepress-cacheDirectory", "", "yes");
INSERT INTO `wp_options` VALUES("466", "tubepress-cacheLifetimeSeconds", "3600", "yes");
INSERT INTO `wp_options` VALUES("467", "tubepress-autoNext", "1", "yes");
INSERT INTO `wp_options` VALUES("468", "tubepress-enableJsApi", "1", "yes");
INSERT INTO `wp_options` VALUES("469", "tubepress-lazyPlay", "1", "yes");
INSERT INTO `wp_options` VALUES("470", "tubepress-perPageSort", "none", "yes");
INSERT INTO `wp_options` VALUES("471", "tubepress-searchResultsRestrictedToUser", "", "yes");
INSERT INTO `wp_options` VALUES("472", "tubepress-searchProvider", "", "yes");
INSERT INTO `wp_options` VALUES("473", "tubepress-searchResultsOnly", "", "yes");
INSERT INTO `wp_options` VALUES("474", "tubepress-searchResultsUrl", "", "yes");
INSERT INTO `wp_options` VALUES("475", "tubepress-disabledOptionsPageParticipants", "", "yes");
INSERT INTO `wp_options` VALUES("476", "tubepress-fluidThumbs", "1", "yes");
INSERT INTO `wp_options` VALUES("477", "tubepress-theme", "default", "yes");
INSERT INTO `wp_options` VALUES("478", "tubepress-vimeoKey", "", "yes");
INSERT INTO `wp_options` VALUES("479", "tubepress-vimeoSecret", "", "yes");
INSERT INTO `wp_options` VALUES("480", "tubepress-autoHide", "fadeOnlyProgressBar", "yes");
INSERT INTO `wp_options` VALUES("481", "tubepress-youtubeClosedCaptions", "", "yes");
INSERT INTO `wp_options` VALUES("482", "tubepress-youtubeDisableKeyboardControls", "", "yes");
INSERT INTO `wp_options` VALUES("483", "tubepress-modestBranding", "1", "yes");
INSERT INTO `wp_options` VALUES("484", "tubepress-youtubeShowAnnotations", "", "yes");
INSERT INTO `wp_options` VALUES("485", "tubepress-youtubeShowPlayerControls", "showImmediate", "yes");
INSERT INTO `wp_options` VALUES("486", "tubepress-youtubePlayerTheme", "dark", "yes");
INSERT INTO `wp_options` VALUES("487", "tubepress-youtubeMostPopularValue", "today", "yes");
INSERT INTO `wp_options` VALUES("488", "tubepress-youtubeRelatedValue", "P9M__yYbsZ4", "yes");
INSERT INTO `wp_options` VALUES("489", "tubepress-jwPlayerBackColor", "FFFFFF", "yes");
INSERT INTO `wp_options` VALUES("490", "tubepress-jwPlayerFrontColor", "000000", "yes");
INSERT INTO `wp_options` VALUES("491", "tubepress-jwPlayerLightColor", "000000", "yes");
INSERT INTO `wp_options` VALUES("492", "tubepress-jwPlayerScreenColor", "000000", "yes");
INSERT INTO `wp_options` VALUES("441", "_transient_random_seed", "5effe570a4f8a1e2c1355dfde15f0e70", "yes");
INSERT INTO `wp_options` VALUES("496", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.1.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.1-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.1\";s:7:\"version\";s:3:\"4.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1420671902;s:15:\"version_checked\";s:3:\"4.1\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("500", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1420682609", "yes");
INSERT INTO `wp_options` VALUES("501", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:40:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"4851\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3015\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"2967\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2471\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2299\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"1879\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1692\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1646\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1639\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"1623\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1584\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1564\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1469\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1290\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1243\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1158\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1134\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1065\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1051\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:3:\"888\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:3:\"883\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:3:\"864\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"826\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"823\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"772\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"741\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"740\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"694\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"682\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:3:\"662\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"655\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"645\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"640\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"630\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"630\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"616\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"608\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"590\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"583\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"577\";}}", "yes");
INSERT INTO `wp_options` VALUES("443", "_site_transient_timeout_browser_2ecdbfd8102b573d256a595b708fbee8", "1421274759", "yes");
INSERT INTO `wp_options` VALUES("444", "_site_transient_browser_2ecdbfd8102b573d256a595b708fbee8", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"34.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("445", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1420713162", "no");
INSERT INTO `wp_options` VALUES("446", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Dec 2014 18:57:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://wordpress.org/?v=4.2-alpha-31068\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 4.1 “Dinah”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2014/12/dinah/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/news/2014/12/dinah/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Dec 2014 18:35:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3386\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"Version 4.1 of WordPress, named &#8220;Dinah&#8221; in honor of jazz singer Dinah Washington, is available for download or update in your WordPress dashboard. New features in WordPress 4.1 help you focus on your writing, and the new default theme lets you show it off in style. Introducing Twenty Fifteen Our newest default theme, Twenty Fifteen, is [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:24551:\"<p>Version 4.1 of WordPress, named &#8220;Dinah&#8221; in honor of jazz singer <a href=\"http://wikipedia.org/wiki/Dinah_Washington\">Dinah Washington</a>, is available for download or update in your WordPress dashboard. New features in WordPress 4.1 help you focus on your writing, and the new default theme lets you show it off in style.</p>\n<hr />\n<h2 style=\"text-align: center\">Introducing Twenty Fifteen</h2>\n<p><img class=\"aligncenter size-large wp-image-3389\" src=\"https://wordpress.org/news/files/2014/12/2015-laptop-1024x533.png\" alt=\"2015-laptop\" width=\"692\" height=\"360\" /></p>\n<h3>Our newest default theme, Twenty Fifteen, is a blog-focused theme designed for clarity.</h3>\n<p><img class=\"alignright wp-image-3426 size-medium\" src=\"https://wordpress.org/news/files/2014/12/2015-phones-languages-small-300x250.png\" alt=\"\" width=\"300\" height=\"250\" />Twenty Fifteen has flawless language support, with help from <a href=\"https://www.google.com/get/noto/\">Google’s Noto font family</a>.</p>\n<p>The straightforward typography is readable on any screen size.</p>\n<p>Your content always takes center stage, whether viewed on a phone, tablet, laptop, or desktop computer.</p>\n<hr />\n<h2 style=\"text-align: center\">Distraction-free writing</h2>\n<p><img class=\"aligncenter size-large wp-image-3392\" src=\"https://wordpress.org/news/files/2014/12/dfw-screen-1024x614.png\" alt=\"dfw-screen\" width=\"692\" height=\"415\" /></p>\n<h3 style=\"text-align: center\"><em>Just write.</em></h3>\n<p>Sometimes, you just need to concentrate on putting your thoughts into words. Try turning on <strong>distraction-free writing mode</strong>. When you start typing, all the distractions will fade away, letting you focus solely on your writing. All your editing tools instantly return when you need them.</p>\n<hr />\n<h2 style=\"text-align: center\">The Finer Points</h2>\n<h5><strong><img class=\"alignleft wp-image-3405\" src=\"https://wordpress.org/news/files/2014/12/icon-language2.png\" alt=\"\" width=\"80\" height=\"80\" /></strong>Choose a language</h5>\n<p>Right now, WordPress 4.1 is already translated into over forty languages, with more always in progress. You can switch to any translation on the General Settings screen.</p>\n<h5><strong><img class=\"alignleft wp-image-3406\" src=\"https://wordpress.org/news/files/2014/12/icon-logout1.png\" alt=\"\" width=\"80\" height=\"80\" /></strong>Log out everywhere</h5>\n<p>If you’ve ever worried you forgot to sign out from a shared computer, you can now go to your profile and log out everywhere.</p>\n<h5><strong><img class=\"alignleft wp-image-3407\" src=\"https://wordpress.org/news/files/2014/12/icon-vine1.png\" alt=\"\" width=\"80\" height=\"80\" /></strong>Vine embeds</h5>\n<p>Embedding videos from Vine is as simple as pasting a URL onto its own line in a post. See the <a href=\"https://codex.wordpress.org/Embeds\">full list</a> of supported embeds.</p>\n<h5><strong><img class=\"alignleft wp-image-3408\" src=\"https://wordpress.org/news/files/2014/12/icon-recommended1.png\" alt=\"\" width=\"80\" height=\"80\" /></strong>Plugin recommendations</h5>\n<p>The plugin installer suggests plugins for you to try. Recommendations are based on the plugins you and other users have installed.</p>\n<hr />\n<h2 style=\"text-align: center\">Under the Hood</h2>\n<h5>Complex Queries</h5>\n<p>Metadata, date, and term queries now support advanced conditional logic, like nested clauses and multiple operators — <code>A AND ( B OR C )</code>.</p>\n<h5>Customizer API</h5>\n<p>The customizer now supports conditionally showing panels and sections based on the page being previewed.</p>\n<h5><code>&lt;title&gt;</code> tags in themes</h5>\n<p><code>add_theme_support( \'title-tag\' )</code> tells WordPress to handle the complexities of document titles.</p>\n<h5>Developer Reference</h5>\n<p>Continued improvements to inline code documentation have made the <a href=\"https://developer.wordpress.org/reference/\">developer reference</a> more complete than ever.</p>\n<hr />\n<h2 style=\"text-align: center\">The Choir</h2>\n<p>This release was led by <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, with the help of these awesome folks. Check out some of their profiles while listening to Dinah Washington on the music service of your choice:</p>\n<a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/akumria\">akumria</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/collinsinternet\">Allan Collins</a>, <a href=\"https://profiles.wordpress.org/momo360modena\">Amaury Balmer</a>, <a href=\"https://profiles.wordpress.org/amruta123b\">Amruta Bhosale</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andg\">Andrea Gandino</a>, <a href=\"https://profiles.wordpress.org/sumobi\">Andrew Munro (sumobi)</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewryno\">Andrew Ryno</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/ankitgadertcampcom\">Ankit Gade</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/antpb\">antpb</a>, <a href=\"https://profiles.wordpress.org/arippberger\">arippberger</a>, <a href=\"https://profiles.wordpress.org/filosofo\">Austin Matzko</a>, <a href=\"https://profiles.wordpress.org/bainternet\">Bainternet</a>, <a href=\"https://profiles.wordpress.org/barrykooij\">Barry Kooij</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/benjmay\">Ben May</a>, <a href=\"https://profiles.wordpress.org/neoxx\">Bernhard Riedl</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/bramd\">Bram Duvigneau</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/briandichiara\">Brian DiChiara</a>, <a href=\"https://profiles.wordpress.org/rzen\">Brian Richards</a>, <a href=\"https://profiles.wordpress.org/bswatson\">Brian Watson</a>, <a href=\"https://profiles.wordpress.org/camdensegal\">Camden Segal</a>, <a href=\"https://profiles.wordpress.org/captaintheme\">Captain Theme</a>, <a href=\"https://profiles.wordpress.org/hiwhatsup\">Carlos</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/ccprice\">ccprice</a>, <a href=\"https://profiles.wordpress.org/mackensen\">Charles Fulton</a>, <a href=\"https://profiles.wordpress.org/chrico\">ChriCo</a>, <a href=\"https://profiles.wordpress.org/aprea\">Chris Aprea</a>, <a href=\"https://profiles.wordpress.org/chrisbliss18\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/jazzs3quence\">Chris Reynolds</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chrisl27\">chrisl27</a>, <a href=\"https://profiles.wordpress.org/cfoellmann\">Christian Foellmann</a>, <a href=\"https://profiles.wordpress.org/cfinke\">Christopher Finke</a>, <a href=\"https://profiles.wordpress.org/cyclometh\">Corey Snow</a>, <a href=\"https://profiles.wordpress.org/corphi\">Corphi</a>, <a href=\"https://profiles.wordpress.org/curtjen\">curtjen</a>, <a href=\"https://profiles.wordpress.org/colorful-tones\">Damon Cook</a>, <a href=\"https://profiles.wordpress.org/dancameron\">Dan Cameron</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/convissor\">Daniel Convissor</a>, <a href=\"https://profiles.wordpress.org/nerrad\">Darren Ethier (nerrad)</a>, <a href=\"https://profiles.wordpress.org/koop\">Daryl Koopersmith</a>, <a href=\"https://profiles.wordpress.org/dmchale\">Dave McHale</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/davidjlaietta\">David Laietta</a>, <a href=\"https://profiles.wordpress.org/technical_mastermind\">David Wood</a>, <a href=\"https://profiles.wordpress.org/davidthemachine\">DavidTheMachine</a>, <a href=\"https://profiles.wordpress.org/dcavins\">dcavins</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/wedi\">Dirk Weise</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dominikschwind-1\">Dominik Schwind</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dustyf\">Dustin Filippini</a>, <a href=\"https://profiles.wordpress.org/dustinhartzler\">Dustin Hartzler</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ew_holmes\">Eric Holmes</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Lewis</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/florianziegler\">florianziegler</a>, <a href=\"https://profiles.wordpress.org/hereswhatidid\">Gabe Shackle</a>, <a href=\"https://profiles.wordpress.org/garyc40\">Gary Cao</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/babbardel\">George Olaru</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/gregrickaby\">Greg Rickaby</a>, <a href=\"https://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/hardy101\">hardy101</a>, <a href=\"https://profiles.wordpress.org/hauvong\">hauvong</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/heshiming\">heshiming</a>, <a href=\"https://profiles.wordpress.org/honeysilvas\">honeysilvas</a>, <a href=\"https://profiles.wordpress.org/hugodelgado\">hugodelgado</a>, <a href=\"https://profiles.wordpress.org/iandstewart\">Ian Stewart</a>, <a href=\"https://profiles.wordpress.org/ianmjones\">ianmjones</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jaimieolmstead\">jaimieolmstead</a>, <a href=\"https://profiles.wordpress.org/jakubtyrcha\">jakub.tyrcha</a>, <a href=\"https://profiles.wordpress.org/janhenckens\">janhenckens</a>, <a href=\"https://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jwenerd\">Jared Wenerd</a>, <a href=\"https://profiles.wordpress.org/jarednova\">jarednova</a>, <a href=\"https://profiles.wordpress.org/jeanyoungkim\">jeanyoungkim</a>, <a href=\"https://profiles.wordpress.org/jfarthing84\">Jeff Farthing</a>, <a href=\"https://profiles.wordpress.org/jeffstieler\">Jeff Stieler</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/jayjdk\">Jesper Johansen (jayjdk)</a>, <a href=\"https://profiles.wordpress.org/engelen\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jessepollak\">Jesse Pollak</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">jipmoors</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johneckman\">John Eckman</a>, <a href=\"https://profiles.wordpress.org/johnrom\">johnrom</a>, <a href=\"https://profiles.wordpress.org/johnstonphilip\">johnstonphilip</a>, <a href=\"https://profiles.wordpress.org/jb510\">Jon Brown</a>, <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/softmodeling\">Jordi Cabot</a>, <a href=\"https://profiles.wordpress.org/joshuaabenazer\">Joshua Abenazer</a>, <a href=\"https://profiles.wordpress.org/tai\">JOTAKI Taisuke</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/julien731\">Julien Liabeuf</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kamelkev\">kamelkev</a>, <a href=\"https://profiles.wordpress.org/karpstrucking\">karpstrucking</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevinlangleyjr\">Kevin Langley</a>, <a href=\"https://profiles.wordpress.org/kdoran\">Kiko Doran</a>, <a href=\"https://profiles.wordpress.org/kpdesign\">Kim Parsell</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kosvrouvas\">Kostas Vrouvas</a>, <a href=\"https://profiles.wordpress.org/kraftner\">kraftner</a>, <a href=\"https://profiles.wordpress.org/kristastevens\">kristastevens</a>, <a href=\"https://profiles.wordpress.org/kurtpayne\">Kurt Payne</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/offereins\">Laurens Offereins</a>, <a href=\"https://profiles.wordpress.org/linuxologos\">linuxologos</a>, <a href=\"https://profiles.wordpress.org/ideag\">Liuiza Arunas</a>, <a href=\"https://profiles.wordpress.org/loushou\">loushou</a>, <a href=\"https://profiles.wordpress.org/latz\">Lutz Schroer</a>, <a href=\"https://profiles.wordpress.org/manoz69\">Manoz69</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/marcosf\">Marco Schmoecker</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/landakram\">Mark Hudnall</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/senff\">Mark Senff</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/marsjaninzmarsa\">marsjaninzmarsa</a>, <a href=\"https://profiles.wordpress.org/matveb\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattkeys\">mattkeys</a>, <a href=\"https://profiles.wordpress.org/mlteal\">Maura Teal</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/merty\">Mert Yazicioglu</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/tw2113\">Michael Beckwith</a>, <a href=\"https://profiles.wordpress.org/cainm\">Michael Cain</a>, <a href=\"https://profiles.wordpress.org/smashcut\">Michael Pick</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/chellycat\">Michelle Langston</a>, <a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeyarce\">Mikey Arce</a>, <a href=\"https://profiles.wordpress.org/studionashvegas\">Mitch Canter (studionashvegas)</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mvd7793\">mvd7793</a>, <a href=\"https://profiles.wordpress.org/alex-ye\">Nashwan Doaqan</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal (NikV)</a>, <a href=\"https://profiles.wordpress.org/nikolovtmw\">Nikola Nikolov</a>, <a href=\"https://profiles.wordpress.org/nobleclem\">nobleclem</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nvwd\">Nowell VanHoesen</a>, <a href=\"https://profiles.wordpress.org/originalexe\">OriginalEXE</a>, <a href=\"https://profiles.wordpress.org/p_enrique\">p_enrique</a>, <a href=\"https://profiles.wordpress.org/pushplaybang\">Paul</a>, <a href=\"https://profiles.wordpress.org/pauldewouters\">Paul de Wouters</a>, <a href=\"https://profiles.wordpress.org/paulschreiber\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/peterchester\">Peter Chester</a>, <a href=\"https://profiles.wordpress.org/donutz\">Peter J. Herrel</a>, <a href=\"https://profiles.wordpress.org/westi\">Peter Westwood</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/phpmypython\">phpmypython</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/nprasath002\">Prasath Nadarajah</a>, <a href=\"https://profiles.wordpress.org/psycleuk\">psycleuk</a>, <a href=\"https://profiles.wordpress.org/ptahdunbar\">Ptah Dunbar</a>, <a href=\"https://profiles.wordpress.org/quietnic\">quietnic</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/greuben\">Reuben Gunday</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/richardmtl\">Richard Archambault</a>, <a href=\"https://profiles.wordpress.org/rickalee\">Ricky Lee Whittemore</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sakinshrestha\">Sakin Shrestha</a>, <a href=\"https://profiles.wordpress.org/samhotchkiss\">Sam Hotchkiss</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shooper\">Shawn Hooper</a>, <a href=\"https://profiles.wordpress.org/simonp303\">Simon Pollard</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/skaeser\">skaeser</a>, <a href=\"https://profiles.wordpress.org/slobodanmanic\">Slobodan Manic</a>, <a href=\"https://profiles.wordpress.org/socki03\">socki03</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">solarissmoke</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/tacoverdo\">TacoVerdo</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie</a>, <a href=\"https://profiles.wordpress.org/tareq1988\">Tareq Hasan</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/ipm-frommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tillkruess\">Till Kruss</a>, <a href=\"https://profiles.wordpress.org/tschutter\">Tobias Schutter</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tmtrademark\">Toby McKes</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomasm\">Tomas Mackevicius</a>, <a href=\"https://profiles.wordpress.org/tomharrigan\">TomHarrigan</a>, <a href=\"https://profiles.wordpress.org/topher1kenobe\">Topher</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/transom\">transom</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/desaiuditd\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/umeshsingla\">Umesh Kumar</a>, <a href=\"https://profiles.wordpress.org/vinod-dalvi\">Vinod Dalvi</a>, <a href=\"https://profiles.wordpress.org/vlajos\">vlajos</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/nobinobi\">Yuta Sekine</a>, <a href=\"https://profiles.wordpress.org/zrothauser\">Zack Rothauser</a>, and <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>.\n<p>There were 283 contributors to this release, again a new high.</p>\n<p>If you want to help out or follow along, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Thanks for choosing WordPress. Happy holidays and see you next year for version 4.2!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/news/2014/12/dinah/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 4.1 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Dec 2014 02:22:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3411\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:429:\"The next release candidate for WordPress 4.1 is now available for testing. Seventy changes have gone in since the first release candidate. With no known issues left, we plan to release 4.1 tomorrow, December 18. To test, try the WordPress Beta Tester plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can download the release candidate here (zip). If you&#8217;d like to learn more about [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1465:\"<p>The next release candidate for WordPress 4.1 is now available for testing.</p>\n<p><a href=\"https://core.trac.wordpress.org/log/trunk?rev=30961&amp;stop_rev=30827\">Seventy changes</a> have gone in since the <a href=\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate/\">first release candidate</a>. With no known issues left, we plan to release 4.1 tomorrow, December 18.</p>\n<p>To test, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.1-RC3.zip\">download the release candidate here</a> (zip). If you&#8217;d like to learn more about what&#8217;s new in WordPress 4.1, visit the updated About screen in your dashboard (<strong><img src=\"https://i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar) and also check out <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\">the Beta 1 post</a>.</p>\n<p><strong>Plugin authors:</strong> Remember to test your plugins against 4.1, and if they&#8217;re compatible, make sure they are marked as tested up to 4.1. Be sure to follow along the core development blog; we&#8217;ve been posting <a href=\"https://make.wordpress.org/core/tag/4-1-dev-notes/\">notes for developers for 4.1</a> as always.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.1 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Dec 2014 11:52:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3375\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:341:\"The release candidate for WordPress 4.1 is now available. We&#8217;ve made a lot of refinements over the last few weeks. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.1 on Tuesday, December 16, but we need your [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2301:\"<p>The release candidate for WordPress 4.1 is now available.</p>\n<p>We&#8217;ve made a lot of refinements over the last few weeks. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.1 on Tuesday, December 16, but we need your help to get there. If you haven’t tested 4.1 yet, now is the time! (Please though, not on your live site unless you’re adventurous.)</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.1 RC1, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.1-RC1.zip\">download the release candidate here</a> (zip). If you&#8217;d like to learn more about what&#8217;s new in WordPress 4.1, visit the About screen in your dashboard (<strong><img src=\"https://i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar) or check out the <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\">beta announcement</a>.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.1 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.1 before next week. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where we&#8217;ll continue to post <a href=\"https://make.wordpress.org/core/tag/4-1-dev-notes/\">notes for developers</a> for 4.1. (For example: if you&#8217;ve written a child theme for Twenty Fifteen, some of the new pagination functions have been renamed for clarity.)</p>\n<p><em>Testing four point one</em><br />\n<em>Why are we up at this hour?</em><br />\n<em>Code is poetry</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2014/12/wordpress-4-1-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.0.1 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Nov 2014 18:55:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3363\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"WordPress 4.0.1 is now available. This is a critical security release for all previous versions and we strongly encourage you to update your sites immediately. Sites that support automatic background updates will be updated to WordPress 4.0.1 within the next few hours. If you are still on WordPress 3.9.2, 3.8.4, or 3.7.4, you will be [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3395:\"<p>WordPress 4.0.1 is now available. This is a <strong>critical security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>Sites that support automatic background updates will be updated to WordPress 4.0.1 within the next few hours. If you are still on WordPress 3.9.2, 3.8.4, or 3.7.4, you will be updated to 3.9.3, 3.8.5, or 3.7.5 to keep everything secure. (We don’t support older versions, so please update to 4.0.1 for the latest and greatest.)</p>\n<p>WordPress versions 3.9.2 and earlier are affected by a critical cross-site scripting vulnerability, which could enable anonymous users to compromise a site. This was reported by <a href=\"http://klikki.fi/\">Jouko Pynnonen</a>. This issue does not affect version 4.0, but version 4.0.1 does address these eight security issues:</p>\n<ul>\n<li>Three cross-site scripting issues that a contributor or author could use to compromise a site. Discovered by <a href=\"http://joncave.co.uk/\">Jon Cave</a>, <a href=\"http://www.miqrogroove.com/\">Robert Chapin</a>, and <a href=\"https://johnblackbourn.com/\">John Blackbourn</a> of the WordPress security team.</li>\n<li>A cross-site request forgery that could be used to trick a user into changing their password.</li>\n<li>An issue that could lead to a denial of service when passwords are checked. Reported by <a href=\"http://www.behindthefirewalls.com/\">Javier Nieto Arevalo</a> and <a href=\"http://www.devconsole.info/\">Andres Rojas Guerrero</a>.</li>\n<li>Additional protections for server-side request forgery attacks when WordPress makes HTTP requests. Reported by Ben Bidner (vortfu).</li>\n<li>An extremely unlikely hash collision could allow a user&#8217;s account to be compromised, that also required that they haven&#8217;t logged in since 2008 (I wish I were kidding). Reported by <a href=\"http://david.dw-perspective.org.uk\">David Anderson</a>.</li>\n<li>WordPress now invalidates the links in a password reset email if the user remembers their password, logs in, and changes their email address. Reported separately by <a href=\"https://twitter.com/MomenBassel\">Momen Bassel</a>, <a href=\"http://c0dehouse.blogspot.in/\">Tanoy Bose</a>, and <a href=\"https://managewp.com/\">Bojan Slavković of ManageWP</a>.</li>\n</ul>\n<p>Version 4.0.1 also fixes 23 bugs with 4.0, and we&#8217;ve made two hardening changes, including better validation of EXIF data we are extracting from uploaded photos. Reported by <a href=\"http://www.securesolutions.no/\">Chris Andrè Dale</a>.</p>\n<p>We appreciated the <a href=\"https://codex.wordpress.org/FAQ_Security\">responsible disclosure</a> of these issues directly to our security team. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.0.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.0?rev=30475&amp;stop_rev=29710\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.0.1</a> or venture over to <strong>Dashboard → Updates</strong> and simply click “Update Now”.</p>\n<p><em>Already testing WordPress 4.1? The second beta is now available (<a href=\"https://wordpress.org/wordpress-4.1-beta2.zip\">zip</a>) and it contains these security fixes. For more on 4.1, see <a href=\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\">the beta 1 announcement post</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/11/wordpress-4-0-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.1 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Nov 2014 22:35:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3352\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"Welcome, everyone, to WordPress 4.1 Beta 1! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.1, try the WordPress Beta Tester plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3409:\"<p>Welcome, everyone, to WordPress 4.1 Beta 1!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.1, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"//wordpress.org/wordpress-4.1-beta1.zip\">download the beta here</a> (zip).</p>\n<p>WordPress 4.1 is due for release next month, so we need your help with testing. Here are some highlights of what to test:</p>\n<ul>\n<li>Our beautiful new default theme, <a href=\"https://make.wordpress.org/core/2014/09/09/twenty-fifteen/\">Twenty Fifteen</a>. It&#8217;s a clean, mobile-first, blog-focused theme designed through simplicity.</li>\n<li>A new <a href=\"https://make.wordpress.org/core/2014/11/11/focus-v2-demo-video/\">distraction-free writing mode for the editor</a>. It&#8217;s enabled by default for beta, and we&#8217;d love feedback on it.</li>\n<li>The ability to automatically install new language packs right from the General Settings screen (available as long as your site&#8217;s filesystem is writable).</li>\n<li>A new inline formatting toolbar for images embedded into posts.</li>\n</ul>\n<p>There have been a lot of changes for developers to test as well:</p>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2014/10/20/update-on-query-improvements-in-4-1/\">Improvements to meta, date, comment, and taxonomy queries</a>, including complex (nested, multiple relation) queries; and querying comment types (<a href=\"https://core.trac.wordpress.org/ticket/12668\">#12668</a>).</li>\n<li>A single term shared across multiple taxonomies is now split into two when updated. For more, <a href=\"https://make.wordpress.org/core/2014/11/12/an-update-on-the-taxonomy-roadmap/\">see this post</a>, <a href=\"https://core.trac.wordpress.org/ticket/5809\">#5809</a>, and <a href=\"https://core.trac.wordpress.org/ticket/30335\">#30335</a>.</li>\n<li>A new and better way for <a href=\"https://make.wordpress.org/core/2014/10/29/title-tags-in-4-1/\">themes to handle title tags</a>.</li>\n<li>Several <a href=\"https://make.wordpress.org/core/2014/10/27/toward-a-complete-javascript-api-for-the-customizer/\">improvements to the Customizer API</a>, including contextual panels and sections, and JavaScript templates for controls.</li>\n</ul>\n<p>If you want a more in-depth view of what changes have made it into 4.1, <a href=\"https://make.wordpress.org/core/tag/week-in-core/\">check out the weekly review posts</a> on the main development blog.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.1\">everything we’ve fixed</a> so far.</p>\n<p>Happy testing!</p>\n<p><em>Twenty Fifteen theme</em><br />\n<em> The beautiful face which hides</em><br />\n<em> Many improvements</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2014/11/wordpress-4-1-beta-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Watch WordCamp San Francisco Livestream\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/10/wcsf-livestream/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/10/wcsf-livestream/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Oct 2014 20:18:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3341\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordCamp San Francisco is the official annual WordPress conference, gathering the community every year since 2006. This is the time when Matt Mullenweg addresses the community in his annual State of the Word presentation – a recap of  the year in WordPress and giving us a glimpse into its future. This year the speaker lineup is stellar. There will be talks by [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nikolay Bachiyski\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1975:\"<p><a title=\"2014 edition\" href=\"http://2014.sf.wordcamp.org\">WordCamp San Francisco</a> is the official annual WordPress conference, gathering the community every year <a title=\"An old website for a WordPress long time ago\" href=\"http://2006.sf.wordcamp.org\">since 2006</a>. This is the time when Matt Mullenweg addresses the community in his annual <a href=\"http://wordpress.tv/?s=state+of+the+word\">State of the Word</a> presentation – a recap of  the year in WordPress and giving us a glimpse into its future.</p>\n<p>This year the speaker lineup is stellar. There will be talks by three of the lead WordPress developers: <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-andrew-nacin\">Andrew Nacin</a>, <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-helen-hou-sandi\">Helen Hou-Sandí</a>, and <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-mark-jaquith\">Mark Jaquith</a>. We’re also looking forward to speakers like <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-jenny-lawson\">Jenny Lawson</a>, also known as The Bloggess, and <a href=\"http://2014.sf.wordcamp.org/speaker/chris-lema/\">Chris Lema</a>. If you’re at all interested in the web, you will appreciate the appearance of <a href=\"http://2014.sf.wordcamp.org/speakers/#wcorg-speaker-jeff-veen\">Jeff Veen</a> – one of the creators of Google Analytics and co-founder of Typekit.</p>\n<p>Even though San Francisco is far far away for most of you, you can still be part of the fun and watch all presentations in real-time via livestream:</p>\n<p><a href=\"http://2014.sf.wordcamp.org/tickets/\">Get a livestream ticket and watch all talks from WordCamp San Francisco live</a></p>\n<p>If you hurry, you can get one of the special livestream tickets, including a WordCamp San Francisco 2104 t-shirt. You can find all the technical details and start times <a href=\"http://2014.sf.wordcamp.org/live-stream/\">at the WordCamp San Francisco website</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/10/wcsf-livestream/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 4.0 “Benny”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2014/09/benny/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/news/2014/09/benny/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Sep 2014 17:05:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3296\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"Version 4.0 of WordPress, named “Benny” in honor of jazz clarinetist and bandleader Benny Goodman, is available for download or update in your WordPress dashboard. While 4.0 is just another number for us after 3.9 and before 4.1, we feel we&#8217;ve put a little extra polish into it. This release brings you a smoother writing and management experience [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:23564:\"<p>Version 4.0 of WordPress, named “Benny” in honor of jazz clarinetist and bandleader <a href=\"http://en.wikipedia.org/wiki/Benny_Goodman\">Benny Goodman</a>, is available <a href=\"https://wordpress.org/download/\">for download</a> or update in your WordPress dashboard. While 4.0 is just another number for us after 3.9 and before 4.1, we feel we&#8217;ve put a little extra polish into it. This release brings you a smoother writing and management experience we think you&#8217;ll enjoy.</p>\n<div id=\"v-bUdzKMro-1\" class=\"video-player\"><embed id=\"v-bUdzKMro-1-video\" src=\"https://v0.wordpress.com/player.swf?v=1.03&amp;guid=bUdzKMro&amp;isDynamicSeeking=true\" type=\"application/x-shockwave-flash\" width=\"692\" height=\"388\" title=\"Introducing WordPress 4.0 &quot;Benny&quot;\" wmode=\"direct\" seamlesstabbing=\"true\" allowfullscreen=\"true\" allowscriptaccess=\"always\" overstretch=\"true\"></embed></div>\n<hr />\n<h2 style=\"text-align: center\">Manage your media with style</h2>\n<p><img class=\"alignnone size-full wp-image-3316\" src=\"https://wordpress.org/news/files/2014/09/media.jpg\" alt=\"Media Library\" width=\"1000\" height=\"586\" />Explore your uploads in a beautiful, endless grid. A new details preview makes viewing and editing any amount of media in sequence a snap.</p>\n<hr />\n<h2 style=\"text-align: center\">Working with embeds has never been easier</h2>\n<div style=\"width: 632px; \" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-3296-1\" width=\"632\" height=\"445\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.0/embed.mp4?_=1\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.0/embed.webm?_=1\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.0/embed.ogv?_=1\" /><a href=\"//s.w.org/images/core/4.0/embed.mp4\">//s.w.org/images/core/4.0/embed.mp4</a></video></div>\n<p>Paste in a YouTube URL on a new line, and watch it magically become an embedded video. Now try it with a tweet. Oh yeah — embedding has become a visual experience. The editor shows a true preview of your embedded content, saving you time and giving you confidence.</p>\n<p>We’ve expanded the services supported by default, too — you can embed videos from CollegeHumor, playlists from YouTube, and talks from TED. <a href=\"https://codex.wordpress.org/Embeds\">Check out all of the embeds</a> that WordPress supports.</p>\n<hr />\n<h2 style=\"text-align: center\">Focus on your content</h2>\n<div style=\"width: 632px; \" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-3296-2\" width=\"632\" height=\"356\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.0/focus.mp4?_=2\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.0/focus.webm?_=2\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.0/focus.ogv?_=2\" /><a href=\"//s.w.org/images/core/4.0/focus.mp4\">//s.w.org/images/core/4.0/focus.mp4</a></video></div>\n<p>Writing and editing is smoother and more immersive with an editor that expands to fit your content as you write, and keeps the formatting tools available at all times.</p>\n<hr />\n<h2 style=\"text-align: center\">Finding the right plugin</h2>\n<p><img class=\"aligncenter size-large wp-image-3309\" src=\"https://wordpress.org/news/files/2014/09/add-plugin1-1024x600.png\" alt=\"Add plugins\" width=\"692\" height=\"405\" /></p>\n<p>There are more than 30,000 free and open source plugins in the WordPress plugin directory. WordPress 4.0 makes it easier to find the right one for your needs, with new metrics, improved search, and a more visual browsing experience.</p>\n<hr />\n<h2 style=\"text-align: center\">The Ensemble</h2>\n<p>This release was led by <a href=\"http://helenhousandi.com\">Helen Hou-Sandí</a>, with the help of these fine individuals. There are 275 contributors with props in this release, a new high. Pull up some Benny Goodman on your music service of choice, as a bandleader or in one of his turns as a classical clarinetist, and check out some of their profiles:</p>\n<p><a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/alexanderrohmann\">Alexander Rohmann</a>, <a href=\"https://profiles.wordpress.org/aliso\">Alison Barrett</a>, <a href=\"https://profiles.wordpress.org/collinsinternet\">Allan Collins</a>, <a href=\"https://profiles.wordpress.org/amit\">Amit Gupta</a>, <a href=\"https://profiles.wordpress.org/sabreuse\">Amy Hendrix (sabreuse)</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrezrv\">Andres Villarreal</a>, <a href=\"https://profiles.wordpress.org/zamfeer\">Andrew Mowe</a>, <a href=\"https://profiles.wordpress.org/sumobi\">Andrew Munro (sumobi)</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/arnee\">arnee</a>, <a href=\"https://profiles.wordpress.org/aubreypwd\">Aubrey Portwood</a>, <a href=\"https://profiles.wordpress.org/filosofo\">Austin Matzko</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/bramd\">Bram Duvigneau</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/brianlayman\">Brian Layman</a>, <a href=\"https://profiles.wordpress.org/rzen\">Brian Richards</a>, <a href=\"https://profiles.wordpress.org/camdensegal\">Camden Segal</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/mackensen\">Charles Fulton</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrico\">ChriCo</a>, <a href=\"https://profiles.wordpress.org/c3mdigital\">Chris Olbekson</a>, <a href=\"https://profiles.wordpress.org/chrisl27\">chrisl27</a>, <a href=\"https://profiles.wordpress.org/caxelsson\">Christian Axelsson</a>, <a href=\"https://profiles.wordpress.org/cfinke\">Christopher Finke</a>, <a href=\"https://profiles.wordpress.org/boda1982\">Christopher Spires</a>, <a href=\"https://profiles.wordpress.org/clifgriffin\">Clifton Griffin</a>, <a href=\"https://profiles.wordpress.org/jupiterwise\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/corphi\">Corphi</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/ghost1227\">Dan Griffiths</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danielhuesken\">Daniel Husken</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/dannydehaan\">Danny de Haan</a>, <a href=\"https://profiles.wordpress.org/dkotter\">Darin Kotter</a>, <a href=\"https://profiles.wordpress.org/koop\">Daryl Koopersmith</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dnaber-de\">David Naber</a>, <a href=\"https://profiles.wordpress.org/davidthemachine\">DavidTheMachine</a>, <a href=\"https://profiles.wordpress.org/debaat\">DeBAAT</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/donncha\">Donncha O Caoimh</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dustyn\">Dustyn Doyle</a>, <a href=\"https://profiles.wordpress.org/eddiemoya\">Eddie Moya</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/edwin-at-studiojoyocom\">Edwin Siebel</a>, <a href=\"https://profiles.wordpress.org/ehg\">ehg</a>, <a href=\"https://profiles.wordpress.org/tmeister\">Enrique Chavez</a>, <a href=\"https://profiles.wordpress.org/erayalakese\">erayalakese</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"https://profiles.wordpress.org/ejdanderson\">Evan Anderson</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/fahmiadib\">Fahmi Adib</a>, <a href=\"https://profiles.wordpress.org/feedmeastraycat\">feedmeastraycat</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/garhdez\">garhdez</a>, <a href=\"https://profiles.wordpress.org/garyc40\">Gary Cao</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/garza\">garza</a>, <a href=\"https://profiles.wordpress.org/gauravmittal1995\">gauravmittal1995</a>, <a href=\"https://profiles.wordpress.org/gavra\">Gavrisimo</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/vancoder\">Grant Mangham</a>, <a href=\"https://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/harrym\">harrym</a>, <a href=\"https://profiles.wordpress.org/hebbet\">hebbet</a>, <a href=\"https://profiles.wordpress.org/hinnerk\">Hinnerk Altenburg</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/iljoja\">iljoja</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/issuu\">issuu</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jacklenox\">Jack Lenox</a>, <a href=\"https://profiles.wordpress.org/jackreichert\">Jack Reichert</a>, <a href=\"https://profiles.wordpress.org/jacobdubail\">Jacob Dubail</a>, <a href=\"https://profiles.wordpress.org/janhenkg\">JanHenkG</a>, <a href=\"https://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/jwenerd\">Jared Wenerd</a>, <a href=\"https://profiles.wordpress.org/jaza613\">Jaza613</a>, <a href=\"https://profiles.wordpress.org/jeffstieler\">Jeff Stieler</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/slimndap\">Jeroen Schmit</a>, <a href=\"https://profiles.wordpress.org/jerrysarcastic\">Jerry Bates (jerrysarcastic)</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/jayjdk\">Jesper Johansen (jayjdk)</a>, <a href=\"https://profiles.wordpress.org/engelen\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jesper800\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/jessepollak\">Jesse Pollak</a>, <a href=\"https://profiles.wordpress.org/jgadbois\">jgadbois</a>, <a href=\"https://profiles.wordpress.org/jartes\">Joan Artes</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/jkudish\">Joey Kudish</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnzanussi\">John Zanussi</a>, <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/softmodeling\">Jordi Cabot</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/tai\">JOTAKI Taisuke</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/greenshady\">Justin Tadlock</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kapeels\">kapeels</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevinlangleyjr\">Kevin Langley</a>, <a href=\"https://profiles.wordpress.org/kworthington\">Kevin Worthington</a>, <a href=\"https://profiles.wordpress.org/kpdesign\">Kim Parsell</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kurtpayne\">Kurt Payne</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/lessbloat\">lessbloat</a>, <a href=\"https://profiles.wordpress.org/layotte\">Lew Ayotte</a>, <a href=\"https://profiles.wordpress.org/lritter\">lritter</a>, <a href=\"https://profiles.wordpress.org/lukecarbis\">Luke Carbis</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/m_i_n\">m_i_n</a>, <a href=\"https://profiles.wordpress.org/funkatronic\">Manny Fleurmond</a>, <a href=\"https://profiles.wordpress.org/targz-1\">Manuel Schmalstieg</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/sivel\">Matt Martz</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mdbitz\">Matthew Denton</a>, <a href=\"https://profiles.wordpress.org/mattheweppelsheimer\">Matthew Eppelsheimer</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/meekyhwang\">meekyhwang</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/midxcat\">midxcat</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikemanger\">Mike Manger</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeyarce\">Mikey Arce</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinic</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/usermrpapa\">Mr Papa</a>, <a href=\"https://profiles.wordpress.org/mrmist\">mrmist</a>, <a href=\"https://profiles.wordpress.org/m_uysl\">Mustafa Uysal</a>, <a href=\"https://profiles.wordpress.org/muvimotv\">MuViMoTV</a>, <a href=\"https://profiles.wordpress.org/nabil_kadimi\">nabil_kadimi</a>, <a href=\"https://profiles.wordpress.org/namibia\">Namibia</a>, <a href=\"https://profiles.wordpress.org/alex-ye\">Nashwan Doaqan</a>, <a href=\"https://profiles.wordpress.org/nd987\">nd987</a>, <a href=\"https://profiles.wordpress.org/neil_pie\">Neil Pie</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/schoenwaldnils\">Nils Schonwald</a>, <a href=\"https://profiles.wordpress.org/ninos-ego\">Ninos</a>, <a href=\"https://profiles.wordpress.org/nvwd\">Nowell VanHoesen</a>, <a href=\"https://profiles.wordpress.org/compute\">Patrick Hesselberg</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pdclark\">Paul Clark</a>, <a href=\"https://profiles.wordpress.org/paulschreiber\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/westi\">Peter Westwood</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/philipjohn\">Philip John</a>, <a href=\"https://profiles.wordpress.org/senlin\">Piet Bos</a>, <a href=\"https://profiles.wordpress.org/psoluch\">Piotr Soluch</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/purzlbaum\">purzlbaum</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rclations\">RC Lations</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rickalee\">Ricky Lee Whittemore</a>, <a href=\"https://profiles.wordpress.org/rob1n\">rob1n</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rdall\">Robert Dall</a>, <a href=\"https://profiles.wordpress.org/harmr\">RobertHarm</a>, <a href=\"https://profiles.wordpress.org/rohan013\">Rohan Rawat</a>, <a href=\"https://profiles.wordpress.org/rhurling\">Rouven Hurling</a>, <a href=\"https://profiles.wordpress.org/ruudjoyo\">Ruud Laan</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sammybeats\">Sam Brodie</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sathishn\">Sathish Nagarajan</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/greglone\">ScreenfeedFr</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seanchayes\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/nessworthy\">Sean Nessworthy</a>, <a href=\"https://profiles.wordpress.org/sergejmueller\">Sergej Muller</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shanebp\">shanebp</a>, <a href=\"https://profiles.wordpress.org/sharonaustin\">Sharon Austin</a>, <a href=\"https://profiles.wordpress.org/shaunandrews\">Shaun Andrews</a>, <a href=\"https://profiles.wordpress.org/simonp303\">Simon Pollard</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/slobodanmanic\">Slobodan Manic</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">solarissmoke</a>, <a href=\"https://profiles.wordpress.org/sphoid\">sphoid</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stompweb\">Steven Jones</a>, <a href=\"https://profiles.wordpress.org/strangerstudios\">strangerstudios</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/t4k1s\">t4k1s</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/taylorde\">Taylor Dewey</a>, <a href=\"https://profiles.wordpress.org/thomasvanderbeek\">Thomas van der Beek</a>, <a href=\"https://profiles.wordpress.org/tillkruess\">Till Kruss</a>, <a href=\"https://profiles.wordpress.org/codenameeli\">Tim \'Eli\' Dalbey</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/willmot\">Tom Willmot</a>, <a href=\"https://profiles.wordpress.org/topher1kenobe\">Topher</a>, <a href=\"https://profiles.wordpress.org/torresga\">torresga</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/treyhunner\">treyhunner</a>, <a href=\"https://profiles.wordpress.org/umeshsingla\">Umesh Kumar</a>, <a href=\"https://profiles.wordpress.org/vinod-dalvi\">Vinod Dalvi</a>, <a href=\"https://profiles.wordpress.org/vlajos\">vlajos</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/winterdev\">winterDev</a>, <a href=\"https://profiles.wordpress.org/wojtekszkutnik\">Wojtek Szkutnik</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/katzwebdesign\">Zack Katz</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, and <a href=\"https://profiles.wordpress.org/zoerooney\">Zoe Rooney</a>. Also thanks to <a href=\"http://michaelpick.wordpress.com/\">Michael Pick</a> for producing the release video, and Helen with <a href=\"http://adriansandi.com\">Adrián Sandí</a> for the music.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.1!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/news/2014/09/benny/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.0 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Aug 2014 12:20:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3287\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:321:\"The first release candidate for WordPress 4.0 is now available! In RC 1, we’ve made refinements to what we&#8217;ve been working on for this release. Check out the Beta 1 announcement post for more details on those features. We hope to ship WordPress 4.0 next week, but we need your help to get there. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2134:\"<p>The first release candidate for WordPress 4.0 is now available!</p>\n<p>In RC 1, we’ve made refinements to what we&#8217;ve been working on for this release. Check out the <a href=\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/\">Beta 1 announcement post</a> for more details on those features. We hope to ship WordPress 4.0 <em>next week</em>, but we need your help to get there. If you haven’t tested 4.0 yet, there’s no time like the present. (Please, not on a production site, unless you’re adventurous.)</p>\n<p><strong>Think you’ve found a bug? </strong>Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area in the support forums</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.0 RC1, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.0-RC1.zip\">download the release candidate here</a> (zip). If you’d like to learn more about what’s new in WordPress 4.0, visit the awesome About screen in your dashboard (<strong><img src=\"https://i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png?w=692\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar).</p>\n<p><strong>Developers,</strong> please test your plugins and themes against WordPress 4.0 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.0 before next week. If you find compatibility problems, please be sure to post any issues to the support forums so we can figure those out before the final release. You also may want to <a href=\"https://make.wordpress.org/core/2014/08/21/introducing-plugin-icons-in-the-plugin-installer/\">give your plugin an icon</a>, which we launched last week and will appear in the dashboard along with banners.</p>\n<p><em>It is almost time</em><br />\n<em> For the 4.0 release</em><br />\n<em> And its awesomeness</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2014/08/wordpress-4-0-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.0 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 15 Aug 2014 05:06:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3280\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:353:\"The fourth and likely final beta for WordPress 4.0 is now available. We&#8217;ve made more than 250 changes in the past month, including: Further improvements to the editor scrolling experience, especially when it comes to the second column of boxes. Better handling of small screens in the media library modals. A separate bulk selection mode [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2003:\"<p>The fourth and likely final beta for WordPress 4.0 is now available. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?rev=29496&amp;stop_rev=29229&amp;limit=300\">more than 250 changes</a> in the past month, including:</p>\n<ul>\n<li>Further improvements to the editor scrolling experience, especially when it comes to the second column of boxes.</li>\n<li>Better handling of small screens in the media library modals.</li>\n<li>A separate bulk selection mode for the media library grid view.</li>\n<li>Improvements to the installation language selector.</li>\n<li>Visual tweaks to plugin details and customizer panels.</li>\n</ul>\n<p><strong>We need your help</strong>. We’re still aiming for a release this month, which means the next week will be critical for identifying and squashing bugs. If you’re just joining us, please see <a href=\"https://wordpress.org/news/2014/07/wordpress-4-0-beta-1/\">the Beta 1 announcement post</a> for what to look out for.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums, where friendly moderators are standing by. <b>Plugin developers</b><strong>,</strong> if you haven’t tested WordPress 4.0 yet, now is the time — and be sure to update the “tested up to” version for your plugins so they’re listed as compatible with 4.0.</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.0, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.0-beta4.zip\">download the beta here</a> (zip).</p>\n<p><em>We are working hard</em><br />\n<em>To finish up 4.0<br />\n</em><em>Will you help us too?</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2014/08/wordpress-4-0-beta-4/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 3.9.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Aug 2014 19:04:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3269\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:377:\"WordPress 3.9.2 is now available as a security release for all previous versions. We strongly encourage you to update your sites immediately. This release fixes a possible denial of service issue in PHP&#8217;s XML processing, reported by Nir Goldshlager of the Salesforce.com Product Security Team. It  was fixed by Michael Adams and Andrew Nacin of the WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2353:\"<p>WordPress 3.9.2 is now available as a security release for all previous versions. We strongly encourage you to update your sites immediately.</p>\n<p>This release fixes a possible denial of service issue in PHP&#8217;s XML processing, reported by <a href=\"https://twitter.com/nirgoldshlager\">Nir Goldshlager</a> of the Salesforce.com Product Security Team. It  was fixed by Michael Adams and Andrew Nacin of the WordPress security team and David Rothstein of the <a href=\"https://www.drupal.org/SA-CORE-2014-004\">Drupal security team</a>. This is the first time our two projects have coordinated joint security releases.</p>\n<p>WordPress 3.9.2 also contains other security changes:</p>\n<ul>\n<li>Fixes a possible but unlikely code execution when processing widgets (WordPress is not affected by default), discovered by <a href=\"http://www.buayacorp.com/\">Alex Concha</a> of the WordPress security team.</li>\n<li>Prevents information disclosure via XML entity attacks in the external GetID3 library, reported by <a href=\"http://onsec.ru/en/\">Ivan Novikov</a> of ONSec.</li>\n<li>Adds protections against brute attacks against CSRF tokens, reported by <a href=\"http://systemoverlord.com/\">David Tomaschik</a> of the Google Security Team.</li>\n<li>Contains some additional security hardening, like preventing cross-site scripting that could be triggered only by administrators.</li>\n</ul>\n<p>We appreciated responsible disclosure of these issues directly to our security team. For more information, see the <a href=\"https://codex.wordpress.org/Version_3.9.2\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/3.9?stop_rev=29383&amp;rev=29411\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 3.9.2</a> or venture over to <strong>Dashboard → Updates</strong> and simply click &#8220;Update Now&#8221;.</p>\n<p>Sites that support automatic background updates will be updated to WordPress 3.9.2 within 12 hours. (If you are still on WordPress 3.8.3 or 3.7.3, you will also be updated to 3.8.4 or 3.7.4. We don&#8217;t support older versions, so please update to 3.9.2 for the latest and greatest.)</p>\n<p>Already testing WordPress 4.0? The third beta is <a href=\"https://wordpress.org/wordpress-4.0-beta3.zip\">now available</a> (zip) and it contains these security fixes.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2014/08/wordpress-3-9-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 07 Jan 2015 22:32:42 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:10:\"x-pingback\";s:37:\"https://wordpress.org/news/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Thu, 18 Dec 2014 18:57:51 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20141124234515\";}", "no");
INSERT INTO `wp_options` VALUES("447", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1420713162", "no");
INSERT INTO `wp_options` VALUES("448", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1420669962", "no");
INSERT INTO `wp_options` VALUES("450", "_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c", "1420713163", "no");
INSERT INTO `wp_options` VALUES("451", "_transient_feed_867bd5c64f85878d03a060509cd2f92c", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: Better Search Replace: A New Plugin for Updating URLs and Text in WordPress Databases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36741\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/better-search-replace-a-new-plugin-for-updating-urls-and-text-in-wordpress-databases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4372:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/find-replace.png\" rel=\"prettyphoto[36741]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/find-replace.png?resize=1024%2C471\" alt=\"photo credit: Bunches and Bits {Karina} - cc\" class=\"size-full wp-image-36777\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/bunchesandbits/4106216129/\">Bunches and Bits {Karina}</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>When migrating a WordPress site to a new domain, you&#8217;ll have to update every instance of the site&#8217;s URL in the database. Some developers prefer to use tools like <a href=\"http://wp-cli.org/\" target=\"_blank\">WP-CLI</a> or <a href=\"https://wordpress.org/plugins/wp-migrate-db/\" target=\"_blank\">WP Migrate DB</a> to handle this, while others opt for a general database search and replace plugin with a UI in the WordPress admin.</p>\n<p><a href=\"https://wordpress.org/plugins/better-search-replace/\" target=\"_blank\">Search and Replace</a> is an old plugin, with nearly a million downloads, that can be used to update URLs and text in the database. I used this plugin successfully for a number of years, but it went without any updates for long time. It has since come under new ownership, although the screenshots demonstrate just how long ago the plugin was released.</p>\n<p><a href=\"https://wordpress.org/plugins/better-search-replace/\" target=\"_blank\">Better Search Replace</a> is a new take on database search and replace plugins. It was heavily based on <a href=\"https://interconnectit.com/products/search-and-replace-for-wordpress-databases/\" target=\"_blank\">Interconnect/It&#8217;s open source Search Replace DB script</a> that performs replacement actions without damaging PHP serialized strings or objects. I&#8217;ve used this script a number of times with success, although it&#8217;s not as convenient as a plugin. The Better Search Replace plugin packages it up using native WordPress database functions and adds a friendly UI.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/better-search-replace-screenshot.png\" rel=\"prettyphoto[36741]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/better-search-replace-screenshot.png?resize=1025%2C613\" alt=\"better-search-replace-screenshot\" class=\"aligncenter size-full wp-image-36795\" /></a></p>\n<p>The plugin merges the best features from older plugins and the Interconnect/It script to support the following capabilities:</p>\n<ul>\n<li>Serialization support for all tables</li>\n<li>The ability to select specific tables</li>\n<li>The ability to run a &#8220;dry run&#8221; to see how many fields will be updated</li>\n<li>No server requirements aside from a running installation of WordPress</li>\n</ul>\n<p>Since searching and replacing in the database is a sensitive action to perform, the &#8220;dry run&#8221; feature gives you a good idea of what you can expect before pulling the trigger. Even with the option of performing a dry run, you will undoubtedly want to have a backup of your database created before touching it.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/better-search-replace-dry-run.png\" rel=\"prettyphoto[36741]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/better-search-replace-dry-run.png?resize=1025%2C594\" alt=\"better-search-replace-dry-run\" class=\"aligncenter size-full wp-image-36797\" /></a></p>\n<p>Migrations aren&#8217;t the only reason for this type of plugin. Perhaps you&#8217;ve renamed your company or product line and need to replace all instances throughout your website. This plugin makes it safe and easy to perform the replacements directly within the WordPress admin. I tested it on a development site and found that it is fast and works exactly as advertised.</p>\n<p>Better Search Replace was created by Matt Shaw, author of the <a href=\"http://wptavern.com/free-revisr-plugin-offers-git-management-for-wordpress\" target=\"_blank\">Revisr plugin</a> that allows developers to synchronize WordPress with a remote Git repository. If you&#8217;re a long-time fan of the Interconnect/It script, you&#8217;ll find that this plugin is even easier to use. You can find <a href=\"https://wordpress.org/plugins/better-search-replace/\" target=\"_blank\">Better Search Replace on WordPress.org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jan 2015 21:19:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: Happy Joe to Host WP Boot Camp January 23: A Free Training Event for Military Veterans\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36751\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://wptavern.com/happy-joe-to-host-wp-boot-camp-january-23-a-free-training-event-for-military-veterans\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1827:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/wp-boot-camp.png\" rel=\"prettyphoto[36751]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/wp-boot-camp.png?resize=1025%2C479\" alt=\"wp-boot-camp\" class=\"aligncenter size-full wp-image-36755\" /></a></p>\n<p><a href=\"http://www.happyjoe.org/\" target=\"_blank\">Happy Joe </a>is launching its first planned <a href=\"http://www.happyjoe.org/wp-bootcamp-for-military-veterans/\" target=\"_blank\">WP Boot Camp</a> in San Antonio, TX on January 23, 2015. The non-profit organization <a href=\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\" target=\"_blank\">helps US military veterans re-enter the workforce</a> through training in WordPress and the web technology industry in general. Happy Joe was started by former service member <a href=\"http://www.jamesdalman.com/\" target=\"_blank\">James Dalman</a>, who will be presenting at the first WP Boot Camp, along with other WordPress professionals.</p>\n<p>The three hour event will give military veterans and their spouses an opportunity to learn, network, and gain access to free resources and online training. Dahlman plans to assist attendees in setting up an online resume website using WordPress as a first step towards entering the web technology industry.</p>\n<p>WP Boot Camp is free of charge to anyone with a valid military ID, thanks to event sponsors iThemes, Automattic, WP Site Care, and WebTegrity. The event will be held at <a href=\"http://www.geekdom.com/san-antonio\" target=\"_blank\">Geekdom San Antonio</a>, the largest collaborative co-working space in Texas. However, it is limited to 30 attendees, so those planning to attend must <a href=\"http://www.happyjoe.org/wp-bootcamp-for-military-veterans/\" target=\"_blank\">RSVP</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jan 2015 19:00:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: WP.com Year in Review\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44587\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"http://ma.tt/2015/01/wp-com-year-in-review/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:192:\"<p>There&#8217;s a <a href=\"https://en.blog.wordpress.com/2015/01/06/2014-in-review/\">great write-up of the human side of WordPress.com&#8217;s 2014 as well as some impressive numbers</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jan 2015 18:53:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Post Status: The ABCs of the web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7300\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/web-abcs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3244:\"<p>I wanted to change my primary URL, and also setup HTTPS on my new VPS.</p>\n<p>So, I bought an SSL cert that required I add a TXT record to get a verification email. The domain was new so I needed Google MX records added to receive the new email. Ah, but I also changed the DNS provider where I put those records. Thankfully, the TTL for new records was short and I got squared away so I could submit a CSR and get the SSL. I had to make sure to choose a CDN provider to support SSL too, and it happened to be the same place that handles my DNS now. This service also GZIP compresses as much as it can.</p>\n<p>The domain is square now so I SSH&#8217;d into my new VPS to set a few things straight. For one, I needed to edit the MySQL DB with WP-CLI to search and replace the new URL. But I accidentally forgot to exclude the GUIDs so my RSS went haywire.</p>\n<p>My VC is kinda jacked for deployment purposes, though I&#8217;m learning to handle dependencies and repo management with a JSON file via Composer. But I&#8217;ll still need to deploy my Git repo with something like Dploy.io. For now I had to cowboy up and SCP some new stuff to the server, since it doesn&#8217;t have (bad practice) FTP. Then I noticed I screwed something up, so I used Vi to edit it live, like a madman.</p>\n<p>My new CDN provider not only delivers but also caches HTML, CSS, and JS. That&#8217;s on top of what JS-based Grunt does on the theme side, where my front-end JS is concatenated and minified, and my Sass is pre-processed to CSS. Grunt is also managed with a JSON config file, where I can do these things and more: like linting, combing, .pot generation, and auto-prefixing my Sass. I can even generate RTL-specific CSS if I need to. I&#8217;m told that hardly scratches the surface still.</p>\n<p>In order to do these things, I work locally with VVV, so these scripts can run. That lets met setup custom LEMP stacks to my heart&#8217;s content, stored in a www folder. I can even do auto-site generation with one of many custom shell scripts, though you have to watch out if the project structure isn&#8217;t the same as yours. VVV supports WP-CLI too, so that&#8217;s nice.</p>\n<p>Now the live site is HTTPS instead of HTTP, and because of new tools and modern browsers (that support stuff like SPDY and SVG) my website has fewer HTTP requests, and weighs less than a single MB.</p>\n<p>Also, I better not forget to 301 the old URLs to the new URLs with the domain change; that&#8217;s easy with nginx and will help me keep my SEO.</p>\n<p>Of course, these things are happening while building my site with my CMS of choice, which is also the one largely considered the easiest to work with: WP. And I&#8217;m <a title=\"A new look and a new domain\" href=\"https://poststatus.com/new-look-new-domain/\">not even close to done</a>. I have so much to learn, APIs to explore, and mistakes to make.</p>\n<hr />\n<p>The moral of this silly story, is that building and maintaining websites is still pretty complicated. In fact, I think it may be more complicated than ever. I always feel like a kid learning his ABCs, but that shouldn&#8217;t stop us. Don&#8217;t get intimidated. Dig in. Eventually we learn to string a few sentences together, or even a story.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jan 2015 18:16:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Post Status: A new look and a new domain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7287\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://poststatus.com/new-look-new-domain/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12091:\"<p>Last night I launched version 3 of Post Status. The site design was about a year and a half old and in the first two iterations I never put too much thought into it as much as just trying to get something out the door as soon as possible. This time, I tried to build something that could be a foundation for a while.</p>\n<p>I&#8217;m going to try and walk you through much of my thought processes. Hopefully it gives you insight to what I&#8217;ve been up to, as well as perhaps point you to a new resource or two. And if you have advice for me, I&#8217;ll take it.</p>\n<h3>The new design starts with a name</h3>\n<p>I never really expected Post Status to be my business, but now it is. I realized that some early decisions were mistakes &#8212; like not having the .com for the domain. Poststat.us was a fun domain hack and the .com wasn&#8217;t available, but it was also a branding issue. The site&#8217;s name is Post Status, not PostStat.us or poststat.us or whatever else. That&#8217;s always been hard to shake.</p>\n<p>A few days ago <a href=\"https://twitter.com/greg_wallace/status/551229639104794625\">Greg Wallace pointed me</a> to a Flippa auction for the poststatus.com domain. I was both pleased and annoyed. I tried &#8212; in the past year or so &#8212; to contact the owner privately multiple times and never got a response, even with a direct offer of cash. Nevertheless, I <a href=\"https://flippa.com/3484788-13-years-aged-huge-industry-development-potential-exact-match-domain\">bid on the domain</a> and even got the seller to give me a buy it now option so I could guarantee the domain. It was $800, but I think I got plenty of value in the transaction. All of that happened just yesterday.</p>\n<h3>HTTPS everywhere</h3>\n<p>Another important thing to me was making the entire site utilize HTTPS. I&#8217;ll need it for the eCommerce memberships anyway, and it&#8217;s a good practice and even <a href=\"https://thethemefoundry.com/blog/ssl-everywhere/\">has speed benefits</a>. Post Status is now on a custom VPS product that I&#8217;m working on with <a href=\"http://siteground.com\">SiteGround</a>.</p>\n<p>The site is on a LEMP stack, and utilizes a variation of their <a href=\"https://www.getclouder.com/\">GetClouder</a> product. DNS, CDN, and additional caching elements are provided through <a href=\"https://www.cloudflare.com\">Cloudflare</a> Pro, which took me a while to settle on. The SSL certification is from <a href=\"https://www.digicert.com/\">DigiCert</a>, which had great reviews.</p>\n<p>I&#8217;m really excited about using nginx as well as being able to take advantage of SPDY. My site is now more secure, faster, more customizable, and ready for the future. Meanwhile, I was able to knock out two redirects (for the new domain and from HTTP to HTTPS) in one go.</p>\n<h3>New logo</h3>\n<p>The logo featured above is probably not finalized, but it&#8217;s about where I want it to be. I sketched out logo drafts for months and <a href=\"http://sara-cannon.com/\">Sara Cannon</a> helped me put the first version into Illustrator. The one shown in the featured image is a bit thicker than the original, since the thinner one is tough to scale at small sizes.</p>\n<p>I&#8217;ll probably be tweaking this with the help of someone less like a bull in a china shop within Illustrator as I am, to get it cleaned up and <em>swag-ready</em> (oh yeah!). Either way, I&#8217;m happy to finally have a logo for this project, and I think it represents both the brand and the nature of the site pretty well.</p>\n<h3>New theme</h3>\n<p>The part of the site I&#8217;m most excited about is the new theme design. I&#8217;ve had this concept in mind for months, but didn&#8217;t really execute the latter half (aka 90% of it) until the last couple of weeks.</p>\n<p>In general, finding things based on topic and search should be a lot better, and the reading experience is more focused than ever. I went one column on article pages &#8212; something I&#8217;ve wanted to do for a while. And I went to a two-column format for archives, minus the latest article that sits in a featured spot on the home page.</p>\n<p>The development is based off of <a href=\"http://underscores.me\">Underscores</a>, which I&#8217;ve grown to love. I&#8217;m using Sass for the preprocessor, though with a different structure than base Underscores. Though I&#8217;m no longer using <a href=\"http://themehybrid.com/hybrid-core\">Hybrid Core</a> (I still love it), I am using Get The Image from it to wrangle some default featured images on legacy archives.</p>\n<p>One thing you may notice is the icons. Everything is SVG, using <a href=\"https://useiconic.com/\">Iconic</a>. Iconic makes using SVG super simple. I just insert the SVG of choice with an image tag and the Iconic JS (that&#8217;s minified in my primary JS via Grunt) actually changes the image tag to inline SVG. Iconic also has small, medium, and large versions of each icon, which will be pretty cool for some of the larger ones I intend to use for other landing and member page templates. One thing I don&#8217;t like is the FOUI (flash of unstyled icon &#8212; I just made that up) when I load the page. Hopefully that gets cached and doesn&#8217;t happen often, but I sometimes see it working locally.</p>\n<p>The call to action for memberships on the homepage is also something I debated a lot. I&#8217;m excited about how it came together, mostly because that section will also be the member dashboard for folks once they&#8217;re logged in; so the CTAs shouldn&#8217;t be too obnoxious for those that follow them.</p>\n<p>This design is super alpha and I&#8217;m very willing to receive feedback of what you like and hate. I have a lot of known issues too. The bottom half of article pages have a ton of work to do. The footer doesn&#8217;t exist yet. And I have to build out templates for new sections of the website.</p>\n<h3>Typography</h3>\n<p>Part of the new theme is new typography. I have stayed with <a href=\"http://typography.com\">Typography.com</a>&#8216;s delivery service &#8212; mostly because I am just too in love with Gotham Rounded for my titles.</p>\n<p>I do have some performance concerns, as <a href=\"https://www.tollmanz.com/typography-coms-cssom-blocking-font-loader/\">Zack Tollman outlines</a>, but I have reduced the font&#8217;s package size considerably &#8212; from 9 fonts to 6, and they are smaller sets as well.</p>\n<p>I&#8217;m still using Gotham Rounded for the logo, buttons, and for main headers and titles. It&#8217;s just so pretty. But I&#8217;m only using a single weight, since the use is quite controlled.</p>\n<p>I&#8217;m also using a single weight (light italic) of Sentinel, an incredible slab serif, for archive titles, taglines, and pullquotes. Sentinel is replacing four weights of Archer. I thought about not using any serif, but I think Sentinel is worth it.</p>\n<p>The body font is the biggest change. I&#8217;ve gone from Gotham Rounded to Gotham Narrow. It&#8217;s a more traditional sans-serif, and I think it&#8217;s both slightly more serious and slightly more readable. I toyed with the idea of listing (but not hosting) a series of sans-serifs for body, to gain speed improvements by downloading the best available local fonts from the reader; but I discovered I&#8217;m too picky for that. That said, the four weights I&#8217;m using of Gotham Narrow are lighter than Gotham Rounded was.</p>\n<h3>Performance</h3>\n<p>Performance has been a primary concern throughout the redesign. I&#8217;m trying really hard to consider whether I need things.</p>\n<p><span class=\"pullquote alignright\"><br />\nOne takeaway is that performance is a multi-faceted, challenging endeavor that spans design, development, and infrastructure.</span> All in all, Post Status is way faster now.</p>\n<p>Some of that is hardware, with nginx on a VPS and SPDY support with HTTPS. But the theme is faster too. I&#8217;m using no images unless they are in a post. I&#8217;m not using an icon font, but instead using SVG. I&#8217;m using Grunt to concatenate and minify various theme scripts. Fonts are still a burden, but one I decided was worth it.</p>\n<p>And then there are plugins. Oh, plugins.</p>\n<p>Wrangling Jetpack has been tough. I&#8217;m probably screwing up some features on the site, but I&#8217;m basically dequeuing everything Jetpack spits out. However, I&#8217;m confident I&#8217;ll be able to wrangle Jetpack okay, as I&#8217;m really only going to use Related Posts and Sharing as front-facing features; and though neither is shown here today, both are manageable without Jetpack&#8217;s styles and scripts.</p>\n<p>Gravity Forms is another one I still have to wrangle. A simple newsletter signup form (a single email field) is causing four stylesheets and two Javascript files to be loaded on every page. That can&#8217;t happen, so I have some work to do there.</p>\n<p>Generally, finding, dequeuing, and enqueuing styles and scripts from plugins is just annoying. I totally understand why folks tend to just not bother. I would love to see product makers start offering guides on how users can responsibly enqueue such things on their own.</p>\n<p>Especially with something like forms, I don&#8217;t want to remove a script that prevents the form from working properly. But I <em>do</em> want to remove pointless stylesheets that don&#8217;t matter at all to my simple forms. I don&#8217;t mean to pick on Gravity Forms, as I freaking love Gravity Forms. I just want to figure out how to make complex plugins more performant. Every http request matters, you know?</p>\n<p>All in all, every page load is under pretty well under 1MB uncached, and making between 25-50 requests. I&#8217;d like to keep it that way, and really I&#8217;d like to make sure full page loads are under 1 second always, and usually under 500ms. I have a lot of work to do!</p>\n<h3>So much left to do</h3>\n<p>Today is an early Alpha of the new site. I&#8217;ll walk you through some of what&#8217;s left or still in progress:</p>\n<p>Deployments. My deployment method for this site is terrible. I spent a lot of time learning about Composer (will have posts on that) and I may use it, but either way I&#8217;ve got work to do on proper repo management and deployments. This is especially the case since I&#8217;m trying to both manage the site&#8217;s private repo as well as share the theme and functionality plugin as their own repos for others to use, see, and contribute to.</p>\n<p>Memberships and membership functionality still have a long way to go. I&#8217;m using <a href=\"http://www.woothemes.com/woocommerce/\">WooCommerce</a>,  Subscriptions by <a href=\"http://prospress.com/\">Prospress</a> and (most likely) a product that&#8217;s in Alpha/Beta from <a href=\"http://www.skyverge.com/\">SkyVerge</a> for content restriction and other member features. I&#8217;m using the Mailchimp API to create a custom email to send to members with new private content; that&#8217;s been fun to learn.</p>\n<p>I&#8217;ve created two new content types (Notes and Resources) that are going to be members only. Notes are like the old links, but now a members only blog and newsletter. Resources will be mostly members only with some free stuff, and will be evergreen informational content. Then I&#8217;m creating a Profiles content type to create static pages for people and companies (think Crunchbase for WordPress), as well as a cross-relational tool for posts about those folks.</p>\n<p><span class=\"pullquote alignleft\">The goal with the new Post Status is to provide useful and informative free content for everyone, but go above and beyond for members.</span> I&#8217;m working hard to make that content accessible, digestible, high quality, and trim enough for busy WordPress professionals.</p>\n<p>Okay, this is way more than you needed to know. If you read all that, you are my ideal customer.</p>\n<p>I can&#8217;t wait until I can show you guys the rest of the site! I&#8217;m having a blast spending all of my working time on my own project. It&#8217;s a professional euphoria I&#8217;ve never known until now.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jan 2015 16:11:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Post Status: Website micro services provider, Elto, is shutting down for now\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7258\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://poststatus.com/elto-shutting-down-temporarily/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4615:\"<p><a href=\"http://elto.com\">Elto</a>, formerly Tweaky, is a micro services provider, for lack of a better term. They started with $25 tweaks, which until they <a href=\"http://www.elto.com/blog/well-be-back/\">shut down services today</a>, worked it&#8217;s way to a $199 minimum.</p>\n<p>WordPress is a high focus vertical for Elto&#8217;s, and I presume it&#8217;s their largest as well. Elto is one of several such providers of micro services like this; others still running are <a href=\"https://codeable.io/\">Codeable</a> and <a href=\"http://studio.envato.com/\">Envato Studio</a> (formerly Microlancer). These are besides the longstanding generic types (with rather poor reputations, in my opinion) such as oDesk and Elance.</p>\n<p>I have always kept track of Elto, as I started referring folks to them from my own contact form for small projects, in order to narrow the leads I was getting. When I got the email today from Ned Dwyer, Elto&#8217;s founder, I went to my dashboard to see how many folks had used my referral and what those services were:<br />\n<img src=\"https://poststatus.com/wp-content/uploads/2014/12/elto-services-752x261.png\" alt=\"elto-services\" width=\"752\" height=\"261\" class=\"aligncenter size-large wp-image-7273\" /></p>\n<p>In the time I was referring folks to Elto, I sent them nearly $2,000 in business and got a 25% referral fee. That&#8217;s not a lot; more interesting is that of these referrals, there was an 8.5 / 10 satisfaction rate. I wouldn&#8217;t say that&#8217;s outstanding, but it&#8217;s not bad either. It&#8217;s probably better or close to the satisfaction of more traditional web services providers.</p>\n<p>I emailed Ned to see if he could offer any more insight into this decision. He responded with the following:</p>\n<blockquote><p>\nIt was something we thought long and hard about before making this change.</p>\n<p>The challenge is that the current model was working well &#8211; customers rate us on average 8.7 out of 10, thousands of new customers every month etc &#8211; but it wasn&#8217;t delivering the kinds of results we wanted. This will become clearer when we launch the new version.</p>\n<p>While we could have kept going with this model while working on the next version in the background, the current model has significant customer support challenges. This puts a burden on our team to maintain the current app and customer base which draws resources away from us working on what&#8217;s important.</p>\n<p>We have the full support of our team and investors in making these changes and we&#8217;re excited about what&#8217;s next.</p></blockquote>\n<p>So it appears that this is a temporary stop for Elto. I&#8217;m sure &#8212; with investors to answer to &#8212; rising support challenges makes change inevitable.</p>\n<p>I&#8217;ve always liked the idea of companies like Elto from a developer standpoint. As long as the company values the developers they are mediating for, it can be a nice way for junior developers or just folks that don&#8217;t want to interact with clients much to be able to get work. It can also be a way to fill in the gaps in someone&#8217;s own freelance work.</p>\n<p>I&#8217;m not sure what the next version of Elto will look like, but it seems they&#8217;re aiming to be more in the product business and less in the service business.</p>\n<p>From what I can gather, they raised at least a seed round in 2012, <a href=\"http://thenextweb.com/insider/2012/07/17/99design-founders-invest-460000-in-tweaky-a-marketplace-for-minor-website-customizations/\">reported at $460,000</a>, and perhaps <a href=\"http://www.startupsmart.com.au/growth/growth-strategy/introducing-elto-tweaky-founder-shares-about-their-major-pivot-brand-change-and-latest-investment-round/2014020311615.html\">another round in 2013</a> from Blackbird Ventures.</p>\n<p>I guess my primary takeaway from a change like this is that even when companies are productizing services, doing work for cheap isn&#8217;t easy. Support struggles, maintaining customer expectations, managing developers &#8212; it&#8217;s all tough. I am curious if Codeable and other what I&#8217;d call &#8220;progressive&#8221; members of this style market can relate to Elto&#8217;s struggles, or if they have somehow managed to get past those.</p>\n<p>For some additional reading on Elto&#8217;s journey, Ned&#8217;s post about <a href=\"http://www.elto.com/blog/lessons-weve-learned-from-2-years-of-running-elto/\">what they learned in their first two years</a> was insightful. He also hints they considered a pause even then; so I guess today shouldn&#8217;t be too much of a surprise.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Post Status: WordPress 4.1, “Dinah”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://poststatus.com/wordpress-4-1-dinah/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7094:\"<p><img src=\"https://poststatus.com/wp-content/uploads/2014/12/wordpress-4-1-752x300.jpg\" alt=\"wordpress-4-1\" width=\"627\" height=\"250\" class=\"aligncenter size-large wp-image-7247\" /><br />\nWordPress 4.1, &#8220;Dinah&#8221;, <a href=\"https://wordpress.org/news/2014/12/dinah/\">has just been released</a>. WordPress 4.1 is the result of months of work and includes a number of excellent new features.</p>\n<p>WordPress 4.1 was led by <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, who did an outstanding job. Two hundred and eighty three contributors were part of WordPress 4.1, which Matt Mullenweg states is a new high.</p>\n<p>Here are some of the new features.</p>\n<h3>Persistent Distraction-free Writing</h3>\n<p>I must begin with the new persistent Distraction-free Writing feature, as I&#8217;m using it to write this very post. We&#8217;ve had Distraction-free Writing since 2011, with the <a href=\"https://wordpress.org/news/2011/07/gershwin/\">release of WordPress 3.2</a>. However, it&#8217;s always been a single-experience decision. You hit the button to enter distraction free mode, and you utilize it for a single writing session.<span id=\"more-7245\"></span></p>\n<p>Now, the button itself is persistent, and the experience of writing distraction free doesn&#8217;t enter a new screen, but rather fade away the distractions of the default editor.</p>\n<p>https://cloudup.com/cqbFU6CSqm2</p>\n<p>The left admin seamlessly floats away, as do the metaboxes to the right of and below the editor. The editor itself remains, versus using a modified editor like before.</p>\n<p>When you update to WordPress 4.1, you are triggered with a note about Distraction-free Writing, and now that it&#8217;s a decision you only have to make once, I think this feature will finally get the broad use it deserves. It really is much more pleasant to write without everything else around you, to be lost in your thoughts as they make their way to the editor.</p>\n<h3>Twenty Fifteen theme</h3>\n<p>https://cloudup.com/cgjoFpPJvYk</p>\n<p>The Twenty Fifteen theme is the finest work I&#8217;ve seen yet of the default theme team. A blogging, and personal, theme &#8212; Twenty Fifteen is simple, with beautiful typography, and capable of showcasing blog posts of any format with poise.</p>\n<p>Twenty Fifteen comes in six base color schemes: default (light), dark, yellow, ping, purple, and blue. It also supports WordPress&#8217; background and header image features, and allows you to customize colors from your base selection; Twenty Fifteen can be as quirky as you are.</p>\n<p>https://cloudup.com/cFEI4yyaDmU</p>\n<p>Here&#8217;s a link to the <a href=\"http://twentyfifteendemo.wordpress.com/\">default theme demo</a>, as well as it&#8217;s <a href=\"https://wordpress.org/themes/twentyfifteen\">new page on WordPress.org</a>.</p>\n<h3>Dozens of languages, available any time</h3>\n<p>https://cloudup.com/ckbOnTY71Gq</p>\n<p>WordPress has made tremendous progress for non-English speaking users in the past few releases. With WordPress 4.0, you could choose a language on installation, whereas before it required many more steps. Now the team has gone a step further, so that language can be changed at any time, right from WordPress&#8217; general settings page.</p>\n<p>Given that <a href=\"https://poststatus.com/understand-wordpress-internationalization-translation/\">a third of WordPress installs are non-English</a> (and if I recall correctly half of new downloads are non-English now), this change further reduces the barrier of language in publishing software, and is an excellent move for the progression of the platform across the world.</p>\n<h3>Recommended plugins</h3>\n<p>https://cloudup.com/cQi9LX744H8</p>\n<p>I believe recommended plugins is probably the most controversial feature in WordPress 4.1, though it is not without precedent. &#8220;Featured&#8221; themes have been in the WordPress dashboard for a while now. But with a tab for recommended plugins, now users can see plugin recommendations based on plugins already installed and plugins other sites have installed.</p>\n<p>Recommended plugins are replacing the former popular plugins tab, and is mostly a change in the underlying API for showing the plugins themselves. Since it&#8217;s not a manual recommendation, I think this is a good change, and will more accurately help folks find relevant plugins than just listing the most popular plugins in the directory.</p>\n<h3>New template tags and theming tools</h3>\n<p>I&#8217;m really looking forward to using some of the new template tags introduced in WordPress 4.1.</p>\n<p>My favorite is <code>get_the_archive_title()</code>. Themers out there all know about the big blob of conditionals in most theme archive templates to spit out the right string based on which archive template it is. Now, there&#8217;s a function for that, and it&#8217;s fully filterable to boot.</p>\n<p>Descriptions of the new title functions, some new pagination functions, and some particularly nice body class assignment enhancements are well described on <a href=\"https://make.wordpress.org/core/2014/12/04/new-template-tags-in-4-1/\">this Make WordPress post</a> by Konstantin Obenland. There&#8217;s also a post about adding theme support to <a href=\"https://make.wordpress.org/core/2014/10/29/title-tags-in-4-1/\">let WordPress handle title tags</a>, which is a handy thing.</p>\n<h3>Log out from anywhere</h3>\n<p>A relatively small but nice security feature is the new ability to log out of all installs from a single location. WordPress uses cookies to keep you logged into your install for a period of time. Well, if you ever leave yourself logged in on a computer you don&#8217;t trust, you can now log out of all instances easily, from your profile page on an install.</p>\n<p>There is a new button that says &#8220;Log Out of All Other Sessions,&#8221; and also tells you if you are logged in at more than one location.</p>\n<h3>More improvements to queries</h3>\n<p>I love how much progress has been made on the WordPress query tools in the last couple of years. WordPress 4.1 introduces the ability for a nested query syntax, which makes more complex queries possible for <code>WP_Tax_Query</code>, <code>WP_Date_Query</code>, and <code>WP_Meta_Query</code>. I don&#8217;t often call out single individual&#8217;s work on something, but Boone Georges <a href=\"https://core.trac.wordpress.org/ticket/29822\">really</a> <a href=\"https://core.trac.wordpress.org/ticket/29738\">slayed</a> <a href=\"https://core.trac.wordpress.org/ticket/29642\">it</a> with the nested queries work. He wrote about it <a href=\"http://teleogistic.net/2014/12/wordpress-4-1-and-me/\">on his blog in detail</a>.</p>\n<h3>More under the hood</h3>\n<p>WordPress 4.1 includes many other under the hood features you should check out on the <a href=\"http://codex.wordpress.org/Version_4.1\">Codex page about the release</a>.</p>\n<h3>More excellent progress for WordPress</h3>\n<p>WordPress is better than ever, and hundreds (or thousands) of people make it so. Great job everyone. Now, go download WordPress 4.1.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Post Status: Let’s WordSesh together\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7232\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://poststatus.com/lets-wordsesh-together/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1513:\"<p><img class=\"aligncenter size-large wp-image-7233\" src=\"https://poststatus.com/wp-content/uploads/2014/12/wordsesh-3-752x317.png\" alt=\"wordsesh-3\" width=\"627\" height=\"264\" /></p>\n<p>This weekend, <a href=\"http://wordsesh.org/\">WordSesh</a> 3 will begin. WordSesh is 24 straight hours of live streamed presentations and discussions from a variety of intelligent folks in the WordPress world.</p>\n<p>It starts at 0:00 UTC Saturday, which really means 7:00 p.m. Eastern time on Friday for those of us in America. It&#8217;ll run through Saturday evening.</p>\n<p>The <a href=\"http://wordsesh.org/#schedule\">lineup</a> for WordSesh is as good as any WordCamp, and the chat around the past events has been fantastic. Scott Basgaard and his team of volunteers do a great job.</p>\n<p>I&#8217;ll be on a WordPress news roundtable at the tail end of WordSesh. On Friday, I&#8217;m going to have some news that will help explain my radio silence of late, and will probably spice up the conversation I&#8217;m to have with Jeff Chandler (of WP Tavern), Dre Armeda and Brad Williams (of DradCast) and Doc Pop (of Torquemag). I hope you&#8217;ll watch.</p>\n<p>Check out all the information on the <a href=\"http://wordsesh.org/\">WordSesh</a> website, follow <a href=\"https://twitter.com/wordsesh\">@WordSesh</a> on Twitter, and RSVP if you&#8217;d like to attend. There are already over 600 people signed up. It&#8217;s completely free and community supported. I love this event and I&#8217;m glad to see it happen again.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Post Status: Matt Mullenweg’s 2014 State of the Word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7213\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/matt-mullenwegs-2014-state-word/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11832:\"<p><img class=\"aligncenter size-large wp-image-7215\" src=\"https://poststatus.com/wp-content/uploads/2014/10/mullenweg-752x564.jpg\" alt=\"mullenweg\" width=\"627\" height=\"470\" /></p>\n<blockquote><p>&#8220;Oh, my name is Matt Mullenweg by the way. Nice to meet you.&#8221;</p></blockquote>\n<p>After the WordPress co-founder welcomed the largest WordCamp San Francisco audience ever, he introduced himself and began this year&#8217;s State of the Word &#8212; the annual talk where he provides insight of the last year of WordPress and inspiration for the future.</p>\n<p><em>edit</em>: The video is now available:</p>\n<div class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<a href=\"http://videos.videopress.com/GmPDhkyi/135_3_dvd.mp4\">http://videos.videopress.com/GmPDhkyi/135_3_dvd.mp4</a></div>\n<p><a href=\"http://wordpress.tv/2014/10/26/matt-mullenweg-the-state-of-the-word-2014/\">Or watch on WordPress.tv</a></p>\n<h3>The last WCSF as we know it</h3>\n<p>WordCamp San Francisco has been here in Mission Bay for 7 years, and it&#8217;s the last year here. Next year, things are going to change. There will be a WordCamp US (Matt notes it&#8217;s a working title) that will be modeled similarly to WordCamp Europe. The name, location and date are yet to be determined.</p>\n<h3>The annual WordPress survey</h3>\n<p>This year there were over 33,000 responses to the annual WordPress survey.</p>\n<p>Only 23% of the survey respondents were from the United States &#8212; a 6% increase of international respondents. And for the first time ever, non-English downloads surpassed English downloads. This change is much due to the new internationalization tools in WordPress core itself.</p>\n<p>A quarter of the respondents now make their living fully off of WordPress &#8212; 7,539 people from the survey pool. Matt estimates those people alone make up for more than a billion dollars of economic impact.</p>\n<p>Of those people surveyed, they have between half a million and a million currently active websites they own or have developed. And 91% of those sites took less than 200 hours to make.</p>\n<h3>5 releases since the last WCSF</h3>\n<p><img class=\"aligncenter size-large wp-image-7218\" src=\"https://poststatus.com/wp-content/uploads/2014/10/contributors-752x560.jpg\" alt=\"contributors\" width=\"627\" height=\"466\" /></p>\n<p>Since last summer and the last WCSF, we&#8217;ve had five major releases of WordPress. Matt spent some time going over some of the features we&#8217;ve gained.</p>\n<p>From WordPress 3.6 to WordPress 4.0, WordPress has evolved an enormous amount in a short amount of time. It&#8217;s better on mobile; has a better user experience; is more performant; is easier to use for both developers and end users; and is the best publishing tool in the world.</p>\n<p>There have been seven release leads in that time:</p>\n<ul>\n<li>Jon Cave</li>\n<li>Andrew Nacin</li>\n<li>Helen Hou-Sandi</li>\n<li>Mark Jaquith</li>\n<li>Dion Hulse</li>\n<li>Mike Schroder</li>\n<li>Aaron Campbell</li>\n</ul>\n<p>Additionally, Matt highlighted another 8 significant contributors and five new committers to the WordPress project.</p>\n<p>In these five releases, there have been 785 contributors to the project. And Matt also highlights John Blackbourn &#8212; the WordPress 4.1 release lead, which will soon enter beta.</p>\n<h3>Two Drupal growth</h3>\n<p>Since last summer, WordPress has grown &#8220;two Drupal marketshares.&#8221;</p>\n<p>There have been 684 theme additions to the repository this year &#8212; a 36% increase year over year. There are now 2,781 themes in the repo.</p>\n<h3>iOS and Android</h3>\n<p>There have been two updates for Android, five for iOS, and we abandoned older platforms to focus on a better user experience. &#8220;Sorry, both of the Windows phone users,&#8221; he joked.</p>\n<p>Matt notes that there are now more mobile phones than humans on earth, and that this will continue to be a huge priority.</p>\n<h3>Developer.WordPress.org</h3>\n<p>Noted in the last WCSF State of the Word, <a href=\"http://developer.wordpress.org\">developer.wordpress.org</a> is now live. A little later that hoped, he noted, but it&#8217;s a huge achievement and improvement for WordPress documentation.</p>\n<h3>Community</h3>\n<p>There are over 100 meetup and WordCamp organizers here at WordCamp San Francisco. Matt asked them all to stand, with a personal thanks to their commitment to a difficult, but rewarding task.</p>\n<h3>Internationalization</h3>\n<p>We have a long way to go with Internationalization, but Matt highlights some of the progress and promise for the future, including the advancement of language packs that plugin and theme developers will be able to take advantage of.</p>\n<p>Soon &#8212; with the release of WordPress 4.1 &#8212; Matt announced that the WordPress plugin and theme directories will be fully localized, making it more accessible and fully translated for non-English speakers.</p>\n<p>&#8220;The discovery process [of themes and plugins] is prohibitive&#8221; unless we make it a priority to offer the same discovery features that are in English to other languages.</p>\n<blockquote><p>&#8220;We have the potential &#8212; thanks to the web &#8212; for WordPress to be a truly global experience.&#8221;</p></blockquote>\n<h3>Better WordPress.org stats</h3>\n<p>Matt is promising a better offering of statistics for WordPress theme and plugin providers &#8212; a task that&#8217;s being worked on right now by the .org team.</p>\n<p>These are numbers people have long wanted and are very difficult to get. This is a very welcome change.</p>\n<h3>Adoption of new releases</h3>\n<p>Matt says only 25% of users are on the latest install, WordPress 4.0. While he notes that it&#8217;s far better than it was in the past, we still have a lot of improvement we can make.</p>\n<p>And he goes into the importance of removing versions from the conversation in software. Users should not know or care the version of their software. They should only know that it works.</p>\n<p>&#8220;Our vision is that we&#8217;re like Chrome. &#8230; And the hosts have helped pioneer this.&#8221; But WordPress itself will eventually move to such a model; this is a thing that is controversial, but I believe it is an essential and inevitable evolution.</p>\n<p>Matt asked how many people had been hacked &#8212; and even in a room full of professionals &#8212; it was a lot of people. This is why updates are important, as updated WordPress installs are much safer.</p>\n<h3>Relationship with PHP</h3>\n<p>Matt spent some time talking about WordPress support for more modern versions of PHP.</p>\n<p>WordPress is notorious for being a poor supporter of modern PHP. But that&#8217;s ready to change.</p>\n<blockquote><p>&#8220;We&#8217;re going to start working with hosts to get everyone on PHP 5.5 or above.&#8221;</p></blockquote>\n<h3>The Twenty Fifteen theme</h3>\n<p>Matt is excited about Twenty Fifteen, this coming year&#8217;s default theme. He notes this is our fifth year with a new default theme, and it&#8217;s the same number of years that Kubrick was the only default theme. A massive success.</p>\n<h3>WordPress and Github</h3>\n<p>Matt Mullenweg says that starting this year, you can submit a pull request to WordPress on Github, &#8220;and that will not go into a black hole.&#8221;</p>\n<p>He asked how many people are using Github, and nearly everyone raised their hand. This removes a barrier to contributing to WordPress, and is a huge improvement.</p>\n<p>He also says that all development of the WordPress mobile apps is now on Github. It&#8217;s also worth noting that much of Automattic&#8217;s internal projects, like Jetpack, are run on Github.</p>\n<h3>Community communication with Slack</h3>\n<p>For the first time in 11 years, WordPress is leaving IRC for primary organization communication. We&#8217;re going to try a tool called <a href=\"http://slack.com\">Slack</a>, built by a company in San Francisco started by the former founder of Flickr. Slack has taken over communication in remote teams, from my experience, and will be excellent.</p>\n<p>Slack will also help us make use of integrations and notifications. Right after the talk, <a href=\"http://chat.wordpress.org\">chat.wordpress.org</a> will lead any WordPress.org user to a method for using Slack for communication.</p>\n<p>This is a huge partnership, and as someone that uses Slack daily, I&#8217;m incredibly excited. I&#8217;m sure there could be pushback for using a paid tool for this, but it&#8217;s certainly and interesting experiment and I&#8217;m excited to see what happens.</p>\n<p>It appears clear to me that contributing to WordPress will now be easier than ever.</p>\n<h3>Five for the future</h3>\n<p>Matt talked about his controversial blog post about the concept of <a href=\"http://ma.tt/2014/09/five-for-the-future/\">Five for the future</a>, something <a title=\"Contribution as culture\" href=\"https://poststatus.com/contribution-culture/\">I also opined about</a>.</p>\n<p>Matt highlighted three companies: Gravity Forms, WPMUDev, and Automattic are all now contributing 5%. Of course he notes others are doing it as well, but wanted to highlight those that have committed to doing it publicly.</p>\n<p>Matt discussed a number of ways people can contribute, and that folks can attend sessions to learn how to contribute both here at WCSF and at most other WordCamp events.</p>\n<blockquote><p>&#8220;A contributor, by the way, is a title that no one can give you except yourself.&#8221;</p></blockquote>\n<p>He called it an altruistic mentality of contribution.</p>\n<h3>The JSON REST API</h3>\n<blockquote><p>&#8220;Who&#8217;s excited about the REST API?&#8221;</p></blockquote>\n<p>Nearly everyone responded with enthusiasm. Matt talks about how WordPress.com has had a similar API for years now, and what they&#8217;ve learned, and how much potential there will be for the core version, and the importance for marrying the .com API and the .org API as they each approach 2.0.</p>\n<p>Matt wants us to re-think &#8220;the WordPress engine&#8221; as a kernel that can a hub for building all sorts of things that are more capable to be fit into a proper architecture for the case at hand versus &#8220;shoehorning&#8221; existing WordPress features to areas that aren&#8217;t really meant for it.</p>\n<blockquote><p>&#8220;Maybe what we need isn&#8217;t a way for theming the WP admin; maybe what we need is a way for 1,000 WP admins to be built.&#8221;</p></blockquote>\n<p>And for those admins to be able to fork each other, learn from one another, and create better and catered publishing experiences catered to specific use cases.</p>\n<p>We can expect the core WordPress JSON API in 2015.</p>\n<h3>The continuing importance of WordPress and mobile.</h3>\n<p>Matt discussed how important mobile is to the future of the web, and therefore WordPress. &#8220;They are winning,&#8221; he says about the phones, and says how phones are more available and evolving every year. &#8220;They&#8217;re getting bigger and bigger,&#8221; and the interfaces and methods for interacting with our phones are evolving as well.</p>\n<p>Matt believes that WordPress can play a central role in the further evolution of mobile applications and the mobile web. As the power of mobile devices gets better, Matt believes that the web will become a bigger part of the mobile experience than it is now &#8212; when the conversation seems to be completely centered around apps.</p>\n<blockquote><p>&#8220;This is one of the ways that we can be truly global.&#8221;</p></blockquote>\n<h3>Wrapping up</h3>\n<p>To democratize publishing, is the mission of WordPress.</p>\n<p>WordPress is a community, Matt states, and accessibility from a language, device, and any other point of view is critical to the mission of WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Post Status: Postmatic wants to revitalize your WordPress email, starting with comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7197\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://poststatus.com/postmatic-wordpress-email/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4912:\"<p><img class=\"aligncenter size-large wp-image-7200\" src=\"https://poststatus.com/wp-content/uploads/2014/10/postmatic-752x307.gif\" alt=\"postmatic\" width=\"627\" height=\"255\" /></p>\n<p><a href=\"http://gopostmatic.com/\">Postmatic</a> is a new WordPress plugin that I think is quite promising. It&#8217;s aim is to eventually change the way you utilize WordPress email in many ways, but its comment functionality is what intrigued me immediately.</p>\n<p>Postmatic currently allows users to subscribe to comments and posts by email; but what sets it apart is that it enables <em>reply by email</em> functionality as well. That&#8217;s something that has been high on my list of wants for a WordPress plugin for a long time, and I wanted it without switching to a third party system like Disqus.</p>\n<p>All in all &#8212; aside from enabling replies by email &#8212; the current feature set is quite similar to Jetpack&#8217;s Subscriptions module. Postmatic has widgets for post subscriptions and will send subscribers new posts and allow them to get emailed comment notifications as well.</p>\n<p></p>\n<p>I asked Jason Lemieux, a co-founder of Postmatic, if they were considering a way to import from Jetpack or otherwise integrate with it, and they are. They&#8217;re working now to make it so that your old posts using Jetpack&#8217;s subscription module for comment notifications will still work, and your new posts will use Postmatic.</p>\n<p>I had a pretty thorough conversation with Jason and got to see Postmatic in action. For a free plugin especially, the functionality is quite impressive. I tested subscribing to comments, replying by email, and opting into subscriptions, and it is all very smooth. Here&#8217;s a sample reply notification to my email.<span id=\"more-7197\"></span></p>\n<div id=\"attachment_7201\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7201 size-large\" src=\"https://poststatus.com/wp-content/uploads/2014/10/postmatic-email-752x816.gif\" alt=\"postmatic-email\" width=\"627\" height=\"680\" /><p class=\"wp-caption-text\">Sample Postmatic notification email</p></div>\n<p>Postmatic is already in beta with their API as well. With a little legwork, you can utilize Postmatic for a variety of custom use cases. I know I&#8217;d love to play with it to see if I could create email campaigns for custom post types or multiple lists. They also intend to monetize the plugin via a few avenues &#8212; including ensuring mail delivery and functionality add-ons.</p>\n<p>Postmatic &#8212; available for <a href=\"https://wordpress.org/plugins/postmatic/\">download on WordPress.org</a> &#8212; is and will remain completely free. At some point they&#8217;ll exit beta and they will offer paid delivery of outgoing mail for larger sites. They understand the limitations of sending email through your own server and are using Mailgun to ensure delivery. They also have an extensive &#8212; and for now private &#8212; list of features they aim to introduce to Postmatic.</p>\n<p>The product is definitely version 1.0. Advanced list management, and more advanced campaign delivery is still not ready. But I was impressed by how good of a 1.0 Postmatic is, and how much effort Jason and his business parter, Dylan Kuhn, have clearly invested heavily into the product. For instance, subscriber importing is already possible, so you could move to Postmatic for post delivery right away. They <a href=\"http://gopostmatic.com/setup/\">have videos show how to do that and more</a> already available.</p>\n<p>They tell me as well that Postmatic is in very early stages. Right now they are working on more advanced template building and other features to help tame your WordPress emails. I think they definitely have other services like <a href=\"http://jetpack.me\">Jetpack&#8217;s</a> Subscriptions and <a title=\"WYSIJA is now MailPoet\" href=\"https://poststatus.com/wysija-now-mailpoet/\">MailPoet</a> in their sights.</p>\n<p>I think WordPress email is ripe for disruption. Imagine, currently, all the ways users can get emails from a website, with little continuity: WordPress itself, Mailchimp or other newsletter provider, Jetpack / WordPress.com, eCommerce solutions, form solutions. Each of these sends email and each has their own quirks, look and feel, and otherwise.</p>\n<p>I&#8217;d love to see a service like <a href=\"http://gopostmatic.com/\">Postmatic</a> help tame WordPress email as a whole, and offer a more seamless experience for my website visitors that receive email from me.</p>\n<p>In the short term, I doubt any service will be able to do this perfectly. But I think as WordPress sites send more and more mail, continuity in this arena will be very important. I know, for me, as I prepare to enable <a title=\"The future of Post Status\" href=\"https://poststatus.com/radical/\">club memberships on Post Status</a>, it&#8217;s top of my mind to provide a quality email experience to my members.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Post Status: LoopConf: A new WordPress conference that’s only for developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7188\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://poststatus.com/loopconf-new-wordpress-conference-thats-developers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3300:\"<p>&nbsp;</p>\n<p><img class=\"aligncenter size-large wp-image-7191\" src=\"https://poststatus.com/wp-content/uploads/2014/10/loopconf1-752x295.png\" alt=\"loopconf\" width=\"627\" height=\"245\" /></p>\n<p>Early May 2015 will be the first ever <a href=\"http://loopconf.io/\">LoopConf</a>, a WordPress conference that&#8217;s geared solely toward developers. Ryan Sullivan, the owner of <a href=\"http://wpsitecare.com\">WP Site Care</a>, is hosting the conference that is to be held in Las Vegas.</p>\n<p>LoopConf describes itself like this:</p>\n<blockquote><p>LoopConf is the greatest conference ever created for WordPress developers. LoopConf came about as we heard technically-minded folks talk about wanting to get together and dive deep into advanced engineering and development topics. We&#8217;ve assembled an amazing group of speakers to get this inaugural event started off on the right foot, and we&#8217;re excited to share our excitement and passion for WordPress with all of you in an exciting two-day event. We hope that you join us to celebrate the software we love, enjoy each other&#8217;s company, and learn from one another.</p></blockquote>\n<p>There are already six speakers confirmed:</p>\n<ul>\n<li><a href=\"http://nacin.com\">Andrew Nacin</a>: WordPress lead developer, works at Audrey Capital</li>\n<li><a href=\"http://helenhousandi.com/\">Helen Hou-Sandí</a>: Lead developer of WordPress 4.0, works at 10up</li>\n<li><a href=\"http://ghost.org\">John O&#8217;Nolan</a>: Founder of Ghost and former WordPress contributor</li>\n<li><a href=\"http://www.balkhis.com/about/\">Syed Balkhi</a>: Owner of Awesome Motive, the parent company for WP Beginner, List 25, OptinMonster, and others</li>\n<li><a href=\"http://jennmoney.biz/\">Jenn Schiffer</a>: Open web engineer at Bocoup</li>\n<li><a href=\"http://yoast.com\">Joost de Valk</a>: owner of Yoast and maker of the WordPress SEO plugin, amongst others</li>\n</ul>\n<p>The initial speaker line-up is pretty fantastic. I&#8217;d love to learn more from each one of them.</p>\n<p>LoopConf is not a WordCamp or associated with the WordPress foundation. It&#8217;s an independent WordPress conference, and Ryan says it&#8217;s the first in-person developer only WordPress conference he knows of. Most WordCamps are very catered to a diverse audience.</p>\n<p>This could be a good way for people to have more developer centric conversations. I&#8217;m certainly interested to see how it goes, and would like to make it myself. They are seeking sponsors and speaker submissions now. I don&#8217;t know how much the tickets will be exactly, but Ryan tells me he hopes for LoopConf to have a prestige and quality similar to An Event Apart events, but for WordPress &#8212; so I imagine the tickets won&#8217;t be cheap.</p>\n<p>As the WordPress conference ecosystem continues to blossom, I&#8217;m sure this isn&#8217;t the only one we&#8217;ll see like this. Non-WordCamp, niche events like <a href=\"http://pressnomics.com\">PressNomics</a> helped lead the way for those that are happening now, and I think generally it&#8217;s been good to have a diverse array of options for people to attend and learn from one another.</p>\n<p>You can keep up with <a href=\"http://twitter.com/loopconf\">@LoopConf</a> on Twitter or <a href=\"http://loopconf.io\">via the website</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Post Status: 5 years into business, Pagely is growing faster than ever\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7174\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/pagely-growth-wordpress-hosting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9862:\"<p><img class=\"aligncenter size-full wp-image-7177\" src=\"https://poststatus.com/wp-content/uploads/2014/10/pagely.png\" alt=\"pagely\" width=\"640\" height=\"220\" /></p>\n<p><a href=\"http://pagely.com\">Pagely</a> is celebrating their fifth year of business right now. They have just launched their newly designed website (<em>note to early readers</em>: it&#8217;s in process of launching at this moment, so some links may not work until later today) to reflect some of the ways they&#8217;ve changed over the years. They are also growing, rapidly.</p>\n<p>The new website is a complete rebrand. They&#8217;ve tweaked their logo many times over the years, but they&#8217;ve completely changed it now. It&#8217;s much more modern and can be used in a variety of ways.</p>\n<p>The new website is flat, geometric, modern, and as sassy as ever (like with their <a href=\"https://pagely.com/about-us/investors/\">Investors page</a> they are quite proud of). In all, the redesign attempts to showcase happy customers and what makes them different.</p>\n<p><a href=\"https://poststatus.com/pagely-growth-wordpress-hosting/pagely-new-homepage/\" rel=\"attachment wp-att-7181\"><img class=\"aligncenter size-large wp-image-7181\" src=\"https://poststatus.com/wp-content/uploads/2014/10/pagely-new-homepage-752x547.png\" alt=\"pagely-new-homepage\" width=\"627\" height=\"456\" /></a></p>\n<p>They are introducing <a href=\"https://pagely.com/ambassadors/\">brand ambassadors</a> &#8212; a kind of super testimonial &#8212; that includes names you&#8217;ll surely recognize from the WordPress community.</p>\n<p>Additionally, they are giving other managed hosts a bit of a sting with what they call <a href=\"https://pagely.com/turnthepage/\">#turnthepage</a>, a dedicated page to highlight that they don&#8217;t charge for pageviews, something that most managed WordPress hosting companies do.<span id=\"more-7174\"></span></p>\n<p>Pagely has implemented the new branding and design elements across most of their platform, including their Support sub-site.</p>\n<p><img class=\"aligncenter size-large wp-image-7176\" src=\"https://poststatus.com/wp-content/uploads/2014/10/support-pagely-752x491.png\" alt=\"support-pagely\" width=\"627\" height=\"409\" /></p>\n<p>In addition to branding and a web redesign, Pagely is attempting to showcase that they were first to market with managed WordPress hosting, but also that they are best in class. The strategy &#8212; and particularly their recent all-in <a title=\"Pagely has new plans, a new dashboard, and a new Amazon Web Services infrastructure\" href=\"https://poststatus.com/pagely-wordpress-hosting-amazon/\">move to being an AWS-based service</a> &#8212; appear to be working.</p>\n<h3>Record growth</h3>\n<p>I discussed the Pagely redesign and their recent growth with Joshua Strebel, Pagely co-founder and CEO. He told me that they&#8217;ve seen an enormous amount of growth this year.</p>\n<p>Revenue is up 28% in the last month alone and between 40-45% quarter over quarter. This means that Pagely is on pace to more than double in size between this summer and next.</p>\n<p>To some this may seem a surprise, but it&#8217;s part of some slow and steady investments Pagely has made in recent years.</p>\n<p>They certainly did not scale at the pace of other players in the market &#8212; most notably <a href=\"http://wpengine.com\">WP Engine</a>. They also (as noted above with the Investors page) have bootstrapped their company from the beginning.</p>\n<p>Noone knows exactly how big Pagely is today, and that&#8217;s part of what you get with their owners. Though I&#8217;m told they are &#8220;more than 10 people but fewer than 50.&#8221;</p>\n<p><img class=\"aligncenter size-large wp-image-6550\" src=\"https://poststatus.com/wp-content/uploads/2014/05/pagely-team-752x378.jpg\" alt=\"pagely-team\" width=\"627\" height=\"315\" /></p>\n<p>The Strebel&#8217;s (on the left of the picture above) own the company &#8212; only sharing equity with some key employees &#8212; and they are proud of their independence.</p>\n<p>It&#8217;s nearly impossible to be a Pagely customer without feeling the presence of Josh and Sally Strebel&#8217;s own personalities. And while Josh is an opinionated figure in the WordPress community, Pagely customers seem quite happy with that.</p>\n<h3>Managed host customer satisfaction</h3>\n<p>Steven Gliebe started a new project recently called <a href=\"http://hostingreviews.io/\">HostingReviews.io</a>, a website that attempts to collect non-biased reviews from social media about various hosting solutions. Pagely has a 94% happiness rating according to HostingReviews.io &#8212; matched only by <a href=\"http://getflywheel.com\">Flywheel&#8217;s</a> 95% rating.</p>\n<p>I like Steven&#8217;s project because he is not using affiliates at all with this project, an aspect that spoils most hosting review websites. Here&#8217;s a breakdown of some others:</p>\n<p><a href=\"https://poststatus.com/pagely-growth-wordpress-hosting/hosting-reviews-io/\" rel=\"attachment wp-att-7175\"><img class=\"aligncenter size-large wp-image-7175\" src=\"https://poststatus.com/wp-content/uploads/2014/10/hosting-reviews-io-752x757.png\" alt=\"hosting-reviews-io\" width=\"627\" height=\"631\" /></a></p>\n<p>&nbsp;</p>\n<h3>Changes in managed WordPress hosting markets</h3>\n<p>It&#8217;s been an interesting time to analyze the managed WordPress hosting market. For one, the term &#8220;managed WordPress hosting&#8221; is here to stay. Nearly every large player &#8212; including the likes of GoDaddy, Bluehost, Dreamhost, and more &#8212; offer a managed WordPress hosting product.</p>\n<p>The differences between these large company products and the original smaller players &#8212; players like Pagely, WP Engine, Pressable, and later entrants like Flywheel, Siteground, and Pantheon &#8212; are beyond the name of the product. You really have to dig into each service and business model to get a full grasp of how they are unique.</p>\n<p>And this is really hard.</p>\n<p>For one, you can find positive and negative things about every host in the world. But also, these companies are often targeting different audiences. For instance, GoDaddy and the other large hosts pretty clearly want the smaller website audience, but to upsell them with a more WordPress-specific package. And that&#8217;s fine; they can offer some great functionality for that.</p>\n<p>But Pagely, Pantheon, and some others are going after bigger fish; and they are marketing themselves appropriately.</p>\n<h3>Going after WordPress.com VIP</h3>\n<p><a href=\"http://vip.wordpress.com/\">WordPress.com VIP</a> is the king of the big-WordPress mountain. They have the promise of infinite scale and excellent reliability. It&#8217;s Automattic&#8217;s own product and an excellent business model for them.</p>\n<p>They are able to charge big companies big dollars (relative to other WordPress hosting, not compared to some enterprise software these companies are used to) to get the assurance that their website is hosted safely and reliably.</p>\n<p>WordPress.com <a href=\"http://vip.wordpress.com/stats/\">serves billions of pageviews every month</a>. It&#8217;s simply a massive platform and a comfortable place for companies to take their WordPress hosting needs.</p>\n<p>Pagely wants to be an alternative to WordPress.com VIP. They see themselves as a viable and attractive alternative. For one, they&#8217;ll tell you that you can run anything on Pagely; whereas WordPress VIP has a restricted ecosystem that involves approved-only plugins and stringent code reviews for any custom code, that often requires one of their VIP service partners to perform the work.</p>\n<blockquote><p>VIP is a great service. However it is no longer the only service capable of serving clients at scale. We are winning more of those high-caliber clients that need the extra flexibility our stack offers.</p>\n<p>&#8211; Joshua Strebel, Pagely CEO</p></blockquote>\n<p>Pagely and others seeking the high end market are still relatively early on in their efforts; WordPress.com VIP is a behemoth in that market.</p>\n<h3>A changing tide</h3>\n<p>I&#8217;ve noticed &#8212; and I&#8217;m sure some of you have too &#8212; a change in tide of WordPress managed hosting. This year has no doubt been a very tough one for some managed hosts.</p>\n<p>It&#8217;s been painful to see customers that were once happy with their service &#8212; to the point of being huge brand ambassadors themselves &#8212; to quietly leaving and moving on to something else, now with warranted skepticism.</p>\n<p>Personally, I try to stay pretty host-agnostic. It is a very difficult market to say anything about, due to its incredibly competitive nature. However, I think it&#8217;s obvious that Pagely &#8212; accompanied by the likes of <a href=\"http://siteground.com\">SiteGround</a> and <a href=\"http://getpantheon.com\">Pantheon</a> &#8212; is on the rise while some of the other early entrants to WordPress managed hosting are struggling to consistently deliver on their promises.</p>\n<p>However, with new-found popularity and fast growth, Pagely too can be susceptible to some of the same growing pains of their competition. But they say they&#8217;re ready for it.</p>\n<p>They&#8217;ve invested heavily in AWS and put all their technology chips in Amazon&#8217;s basket. And they assure me that they have been hiring some of the best support techs and engineers in the business. Additionally, they tell me that because they aren&#8217;t investing a ton of money into marketing, their customer influx is more natural and less likely to strain more linear growth levels.</p>\n<p>Time will tell if <a href=\"http://pagely.com\">Pagely</a> is ready to scale with players that have more money and resources than they do, but they&#8217;re definitely excited about the recent growth, the new brand and website, their brand ambassadors, and the challenges ahead.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Post Status: Is WordPress right for eCommerce?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://poststatus.com/wordpress-right-ecommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11014:\"<p><img class=\"aligncenter size-large wp-image-7170\" src=\"https://poststatus.com/wp-content/uploads/2014/10/wordpress-ecommerce-discussion-752x352.jpg\" alt=\"wordpress-ecommerce-discussion\" width=\"627\" height=\"293\" /></p>\n<p>I&#8217;m going to take a leaf out of <a href=\"http://www.chrislema.com/\">Chris Lema&#8217;s</a> book right now to answer whether WordPress should be used for eCommerce: <strong>It depends</strong>.</p>\n<p>There are camps of thought that think WordPress isn&#8217;t right for eCommerce, and there are people that think it&#8217;s the only way to go. Having worked with and used several different eCommerce platforms (both hosted and self-hosted), I&#8217;ve definitely developed the mindset that there are use cases for each. WordPress can be the right choice in a lot of circumstances, but not all.</p>\n<h3>Hosted vs. self-hosted</h3>\n<p>If you&#8217;re not sure about the major differences between hosted vs self hosted platforms, I recommend reading <em>Patrick Rauland&#8217;s</em> <a href=\"http://speakinginbytes.com/2014/08/hosted-vs-self-hosted-e-commerce/\">overview of the major differences</a>. WordPress eCommerce usually falls under self-hosted eCommerce (I don&#8217;t count WordPress.com since it uses external eCommerce solutions). Forbes also <a href=\"http://www.forbes.com/sites/allbusiness/2014/09/26/which-e-commerce-platform-is-the-best-choice-for-your-online-store/\">recently wrote about this</a>, though I don&#8217;t necessarily agree with their conclusions.</p>\n<p>The <a href=\"http://www.practicalecommerce.com/articles/70101-When-to-Avoid-WordPress-Ecommerce\">typical viewpoint</a> is that WordPress plugins like WooCommerce or Easy Digital Downloads are great for small stores or people that just want to quickly and easily sell a few items, while hosted platforms like Shopify and Bigcommerce are for &#8220;serious&#8221; stores.</p>\n<p>This viewpoint is actually pretty backwards, not to mention the fact that the number of items is a poor way of determining which platform you should use.</p>\n<h3 id=\"give-each-its-due\">Give each its due</h3>\n<p>Is WordPress the best platform on which to build apps? I don&#8217;t always think so, but it <strong>could be</strong>. Is it always a good choice for eCommerce? Nope. However, it&#8217;s the <strong>right one</strong> for lots of stores, and it&#8217;s the <strong>wrong one</strong> for lots of stores.</p>\n<p>There are a few major strengths and weaknesses of both WordPress and hosted solutions. I&#8217;ve worked most with <a href=\"http://www.woothemes.com/woocommerce/\">WooCommerce</a>, <a href=\"http://easydigitaldownloads.com/\">Easy Digital Downloads</a>, and <a href=\"http://www.shopify.com/\">Shopify</a>, but have tried lots of other eCommerce solutions for comparison. Some of the knocks against WordPress aren&#8217;t valid, but we should note that some are.</p>\n<h3>WordPress eCommerce weaknesses</h3>\n<p>Everyone loves to talk about how easy certain WordPress plugins are to use. When you compare WordPress plugins to something like Shopify, this just <strong>isn&#8217;t true</strong>. They may be easy to use for people that are familiar with WordPress, but not for the average user who wants to start selling online with no experience.</p>\n<p>WordPress requires a domain name purchase, hosting setup, installation, plugin installation and setup, theme installation and setup, blah blah blah, you get the drift. With hosted solutions, you don&#8217;t worry about this (though solutions like <a href=\"http://evermo.re/\">Evermore</a> &#8212; which was <a title=\"Evermore, hosted WordPress with power and ease of use\" href=\"https://poststatus.com/evermore-interview/\">covered by Post Status</a> when it launched &#8212; make this interesting). You pay your monthly bill, and you&#8217;re handed a store website &#8211; you just pick the name and get rolling. You can start adding products right away, and then you might get into changing your theme or other setup.<span id=\"more-7165\"></span></p>\n<div id=\"attachment_7167\" class=\"wp-caption alignright\"><img class=\"wp-image-7167 size-medium\" src=\"https://poststatus.com/wp-content/uploads/2014/10/easy-300x258.jpg\" alt=\"easy\" width=\"300\" height=\"258\" /><p class=\"wp-caption-text\"><a href=\"https://c2.staticflickr.com/4/3181/3086827283_e9e762331c.jpg\">Image Credit</a></p></div>\n<p>Some of the site tweaks or setup with hosted solutions aren&#8217;t easy, but the learning curve for a solution like Shopify is far gentler than the learning curve for something like WooCommerce.</p>\n<p>There are also <strong>WP Cron</strong> issues for some sites, as it&#8217;s not a perfect system for scheduling actions, like recurring payments. It can work pretty well, but other platforms can make this far easier to implement and more reliable than Cron.</p>\n<p>WordPress store owners are also <strong>responsible</strong> for their own hosting, software updates, and security. For many site owners, these are huge responsibilities. Hosted solutions roll all of this into their package so that users don&#8217;t have to know how their website is powered. They just have to use it.</p>\n<p>Both WordPress and hosted solutions will scale, but there are considerations with WordPress that users need to be aware of. Database issues (like backups or memory with massive amounts of customers and orders) should be addressed, hosting has to be optimized, and plugins need to scale with the site. With a hosted solution, none of this is your problem as a user.</p>\n<h3>WordPress eCommerce strengths</h3>\n<p>Bearing these weaknesses in mind, it&#8217;s a bit crazy to me that WordPress is sometimes referred to as the &#8220;easy solution&#8221; or the right tool for &#8220;small stores&#8221;. It&#8217;s not. In many cases, it&#8217;s like bringing a tank to the eCommerce playground.</p>\n<p>So what does WordPress do well?</p>\n<p>First, WordPress offers the most all-in-one website solution available. WordPress can offer the eCommerce aspects of the website, in addition to its many other CMS features. The ability to create a single, seamless CMS experience for a multi-purpose website makes it quite compelling and more budget-friendly than more &#8220;eCommerce first&#8221; platforms.</p>\n<p>Second, it&#8217;s optimized for <strong>SEO</strong>. Your content is crucial here, and WordPress is built for content. More importantly, if you&#8217;ve tried to blog on another platform, you know how painful it can be (don&#8217;t start with me Squarespace fans, that thing is difficult to use). WordPress doesn&#8217;t encourage you to avoid blogging to avoid headache: it&#8217;s built for <strong>complete websites</strong>, and is not simply focused on eCommerce.</p>\n<p>WordPress also contains functionality that you can&#8217;t always get with different platforms. There&#8217;s a massive selection of plugins, themes, and all sorts of solutions for WordPress that are readily available. Since it&#8217;s open source, it&#8217;s far easier to find ways to customize it when compared to closed platforms like Bigcommerce.</p>\n<p>Speaking of customizations, your ability to customize WordPress or plugins is <strong>far</strong> easier than with hosted solutions. There&#8217;s lots of functionality that can be achieved with WordPress that&#8217;s not even possible in hosted solutions. For example, developers have no control over the Shopify checkout process, but this can be entirely customized with WordPress.</p>\n<p>You can also usually find a plugin that will provide a &#8220;starting point&#8221; for a customization project. Even if you find a Shopify or Bigcommerce app that gets <em>close</em> to what you need, but not quite, you&#8217;ll need to create a completely custom solution anyway &#8211; there&#8217;s no &#8220;extending&#8221; there.</p>\n<p>Along with customization is the <strong>control over your environment</strong>. You can spin up your eCommerce site on something like Digital Ocean, and you&#8217;ve got control over the entire site, from server to theme.</p>\n<h3>Product type</h3>\n<p>The biggest difference for me between hosted solutions and self-hosted actually isn&#8217;t usability or scalability &#8211; it&#8217;s <strong>product type</strong>. Can almost every eCommerce platform sell tee shirts? Yes. Even EDD can do that, and it&#8217;s made for digital products.</p>\n<p>However, selling complex products becomes infinitely more difficult on hosted platforms, as you&#8217;re restricted to what the API offers for product changes, which isn&#8217;t always a lot. For example, if you&#8217;ve ever tried to add pricing changes for customization options in Shopify, you know that it literally takes some wizardry, black magic, and possibly bubble gum used as tape to do so.</p>\n<p>WordPress plugins make this far easier, because the entire platform is open, not just an API. Most eCommerce plugins have more than enough actions or filters to change products, product pages, checkout forms, or any other part of your site.</p>\n<h3>Recap</h3>\n<p>Hosted eCommerce solutions are typically easy to use, and can provide some customization options via apps or other add-on services. However, it&#8217;s like renting a house versus owning. With a rented house, you can&#8217;t go knocking down walls or completely remodeling &#8211; you&#8217;ve got to work inside of a framework you&#8217;re given. This is exactly how a hosted solution works.</p>\n<p>The benefit to this is that you absolve yourself of a lot of responsibility and worry. The entire experience is managed and supported, and is typically very easy to work with.</p>\n<p>However, WordPress eCommerce is like buying the house. You can do whatever you want &#8211; add-on, rebuild sections of the house, change layouts around, add tunnels to other houses, you name it. However, when the water heater blows up, it&#8217;s your responsibility.</p>\n<p>WordPress also affords the opportunity to sell complex products, such as measurement based products like corks by the pound, that simply can&#8217;t be sold on other platforms. The same ability to customize WordPress so thoroughly lets you customize the eCommerce plugin you&#8217;re using.</p>\n<p>You gain the flexibility that comes with the platform, as well as the benefits like tons of plugins, themes, a great content structure, and a consistently maintained and updated core solution. However, the Frankenstein site that you build is your baby, and yours alone &#8211; you need to host it, maintain it, and care for it.</p>\n<p>WordPress lets you create advanced functionality via plugins and customizations, but isn&#8217;t right for users looking for an easy, basic shop setup. If you want a move-in ready house or a beautiful rental, you should look at hosted solutions. If you&#8217;re willing to make your dream house from great bones and foundation, or you need to sell fairly complex products, then WordPress might be it for you. It&#8217;s not the &#8220;easy&#8221; solution, but it can be a great one.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Beka Rice\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Post Status: Contribution as culture\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7153\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://poststatus.com/contribution-culture/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12488:\"<p><img class=\"aligncenter size-large wp-image-7157\" src=\"https://poststatus.com/wp-content/uploads/2014/10/five-percent-752x250.gif\" alt=\"five-percent\" width=\"627\" height=\"208\" /></p>\n<p><em>This post spends a lot of time analyzing and referencing two other blog posts. Excuse me for that, but also be sure to read both, as they are relevant for this post and also interesting in their own right.</em></p>\n<p>Matt Mullenweg wrote a blog post called <a href=\"http://ma.tt/2014/09/five-for-the-future/\">Five for the Future</a> yesterday that advocates his belief that WordPress-centric companies should aim to utilize 5% of their company resources toward contributing back to the project.</p>\n<p>He noted in the post that <a href=\"http://automattic.com\">Automattic</a> isn&#8217;t quite to this point, but that they are working on it, and describes why he believes it&#8217;s important. He closes with this:</p>\n<blockquote><p>It’s a big commitment, but I can’t think of a better long-term investment in the health of WordPress overall. <strong>I think it will look incredibly modest in hindsight.</strong> This ratio is probably the bare minimum for a sustainable ecosystem, avoiding the <a href=\"http://en.wikipedia.org/wiki/Tragedy_of_the_commons\">tragedy of the commons</a>. I think the 5% rule is one that all open source projects and companies should follow, at least if they want to be vibrant a decade from now.</p></blockquote>\n<p>This was followed up by one of the co-founders of one of the very hosting companies Matt partially referenced in his post &#8212; WP Engine&#8217;s Ben Metcalfe &#8212; who responded with a blog post of his own: <a href=\"http://benmetcalfe.com/blog/2014/09/wordpress-what-exactly-do-they-get-for-their-5/\">WordPress: What exactly do they get for their 5%?</a></p>\n<p>I think I was immediately thrown off by Ben&#8217;s post title, but so many times throughout reading it I was shocked at how he made assumptions of Matt&#8217;s intentions or missed what I would call &#8220;the point&#8221;.</p>\n<h3>5% is not a decree</h3>\n<p>Obviously, Matt is not speaking from the mountaintop with a proclamation of law. This is his recommendation &#8212; one that he believes will reward the firms that strive for it.</p>\n<p>I believe that the community has already shown us that those that invest into WordPress are rewarded from it. We improve our understanding of a foundational software of our careers, improve our skills, are more marketable, more attractive to employers, and create natural opportunities for developing industry relationships.</p>\n<p>How should 5% of &#8220;people&#8221; be defined? I&#8217;m pretty sure Matt would agree that 5% of people or 5% of revenue toward people doesn&#8217;t really matter to him; yet Ben makes a continuous sticking point about the cost of &#8212; and need for &#8212; engineers.</p>\n<p>Additionally, while Matt utilizes full-time employees, the same (or better) effect could be had with shared time from more employees.</p>\n<p>I&#8217;m not big into absolutes, so it&#8217;s important to remember that while I&#8217;m advocating that Matt&#8217;s recommendation of 5% time, I think it&#8217;s simply a good recommendation. This is a free economy and companies can do what they want. But I think in the current and long term, contribution will be key to greater corporate success for those that choose to do so.</p>\n<h3>What does 5% cost, and who does it require?</h3>\n<p><span id=\"more-7153\"></span></p>\n<blockquote><p>While Matt was careful to include numerous non-engineering roles companies could help with, ultimately what drives the open source project is source code contribution by software engineers. &#8230;</p>\n<p>A reasonable engineer in the US costs $100k/y, and if you factor in benefits <em>(tax funded health-care, anyone?)</em> and overheads you could easily be looking at $130k or more per person, per year. &#8230;</p>\n<p>A 200+ person web hosting company would need to hire 10 engineers to meet a 5% goal, requiring a budget of anything between $1MM-1.3MM+ per year. Those engineers probably need a manager – to mentor them, provide career development etc. Those 11 people also put pressure on human resources, finance, legal, facilities etc – probably equating to another person again. Now we’re talking probably more like $1.25-$1.5m annually.</p></blockquote>\n<p>First, I believe Ben has spent too much time in the world&#8217;s largest cities if he believes engineers cost $100,000 per year on average. In my experience (yes, I interview people myself), that&#8217;s not the case, and based on my decent view of the ecosystem it&#8217;s not an appropriate going rate &#8212; especially if the offer on the table is a particularly desirable position.</p>\n<p>More importantly, <strong>the project needs far more non-technical contributors</strong>. Ben&#8217;s assertion that &#8220;ultimately&#8221; software engineers drive the project is not true. Users drive the project. A technically savvy user-minded contributor can be a beacon of light to a group of software developers. And given the user-facing nature of WordPress itself, non-engineer contributors could drastically improve the less code-sexy parts of the WordPress ecosystem: project management, docs, training, testing, support, translation, etc.</p>\n<p>Additional to &#8220;core&#8221; contributions, WordCamps, plugins, themes, communities, and many other venues are outstanding places where contributors &#8212; yes, they&#8217;re still contributors! &#8212; can impact the overall project.</p>\n<p>Finally, as I noted above, I think companies could quite effectively contribute parts of employees&#8217; time versus dedicated 100% time, which would also prevent the need to have dedicated managers for open source contributors.</p>\n<h3>Foundational software to your business</h3>\n<p>Ben spends a chunk of time saying that big companies like GoDaddy get a &#8220;get out of jail free card&#8221; and that obviously Matt wouldn&#8217;t expect they dedicate 5% of their thousands of employees.</p>\n<p>GoDaddy definitely benefits from WordPress and they also contribute to it; and no, they don&#8217;t contribute 5% I&#8217;m sure. But WordPress is not foundational to GoDaddy&#8217;s business. They have a dedicated sub-product for it, and they also have many contributors to it.</p>\n<p>WP Engine, and many others (including mine), are almost completely or completely reliant on WordPress as a platform. WordPress and its underlying technologies are foundational to our careers and businesses.</p>\n<p>It is simply a different story to compare a company that would continue on pretty much fine without WordPress and one that would have to seriously reconsider their entire business model.</p>\n<p>For example, let&#8217;s compare the scenario to a publisher. <a href=\"http://recode.net\">Re/code</a> is built on WordPress. They have a staff of 20+. Do they <em>completely rely</em> on WordPress for their website? Yes. For their business model? No. In their scenario, it makes sense for them &#8212; and could benefit them pretty directly &#8212; to allocate some time of some employees to WordPress, but if WordPress disappears they can and will migrate to a different platform.</p>\n<h3>Contributing to the full stack</h3>\n<p>It was questioned to me on Twitter, after my initial reaction to Ben&#8217;s post, whether I contribute 5% of my time to open source projects like PHP, MySQL, and other tools that WordPress relies on.</p>\n<p>This is a good question and point, but it does not cause me to stumble in my opinions. I believe open source contributions in general benefit the entire software stack.</p>\n<p>In my scenario, I can be more impactful on the WordPress project than others. But I believe contributions can take many shapes, in both directions.</p>\n<p>Some folks, like Daniel Bachhuber, greatly contribute to the project as a whole by supporting upstream projects like <a href=\"http://wp-cli.org\">WP CLI.</a></p>\n<p>Automattic is a fantastic example of a company that has both upstream and downstream contributions. They are active contributors to, employers of contributors or founders, or monetary sponsors to a huge number of downstream projects: WordPress, PHP, Nginx, jQuery, Elastic Search, Node, Socket.io, and probably a bunch I can&#8217;t think of or don&#8217;t know about. Additionally, they are a driving force behind dozens of upstream, open source themes and plugins.</p>\n<p><em>Edit: Matt <a href=\"https://twitter.com/photomatt/status/517270097355091968\">says in a Tweet</a> where Andrey Savchenko asked for clarification about PHP contributions that Automattic doesn&#8217;t actively contribute to PHP. Though I think I define contribution a bit more loosely than Matt does.</em></p>\n<p>Whether a company is contributing to their foundational piece of software, a downstream or upstream application, or on an adjacent aspect that leads to the betterment of the platform that is foundational to their business objectives, then I believe it will in turn be beneficial to their bottom line.</p>\n<h3>Contribution as culture</h3>\n<p>Contribution should not be considered an isolated cost, but an enabling investment.</p>\n<p>If I run a business that relies on a foundational piece of software like WordPress, then it benefits me greatly for my employees &#8212; no matter what role they play within the company &#8212; to be intimately familiar with that software.</p>\n<p>In my last job, I was tasked with guiding a transition of my company from developing mostly on a proprietary CMS to WordPress. I consistently preached the importance for everyone in the company to understand some fundamentals of WordPress itself. During my time there and since I&#8217;ve moved on, I&#8217;ve seen other members of that company learn the software, get involved in our local community, and even contribute back to WordPress itself; and both they and the company are better off for it.</p>\n<p>Whether an employee is in sales, customer service, design, development, management, or wherever else &#8212; every employee knowing your product is important. I firmly believe this. I would want anyone in an organization I&#8217;m part of to be able to discuss our product in detail and with confidence to anyone.</p>\n<p>When your company relies on a foundational piece of software &#8212; such as those we&#8217;re discussing in this post &#8212; that&#8217;s in effect part of your product. We are building products and services around and for WordPress. How important should it be that our company&#8217;s employees understand it?</p>\n<p>And how can they understand it better? By contributing of course!</p>\n<p>Have a new support rep? Show them the WordPress.org forums to get their feet wet. New designer or front-end developer? Have them sit in on default theme conversations or read through the Make UI blog. New sales person? Get them involved at your local meetup and WordCamp. This list can go on.</p>\n<p>Avenues for contribution are an incredible gateway for learning WordPress. Blogging about WordPress (another avenue of contribution) has greatly enabled me to be better at my job, and therefore made me significantly more valuable to the companies I&#8217;ve worked with.</p>\n<h3>Five for now</h3>\n<p>Matt called his post Five for the Future, and talked specifically about how a 5% investment by a company will ensure a greater future for WordPress and therefore said company. I disagree.</p>\n<p>Contributing now will benefit the company and its employees <em>right now</em>. And while both Matt and Ben focused on individuals within the company being targeted contributors, I think it&#8217;s much more beneficial to have a much larger percentage of a company contributing a portion of their time (even if small). I&#8217;d rather see 2 of 200 employees be full time contributors and then have 80 10% contributors than have 10 full time contributors.</p>\n<p>I think we&#8217;ve seen many, many examples of contributors (people and companies) reaping tangible and intangible benefits from when they contribute &#8212; whether that contribution is to the codebase or the community. Contributors in this ecosystem come out on top.</p>\n<p>Contributions are not an isolated cost or burden. Nor should their effects be limited to good faith investments to the sustainability of the ecosystem.</p>\n<p>Contributions benefit the bottom line, and they benefit the bottom line right now.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Post Status: The anatomy of a security breach, and how to do good in a bad situation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://poststatus.com/?p=7134\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://poststatus.com/ithemes-security-breach-and-disclosure/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12133:\"<p><img class=\"aligncenter size-large wp-image-7139\" src=\"https://poststatus.com/wp-content/uploads/2014/09/ithemes-dark-752x226.jpg\" alt=\"ithemes-dark\" width=\"627\" height=\"188\" /></p>\n<p>On Tuesday, iThemes posted an announcement that they had <a href=\"http://ithemes.com/2014/09/23/important-security-update-for-all-customers/\">suffered from a security breach</a> of their website and servers. The attackers had reached the servers which stored customer information, including email addresses, IP addresses, full names, and yes, passwords.</p>\n<p>iThemes was quick to notify customers via their blog, social media, and their full customer email list about the breach. Approximately 60,000 users were affected. They warned that passwords were vulnerable. In <a href=\"http://ithemes.com/2014/09/25/update-2-security-update-for-ithemes-customers/\">the second update</a>, posted today, they gave more information about passwords, in response to many questions from users.</p>\n<p>It turns out that passwords were stored in plaintext on iThemes&#8217; server. That is, obviously, very bad practice.</p>\n<blockquote>\n<h3>Why Would You Store Passwords in Plain Text?</h3>\n<p>This is how the membership software we started using in 2009 did it. There are a number of factors for this, none that will make much of a difference at this point or make anyone feel any better about it, myself included.</p>\n<p>Know that it’s not because we did not value your data. As an organization, we have been working on a very large migration process that has required us to interlink legacy systems with the latest technologies. Anyone that has ever gone through that process understands the complexities and challenges.</p>\n<p>Frankly put, it’s been something we identified as a potential risk and are working rapidly now to rectify this issue as fast as humanly possible.</p></blockquote>\n<p>It&#8217;s also worth noting that their customer database and iThemes.com users were affected, but customers that use their Sync product to manage their own websites were not. So if you use iThemes Sync, and utilized your site passwords to connect, those accounts and passwords were not part of this breach.</p>\n<h3>aMember and legacy membership platforms</h3>\n<p>The membership platform that Cory highlights in the update is a<a href=\"http://www.amember.com/\">Member</a>, a membership management system that&#8217;s been around for many years. aMember only introduced <a href=\"http://www.amember.com/p/2011/11/amember-pro-version-4-stable/\">encrypted passwords in version 4</a>, which was released in November of 2011.</p>\n<p>I discussed aMember and plaintext passwords with some other folks that have a significant history with the membership platform, and there are some significant problems that anyone using aMember have experienced.</p>\n<p>First, most folks heavily using aMember aren&#8217;t using it out of the box. At the time, most membership sites were doing significant customizations to aMember to achieve desired functionality. So when the v.4 update came out, it was a very difficult update procedure for people to take advantage of the features.</p>\n<p>iThemes would even tell you that their current version of membership software doesn&#8217;t look much like aMember at all.</p>\n<p>iThemes is also not the first to be hacked and their aMember passwords leaked. Tuts+ Premium <a href=\"http://marketblog.envato.com/general/tuts-premium-security/\">had the same issue in 2012</a>.</p>\n<p>I discussed aMember at length with <a href=\"http://twitter.com/pippinsplugins\">Pippin Williamson</a>. He has done a lot of work on his brother&#8217;s membership site, <a href=\"http://cgcookie.com/\">CGCookie</a>, which also used aMember until 2012, when he did a huge migration of tens of thousands of members to a new platform.</p>\n<p>At the time, Pippin notes that aMember did not disclose passwords were stored in plaintext, so CGCookie had no idea that their users were vulnerable until they learned of the Tuts+ hack, wherein they put a planned migration &#8220;into hyperdrive.&#8221;</p>\n<p>The problem with iThemes&#8217; situation is that they knew of the plaintext passwords and didn&#8217;t address the obvious security vulnerability.</p>\n<p>All in all, the migration for CGCookie took months to perfect and significant juggling of priorities by their team.</p>\n<h3>Ticking time bomb</h3>\n<p>Speaking with Pippin, migrating from aMember was not an easy task. Paypal&#8217;s IPN handlers (a payment notification system) were tightly linked to aMember and preventing customer accounts from being disconnected from the membership site took weeks of engineering. Additionally, simply upgrading to the newer versions was also terrible.</p>\n<p>Many other WordPress companies have used aMember in the past as well, storing plaintext passwords just like iThemes today.</p>\n<p>So, aMember has definitely been a problem before now, but iThemes has absolutely slacked in their prioritization of the issue. Simply put, it&#8217;s inexcusable to put users into long term risk if you know their passwords are stored in plaintext.<span id=\"more-7134\"></span></p>\n<p>That said, we should consider the potential consequences &#8212; though it doesn&#8217;t make it excusable. Because iThemes doesn&#8217;t store credit card details, emails and names and passwords are about the worst things at risk. Still, a tiny percentage of the general population uses responsible passwords, so getting a list of names and emails and passwords is a treasure trove of information for third party (as in other websites like banks and email providers) to steal identities and break directly into user accounts.</p>\n<p>This should also be a significant lesson for any user to always use different passwords for every website where you keep an account. Tools like <a href=\"https://lastpass.com/\">LastPass</a> and <a href=\"https://agilebits.com/\">1Password</a> make account password management easy. Additionally, learn about <a href=\"http://en.wikipedia.org/wiki/Two-step_verification\">2-factor authentication</a> and use it whenever the service enables it.</p>\n<h3>Owning mistakes</h3>\n<p>This is clearly a horrible situation for iThemes to be in. Users have a right to be mad. In 2014 we should be able to expect that our passwords are encrypted, and that even if a server where our information is stored is hacked, that certain valuable details like credit cards or passwords are not exposed. Thankfully, iThemes doesn&#8217;t store credit card details, but those passwords should now be assumed stolen, and users have to pay that price.</p>\n<p>But where I have enormous respect for iThemes is how they have owned it. Especially in the update post, Cory Miller &#8212; iThemes&#8217; founder and CEO &#8212; took ownership of the issue and told the full story of the breach.</p>\n<blockquote><p>I realize this will generate a lot of concern. Again, I am deeply sorry for this mistake and how it has affected you.</p>\n<p>Let me say: we have made mistakes in the past at iThemes … and as humans will make mistakes in the future. To make a promise otherwise would be absurd and misleading.</p>\n<p><strong>But my promise to you, our customers, is this</strong> … and it’s the same promise that I’ve held to since January 2008 when I started iThemes in my home:</p>\n<ol>\n<li><strong>We will identify mistakes as best we can.</strong> You have helped us with this and appreciate that accountability.</li>\n<li><strong>We will own up to our mistakes.</strong> Again, we’ve done this in the past, we did this yesterday and this post is another example of us living this value.</li>\n<li><strong>We will fix the mistake as fast as humanly possible.</strong> A number of priority issues have been unearthed, shone a hard light on, but we are working to resolve them.</li>\n<li><strong>We will learn and grow from it and be better for it and for you.</strong></li>\n</ol>\n<p>Additionally, as the founder and CEO, the leader of this company, I want you to know: <strong>the buck stops with me and me alone.</strong></p>\n<p>At the end of the day, I am responsible for our company, iThemes, and the work we do. I’ve often tried to defer credit for the great work we’ve done to our team, but as for the mistakes we make, that credit belongs solely to me.</p></blockquote>\n<p>Not every company that&#8217;s been breached can say the same. Even huge organizations (I&#8217;m thinking of Home Depot as the latest) have done a horrible job at responsible and honest disclosure to their customers.</p>\n<p>iThemes could have made this much more quiet and kept it from being a priority to their users or a big deal in WordPress news-land. But they didn&#8217;t. They owned it, they apologized, and they&#8217;ve been rewarded for that.</p>\n<p>In the comments of the security update post, users were appalled by the lack of responsibility on the security priorities, but the honesty paid off in the sense that users were verbally thankful for it so that they could accept the problem and deal with it, when the alternative was to be in the dark.</p>\n<p>While this breach has cost iThemes some credibility, and some trust, I believe those things are recoverable. Had they obfuscated the hack itself, my post and users reactions (had they found out) would be very different.</p>\n<h3>What iThemes is doing now</h3>\n<p>iThemes has learned a hard lesson this week, as many other companies have before them. Now they must react, and react strongly. In a situation like this, nothing should take priority over getting this issue fixed.</p>\n<p>Until they get their password storage issue fixed, they still are storing passwords in plaintext, even the new ones. Thankfully they&#8217;ve already updated password restrictions &#8212; which previously limited passwords to 20 characters &#8212; to now accept up to 255 characters. But storing them in plaintext means that they are still as vulnerable today as they were last week if someone gets into the server again. So they must be absolutely vigilant to protect their servers through this migration.</p>\n<h3>What we can all learn</h3>\n<p>Security is not a sexy industry. Too often we don&#8217;t consider it until it&#8217;s a problem. &#8220;Going on offense&#8221; should be our default when we consider security actions, but more often &#8212; even with some of the best companies and people in the tech space &#8212; we react to issues and aren&#8217;t appropriately proactive.</p>\n<p>That said, our job is not done either. All of us should consider our own security situation and how we can improve it. Especially if you have users of your own (and many of my readers do), consider that state of your own security, and make sure it&#8217;s a priority in your business.</p>\n<p>When we think about what pays the bills, it&#8217;s not security awareness and proactive security investments. But we should consider security breaches and vulnerabilities as risks that must be managed; meaning investment into security priorities should be a significant part of any business.</p>\n<p>iThemes, Envato, and WooThemes are all &#8220;big&#8221; businesses from a WordPress business perspective. Each of them has fought a website security battle. Envato and WooThemes before iThemes have recovered and maintained their users and the community&#8217;s trust. I think iThemes will too. But before you, or me, decide &#8220;it won&#8217;t happen to us&#8221;, consider that it can happen to anyone, and our investments into security measures and best practices are not only worthwhile, but the only responsible thing to do.</p>\n<p>And for users, use different passwords on every site. Use LastPass or 1Password. Enable 2-factor authentication. Be vigilant. Do not use the excuse that it&#8217;s too hard or a burden. What&#8217;s much more of a burden is dealing with a hacked email or bank account. Protect yourself and learn how to protect your accounts. It&#8217;s easy to adjust to and modern tools make it a much simpler task to manage.</p>\n<p>Let&#8217;s all &#8212; web professionals and users &#8212; learn with iThemes here, and do better.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 23:30:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: WordPress StackExchange Thrives in 2014 with 17 Million Page Views and 14K New Questions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36695\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://wptavern.com/wordpress-stackexchange-thrives-in-2014-with-17-million-page-views-and-14k-new-questions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10679:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/wpse.png\" rel=\"prettyphoto[36695]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/wpse.png?resize=746%2C363\" alt=\"wpse\" class=\"aligncenter size-full wp-image-36734\" /></a></p>\n<p>Last week, moderators from the <a href=\"http://wordpress.stackexchange.com/\" target=\"_blank\">WordPress Development StackExchange</a> (WPSE) posted a short summary of <a href=\"http://meta.wordpress.stackexchange.com/questions/3951/happy-new-year-how-about-some-stats/3952#3952\" target=\"_blank\">stats from 2014</a>, which demonstrate the remarkable growth and success of the community surrounding the site. This past year WPSE pulled in approximately 15,000 new users, bringing the total to 45,000.</p>\n<p>The site received a total of 17 million page views during 2014. Users submitted 14,000 new questions, and the site received 13,000 new answers.</p>\n<p>The question and answer model employed at the WordPress StackExchange may not be a perfect forumula, but it works. If you&#8217;re a developer looking for help, you&#8217;re far more likely to receive high quality answers on WPSE than on the official WordPress.org forums. On average, the two forums cater to different types of users.</p>\n<p>The <a href=\"http://stackexchange.com/\" target=\"_blank\">StackExchange</a> question and answer communities are expert communities by design. Right answers float to the top, based on votes from experts in the community, making it an efficient way to locate the most helpful answers.</p>\n<p>In more traditional forums, you&#8217;ll spend quite a bit of time weeding through useless, poor quality information to find what you&#8217;re looking for. Those who share their knowledge on StackExchange communities earn reputation points, which also helps users discern the quality of answers provided. Overall, it&#8217;s a tidy formula for engaging and rewarding expert advice.</p>\n<h3>The Culture of the WordPress StackExchange Community</h3>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/rarst-wpse.png\" rel=\"prettyphoto[36695]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/rarst-wpse.png?resize=300%2C199\" alt=\"rarst-wpse\" class=\"alignright size-medium wp-image-36731\" /></a>Each new StackExchange community passes through a beta period where it is required to demonstrate sustained activity around the topic. I spoke with <a href=\"http://www.rarst.net/\" target=\"_blank\">Andrey Savchenko</a>, better known online as <a href=\"https://twitter.com/rarst\" target=\"_blank\">@Rarst</a>, a moderator who has witnessed the evolution of WPSE from its early beta days to today. Browsing through questions on the site, there seem to be very few beginner inquiries, as compared to WordPress.org support. I asked Savchenko if the site purposely attracts a different crowd or if the questions are heavily moderated.</p>\n<p>&#8220;At 45,000+ registered users it would be hard for me to paint an average user in few strokes,&#8221; he said. &#8220;Out of more obvious quirks I would say is that WPSE seems more heavily European than WordPress&#8217; usual.</p>\n<p>&#8220;It&#8217;s also a clearly for–developer resource in a primarily user–centric WordPress world, which doesn&#8217;t mean beginner development questions are unwelcome — they often make some of the best ones. But beginner user questions aren&#8217;t something we historically selected for.&#8221;</p>\n<p>While moderation is one of the key features in place in every StackExchange network, Rarst believes it&#8217;s not as heavy as one might imagine. &#8220;I think SE moderation is efficient rather than heavy. It is strict when it needs to be and intelligently flexible when not,&#8221; he said.</p>\n<p>Why do many WordPress users prefer getting help at WPSE as opposed to WordPress.org? Apart from the general difference in the user base, the WPSE community has a different mission and approach to answering questions.</p>\n<p>&#8220;WPSE is a unique case of a high profile WordPress site outside of the WordPress ethos. In a way, we are the other side of the coin — a corner for people who don&#8217;t click with mainline WordPress resources too well,&#8221; Rarst explained.</p>\n<p>&#8220;For StackExchange, the cultivation of knowledge is the primary mission, as the WordPress.org documentation and forums often feel like a neglected afterthought.&#8221; WPSE offers an alternative way to explore WordPress development questions, outside of the culture that exists on WordPress.org.</p>\n<h3>WPSE Thrives on an Organic, Self-Governing Organizational Structure</h3>\n<p>WPSE manages to maintain a cohesive community without instituting an overly strict governing body. All WPSE moderators are organically grown within the community. &#8220;People tend to choose their own level of social involvement; the system isn&#8217;t really opinionated about it,&#8221; Rarst said. &#8220;There are some chatty types, who are around on our meta site and in &#8216;The Loop&#8217; chat room a lot. There are also plenty of high ranked people who keep to themselves and stay a complete mystery, apart from avatar and nickname.&#8221;</p>\n<p>When it comes to housekeeping, WPSE has a natural structure, which lends moderation capabilities to members with the most influence and participation. &#8220;The moderators tend to have a lot of pull in organizational issues, but they tend to be elected moderators because they already have that influence,&#8221; Rarst explained. &#8220;Position comes to those who have established themselves, not the other way around.&#8221;</p>\n<p>The overarching StackExchange mission has been key to the community&#8217;s success. The purpose of the 133 StackExchange communities is to enable users to ask questions and get answers without distraction. Unlike a traditional discussion forum, replies are heavily geared towards answers without a lot of chit-chat. &#8220;I think the focus with which Stack Exchange pursues their goals and their dedication to empowering people to contribute is what captures users on any topic,&#8221; Rarst said.</p>\n<p>Users are encouraged to follow a simple set of guidelines when asking questions. They are encouraged to keep questions tightly focused on the topic at hand and to avoid opinion-based questions that would generate a lengthy discussion.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/stackexchange-guidelines.png\" rel=\"prettyphoto[36695]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/stackexchange-guidelines.png?resize=548%2C321\" alt=\"stackexchange-guidelines\" class=\"aligncenter size-full wp-image-36713\" /></a></p>\n<p>In the early days, the site was more exploratory, and moderators were open to trying new things to see where it went. &#8220;These days we are more reserved — we learned what works well for us, what is our main identity,&#8221; Rarst said. &#8220;We had finally pushed through name change to &#8216;WordPress Development&#8217; from &#8216;WordPress Answers&#8217;, which had temporarily and accidentally stuck.&#8221;</p>\n<p>They also learned what kind of content to turn away in order to keep the site working well. &#8220;The most prominent example is probably a much more stronger enforcement of questions specific to plugins and themes being out of scope for our general WordPress development focus,&#8221; Rarst said. This helps to keep the site more focused on how WordPress itself works, as opposed to getting overrun with support questions regarding third-party extensions.</p>\n<p>Over the years, moderators and participants have actively sought to <a href=\"http://meta.wordpress.stackexchange.com/questions/3697/our-wooes-and-future-of-platform-plugins-at-wpse\" target=\"_blank\">elicit feedback</a> in order to improve the experience at WPSE, on both the meta site and on <a href=\"http://www.reddit.com/r/Wordpress/comments/ljlsy/what_do_you_guys_think_of/\" target=\"_blank\">Reddit</a>. Discussion from these exchanges has helped shape the direction of the site to filter out questions that detract from the main mission.</p>\n<h3>What Makes WPSE a Good Place to Ask Questions?</h3>\n<p>WPSE stats show that the most voted new question in 2014 was, &#8220;<a href=\"http://wordpress.stackexchange.com/questions/131697/what-is-your-best-practice-to-execute-one-time-scripts\" target=\"_blank\">What is your best practice to execute one-time scripts?</a>&#8221; The most viewed new question was <a href=\"http://wordpress.stackexchange.com/q/141125/847\" target=\"_blank\">&#8220;Allow HTML in Excerpt</a>&#8221; with 8,300+ views.</p>\n<p>With a predominantly developer-oriented community, Rarst believes that the WPSE model is working because it attracts competent WordPress experts to participate. Like-minded users and moderators have cultivated a fertile soil for answers. &#8220;I consider answering questions an immense personal learning opportunity, but also I think as a resource it is important for WordPress knowledge infrastructure, which is starved for quality information,&#8221; Rarst said.</p>\n<p>The points-based reputation system also helps in motivating users to submit answers, although Rarst doesn&#8217;t attribute it to having played a large role in the site&#8217;s success. &#8220;I wouldn&#8217;t try to guess if points made Stack Exchange popular or was it other way around,&#8221; he said. &#8220;They definitely add a playful component to the experience, but the additional nature of &#8216;play&#8217; is the key here — hardly anyone would participate for points alone in my opinion.&#8221;</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/stackexchange-points.png\" rel=\"prettyphoto[36695]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/stackexchange-points.png?resize=540%2C169\" alt=\"stackexchange-points\" class=\"aligncenter size-full wp-image-36712\" /></a></p>\n<p>The success is more likely attributed to the combination of dedicated and proven moderators, a focused mission, and a foundational question-and-answer format that simply works. Spend a few minutes sifting through questions on the site and you&#8217;ll undoubtedly have the opportunity to explore the inner workings of WordPress with knowledgeable, experienced respondents on hand.</p>\n<p>The growth of the site over the past year shows that WPSE is quickly becoming a popular, high quality resource for finding answers to WordPress-related questions. If you&#8217;re stuck, and you&#8217;ve already done your homework of googling and browsing other forums, WPSE is a solid option for getting real answers without all the extra fluff.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 22:00:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Rise of Bacon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44575\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://ma.tt/2015/01/rise-of-bacon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:217:\"<p><a href=\"http://businessweek.com/articles/2014-10-06/bacon-why-americas-favorite-food-mania-happened\">This article on the amazing rise of bacon</a> was one of my favorite articles I read last year. About bacon.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 13:34:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Control the Visibility of WordPress Widgets Based on Time and Date\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=35102\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/control-the-visibility-of-wordpress-widgets-based-on-time-and-date\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3203:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/time.jpg\" rel=\"prettyphoto[35102]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/time.jpg?resize=1024%2C496\" alt=\"photo credit: Βethan - cc\" class=\"size-full wp-image-35409\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/beth19/4721798240/\">Βethan</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>The traditional use of widgets in WordPress is to set it and forget it. After placing and configuring a widget, it stays in the widgetized area until manually removed. Many plugins have extended widgets to add visibility settings that are based on the page or post where the widget appears. But what if you could also control widgets based on time and date?</p>\n<p>The new <a href=\"https://wordpress.org/plugins/widget-visibility-time-scheduler/\" target=\"_blank\">Widget Visibility Time Scheduler</a> plugin actually allows you to schedule the display of widgets down to the minute. The plugin, created by WordPress developer <a href=\"https://profiles.wordpress.org/hinjiriyo/\" target=\"_blank\">Martin Stehle</a>, adds time-based visibility settings to each widget&#8217;s configuration options.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/widget-visibility.png\" rel=\"prettyphoto[35102]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/widget-visibility.png?resize=446%2C485\" alt=\"widget-visibility\" class=\"aligncenter size-full wp-image-35115\" /></a></p>\n<p>Widget Visibility Time Scheduler was designed to work seamlessly with <a href=\"http://jetpack.me/support/widget-visibility/\" target=\"_blank\">Jetpack&#8217;s Widget Visibility module</a>, which allows you to limit widget display to certain pages. There is no conflict if your site is Jetpack-enabled and you can even use the two visibility options in combination with one another.</p>\n<p>The plugin is perfect for seasonal widgets, temporary sales/promotions, events, live chat buttons, and any other time/date-dependent content. One feature that might be useful to add is an indefinite option for the end time of the widget display. That would enable users to schedule future widgets and leave them in place indefinitely. Additionally, an option to set the widget display based on the day of the week could offer more flexibility.</p>\n<p>After testing the plugin, I can confirm that it works as advertised. If you try the plugin and you want to remove it at a later point in time, you&#8217;ll need to uncheck the widget visibility time scheduler box in each widget before you remove that plugin. This will ensure that none of its data remains in the database after you remove the plugin.</p>\n<p>Widget Visibility Time Scheduler is a handy addition to any site using WordPress as a CMS, an e-commerce platform, or even a blog. In combination with the Jetpack module, it offers full control over when and where your widgets are displayed. This is one you may want to favorite for the next time you need to use it. The plugin is available for <a href=\"https://wordpress.org/plugins/widget-visibility-time-scheduler/\" target=\"_blank\">download from WordPress.org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Jan 2015 22:13:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Emil Uzelac Launches New WordPress Theme Review Service\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36615\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/emil-uzelac-launches-new-wordpress-theme-review-service\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4358:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/theme-review-service.png\" rel=\"prettyphoto[36615]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/theme-review-service.png?resize=300%2C231\" alt=\"theme-review-service\" class=\"alignright size-medium wp-image-36641\" /></a>Emil Uzelac&#8217;s new <a href=\"http://themereview.co/\" target=\"_blank\">WordPress Theme Review service</a> is the first of its kind. As a <a href=\"https://twitter.com/emiluzelac/status/545569135808483328\" target=\"_blank\">four-year veteran</a> of the WordPress.org Theme Review Team, he is uniquely qualified to operate a service that focuses on theme standards and quality control.</p>\n<p>Uzelac plans to assist developers with theme reviews for client projects, commercial themes, and free themes submitted to WordPress.org. The reviews are aimed not only at helping developers meet the latest WordPress theme guidelines but also at catching bugs before the product gains distribution. The service will also aim to give customers detailed feedback on performance and security.</p>\n<p>A preliminary review starts at $90 for the first hour. <strong>&#8220;You would be surprised how much one can find within an hour,&#8221;</strong> Uzelac told the Tavern.</p>\n<p>&#8220;The service will cover things like efficiency, performance, sanity, and the overall code quality,&#8221; he said. &#8220;It will also include UX improvements for both desktop and mobile devices. My goal is also to educate as well,&#8221; he said. Customers who use the service will receive suggestions for improvement, along with examples and support from Uzelac.</p>\n<p>&#8220;Look, no one wants to ship a theme with issues,&#8221; Uzelac said. &#8220;Everyone knows time constraints and the pressure to finish can introduce mistakes even the most seasoned developers miss. That’s completely normal. But frustrated end users quickly abandon themes they don’t understand or can’t fix.&#8221; As the original author of <a href=\"https://wordpress.org/themes/responsive\" target=\"_blank\">Responsive</a>, one of most popular themes of all time on WordPress.org, Uzelac knows the kind of quality and support required to build a strong user base.</p>\n<h3>The Need for Professional Theme Review</h3>\n<p>In the past, getting a theme through the rigorous review process for WordPress.org could take weeks. If you have errors that need to be fixed, your theme goes back into the queue to be reviewed again. Being able to make it through the first time with no issues is advantageous to developers who are hoping to release their themes to the public as soon as possible.</p>\n<p><a href=\"http://devrix.com/\" target=\"_blank\">Mario Peshev</a> recently touched on this topic when we interviewed him regarding his <a href=\"http://wptavern.com/devrix-and-emil-uzelac-team-up-to-produce-masonry-a-free-wordpress-theme\" target=\"_blank\">partnership with Uzelac to launch a theme for his company</a>. &#8220;There is no clear way to hire any of them for theme reviews or building a theme following the WordPress.org guidelines,&#8221; Peshev said, commenting on the lack of visibility of the WordPress Theme Review Team. &#8220;I assume that small and medium agencies would be willing to pay for professional reviews or getting themes built for any reason, which would support both parties,&#8221; he said.</p>\n<p>WordPress users are losing confidence in large commercial theme marketplaces that continue to sell products riddled with <a href=\"http://wptavern.com/why-wordpress-theme-developers-are-moving-functionality-into-plugins\" target=\"_blank\">bad practices</a> and <a href=\"http://wptavern.com/100000-wordpress-sites-compromised-using-the-slider-revolution-security-vulnerability\" target=\"_blank\">security vulnerabilities</a>. The community has a need for a service that can authoritatively address problems with WordPress themes and educate developers on best practices.</p>\n<p>Despite launching his <a href=\"http://themereview.co/\" target=\"_blank\">theme review service</a>, Uzelac plans to continue volunteering on the WordPress.org Theme Review Team for many years to come. &#8220;This is something I enjoy doing, even more than creating themes,&#8221; he said. If the service takes off, he plans to do it full-time and hopes to take on additional reviewers to grow the business.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Jan 2015 18:34:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Matt: What’s in My Bag, 2014\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44570\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"http://ma.tt/2015/01/whats-in-my-bag-2014/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6355:\"<p>As the start of a new year&#8217;s tradition, I&#8217;d like to take inventory of what I carry around in my backpack, which I have with me almost everywhere I go. I&#8217;m constantly iterating and changing what I carry around, so I hope it&#8217;s interesting to see this vignette of what I&#8217;ve found to be the best or most effective items to have with me all the time. With the things in this backpack I can be productive pretty much any place on the planet with a wifi or LTE connection.</p>\n<p><a href=\"http://i1.wp.com/ma.tt/files/2015/01/IMG_4001.jpg\"><img class=\"alignnone\" src=\"http://i1.wp.com/ma.tt/files/2015/01/IMG_4001.jpg?resize=604%2C453\" alt=\"\" /></a></p>\n<ol>\n<li><a href=\"http://www.amazon.com/Kensington-International-Travel-Adapter-K38120WW/dp/B00I3E1ENW/\">Kensington international adapter</a>, I like this one because it has two USB ports, but every adapter I&#8217;ve used seems a little janky.</li>\n<li><a title=\"Been putting a lot of miles on these.\" href=\"http://www.amazon.com/dp/B00DIOAM4Y/\">Plantronics BackBeat GO 2 with charging case</a>, as I mentioned <a href=\"http://ma.tt/2014/10/beats-studio-wireless-vs-samsung-level-over/\">in my headphones post</a>.</li>\n<li><a href=\"http://www.amazon.com/High-Resolution-Display-Adaptive-PagePress-Sensors/dp/B00IOYAM4I/\">Kindle Voyage</a>. Love love love.</li>\n<li>64gb USB stick.</li>\n<li>Lockpick set.</li>\n<li>Apple Thunderbolt / VGA adapter. (I can probably stop carrying this around.)</li>\n<li>Samsung Level Over, as I mentioned <a href=\"http://ma.tt/2014/10/beats-studio-wireless-vs-samsung-level-over/\">in my headphones post</a>.</li>\n<li>Macbook power adapter, and <a href=\"http://www.motorola.com/us/accessories-bluetooth-headsets/Moto-Hint/moto-hint-pdp.html\">Moto Hint bluetooth headset</a>.</li>\n<li>Audrey Hepburn deck of playing cards, and business card holder. The last few items <a href=\"http://www.cocooninnovations.com/grid.php\">are on a Gridit holder</a>, which I like but seems to drop items as I walk around.</li>\n<li><a href=\"http://www.amazon.com/Macally-Charger-iPhone-Mobile-Devices/dp/B003UATJ7C/\">Macally double USB charger</a>, which I like because the plug pivots, and it can charge an iPad at full speed.</li>\n<li>Thunderbolt to thunderbolt cable, which is great for transferring between computers, and <a href=\"http://www.amazon.com/Belkin-Rockstar-Multi-Headphone-Splitter/dp/B00475K64E/\">Belkin audio cable splitter</a>, with an old Beats cable wrapped around which I use with the Samsung headphones.</li>\n<li><a href=\"http://www.amazon.com/gp/product/B00LIS9EM8/\">Retractable HMDI cable</a>.</li>\n<li>Garmin chest strap heart rate monitor, for running.</li>\n<li>Miscellaneous retractable cables: Jawbone UP24 charger (not using the UP at the moment, just the Basis), 1/8th inch audio cable, ethernet CAT5e, USB mini type B.</li>\n<li><a title=\"Best sound, best comfort, but my ears get waxy when I wear them too much.\" href=\"http://pro.ultimateears.com/en-us/home/18-Pro\">Ultimate Ears 18 Pro Custom</a>, with a <a href=\"http://thisisground.com/collections/cordtaco\">gold cord taco</a>.</li>\n<li>Jetpack notebook for taking analog notes.</li>\n<li>Some <a href=\"http://www.amazon.com/Bag-Balm-Vermonts-Original-Moisturizing-Softening/dp/B001838FPA\">bag balm</a> in a little plastic holder, an <a href=\"http://www.amazon.com/Aveda-Blue-Oil-0-24-oz/dp/B0031KN9UE\">Aveda Blue Oil</a> that I find relaxing, and some Advil for when ouches happen.</li>\n<li><a href=\"https://www.amazon.com/gp/product/B007PTCFFW/\">TP-LINK TL-WR702N Wireless N150 Travel Router</a>, which works so-so.</li>\n<li>Chargers for the two watches.</li>\n<li><a href=\"http://www.amazon.com/gp/product/B00KINSDK8\">Mpow Streambot Mini Wireless Bluetooth 4.0 Audio Music Streaming Receiver Adapter</a>.</li>\n<li>Apple Magic Mouse, still the best.</li>\n<li>Moto X second generation, with walnut back and orange highlights.</li>\n<li>Not pictured, iPhone 6+, because it took the picture, space grey of course.</li>\n<li>Miscellaneous swag and trinkets, and a T-mobile SIM card.</li>\n<li>Maison Bonnet sunglasses and cleaning cloth.</li>\n<li><a href=\"http://www.amazon.com/Lamy-Pico-Pocket-Ballpoint-White/dp/B00439T9OM/\">Lamy Pico Pocket Ballpoint pen</a>.</li>\n<li>Brand new passport! No stamps in it yet. Unfortunately picture was taken when I was still in the mustache competition.</li>\n<li><a href=\"http://www.amazon.com/Basis-Peak-Ultimate-Fitness-Tracker/dp/B00GJG79LM\">Basis Peak watch</a>, which I like a lot overall.</li>\n<li><a href=\"http://www.amazon.com/Garmin-Forerunner-620-Black-Bundle/dp/B00FBYYC90\">Garmin Forerunner 620</a>, for quantifying running along with the chest strap in #13.</li>\n<li><a href=\"http://www.westoneaudio.com/index.php/products/hearing-protection/es49-custom-hearing-protection.html\">Westone ES49 custom earplugs</a>, for if I go to concerts or anyplace overly loud.</li>\n<li><a href=\"http://www.amazon.com/Bucky-Eye-Shades-Earplugs-Black/dp/B000FFSWAU/\">Bucky eye shades</a>, like an eye mask but has a curve so it doesn&#8217;t touch your eyes. I don&#8217;t use this often but when I do it&#8217;s a life-saver.</li>\n<li>Retina Macbook Pro, 15 inch, with a few stickers and the custom W light cut-out.</li>\n<li>The bag that holds everything pictured: <a href=\"http://www.hardgraft.com/products/oldschoolrucksack-heritage\">Old School Laptop Rucksack</a>. I wish it had a few more interior pockets for organizing things. It&#8217;s starting to get pretty worn, I probably need to treat the leather on the bottom.</li>\n<li>Not pictured: <a href=\"http://www.amazon.com/Incase-Speed-Charger-Lightning-Cable/dp/B00P7Y6M2Y/\">Incase dual USB 2.4 amp car charger</a>, a <a href=\"http://www.amazon.com/Belkin-Car-Vent-Mount-Smartphones/dp/B00O5JARCI/\">Belkin car mount</a>, and a retractable lightning cable. (They were in the car when I took this.)</li>\n</ol>\n<p><a href=\"http://i1.wp.com/ma.tt/files/2015/01/IMG_4001.jpg\"><img class=\"alignnone\" src=\"http://i1.wp.com/ma.tt/files/2015/01/IMG_4001.jpg?resize=604%2C453\" alt=\"\" /></a></p>\n<p>So if you add it all up, there are about 53 unique items I&#8217;m carrying around all the time. I&#8217;m curious how this total number changes over time as well. If you have any recommendations for a better, lighter, or more functional item than what I&#8217;m carrying please leave it in the comments!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Jan 2015 17:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Kim Parsell, Affectionately Known as #wpmom Passes Away\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36618\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/kim-parsell-affectionately-known-as-wpmom-passes-away\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9532:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsell.png\" rel=\"prettyphoto[36618]\"><img class=\"size-full wp-image-36619\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsell.png?resize=655%2C418\" alt=\"WordCamp San Francisco 2014 By Sheri Bigelow\" /></a>WordCamp San Francisco 2014 By Sheri Bigelow\n<p>In the eight years I&#8217;ve covered the WordPress scene, <a title=\"http://web.archive.org/web/20120827003459/http://www.wptavern.com/forum/forum-lobby/1003-rip-dan-schulz.html\" href=\"http://web.archive.org/web/20120827003459/http://www.wptavern.com/forum/forum-lobby/1003-rip-dan-schulz.html\">only once</a> have I written about someone passing away. It&#8217;s with a heavy heart and great sadness to inform you that <a title=\"https://profiles.wordpress.org/kpdesign\" href=\"https://profiles.wordpress.org/kpdesign\">Kim Parsell</a> passed away last week at her home in Southern, Ohio. The cause of death is unknown and a small service is tentatively scheduled for this Saturday. There&#8217;s also a memorial type of event being planned for WordCamp Columbus, OH.</p>\n<h2>Kim Parsell The Photographer</h2>\n<p>Before getting actively involved in the WordPress project, she was an <a title=\"http://www.kpimages.net/index.php?x=browse&pagenum=1\" href=\"http://www.kpimages.net/index.php?x=browse&pagenum=1\">avid photographer</a>. Almost all of the photos she published were taken on her property in Southern, Ohio. She had an eye for nature&#8217;s beauty and showed the world through photography how beautiful Ohio is. Her photos are so good that I think she could have made a living selling them as prints.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParesellSpringtimeSunset.png\" rel=\"prettyphoto[36618]\"><img class=\"size-full wp-image-36620\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParesellSpringtimeSunset.png?resize=969%2C560\" alt=\"Springtime Sky by Kim Parsell\" /></a>Springtime Sky by Kim Parsell\n<h2>Kim Parsell The Contributor</h2>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsellWordPressProfile.png\" rel=\"prettyphoto[36618]\"><img class=\"size-full wp-image-36626\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsellWordPressProfile.png?resize=963%2C459\" alt=\"Kim Parsell\'s WordPress.org Profile\" /></a>Kim Parsell&#8217;s WordPress.org Profile\n<p>In the past few years, Kim has worked on improving documentation in WordPress as a member of the docs team. She substantially contributed to the effort of adding <a title=\"https://make.wordpress.org/docs/inline-docs/\" href=\"https://make.wordpress.org/docs/inline-docs/\">inline documentation</a> to every hook in WordPress. Her contributions got her <a title=\"http://wordpress.tv/2014/10/26/matt-mullenweg-the-state-of-the-word-2014/\" href=\"http://wordpress.tv/2014/10/26/matt-mullenweg-the-state-of-the-word-2014/\">mentioned by Matt Mullenweg</a> (11:00 minute mark) during his State of the Word presentation at WordCamp San Francisco 2014. She&#8217;s contributed to every release of WordPress from 3.7 to 4.1.</p>\n<p>Being mentioned in the State of the Word is one of Kim&#8217;s best moments and it meant a lot to her. Sarah Pressler <a title=\"http://sarahpressler.com/time-ran-short/\" href=\"http://sarahpressler.com/time-ran-short/\">accurately describes</a> the jubilation felt by Kim, “Can you believe it? Me!!! In Matt’s talk! Me!? I…just …. I can’t believe it. Little ol’ me. An old lady up there on the screen with all the kids. It’s official, I really am #WPMom now.”</p>\n<h2>Kim Parsell The #wpmom</h2>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsellDocsTeamMeetup.jpg\" rel=\"prettyphoto[36618]\"><img class=\"wp-image-36621 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsellDocsTeamMeetup.jpg?resize=750%2C460\" alt=\"The Docs Team Meetup in Cincinnati 2013 - Image Courtesy of <a title=\" /><a title=\" http:=\"></a>Kim Parsell With the Docs Team Meetup in Cincinnati 2013\n<p>Kim became known throughout the WordPress community as <a title=\"https://twitter.com/hashtag/wpmom\" href=\"https://twitter.com/hashtag/wpmom\">#wpmom,</a> a title she fully embraced. She had a way of giving people purpose, taking them under her wing, and showing compassion when it was needed most. As <a title=\"http://www.carriedils.com/for-you-kim/\" href=\"http://www.carriedils.com/for-you-kim/\">Carrie Dils explains</a>, &#8220;Folks jokingly call her <a href=\"https://twitter.com/hashtag/wpmom?src=hash\" target=\"_blank\">#wpmom</a>, but there’s a lot of truth there. She was very much like a mother figure, but never EVER in a condescending way.&#8221;</p>\n<p>In a <a title=\"http://www.carriedils.com/for-you-kim/#comment-68920\" href=\"http://www.carriedils.com/for-you-kim/#comment-68920\">comment</a> on the same post, Amanda describes exactly the type of person Kim was, &#8220;The greatest thing about Kim is that whether you’re standing at the back of the line or the front she would have walked her way down that line to let everyone know they were equally as important and that the only reason there’s a line is because everyone can’t be in the same place at once.&#8221;</p>\n<p>As <a title=\"http://onefinejay.com/2015/01/03/remembering-kim-parsell\" href=\"http://onefinejay.com/2015/01/03/remembering-kim-parsell\">Jayvie Canono found out</a>, Kim didn&#8217;t put up with bull crap from anyone and had no problem letting you know about it. It&#8217;s how she told people which made her unique, &#8220;She brought people together and had the salty, country-gal personality who would <em>not put up with your bull crap</em> and yet would never break one rule of etiquette in the process of letting you know.&#8221;</p>\n<h2>Kim Parsell The Person I Knew</h2>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsellSunset.png\" rel=\"prettyphoto[36618]\"><img class=\"size-full wp-image-36624\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsellSunset.png?resize=1024%2C768\" alt=\"Sunset as Seen From Kim Parsell\'s Property\" /></a>Sunset as Seen From Kim Parsell&#8217;s Property\n<p>Kim referred to herself as “The little ol’ crazy lady at the top of a hill in Ohio.” She wasn&#8217;t crazy but rather, an independent, strong-willed woman who at times was stubborn. A hard worker, she spent a lot of time in rural Ohio alone, &#8220;<span class=\"ProfileHeaderCard-locationText u-dir\" dir=\"ltr\">Chillin&#8217; on a dirt road.</span>&#8221; She routinely drove an hour and a half north to attend <a title=\"http://www.meetup.com/NEOWordPress/\" href=\"http://www.meetup.com/NEOWordPress/\">our WordPress meetup</a> because there wasn&#8217;t a person within 30 miles of her house who knows what WordPress is.</p>\n<p>When I started WordPress Weekly in 2009, she would often join me on each episode to provide the countdown before I hit the record button. She was occasionally a guest on the show as <a title=\"http://wptavern.com/wpweekly-episode-87-%E2%80%93-the-lost-episode\" href=\"http://wptavern.com/wpweekly-episode-87-%E2%80%93-the-lost-episode\">on episode 87</a>. After the show, she would stick around for a half hour to an hour to talk about whatever was on her mind. In many ways, the show offered her an opportunity to connect and speak to WordPress people every week. The show was the closest thing to a meetup she could regularly attend.</p>\n<a href=\"http://recordings.talkshoe.com/TC-34224/TS-317335.mp3\">http://recordings.talkshoe.com/TC-34224/TS-317335.mp3</a>\n<p>She lived in a rural area where her internet was capped at 1.5MB, but it didn&#8217;t stop her from contributing to WordPress. Despite living on top of a hill in Southern Ohio, often alone, she left a lasting impact on people across the world. She wasn&#8217;t much of a speaker but at WordCamp San Francisco 2014, she gave a presentation on WordPress documentation.</p>\n<p></p>\n<h2>Kim Parsell, You Are Missed</h2>\n<p>Kim, you&#8217;re missed by a lot of people, some of whom you&#8217;ve never met. That&#8217;s the kind of impact and legacy you&#8217;ve left us with. You&#8217;re an inspiration to become a better person and be more kind to those in the WordPress community. You opened your heart and soul to whoever needed help and ended every exchange with a smile. I will miss you friend, colleague, and fellow buckeye. My deepest condolences are with the Parsell family.</p>\n<p>If you have a lasting memory of Kim, please share it in the comments.</p>\n<p><strong>Related Reading:</strong></p>\n<ul>\n<li><a title=\"https://make.wordpress.org/docs/2015/01/05/rip-kim-parsell/\" href=\"https://make.wordpress.org/docs/2015/01/05/rip-kim-parsell/\">RIP Kim Parsell </a></li>\n<li><a title=\"http://sarahpressler.com/time-ran-short/\" href=\"http://sarahpressler.com/time-ran-short/\">For Kim. Because Time Ran Short.</a></li>\n<li><a title=\"http://www.carriedils.com/for-you-kim/\" href=\"http://www.carriedils.com/for-you-kim/\">For You, Kim</a></li>\n<li><a title=\"http://onefinejay.com/2015/01/03/remembering-kim-parsell\" href=\"http://onefinejay.com/2015/01/03/remembering-kim-parsell\">Remembering Kim Parsell</a></li>\n<li><a title=\"https://blog.dembowski.net/2015/thank-you-wpmom-for-everything/\" href=\"https://blog.dembowski.net/2015/thank-you-wpmom-for-everything/\">Thank you #wpmom for everything</a></li>\n<li><a title=\"http://werdswords.com/farewell-old-friend/\" href=\"http://werdswords.com/farewell-old-friend/\">Farewell old friend</a></li>\n</ul>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Jan 2015 16:28:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: On API Correctness\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/01/on-api-correctness/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:174:\"<p>Developing an API is hard. <a href=\"https://developer.wordpress.com/2014/12/08/on-api-correctness/\">Here&#8217;s Automattician Demitrious Kelly On API Correctness</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Jan 2015 19:42:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Matt: Case for Distributed Teams\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44564\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://ma.tt/2015/01/case-for-distributed-teams/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:209:\"<p>Avleen Vig wrote a great <a href=\"http://silverwraith.com/blog/2014/12/the-case-for-distributed-teams/\">case for distributed teams</a> that covers many of the high-level highlights I&#8217;d agree with.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Jan 2015 16:00:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Jetpack Speed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://ma.tt/2015/01/jetpack-speed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1422:\"<p>Over on the BruteProtect blog they <a href=\"https://bruteprotect.com/the-jetpack-bloat-myth/\">have a look at the Jetpack Bloat Myth</a>, and find that counter-intuitively even though Jetpack has more comprehensive functionality it&#8217;s faster than using individual plugins to do the same things. There are economies of scale to Jetpack&#8217;s approach, and it doesn&#8217;t even include the impact of doing things more advanced and complex like Related Posts. There&#8217;s a reason why some <a href=\"http://wpengine.com/support/disallowed-plugins/\">web hosts like WP Engine ban most related post plugins but encourage the use of Jetpack</a>.</p>\n<p>The performance of the plugin code, though still faster, is still a small difference when compared to the benefit of offloading certain tasks like image resizing, related posts, stats, video transcoding, and more in the future to the WordPress.com cloud (which is now across 11 datacenters worldwide).</p>\n<p>Of course if you don&#8217;t need the functionality at all it&#8217;s always faster to have nothing, but that&#8217;s a shrinking minority. There are still more optimizations to be had, and in line with <a href=\"http://ma.tt/2014/12/performance-as-design/\">a performance focus in 2015</a> look for more improvements to come in the future. In the meantime, <a href=\"https://bruteprotect.com/the-jetpack-bloat-myth/\">check out the Jetpack benchmarks</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Jan 2015 16:03:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Matt: Software Engineers Should Write\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44560\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://ma.tt/2015/01/software-engineers-should-write/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:151:\"<p>Shubhro Saha on why <a href=\"http://www.shubhro.com/2014/12/27/software-engineers-should-write/\">software engineers should write</a>. Hear hear.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2015 18:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Akismet: December and all of 2014 Stats Roundup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=1753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://blog.akismet.com/2015/01/01/december-and-all-of-2014-stats-roundup/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5184:\"<p><a name=\"text1\"></a><em>Gone with the Wind</em> is the <a href=\"http://en.wikipedia.org/wiki/List_of_highest-grossing_films\">highest-grossing movie</a> of all time &#8211; making over 3 billion dollars<a href=\"http://blog.akismet.com/feed/#footnote1\"><sup>1</sup></a>. The next highest-grossing film is <em>Avatar</em>, with just over 2.7 billion dollars to its name.</p>\n<p><a href=\"http://en.wikipedia.org/wiki/File:Avatar-Teaser-Poster.jpg\"><img class=\" size-medium wp-image-1758 alignleft\" src=\"https://akismet.files.wordpress.com/2015/01/avatar-poster.jpg?w=202&h=300\" alt=\"Avatar movie poster\" width=\"202\" height=\"300\" /></a></p>\n<p><a href=\"http://en.wikipedia.org/wiki/File:Poster_-_Gone_With_the_Wind_01.jpg\"><img class=\" size-medium wp-image-1759 alignnone\" src=\"https://akismet.files.wordpress.com/2015/01/gone-with-the-wind-poster.jpg?w=195&h=300\" alt=\"Gone with the Wind movie poster\" width=\"195\" height=\"300\" /></a></p>\n<p>&nbsp;</p>\n<p>In December, Akismet caught <strong>10,136,855,000 spam comments</strong> &#8211; that&#8217;s just over 10 billion. If each spam comment were one dollar, that amount would be about <strong>equal to 3 times the total sales of <em>Gone with the Wind</em></strong>. Not too shabby.</p>\n<p>On the other hand, Akismet saw just 156,497,000 real comments go through in December. If each one of those were one dollar, they&#8217;d make up about 4% of the total sales of <em>Gone with the Wind</em>. As is usual, we see much less real comments than spam comments &#8211; at a ratio of about 1 to 65 this month.</p>\n<p>Here&#8217;s the day-to-day breakdown:</p>\n<div id=\"attachment_1761\" class=\"wp-caption alignnone\"><img class=\"wp-image-1761 size-large\" src=\"https://akismet.files.wordpress.com/2015/01/akismet-spam-and-ham-stats-december-2014.png?w=700&h=438\" alt=\"Akismet spam and ham numbers plot for the month of December 2014\" /><p class=\"wp-caption-text\">The busiest day of the month was the 5th with just over 409 million spam comments, and the slowest day was the 10th with just under 267 spam comments.</p></div>\n<p>&nbsp;</p>\n<p>For the first time since June, Akismet saw a drop in the number of spam comments month-to-month &#8211; we dropped 16% compared to November. However, we still saw a rise of 52% since last year in December.</p>\n<p>Now&#8230; what about 2014 as a whole? Here&#8217;s what that looked like in plot form:</p>\n<p><a href=\"https://akismet.files.wordpress.com/2015/01/akismet-stats-in-2014.png\"><img class=\"alignnone size-large wp-image-1762\" src=\"https://akismet.files.wordpress.com/2015/01/akismet-stats-in-2014.png?w=700&h=438\" alt=\"Akismet monthly spam and ham numbers for 2014\" /></a></p>\n<p>&nbsp;</p>\n<p>How do the numbers fare against the highest grossing movies of all time? In January 2014, Akismet saw about 6 billion comments go through in total. If each comment were one dollar, <strong>that&#8217;s like the total sales of <em>Gone with the Wind</em> and <em>Avatar</em> combined</strong>.</p>\n<p>Things were moving along at about the same rate until <a href=\"http://blog.akismet.com/2014/09/01/august-stats-roundup/\">August</a>, when we started noticing much more spam coming through. In <a href=\"http://blog.akismet.com/2014/10/01/september-stats-roundup/\">September</a> we hit the 300 million spam caught per day mark. In total, there were 8 billion comments caught.</p>\n<p>November was our highest-traffic month with over 12 billion spam comments caught. Continuing with our movie example, that would be like adding up the totals for the top 4 highest grossing films and then a little more: <em>Gone with the Wind</em> and <em>Avatar</em> and <em>Star Wars</em> and <em>Titanic.</em></p>\n<p><strong>What about the total amount of spam for 2014? That&#8217;s 90,326,951,500 &#8211; like adding up the total sales of the top 10 movies&#8230; and quadrupling that number.</strong></p>\n<p>Over the year, you may have seen similar trends in the amount of spam comments that you see come through on your own blog or website. As always, if you&#8217;re having any issues please do <a href=\"http://akismet.com/contact/\">contact us</a>, we&#8217;re happy to help!</p>\n<p>We&#8217;re looking forward to an even more fruitful 2015, with Akismet continuing to save you from your spam. All of us from Akismet wish you a thrilling, successful, and happy new year!</p>\n<p><em>This post is part of a monthly series summarizing some stats and figures from the Akismet universe. Feel free to browse <a href=\"http://blog.akismet.com/category/monthly-roundup/\">all of the posts in the series</a>.</em></p>\n<p>Footnote<br />\n<a href=\"http://blog.akismet.com/feed/#text1\" name=\"footnote1\"><sup>1</sup></a>when adjusted for inflation in 2011 dollars, which is what really counts <span class=\"wp-smiley wp-emoji wp-emoji-wink\" title=\";)\">;)</span></p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/akismet.wordpress.com/1753/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/akismet.wordpress.com/1753/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.akismet.com&blog=116920&post=1753&subd=akismet&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2015 17:30:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Valerie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Donate to GnuPG\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2014/12/donate-to-gnupg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:185:\"<p>With the news that PGP is one of the things that is still tough for the NSA, now is a <a href=\"https://www.gnupg.org/donate/\">great time to donate to GnuPG</a>, which I just did.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Dec 2014 21:56:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: How to Preview Posts in Distraction-free Writing Mode Without Seeing a Transition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36595\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://wptavern.com/how-to-preview-posts-in-distraction-free-writing-mode-without-seeing-a-transition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1905:\"<p>In order to see the post meta boxes using <a title=\"http://wptavern.com/wordpress-4-1-dinah-released\" href=\"http://wptavern.com/wordpress-4-1-dinah-released\">Distraction-free Writing Mode in WordPress 4.1</a>, you have to move the cursor away from the post editor. During the editing process, you may need to preview a post several times. Since the preview button is only available when the publish meta box is shown, you have to go in and out of DFW mode multiple times before publishing a post.</p>\n<p>This can not only be annoying, but discourage you from using DFW mode altogether. Thankfully, there&#8217;s a <a title=\"https://wordpress.org/plugins/fullscreen-preview-button/\" href=\"https://wordpress.org/plugins/fullscreen-preview-button/\">handy plugin</a> by Alex King that solves the problem by adding a preview button inside the post editor.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/PreviewButtonInDFWMode.png\" rel=\"prettyphoto[36595]\"><img class=\"size-full wp-image-36596\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/PreviewButtonInDFWMode.png?resize=1025%2C384\" alt=\"Preview Button is Always Visible\" /></a>Preview Button is Always Visible\n<p>The preview button inside the editor significantly reduces the amount of times the DFW transition occurs. What&#8217;s nice about this plugin is that when you disable DFW mode, the preview button disappears in favor of the publish meta box.</p>\n<p>I tested the plugin using WordPress 4.1 and didn&#8217;t encounter any issues. The plugin is available in the <a title=\"https://wordpress.org/plugins/fullscreen-preview-button/\" href=\"https://wordpress.org/plugins/fullscreen-preview-button/\">plugin directory</a> and <a title=\"https://github.com/alexkingorg/wp-fullscreen-preview-button\" href=\"https://github.com/alexkingorg/wp-fullscreen-preview-button\">Github</a> where pull requests are welcomed.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Dec 2014 20:02:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Benchmarks Indicate Jetpack Doesn’t Negatively Impact Site Loading Times\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/benchmarks-indicate-jetpack-doesnt-negatively-impact-site-loading-times\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3777:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/JetpackBenchmarksFeaturedImage.png\" rel=\"prettyphoto[36539]\"><img class=\"size-full wp-image-36587\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/JetpackBenchmarksFeaturedImage.png?resize=639%2C200\" alt=\"Jetpack Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/thejoshmeister/8395389163/\">the JoshMeister</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p><a title=\"https://wordpress.org/plugins/jetpack/\" href=\"https://wordpress.org/plugins/jetpack/\">Jetpack </a>is a WordPress plugin maintained by Automattic and has more than 30 different modules. The modules provide a variety of features including, contact forms, stats, and related posts.</p>\n<p>Part of Jetpack&#8217;s reputation in the WordPress community is that it&#8217;s bloated and slows down websites. Sam Hotchkiss, who is part of the Jetpack team, has <a title=\"https://bruteprotect.com/the-jetpack-bloat-myth/\" href=\"https://bruteprotect.com/the-jetpack-bloat-myth/\">published benchmark results</a> showing the performance impact of Jetpack is not as bad as you might think.</p>\n<h2>Testing Setup</h2>\n<p>The benchmarks run on two different setups. The first is a website where the user is only running Jetpack with 19 modules activated. (After The Deadline, Contact Form, Custom Content Types, Custom CSS, Gravatar Hovercards, Latex, Notes, Omnisearch, Post By Email, Publicize, Sharedaddy, Shortcodes, Shortlinks, Stats, Subscriptions, Vaultpress, Verification Tools, Widget Visibility, Widgets).</p>\n<p>The second environment involves a user running five plugins that replicate similar functionality of popular modules. (Contact Form 7, Google Analytics Dashboard for WP, Simple Custom CSS, Share Buttons by AddToAny, NextScripts: Social Networks Auto-Poster). The plugins were chosen because they have the most downloads in the directory providing similar functionality.</p>\n<h2>Testing Results</h2>\n<p>Jetpack, First load, TTFB: 773ms<br />\nJetpack, First load, Complete page load: 1876ms<br />\nJetpack, Repeat view, TTFB: 143ms<br />\nJetpack, Repeat view, Complete page load: 322ms</p>\n<p>Other Plugins, First load, TTFB: 797ms<br />\nOther Plugins, First load, Complete page load: 2609ms<br />\nOther Plugins, Repeat view, TTFB: 460ms<br />\nOther Plugins, Repeat view, Complete page load: 529ms</p>\n<p>As you can see, the performance impact from using Jetpack is negligible at best. Jetpack also has fewer HTTP requests overall than the custom plugins installed.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/NumberOfRequests.png\" rel=\"prettyphoto[36539]\"><img class=\"size-full wp-image-36586\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/NumberOfRequests.png?resize=800%2C535\" alt=\"Number of HTTP Requests\" /></a>Number of HTTP Requests\n<p>According to Hotchkiss, there&#8217;s a series of 35 tests that run against Jetpack <strong>every time</strong> a change is committed to the master branch. The tests are designed to detect whether or not a change negatively impacts site performance. Hotchkiss says the test results will be released in the near future, &#8220;We’ll be releasing all the results of these tests to the public in the near future. Every member of the Jetpack team is committed to making sure that performance is a high priority for the project.&#8221;</p>\n<p>The results indicate Jetpack doesn&#8217;t hinder website performance as much as you might think. It&#8217;s only one set of results, but I&#8217;m curious to see how it performs in a variety of situations and environments. Do you think the results accurately represent Jetpack and what other benchmark tests would you like to see performed?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Dec 2014 17:56:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: A Look Back at WordPress News in 2014, Part 2 of 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36578\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/a-look-back-at-wordpress-news-in-2014-part-2-of-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:37876:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/01/FileArchiveFeaturedImage.jpg\" rel=\"prettyphoto[36578]\"><img class=\"size-full wp-image-13971\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/01/FileArchiveFeaturedImage.jpg?resize=1024%2C655\" alt=\"File Archive Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/merlin1487/5518280677/\">Merlin1487</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>This is part two of a <a title=\"http://wptavern.com/a-look-back-at-wordpress-news-in-2014-part-1-of-2\" href=\"http://wptavern.com/a-look-back-at-wordpress-news-in-2014-part-1-of-2\">two part series</a> looking back at WordPress news in 2014. There was plenty of action to write about with over 900 posts published in 2014. Browse through the list and if a particular story had an impact on you, let us know in the comments.</p>\n<p>The stories included here are handpicked based on their newsworthiness, importance, and whether they generated a healthy discussion in the comments. The posts are in chronological order starting with July.</p>\n<h2>July</h2>\n<ul>\n<li><a title=\"WordPress MailPoet Plugin Security Vulnerability: Immediate Update Recommended\" href=\"http://wptavern.com/wordpress-mailpoet-plugin-security-vulnerability-immediate-update-recommended\">WordPress MailPoet Plugin Security Vulnerability: Immediate Update Recommended </a></li>\n<li><a title=\"VersionPress Misses Crowdfunding Goal By $14.5K\" href=\"http://wptavern.com/versionpress-misses-crowdfunding-goal-by-14-5k\">VersionPress Misses Crowdfunding Goal By $14.5K </a></li>\n<li><a title=\"WordPress Visual Page and Website Builders Make It Easy To Create Ugly Sites\" href=\"http://wptavern.com/wordpress-visual-page-and-website-builders-make-it-easy-to-create-ugly-sites\">WordPress Visual Page and Website Builders Make It Easy To Create Ugly Sites </a></li>\n<li><a title=\"WPBeginner Turns 5, Celebrates With Campaign To Build Two New Schools In Guatemala\" href=\"http://wptavern.com/wpbeginner-turns-5-celebrates-with-campaign-to-build-two-new-schools-in-guatemala\">WPBeginner Turns 5, Celebrates With Campaign To Build Two New Schools In Guatemala </a></li>\n<li><a title=\"In The Next Few Years, 90% Of WordPress Development Could Be JavaScript Based\" href=\"http://wptavern.com/in-the-next-few-years-90-of-wordpress-development-could-be-javascript-based\">In The Next Few Years, 90% Of WordPress Development Could Be JavaScript Based </a></li>\n<li><a title=\"WordPress.tv Adds Its First German Presentation: Konstantin Obenland on Underscores\" href=\"http://wptavern.com/wordpress-tv-adds-its-first-german-presentation-konstantin-obenland-on-underscores\">WordPress.tv Adds Its First German Presentation: Konstantin Obenland on Underscores </a></li>\n<li><a title=\"Kinsta Publishes Guide On The History Of WordPress, Its Ecosystem, and Community\" href=\"http://wptavern.com/kinsta-publishes-guide-on-the-history-of-wordpress-its-ecosystem-and-community\">Kinsta Publishes Guide On The History Of WordPress, Its Ecosystem, and Community </a></li>\n<li><a title=\"WP Engine Becomes The First Large Partner To Integrate Sidekick\" href=\"http://wptavern.com/wp-engine-becomes-the-first-large-partner-to-integrate-sidekick\">WP Engine Becomes The First Large Partner To Integrate Sidekick </a></li>\n<li><a title=\"Critical Security Update For WPTouch, Users Should Update Immediately\" href=\"http://wptavern.com/critical-security-update-for-wptouch-users-should-update-immediately\">Critical Security Update For WPTouch, Users Should Update Immediately </a></li>\n<li><a title=\"WP Quick Install Script Offers a Fast Way to Install WordPress, Plugins, and Themes\" href=\"http://wptavern.com/wp-quick-install-script-offers-a-fast-way-to-install-wordpress-plugins-and-themes\">WP Quick Install Script Offers a Fast Way to Install WordPress, Plugins, and Themes </a></li>\n<li><a title=\"Hybrid Core 2.0 Adds Composer Support, Removes Widgets From Framework\" href=\"http://wptavern.com/hybrid-core-2-0-adds-composer-support-removes-widgets-from-framework\">Hybrid Core 2.0 Adds Composer Support, Removes Widgets From Framework </a></li>\n<li><a title=\"Translate WordPress Plugins and Themes Directly in Your Browser\" href=\"http://wptavern.com/translate-wordpress-plugins-and-themes-directly-in-your-browser\">Translate WordPress Plugins and Themes Directly in Your Browser </a></li>\n<li><a title=\"WPcast.fm Billed As The Professional WordPress Podcast\" href=\"http://wptavern.com/wpcast-fm-billed-as-the-professional-wordpress-podcast\">WPcast.fm Billed As The Professional WordPress Podcast </a></li>\n<li><a title=\"Exploring The Idea Of An Internet Archive Specifically For WordPress Content\" href=\"http://wptavern.com/exploring-the-idea-of-an-internet-archive-specifically-for-wordpress-content\">Exploring The Idea Of An Internet Archive Specifically For WordPress Content </a></li>\n<li><a title=\"VaultPress Begins Offering 5 Day Free Trials Through Jetpack\" href=\"http://wptavern.com/vaultpress-begins-offering-5-day-free-trials-through-jetpack\">VaultPress Begins Offering 5 Day Free Trials Through Jetpack </a></li>\n<li><a title=\"Heavy Analytics for WordPress Now Open Source and Available on GitHub\" href=\"http://wptavern.com/heavy-analytics-for-wordpress-now-open-source-and-available-on-github\">Heavy Analytics for WordPress Now Open Source and Available on GitHub </a></li>\n<li><a title=\"GavickPro Abandons Theme Framework in Favor of WordPress Customizer\" href=\"http://wptavern.com/gavickpro-abandons-theme-framework-in-favor-of-wordpress-customizer\">GavickPro Abandons Theme Framework in Favor of WordPress Customizer </a></li>\n<li><a title=\"Automattic\'s Planned Gravatar App Morphs Into a Selfies App for Android\" href=\"http://wptavern.com/automattics-planned-gravatar-app-morphs-into-a-selfies-app-for-android\">Automattic&#8217;s Planned Gravatar App Morphs Into a Selfies App for Android </a></li>\n<li><a title=\"WordPress JSON REST API Plugin 1.1.1 Security Release: Update Recommended\" href=\"http://wptavern.com/wordpress-json-rest-api-plugin-1-1-1-security-release-update-recommended\">WordPress JSON REST API Plugin 1.1.1 Security Release: Update Recommended </a></li>\n<li><a title=\"WordPress Developers Organize Community Initiative to Standardize Custom Post Types, Taxonomies, and Metadata\" href=\"http://wptavern.com/wordpress-developers-organize-community-initiative-to-standardize-custom-post-types-taxonomies-and-metadata\">WordPress Developers Organize Community Initiative to Standardize Custom Post Types, Taxonomies, and Metadata </a></li>\n<li><a title=\"MigrateWP Launches a Service Dedicated to WordPress Migrations\" href=\"http://wptavern.com/migratewp-launches-a-service-dedicated-to-wordpress-migrations\">MigrateWP Launches a Service Dedicated to WordPress Migrations </a></li>\n<li><a title=\"7 Aspects Of WordPress I Take For Granted\" href=\"http://wptavern.com/7-aspects-of-wordpress-i-take-for-granted\">7 Aspects Of WordPress I Take For Granted </a></li>\n<li><a title=\"Jetpack Rebrands with New Logo,  Adds Custom Post Types in 3.1 Release\" href=\"http://wptavern.com/jetpack-rebrands-with-new-logo-adds-custom-post-types-in-3-1-release\">Jetpack Rebrands with New Logo, Adds Custom Post Types in 3.1 Release </a></li>\n</ul>\n<h2>August</h2>\n<ul>\n<li><a title=\"WordPress Async Task Library from TechCrunch Now Open Source\" href=\"http://wptavern.com/wordpress-async-task-library-from-techcrunch-now-open-source\">WordPress Async Task Library from TechCrunch Now Open Source </a></li>\n<li><a title=\"Serious Bug Discovered In The All In One WordPress Security and Firewall Plugin\" href=\"http://wptavern.com/serious-flaw-discovered-in-the-all-in-one-wordpress-security-and-firewall-plugin\">Serious Bug Discovered In The All In One WordPress Security and Firewall Plugin </a></li>\n<li><a title=\"SchoolPress: A WordPress-Powered Open Source App for Educators and Students\" href=\"http://wptavern.com/schoolpress-a-wordpress-powered-open-source-app-for-educators-and-students\">SchoolPress: A WordPress-Powered Open Source App for Educators and Students </a></li>\n<li><a title=\"Crowd Favorite Announces Chris Lema As New CTO\" href=\"http://wptavern.com/crowd-favorite-announces-chris-lema-as-new-cto\">Crowd Favorite Announces Chris Lema As New CTO </a></li>\n<li><a title=\"WordPress 3.9.2 Fixes Security Vulnerabilities, Users Strongly Encouraged To Update\" href=\"http://wptavern.com/wordpress-3-9-2-fixes-security-vulnerabilities-users-strongly-encouraged-to-update\">WordPress 3.9.2 Fixes Security Vulnerabilities, Users Strongly Encouraged To Update </a></li>\n<li><a title=\"How Crowd Favorite Utilizes Multiple Offices and a Distributed Work Force \" href=\"http://wptavern.com/how-crowd-favorite-utilizes-multiple-offices-and-a-distributed-work-force\">How Crowd Favorite Utilizes Multiple Offices and a Distributed Work Force </a></li>\n<li><a title=\"WP Site Care Acquires Audit WP\" href=\"http://wptavern.com/wp-site-care-acquires-audit-wp\">WP Site Care Acquires Audit WP </a></li>\n<li><a title=\"Sprout Apps to Launch a Suite of WordPress-Powered Apps Targeted at Freelancers and Small Businesses\" href=\"http://wptavern.com/sprout-apps-to-launch-a-suite-of-wordpress-powered-apps-targeted-at-freelancers-and-small-businesses\">Sprout Apps to Launch a Suite of WordPress-Powered Apps Targeted at Freelancers and Small Businesses </a></li>\n<li><a title=\"Carl Hancock Shares Advice On Registering Trademarks\" href=\"http://wptavern.com/carl-hancock-shares-advice-on-registering-trademarks\">Carl Hancock Shares Advice On Registering Trademarks </a></li>\n<li><a title=\"The Simple Criteria That Determines Which Jetpack Modules Are Auto-Activated\" href=\"http://wptavern.com/the-simple-criteria-that-determines-which-jetpack-modules-are-auto-activated\">The Simple Criteria That Determines Which Jetpack Modules Are Auto-Activated </a></li>\n<li><a title=\"WebDevStudios Names Dre Armeda Vice President of Operations\" href=\"http://wptavern.com/webdevstudios-names-dre-armeda-vice-president-of-operations\">WebDevStudios Names Dre Armeda Vice President of Operations </a></li>\n<li><a title=\"A Survival Guide To WordCamps For First Time Attendees\" href=\"http://wptavern.com/a-survival-guide-to-wordcamps-for-first-time-attendees\">A Survival Guide To WordCamps For First Time Attendees </a></li>\n<li><a title=\"Time To Move On From The \" href=\"http://wptavern.com/time-to-move-on-from-the-is-wordpress-a-cms-debate\">Time To Move On From The &#8220;Is WordPress A CMS&#8221; Debate </a></li>\n<li><a title=\"WPChat Relaunches as a Forum Dedicated to WordPress\" href=\"http://wptavern.com/wpchat-relaunches-as-a-forum-dedicated-to-wordpress\">WPChat Relaunches as a Forum Dedicated to WordPress </a></li>\n<li><a title=\"Akismet Account Dashboard Gets a Major Overhaul\" href=\"http://wptavern.com/akismet-account-dashboard-gets-a-major-overhaul\">Akismet Account Dashboard Gets a Major Overhaul </a></li>\n<li><a title=\"WordPress Plugin WP Inject Renames to ImageInject and Introduces New Features\" href=\"http://wptavern.com/wordpress-plugin-wp-inject-renames-to-imageinject-and-introduces-new-features\">WordPress Plugin WP Inject Renames to ImageInject and Introduces New Features </a></li>\n<li><a title=\"Automattic Acquires Parka LLC, The Creators Of BruteProtect\" href=\"http://wptavern.com/automattic-acquires-parka-llc-the-creators-of-bruteprotect\">Automattic Acquires Parka LLC, The Creators Of BruteProtect </a></li>\n<li><a title=\"Chris Wiegman on Why He Sold Better WP Security to iThemes\" href=\"http://wptavern.com/chris-wiegman-on-why-he-sold-better-wp-security-to-ithemes\">Chris Wiegman on Why He Sold Better WP Security to iThemes </a></li>\n<li><a title=\"Matt Mullenweg Hosts Impromptu Q&A Session On Facebook\" href=\"http://wptavern.com/matt-mullenweg-hosts-impromptu-qa-session-on-facebook\">Matt Mullenweg Hosts Impromptu Q&amp;A Session On Facebook </a></li>\n<li><a title=\"Jason Schuller Shares His Experience Running a WordPress Theme Business\" href=\"http://wptavern.com/jason-schuller-shares-his-experience-running-a-wordpress-theme-business\">Jason Schuller Shares His Experience Running a WordPress Theme Business </a></li>\n<li><a title=\"WP Settings Generator: Quickly Create a Custom Options Page Using the WordPress Settings API\" href=\"http://wptavern.com/wp-settings-generator-quickly-create-a-custom-options-page-using-the-wordpress-settings-api\">WP Settings Generator: Quickly Create a Custom Options Page Using the WordPress Settings API </a></li>\n<li><a title=\"Google Authorship is Officially Dead, WordPress Authorship Plugins are Now Obsolete\" href=\"http://wptavern.com/google-authorship-is-officially-dead-wordpress-authorship-plugins-are-now-obsolete\">Google Authorship is Officially Dead, WordPress Authorship Plugins are Now Obsolete </a></li>\n</ul>\n<h2>September</h2>\n<ul>\n<li><a title=\"WordPress Plugin Boilerplate 3.0 Released with New Community Website\" href=\"http://wptavern.com/wordpress-plugin-boilerplate-3-0-released-with-new-community-website\">WordPress Plugin Boilerplate 3.0 Released with New Community Website </a></li>\n<li><a title=\"The Hidden Savings Of a WordCamp Ticket\" href=\"http://wptavern.com/the-hidden-savings-of-a-wordcamp-ticket\">The Hidden Savings Of a WordCamp Ticket </a></li>\n<li><a title=\"Sprout Apps Launches Free WordPress Invoicing Plugin\" href=\"http://wptavern.com/sprout-apps-launches-free-wordpress-invoicing-plugin\">Sprout Apps Launches Free WordPress Invoicing Plugin </a></li>\n<li><a title=\"Critical Security Vulnerability Found in WordPress Slider Revolution Plugin, Immediate Update Advised\" href=\"http://wptavern.com/critical-security-vulnerability-found-in-wordpress-slider-revolution-plugin-immediate-update-advised\">Critical Security Vulnerability Found in WordPress Slider Revolution Plugin, Immediate Update Advised </a></li>\n<li><a title=\"WordPress 4.0 Benny Now Available for Download\" href=\"http://wptavern.com/wordpress-4-0-benny-now-available-for-download\">WordPress 4.0 Benny Now Available for Download </a></li>\n<li><a title=\"Pressgram to Shut Down, Development Discontinued\" href=\"http://wptavern.com/pressgram-to-shut-down-development-discontinued\">Pressgram to Shut Down, Development Discontinued </a></li>\n<li><a title=\"Syed Balkhi on The Overnight Success of OptinMonster\" href=\"http://wptavern.com/syed-balkhi-on-the-overnight-success-of-optinmonster\">Syed Balkhi on The Overnight Success of OptinMonster </a></li>\n<li><a title=\"1,000+ WordPress Themes on Envato Market Potentially Affected by Slider Revolution Security Vulnerability\" href=\"http://wptavern.com/1000-wordpress-themes-on-envato-market-potentially-affected-by-revolution-slider-security-vulnerability\">1,000+ WordPress Themes on Envato Market Potentially Affected by Slider Revolution Security Vulnerability </a></li>\n<li><a title=\"Flywheel Hosting Secures $1.2M In Funding\" href=\"http://wptavern.com/flywheel-hosting-secures-1-2m-in-funding\">Flywheel Hosting Secures $1.2M In Funding </a></li>\n<li><a title=\"WordPress Theme Review Team to Launch Mentoring Program\" href=\"http://wptavern.com/wordpress-theme-review-team-to-launch-mentoring-program\">WordPress Theme Review Team to Launch Mentoring Program </a></li>\n<li><a title=\"Founder Of ManageWP Publishes Open Letter on Security to The WordPress Community\" href=\"http://wptavern.com/founder-of-managewp-publishes-open-letter-on-security-to-the-wordpress-community\">Founder Of ManageWP Publishes Open Letter on Security to The WordPress Community </a></li>\n<li><a title=\"OpenTickets: An Open Source Event Management and Ticket Sales Platform Built on WordPress and WooCommerce\" href=\"http://wptavern.com/opentickets-an-open-source-event-management-and-ticket-sales-platform-built-on-wordpress-and-woocommerce\">OpenTickets: An Open Source Event Management and Ticket Sales Platform Built on WordPress and WooCommerce </a></li>\n<li><a title=\"What Happens When WordPress Is Updated With 100 Plugins Activated?\" href=\"http://wptavern.com/what-happens-when-wordpress-is-updated-with-100-plugins-activated\">What Happens When WordPress Is Updated With 100 Plugins Activated? </a></li>\n<li><a title=\"A Successful WordPress Plugin Adoption Story\" href=\"http://wptavern.com/a-successful-wordpress-plugin-adoption-story\">A Successful WordPress Plugin Adoption Story </a></li>\n<li><a title=\"Join the September 10th Internet Slowdown Protest with These WordPress Plugins\" href=\"http://wptavern.com/join-the-september-10th-internet-slowdown-protest-with-these-wordpress-plugins\">Join the September 10th Internet Slowdown Protest with These WordPress Plugins </a></li>\n<li><a title=\"Jeff Starr Releases New 450 Page Book: WordPress Themes In Depth\" href=\"http://wptavern.com/jeff-starr-releases-new-450-page-book-wordpress-themes-in-depth\">Jeff Starr Releases New 450 Page Book: WordPress Themes In Depth </a></li>\n<li><a title=\"Graph Paper Press Launches Theme.Works, A Drag and Drop Platform for Building WordPress Themes\" href=\"http://wptavern.com/graph-paper-press-launches-theme-works-a-drag-and-drop-platform-for-building-wordpress-themes\">Graph Paper Press Launches Theme.Works, A Drag and Drop Platform for Building WordPress Themes </a></li>\n<li><a title=\"Free PSD Template for Creating a WordPress.org Plugin Banner\" href=\"http://wptavern.com/free-psd-template-for-creating-a-wordpress-org-plugin-banner\">Free PSD Template for Creating a WordPress.org Plugin Banner </a></li>\n<li><a title=\"PhpStorm 8 Released With Full WordPress Support\" href=\"http://wptavern.com/phpstorm-8-released-with-full-wordpress-support\">PhpStorm 8 Released With Full WordPress Support </a></li>\n<li><a title=\"Netropolitan \" href=\"http://wptavern.com/netropolitan-facebook-for-rich-people-is-powered-by-wordpress-and-buddypress\">Netropolitan &#8220;Facebook for Rich People&#8221; is Powered by WordPress and BuddyPress </a></li>\n<li><a title=\"BuddyPress 2.1 Patsy Released\" href=\"http://wptavern.com/buddypress-2-1-patsy-released\">BuddyPress 2.1 Patsy Released </a></li>\n<li><a title=\"Is It Maintained? Web App Monitors the Activity of Open Source Projects\" href=\"http://wptavern.com/is-it-maintained-web-app-monitors-the-activity-of-open-source-projects\">Is It Maintained? Web App Monitors the Activity of Open Source Projects </a></li>\n<li><a title=\"iThemes Suffers Security Breach, Customers Urged To Reset Passwords\" href=\"http://wptavern.com/ithemes-suffers-security-breach-customers-urged-to-reset-passwords\">iThemes Suffers Security Breach, Customers Urged To Reset Passwords </a></li>\n<li><a title=\"How Public Perception of WordPress Influences Developer Contracts\" href=\"http://wptavern.com/how-public-perception-of-wordpress-influences-developer-contracts\">How Public Perception of WordPress Influences Developer Contracts </a></li>\n<li><a title=\"Flox: Privately Hosted Social Networks Powered by WordPress and BuddyPress\" href=\"http://wptavern.com/flox-privately-hosted-social-networks-powered-by-wordpress-and-buddypress\">Flox: Privately Hosted Social Networks Powered by WordPress and BuddyPress </a></li>\n<li><a title=\"A New Resource Devoted To WordPress and Photographers\" href=\"http://wptavern.com/a-new-resource-devoted-to-wordpress-and-photographers\">A New Resource Devoted To WordPress and Photographers </a></li>\n<li><a title=\"iThemes Confirms it Stored Customer Passwords in Clear-Text\" href=\"http://wptavern.com/ithemes-confirms-it-stored-customer-passwords-in-clear-text\">iThemes Confirms it Stored Customer Passwords in Clear-Text </a></li>\n<li><a title=\"Ryan Hellyer\'s AWS Nightmare: Leaked Access Keys Result in a $6,000 Bill Overnight\" href=\"http://wptavern.com/ryan-hellyers-aws-nightmare-leaked-access-keys-result-in-a-6000-bill-overnight\">Ryan Hellyer&#8217;s AWS Nightmare: Leaked Access Keys Result in a $6,000 Bill Overnight </a></li>\n<li><a title=\"WordPress.com Publishes First Ever Video Ad Entitled \" href=\"http://wptavern.com/wordpress-com-publishes-first-ever-video-ad-entitled-welcome-home\">WordPress.com Publishes First Ever Video Ad Entitled &#8220;Welcome Home&#8221; </a></li>\n<li><a title=\"Ben Gillbanks Announces The End of TimThumb\" href=\"http://wptavern.com/ben-gillbanks-announces-the-end-of-timthumb\">Ben Gillbanks Announces The End of TimThumb </a></li>\n<li><a title=\"GoDaddy and Media Temple Engage in Strategic Partnership With WP101\" href=\"http://wptavern.com/godaddy-and-media-temple-engage-in-strategic-partnership-with-wp101\">GoDaddy and Media Temple Engage in Strategic Partnership With WP101 </a></li>\n<li><a title=\"WordPress Beyond Boundaries: A Recap of WordCamp Europe 2014\" href=\"http://wptavern.com/wordpress-beyond-boundaries-a-recap-of-wordcamp-europe-2014\">WordPress Beyond Boundaries: A Recap of WordCamp Europe 2014 </a></li>\n<li><a title=\"Stream Morphs From a Plugin Into a Service\" href=\"http://wptavern.com/stream-morphs-from-a-plugin-into-a-service\">Stream Morphs From a Plugin Into a Service </a></li>\n</ul>\n<h2>October</h2>\n<ul>\n<li><a title=\"Interview With Stream Project Lead, Frankie Jarrett\" href=\"http://wptavern.com/interview-with-stream-project-lead-frankie-jarrett\">Interview With Stream Project Lead, Frankie Jarrett </a></li>\n<li><a title=\"Matt Mullenweg on Ensuring the Future of WordPress\" href=\"http://wptavern.com/matt-mullenweg-on-ensuring-the-future-of-wordpress\">Matt Mullenweg on Ensuring the Future of WordPress </a></li>\n<li><a title=\"WebDevStudios Acquires WordPress Support Services Company, Maintainn\" href=\"http://wptavern.com/webdevstudios-acquires-wordpress-support-services-company-maintainn\">WebDevStudios Acquires WordPress Support Services Company, Maintainn </a></li>\n<li><a title=\"First PodsCamp Is a Success\" href=\"http://wptavern.com/first-podscamp-is-a-success\">First PodsCamp Is a Success </a></li>\n<li><a title=\"WebDesign.com Is Now iThemes Training\" href=\"http://wptavern.com/webdesign-com-is-now-ithemes-training\">WebDesign.com Is Now iThemes Training </a></li>\n<li><a title=\"HostingReviews.io - Webhosting Reviews Without The Affiliate Links\" href=\"http://wptavern.com/hostingreviews-io-webhosting-reviews-without-the-affliate-links\">HostingReviews.io &#8211; Webhosting Reviews Without The Affiliate Links </a></li>\n<li><a title=\"Troubleshooting Handbook For New WordPress Support Forum Volunteers Is Live\" href=\"http://wptavern.com/troubleshooting-handbook-for-new-wordpress-support-forum-volunteers-is-live\">Troubleshooting Handbook For New WordPress Support Forum Volunteers Is Live </a></li>\n<li><a title=\"How to Obtain The Total Download Count For Plugins Attached to a WordPress.org Username\" href=\"http://wptavern.com/how-to-obtain-the-total-download-count-for-plugins-attached-to-a-wordpress-org-username\">How to Obtain The Total Download Count For Plugins Attached to a WordPress.org Username </a></li>\n<li><a title=\"LoopConf: A Conference Catered to WordPress Developers\" href=\"http://wptavern.com/loopconf-a-conference-catered-to-wordpress-developers\">LoopConf: A Conference Catered to WordPress Developers </a></li>\n<li><a title=\"Watch The Q&A Session Between Matt Mullenweg and Om Malik From WordCamp Europe\" href=\"http://wptavern.com/watch-the-qa-session-between-matt-mullenweg-and-om-malik-from-wordcamp-europe\">Watch The Q&amp;A Session Between Matt Mullenweg and Om Malik From WordCamp Europe </a></li>\n<li><a title=\"The First \" href=\"http://wptavern.com/the-first-rate-and-review-a-plugin-day-is-a-success\">The First &#8220;Rate and Review a Plugin Day&#8221; is a Success </a></li>\n<li><a title=\"Jason Schuller to Re-Enter WordPress Theme Market with Niche Admin Designs\" href=\"http://wptavern.com/jason-schuller-to-re-enter-wordpress-theme-market-with-niche-admin-designs\">Jason Schuller to Re-Enter WordPress Theme Market with Niche Admin Designs </a></li>\n<li><a title=\"Monster Widgets for bbPress and BuddyPress Make It Easy to Test Core Widgets\" href=\"http://wptavern.com/monster-widgets-for-bbpress-and-buddypress-make-it-easy-to-test-core-widgets\">Monster Widgets for bbPress and BuddyPress Make It Easy to Test Core Widgets </a></li>\n<li><a title=\"JSTOR Launches Online Daily Magazine Using WordPress\" href=\"http://wptavern.com/jstor-launches-online-daily-magazine-using-wordpress\">JSTOR Launches Online Daily Magazine Using WordPress </a></li>\n<li><a title=\"Matt Mullenweg\'s State of the Word Highlights Internationalization, Mobile, and New Tools for WordPress Contributors\" href=\"http://wptavern.com/matt-mullenwegs-state-of-the-word-highlights-internationalization-mobile-and-new-tools-for-wordpress-contributors\">Matt Mullenweg&#8217;s State of the Word Highlights Internationalization, Mobile, and New Tools for WordPress Contributors </a></li>\n<li><a title=\"Jetpack 3.2 Released, Introduces New Site Logo Feature for Theme Developers\" href=\"http://wptavern.com/jetpack-3-2-released-introduces-new-site-logo-feature-for-theme-developers\">Jetpack 3.2 Released, Introduces New Site Logo Feature for Theme Developers </a></li>\n<li><a title=\"AppPresser Debuts Reactor: A WordPress-Powered Mobile App Creator Built with the WP JSON REST API\" href=\"http://wptavern.com/apppresser-debuts-reactor-a-wordpress-powered-mobile-app-creator-built-with-the-wp-json-rest-api\">AppPresser Debuts Reactor: A WordPress-Powered Mobile App Creator Built with the WP JSON REST API </a></li>\n<li><a title=\"Security Vulnerability Discovered and Patched in WP eCommerce\" href=\"http://wptavern.com/security-vulnerability-discovered-and-patched-in-wp-ecommerce\">Security Vulnerability Discovered and Patched in WP eCommerce </a></li>\n<li><a title=\"John Saddington Releases Desk, a Premium Publishing Application For The Mac\" href=\"http://wptavern.com/john-saddington-releases-desk-a-premium-publishing-application-for-the-mac\">John Saddington Releases Desk, a Premium Publishing Application For The Mac </a></li>\n</ul>\n<h2>November</h2>\n<ul>\n<li><a title=\"Jetpack 3.2 Introduces Centralized Posting from WordPress.com\" href=\"http://wptavern.com/jetpack-3-2-introduces-centralized-posting-from-wordpress-com\">Jetpack 3.2 Introduces Centralized Posting from WordPress.com </a></li>\n<li><a title=\"WPShout Publishes The Results of Its 2014 Webhosting Survey\" href=\"http://wptavern.com/wpshout-publishes-the-results-of-its-2014-webhosting-survey\">WPShout Publishes The Results of Its 2014 Webhosting Survey </a></li>\n<li><a title=\"10up Open Sources Its Engineering Best Practices\" href=\"http://wptavern.com/10up-open-sources-its-engineering-best-practices\">10up Open Sources Its Engineering Best Practices </a></li>\n<li><a title=\"Sidekick\'s Pricing Experiment Reveals Valuable Lessons for WordPress Business Owners\" href=\"http://wptavern.com/sidekicks-pricing-experiment-reveals-valuable-lessons-for-wordpress-business-owners\">Sidekick&#8217;s Pricing Experiment Reveals Valuable Lessons for WordPress Business Owners </a></li>\n<li><a title=\"Automattic Acquires Code for the People, Expands WordPress.com VIP’s Reach Into European Markets\" href=\"http://wptavern.com/automattic-acquires-code-for-the-people-expands-wordpress-com-vips-reach-into-european-markets\">Automattic Acquires Code for the People, Expands WordPress.com VIP’s Reach Into European Markets </a></li>\n<li><a title=\"WooConf, The First Ever Conference Dedicated to WooCommerce Deemed a Success\" href=\"http://wptavern.com/wooconf-the-first-ever-conference-dedicated-to-woocommerce-deemed-a-success\">WooConf, The First Ever Conference Dedicated to WooCommerce Deemed a Success </a></li>\n<li><a title=\"Why WordPress Doesn\'t Need to Fear Ghost, Yet\" href=\"http://wptavern.com/why-wordpress-doesnt-need-to-fear-ghost-yet\">Why WordPress Doesn&#8217;t Need to Fear Ghost, Yet </a></li>\n<li><a title=\"Happy Joe Uses WordPress to Train and Help Veterans Find Careers in Web Technology\" href=\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\">Happy Joe Uses WordPress to Train and Help Veterans Find Careers in Web Technology </a></li>\n<li><a title=\"Flynn O’Connor on Organizing and Marketing a WordCamp for Developers\" href=\"http://wptavern.com/flynn-oconnor-on-organizing-and-marketing-a-wordcamp-for-developers\">Flynn O’Connor on Organizing and Marketing a WordCamp for Developers </a></li>\n<li><a title=\"Installatron Partners With Clef to Add Two-Factor Authentication to Automated Installs of WordPress\" href=\"http://wptavern.com/installatron-partners-with-clef-to-add-two-factor-authentication-to-automated-installs-of-wordpress\">Installatron Partners With Clef to Add Two-Factor Authentication to Automated Installs of WordPress </a></li>\n<li><a title=\"Automattic Open Sources Its DMCA Process Docs on GitHub \" href=\"http://wptavern.com/automattic-open-sources-its-dmca-process-docs-on-github\">Automattic Open Sources Its DMCA Process Docs on GitHub </a></li>\n<li><a title=\"WP eCommerce Has a New Home\" href=\"http://wptavern.com/wp-ecommerce-has-a-new-home\">WP eCommerce Has a New Home </a></li>\n<li><a title=\"DigitalOcean Is Now the Third Largest Hosting Provider, WordPress Droplets Account for 23%\" href=\"http://wptavern.com/digitalocean-is-now-the-third-largest-hosting-provider-wordpress-droplets-account-for-23\">DigitalOcean Is Now the Third Largest Hosting Provider, WordPress Droplets Account for 23% </a></li>\n<li><a title=\"WordPress 4.0.1 is a Critical Security Release that Fixes a Cross-Site Scripting Vulnerability\" href=\"http://wptavern.com/wordpress-4-0-1-is-a-critical-security-release-that-fixes-a-cross-site-scripting-vulnerability\">WordPress 4.0.1 is a Critical Security Release that Fixes a Cross-Site Scripting Vulnerability </a></li>\n<li><a title=\"WP Engine Partners with 10up to Launch Enterprise HHVM WordPress Hosting Platform\" href=\"http://wptavern.com/wp-engine-partners-with-10up-to-launch-enterprise-hhvm-wordpress-hosting-platform\">WP Engine Partners with 10up to Launch Enterprise HHVM WordPress Hosting Platform </a></li>\n<li><a title=\"CyberChimps is Looking For Investors\" href=\"http://wptavern.com/cyberchimps-is-looking-for-investors\">CyberChimps is Looking For Investors </a></li>\n<li><a title=\"A Glimpse Into Serbia\'s Rapidly Growing WordPress Community\" href=\"http://wptavern.com/a-glimpse-into-serbias-rapidly-growing-wordpress-community\">A Glimpse Into Serbia&#8217;s Rapidly Growing WordPress Community </a></li>\n<li><a title=\"ModernThemes Launches Site Dedicated to Providing Free WordPress Themes\" href=\"http://wptavern.com/modernthemes-launches-site-dedicated-to-providing-free-wordpress-themes\">ModernThemes Launches Site Dedicated to Providing Free WordPress Themes </a></li>\n</ul>\n<h2>December</h2>\n<ul>\n<li><a title=\"DawnPatrol Gives Fringe WordPress Communities a Voice\" href=\"http://wptavern.com/dawnpatrol-gives-fringe-wordpress-communities-a-voice\">DawnPatrol Gives Fringe WordPress Communities a Voice </a></li>\n<li><a title=\"JP Bot: The Silent Bot Behind the Jetpack Module Extraction Plugins\" href=\"http://wptavern.com/jp-bot-the-silent-bot-behind-the-jetpack-module-extraction-plugins\">JP Bot: The Silent Bot Behind the Jetpack Module Extraction Plugins </a></li>\n<li><a title=\"WP Engine Sponsors John James Jacoby to Work on HHVM Compatibility with BuddyPress\" href=\"http://wptavern.com/wp-engine-sponsors-john-james-jacoby-to-work-on-hhvm-compatibility-with-buddypress\">WP Engine Sponsors John James Jacoby to Work on HHVM Compatibility with BuddyPress </a></li>\n<li><a title=\"InfiniteWP Client Plugin Releases Security Update\" href=\"http://wptavern.com/infinitewp-client-plugin-releases-security-update\">InfiniteWP Client Plugin Releases Security Update </a></li>\n<li><a title=\"jMonkeyEngine Migrates Community Site Away From BuddyPress and bbPress\" href=\"http://wptavern.com/jmonkeyengine-migrates-community-site-away-from-buddypress-and-bbpress\">jMonkeyEngine Migrates Community Site Away From BuddyPress and bbPress </a></li>\n<li><a title=\"Google\'s New reCAPTCHA API Replaces Distorted Text with a Checkbox\" href=\"http://wptavern.com/googles-new-recaptcha-api-replaces-distorted-text-with-a-checkbox\">Google&#8217;s New reCAPTCHA API Replaces Distorted Text with a Checkbox </a></li>\n<li><a title=\"nRelate Will Shutdown Its Service December 31st\" href=\"http://wptavern.com/nrelate-will-shutdown-its-service-december-31st\">nRelate Will Shutdown Its Service December 31st </a></li>\n<li><a title=\"What Would it Take For WordPress to Lose its Dominance?\" href=\"http://wptavern.com/what-would-it-take-for-wordpress-to-lose-its-dominance\">What Would it Take For WordPress to Lose its Dominance? </a></li>\n<li><a title=\"CEO and Envato Co-founder Collis Ta\'eed On The First 6 Months of Envato\" href=\"http://wptavern.com/ceo-and-envato-co-founder-collis-taeed-on-the-first-6-months-of-envato\">CEO and Envato Co-founder Collis Ta&#8217;eed On The First 6 Months of Envato </a></li>\n<li><a title=\"WP Stagecoach to Bring 1-Click Staging Sites to WordPress in 2015\" href=\"http://wptavern.com/wp-stagecoach-to-bring-1-click-staging-sites-to-wordpress-in-2015\">WP Stagecoach to Bring 1-Click Staging Sites to WordPress in 2015 </a></li>\n<li><a title=\"A New User\'s Experience Installing and Using bbPress\" href=\"http://wptavern.com/a-new-users-experience-installing-and-using-bbpress\">A New User&#8217;s Experience Installing and Using bbPress </a></li>\n<li><a title=\"WordPress Themes Directory Now Requires All Themes to be Translation-Ready\" href=\"http://wptavern.com/wordpress-themes-directory-now-requires-all-themes-to-be-translation-ready\">WordPress Themes Directory Now Requires All Themes to be Translation-Ready </a></li>\n<li><a title=\"Idea Factory: A Frontend Submission and Voting System for WordPress\" href=\"http://wptavern.com/idea-factory-a-frontend-submission-and-voting-system-for-wordpress\">Idea Factory: A Frontend Submission and Voting System for WordPress </a></li>\n<li><a title=\"A Newbie\'s Guide to bbPress\" href=\"http://wptavern.com/a-newbies-guide-to-bbpress\">A Newbie&#8217;s Guide to bbPress </a></li>\n<li><a title=\"BuddyPress, bbPress, and GlotPress Development Campaign is Now Fully Funded\" href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">BuddyPress, bbPress, and GlotPress Development Campaign is Now Fully Funded </a></li>\n<li><a title=\"Google Earth API to Retire December 12th, 2015\" href=\"http://wptavern.com/google-earth-api-to-retire-december-12th-2015\">Google Earth API to Retire December 12th, 2015 </a></li>\n<li><a title=\"The Majority of Shark Tank Contestants Use WordPress and WooCommerce\" href=\"http://wptavern.com/the-majority-of-shark-tank-contestants-use-wordpress-and-woocommerce\">The Majority of Shark Tank Contestants Use WordPress and WooCommerce </a></li>\n<li><a title=\"Pippin Williamson on Building a Community Around Your Open Source Project\" href=\"http://wptavern.com/pippin-williamson-on-building-a-community-around-your-open-source-project\">Pippin Williamson on Building a Community Around Your Open Source Project </a></li>\n<li><a title=\"100,000+ WordPress Sites Compromised Using the Slider Revolution Security Vulnerability\" href=\"http://wptavern.com/100000-wordpress-sites-compromised-using-the-slider-revolution-security-vulnerability\">100,000+ WordPress Sites Compromised Using the Slider Revolution Security Vulnerability </a></li>\n<li><a title=\"Jetpack 3.3 Introduces New Centralized Dashboard for Managing Multiple WordPress Sites\" href=\"http://wptavern.com/jetpack-3-3-introduces-new-centralized-dashboard-for-managing-multiple-wordpress-sites\">Jetpack 3.3 Introduces New Centralized Dashboard for Managing Multiple WordPress Sites </a></li>\n<li><a title=\"ManageWP Releases Plugin Discovery Tool\" href=\"http://wptavern.com/managewp-releases-plugin-discovery-tool\">ManageWP Releases Plugin Discovery Tool </a></li>\n<li><a title=\"Atlanta WordPress Coders Guild: A New Meetup for Designers and Programmers\" href=\"http://wptavern.com/atlanta-wordpress-coders-guild-a-new-meetup-for-designers-and-programmers\">Atlanta WordPress Coders Guild: A New Meetup for Designers and Programmers </a></li>\n<li><a title=\"WordPress 4.1 \" href=\"http://wptavern.com/wordpress-4-1-dinah-released\">WordPress 4.1 &#8220;Dinah&#8221; Released </a></li>\n<li><a title=\"Critical Git Vulnerability Patched: Update Your Git Clients Immediately\" href=\"http://wptavern.com/critical-git-vulnerability-patched-update-your-git-clients-immediately\">Critical Git Vulnerability Patched: Update Your Git Clients Immediately </a></li>\n<li><a title=\"Concept Image Shows Redesign of Drupal.org User Profiles\" href=\"http://wptavern.com/concept-image-shows-redesign-of-drupal-org-user-profiles\">Concept Image Shows Redesign of Drupal.org User Profiles </a></li>\n<li><a title=\"phpBB.com Compromised, Users Should Change Their Passwords\" href=\"http://wptavern.com/phpbb-com-compromised-users-should-change-their-passwords\">phpBB.com Compromised, Users Should Change Their Passwords </a></li>\n<li><a title=\"WordSesh 3 Attracts 3,000 Unique Viewers From 89 Countries\" href=\"http://wptavern.com/wordsesh-3-attracts-3000-unique-viewers-from-89-countries\">WordSesh 3 Attracts 3,000 Unique Viewers From 89 Countries </a></li>\n<li><a title=\"Historic WordPress Project Seeks Contributors\" href=\"http://wptavern.com/historic-wordpress-project-seeks-contributors\">Historic WordPress Project Seeks Contributors </a></li>\n<li><a title=\"Varying Vagrant Vagrants Adopts Open Source MIT License\" href=\"http://wptavern.com/varying-vagrant-vagrants-adopts-open-source-mit-license\">Varying Vagrant Vagrants Adopts Open Source MIT License </a></li>\n<li><a title=\"Without Notifying Customers, GoDaddy and MediaTemple Auto Activate SIDEKICK\" href=\"http://wptavern.com/without-notifying-customers-godaddy-and-mediatemple-auto-activate-sidekick\">Without Notifying Customers, GoDaddy and MediaTemple Auto Activate SIDEKICK </a></li>\n<li><a title=\"WordPress Community Pulls Together to Help a Member in Need\" href=\"http://wptavern.com/wordpress-community-pulls-together-to-help-a-member-in-need\">WordPress Community Pulls Together to Help a Member in Need </a></li>\n</ul>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Dec 2014 00:31:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Alex King: Add a Preview Button to WordPress’ Distraction-Free Writing Mode\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://alexking.org/?p=21220\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://alexking.org/blog/2014/12/30/wordpress-distraction-free-preview-button\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:724:\"<p><img src=\"http://alexking.org/wp-content/uploads/2014/12/screenshot-510x378.png\" alt=\"screenshot\" width=\"480\" height=\"356\" class=\"alignnone size-medium-img wp-image-21222\" /></p>\n<p>When the distraction-free writing mode was overhauled in <a href=\"https://wordpress.org/news/2014/12/dinah/\">WordPress 4.1</a> my little <a href=\"http://alexking.org/project/fullscreen-preview-button\">Preview Button plugin</a> was rendered non-functional. Never fear, it&#8217;s now been updated and works a treat.</p>\n<p class=\"threads-post-notice\">This post is part of the project: <a href=\"http://alexking.org/project/fullscreen-preview-button\">Fullscreen Preview Button</a>. View the project timeline for more context on this post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Dec 2014 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Alex\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Dear WordPress Plugin Developer, Please Add Screenshots\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=30748\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://wptavern.com/dear-wordpress-plugin-developer-please-add-screenshots\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6263:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/plugin.jpg\" rel=\"prettyphoto[30748]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/plugin.jpg?resize=1024%2C485\" alt=\"Plugin Recommendations Featured Image\" class=\"size-full wp-image-34902\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/electrospray/164932344/\">when i was a bird</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>This year the <a href=\"https://wordpress.org/plugins/\" target=\"_blank\">WordPress plugin directory</a> crossed 35,000 plugin listings and is rapidly approaching one billion total downloads. WordPress 4.0 <a href=\"http://wptavern.com/wordpress-4-0-adds-custom-icons-to-the-plugin-installer\" target=\"_blank\">added custom icons to the plugin installer</a> in the admin, which helps developers to differentiate their plugins in this massive sea of extensions. Plugin branding is useful for standing out in the initial results of a search, but beyond that there is one tab that gives plugins a distinct advantage over others.</p>\n<p>How important is the Screenshots tab for plugins hosted on WordPress.org? Feedback from our readers indicates that screenshots are a critical part of a understanding what a plugin does:</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/pollyplummer\">@pollyplummer</a> screenshots is the first tab I click on for any plugin. How a plugin integrates with WP can say a great deal about it.</p>\n<p>&mdash; Scott Evans (@scottsweb) <a href=\"https://twitter.com/scottsweb/status/512308351603339264\">September 17, 2014</a></p></blockquote>\n<p></p>\n<p>There&#8217;s nothing more infuriating than an incomplete plugin description with no screenshots. When you&#8217;re on the hunt for a specific functionality, it can be time-consuming to install a plugin, only to find out that it doesn&#8217;t do what you need it to do. For the plugin developer, there&#8217;s always the risk that someone will install your plugin, find out that it doesn&#8217;t do what they want, and give it a poor review because of the inconvenience.</p>\n<h3>Can Screenshots Make or Break a WordPress Plugin?</h3>\n<p>Many users now hunt for plugins in the admin, as opposed to directly on WordPress.org. If you&#8217;re a plugin developer, it&#8217;s a good idea to remember that the plugin details page is still available to users searching in the admin via a modal window.</p>\n<p><strong>With the exception of plugins that have no visible output, every plugin listed in the directory could benefit from a set of basic screenshots.</strong> Some plugins, such as BuddyPress or Jetpack, have their own websites full of images. Even with a separate website, the plugins still include screenshots for users who don&#8217;t wish to navigate away from the admin or WordPress.org.</p>\n<p>If your plugin does something visual on the frontend, users appreciate a screenshot of an example, even if the output varies depending on the active theme. Frontend and backend screenshots are equally important.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/pollyplummer\">@pollyplummer</a> SO many plugin just show the backend settings. I want to see how it outputs!!</p>\n<p>&mdash; Phil Hoyt (@philhoyt) <a href=\"https://twitter.com/philhoyt/status/512309118066249728\">September 17, 2014</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/pollyplummer\">@pollyplummer</a> <a href=\"https://twitter.com/bobWP\">@bobWP</a> And even if it does something not so visual, screenshots are very much needed, wanted and appreciated!</p>\n<p>&mdash; David Bell (@Cape_Dave) <a href=\"https://twitter.com/Cape_Dave/status/512326778942423040\">September 17, 2014</a></p></blockquote>\n<p></p>\n<p>For a simple plugin, with no dedicated website, having screenshots could be the difference between gaining a strong user base or having your plugin stuck at just a handful of downloads.</p>\n<p>I&#8217;m borderline obsessive when it comes to the WordPress plugin directory. I have scanned through every single plugin that has come through the directory for the past several years, always on the hunt for the cream of the crop. Even with a solid description, if the plugin has no screenshots, it&#8217;s tough to find the motivation to take it on a test run. There are many gems hiding in the directory that have been overlooked and undervalued, simply because users cannot visualize how the plugin works.</p>\n<p>If you are hosting a plugin on WordPress.org, there are three solid advantages to adding screenshots to your details page:</p>\n<ul>\n<li><strong>Screenshots help potential users understand what your plugin does:</strong> These images are an important part of your communication to the user. If you don&#8217;t care about communicating what your plugin does, why host it in a large, public repository where people will demand support?</li>\n<li><strong>Screenshots can reduce trivial support requests:</strong> There will always be people who install a plugin, without being sure of what it does. Having screenshots may help answer easy questions that would otherwise clutter up your support forums.</li>\n<li><strong>Screenshots may help your plugin gain traction and contributors faster:</strong> If a screenshot assists in clarifying what your plugin does, then you may inspire more people to install it, discover how awesome it is, write about it, and recommend it to others.</li>\n</ul>\n<p>A plugin developer&#8217;s decision to omit screenshots is not necessarily indicative of the plugin&#8217;s future, but screenshots can go a long way towards building a solid user base that can make your plugin worth all the hard work you&#8217;ve put into it.</p>\n<p>If you&#8217;re going through the trouble of putting your plugin up on WordPress.org, you might as well spend a couple extra minutes adding a few basic screenshots. Who knows? That plugin could be the key to your next paid gig and a valuable example of your work as an open source developer. Your plugin may even be the next most widely recommended tool for WordPress users, but the world may never know if you don&#8217;t bother to add any screenshots.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Dec 2014 22:09:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Best of Longreads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44548\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2014/12/best-of-longreads/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:178:\"<p>Longreads has just published <a href=\"http://blog.longreads.com/tag/best-of-2014/\">their best of 2014 list</a> which has plenty to keep you entertained and read for hours.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Dec 2014 18:39:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: Add an Expiration Date to WordPress Sticky Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36164\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wptavern.com/add-an-expiration-date-to-wordpress-sticky-posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2901:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/04/paste.png\" rel=\"prettyphoto[36164]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/04/paste.png?resize=900%2C401\" alt=\"photo credit: This Year\'s Love - cc\" class=\"size-full wp-image-21384\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/hand-nor-glove/1481913840/\">This Year&#8217;s Love</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>WordPress&#8217; <a href=\"http://codex.wordpress.org/Sticky_Posts\" title=\"Sticky Posts\" target=\"_blank\">sticky posts</a> feature was introduced six years ago in the <a href=\"http://codex.wordpress.org/Version_2.7\" target=\"_blank\">2.7</a> release. It was added to enable users to stick important posts to the front page so that they won&#8217;t disappear in a blog&#8217;s steady stream of chronologically ordered content.</p>\n<p>By default, a sticky post is sticky indefinitely and requires you to manually uncheck the box under the post&#8217;s visibility settings in order to remove its stickiness. <a href=\"https://wordpress.org/plugins/expire-sticky-posts/\" target=\"_blank\">Expire Sticky Posts</a> is a new ultra-simple plugin that allows you to set an expiration date on your sticky selections.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/expire-sticky-posts.png\" rel=\"prettyphoto[36164]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/expire-sticky-posts.png?resize=306%2C500\" alt=\"expire-sticky-posts\" class=\"alignright size-large wp-image-36501\" /></a>The plugin, created by <a href=\"http://andyv.me/\" target=\"_blank\">Andy von Dohren</a>, is a fork of the <a href=\"https://wordpress.org/plugins/simple-post-expiration/\" target=\"_blank\">Simple Post Expiration</a> plugin by Pippin Williamson. Expire Sticky Posts adds a date entry box to the publish panel for setting an expiration date if the post has been checked as sticky.</p>\n<p>The plugin is perfect for automating the management of seasonal sticky posts and important time-sensitive notices. Also, some themes rely on sticky posts for setting the featured content on the homepage, requiring you to manually change them out. This plugin allows you to set up future dates for expiring sticky posts at the time that you publish them, so you don&#8217;t have to log in and change it later.</p>\n<p>I tested the plugin and found that it works as advertised. The only thing I would add is the ability to set a specific time in addition to the date, as this may be important in some instances. If you find the <a href=\"https://wordpress.org/plugins/expire-sticky-posts/\" target=\"_blank\">Expire Sticky Posts</a> plugin to be useful and have any further feedback, feel free to leave a note in the issues queue of the project&#8217;s <a href=\"https://github.com/avondohren/Expire-Sticky-Posts\" target=\"_blank\">GitHub repository</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Dec 2014 06:07:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordPress Community Pulls Together to Help a Member in Need\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36487\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://wptavern.com/wordpress-community-pulls-together-to-help-a-member-in-need\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3787:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/GenerosityFeaturedImage.png\" rel=\"prettyphoto[36487]\"><img class=\"size-full wp-image-36495\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/GenerosityFeaturedImage.png?resize=639%2C200\" alt=\"Generosity Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/transforminggenerosity/6080870810/\">Stewardship &#8211; Transforming Generosity</a> &#8211; <a href=\"http://creativecommons.org/licenses/by/2.0/\">cc</a>\n<p>Dan Griffiths, who is known on Twitter as <a title=\"https://twitter.com/ghost1227\" href=\"https://twitter.com/ghost1227\">Ghost1227</a> and one of the creators of <a title=\"http://wptally.com/\" href=\"http://wptally.com/\">WP Tally,</a> recently found himself in an emergency situation. Due to personal reasons, details of the situation have been withheld but it required Griffiths to come up with $2,500 within a 24 hour time span. Griffiths is a military Veteran who served in the Marines and received an honorable discharge.</p>\n<p>He reached out to <a title=\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\" href=\"http://wptavern.com/happy-joe-uses-wordpress-to-train-and-help-veterans-find-careers-in-web-technology\">Happy Joe</a>, an organization that helps veterans in need. Happy Joe founder, James Dalman, published an all points bulletin on Twitter asking for help from the WordPress community.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p>PLEASE help <a href=\"https://twitter.com/ghost1227\">@ghost1227</a> raise $2500 in the next 24 hours. It\'s an emergency and he is a <a href=\"https://twitter.com/hashtag/marine?src=hash\">#marine</a> <a href=\"https://twitter.com/hashtag/veteran?src=hash\">#veteran</a>.&#10;&#10;<a href=\"http://t.co/6SDlA41IkP\">http://t.co/6SDlA41IkP</a></p>\n<p>&mdash; jamesdalman (@jamesdalman) <a href=\"https://twitter.com/jamesdalman/status/549749712602300416\">December 30, 2014</a></p></blockquote>\n<p></p>\n<p>At least 22 people retweeted the call for help with several members of the WordPress community sending out custom tweets. I donated $20 to the campaign not only to thank Griffiths for his service, but to help him out in a dire time of need. Within <strong>two hours</strong> of the initial call for help, Griffiths reached his goal and added the following message to his <a title=\"http://ghost1227.com/donate/\" href=\"http://ghost1227.com/donate/\">personal donation page</a>.</p>\n<blockquote><p>I can’t believe the response my call for help has received… For lack of a better word, I’m in shock. My sincerest thanks go out to the whole community for your unbelievable support. In a matter of an hour or two I received more than I ever thought possible… much from people whom I wasn’t even aware I had made an impression on. I am beyond humbled at the awesomeness of our community and can’t begin to express how much you all mean to me. Thanks again, and I hope we can continue to make WordPress, our community, and the Internet as a whole even better this coming year than the last!</p></blockquote>\n<p>This isn&#8217;t the first time the community has been generous to those in need. Near the end of 2013, the community rallied together to donate over $7,300 ($2,000 over the requested amount) to help Justin Tadlock <a title=\"https://www.tilt.com/campaigns/help-buy-a-house-for-christmas\" href=\"https://www.tilt.com/campaigns/help-buy-a-house-for-christmas\">buy a house</a>.</p>\n<p>I can&#8217;t imagine the overwhelming sense of happiness Griffiths must be feeling. The fact that several of the donations came from people he doesn&#8217;t know is another indication of just how awesome and generous the WordPress community is to those who need it most.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Dec 2014 05:09:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: A Look Back at WordPress News in 2014, Part 1 of 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36435\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/a-look-back-at-wordpress-news-in-2014-part-1-of-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:40967:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/WPInternetArchive.png\" rel=\"prettyphoto[36435]\"><img class=\"size-full wp-image-26599\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/WPInternetArchive.png?resize=636%2C300\" alt=\"WordPress Internet Archive Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/mathrong/7988229132/\">mathrong</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc/2.0/\">cc</a>\n<p>In the course of a year, a lot of things happen in the WordPress ecosystem and in 2014, the Tavern published over 900 posts. I&#8217;ve created a list of headlines from the first-half of 2014 where you can see the progression of stories, businesses, and products at a glance. The list indicates it was a busy year for several companies.</p>\n<p>The stories included here are handpicked based on their newsworthiness, importance, and whether they generated a healthy discussion in the comments. The posts are in chronological order starting with January.</p>\n<h2>January</h2>\n<ul>\n<li><a title=\"WordPress Plugin Repository Now Rejects Commits With PHP Errors\" href=\"http://wptavern.com/wordpress-plugin-repository-now-rejects-commits-with-php-errors\">WordPress Plugin Repository Now Rejects Commits With PHP Errors </a></li>\n<li><a title=\"Aesop Story Engine: An Open Source WordPress Plugin For Storytelling\" href=\"http://wptavern.com/aesop-story-engine-an-open-source-wordpress-plugin-for-storytelling\">Aesop Story Engine: An Open Source WordPress Plugin For Storytelling </a></li>\n<li><a title=\"AcademiaThemes - WordPress Themes Specifically For Academia\" href=\"http://wptavern.com/academiathemes-wordpress-themes-specifically-for-academia\">AcademiaThemes &#8211; WordPress Themes Specifically For Academia </a></li>\n<li><a title=\"WordPress Core Trac Gets a Design Refresh, New Features and Enhancements\" href=\"http://wptavern.com/wordpress-core-trac-gets-a-design-refresh-new-features-and-enhancements\">WordPress Core Trac Gets a Design Refresh, New Features and Enhancements </a></li>\n<li><a title=\"Mentor Others In The WordPress Community With WPMentor\" href=\"http://wptavern.com/mentor-others-in-the-wordpress-community-with-wpmentor\">Mentor Others In The WordPress Community With WPMentor </a></li>\n<li><a title=\"AppPresser Launches First Mobile App Development Framework For WordPress\" href=\"http://wptavern.com/apppresser-launches-first-mobile-app-development-framework-for-wordpress\">AppPresser Launches First Mobile App Development Framework For WordPress </a></li>\n<li><a title=\"Encouraging Women To Speak At WordCamps \" href=\"http://wptavern.com/encouraging-women-to-speak-at-wordcamps\">Encouraging Women To Speak At WordCamps </a></li>\n<li><a title=\"Cultivating a Culture of Respect in the WordPress Community\" href=\"http://wptavern.com/cultivating-a-culture-of-respect-in-the-wordpress-community\">Cultivating a Culture of Respect in the WordPress Community </a></li>\n<li><a title=\"WordPress Adds Per-Ticket Notifications to Trac\" href=\"http://wptavern.com/wordpress-adds-per-ticket-notifications-to-trac\">WordPress Adds Per-Ticket Notifications to Trac </a></li>\n<li><a title=\"ManageWP Is Now Integrated Into cPanel With SiteGround Hosting\" href=\"http://wptavern.com/managewp-is-now-integrated-into-cpanel-with-siteground-hosting\">ManageWP Is Now Integrated Into cPanel With SiteGround Hosting </a></li>\n<li><a title=\"Matt Mullenweg Takes On New Role As CEO of Automattic\" href=\"http://wptavern.com/matt-mullenweg-takes-on-new-role-as-ceo-of-automattic\">Matt Mullenweg Takes On New Role As CEO of Automattic </a></li>\n<li><a title=\"Data.gov Is Using WordPress and All the Code is Open Source\" href=\"http://wptavern.com/data-gov-is-using-wordpress-and-all-the-code-is-open-source\">Data.gov Is Using WordPress and All the Code is Open Source </a></li>\n<li><a title=\"WordPress Managed Host NodeKi Goes Bust: No Refunds For Lifetime Customers\" href=\"http://wptavern.com/wordpress-managed-host-nodeki-goes-bust-no-refunds-for-lifetime-customers\">WordPress Managed Host NodeKi Goes Bust: No Refunds For Lifetime Customers </a></li>\n<li><a title=\"Google Releases Its First Plugin For WordPress Publishers\" href=\"http://wptavern.com/google-releases-its-first-plugin-for-wordpress-publishers\">Google Releases Its First Plugin For WordPress Publishers </a></li>\n<li><a title=\"Official Git Mirror Now Available for WordPress Core Development Repository\" href=\"http://wptavern.com/official-git-mirror-now-available-for-wordpress-core-development-repository\">Official Git Mirror Now Available for WordPress Core Development Repository </a></li>\n<li><a title=\"New WordPress Trac Features Have Been Ported to bbPress and BuddyPress\" href=\"http://wptavern.com/new-wordpress-trac-features-have-been-ported-to-bbpress-and-buddypress\">New WordPress Trac Features Have Been Ported to bbPress and BuddyPress </a></li>\n<li><a title=\"GoDaddy Launches Managed WordPress Hosting Service\" href=\"http://wptavern.com/godaddy-launches-managed-wordpress-hosting-service\">GoDaddy Launches Managed WordPress Hosting Service </a></li>\n<li><a title=\"WordCamp Paris 2014: Uniting The French WordPress Community\" href=\"http://wptavern.com/wordcamp-paris-2014-uniting-the-french-wordpress-community\">WordCamp Paris 2014: Uniting The French WordPress Community </a></li>\n<li><a title=\"CodePen Releases Official WordPress Plugin\" href=\"http://wptavern.com/codepen-releases-official-wordpress-plugin\">CodePen Releases Official WordPress Plugin </a></li>\n<li><a title=\"Behind The Scenes In The WordPress Plugin Directory With Mika Epstein\" href=\"http://wptavern.com/behind-the-scenes-in-the-wordpress-plugin-directory-with-mika-epstein\">Behind The Scenes In The WordPress Plugin Directory With Mika Epstein </a></li>\n<li><a title=\"WordPress 3.8.1 Released: Fixes Twitter oEmbed Issues\" href=\"http://wptavern.com/wordpress-3-8-1-released-fixes-twitter-oembed-issues\">WordPress 3.8.1 Released: Fixes Twitter oEmbed Issues </a></li>\n<li><a title=\"PressCastle Aims to Put Every WordPress Theme in One Place\" href=\"http://wptavern.com/presscastle-aims-to-put-every-wordpress-theme-in-one-place\">PressCastle Aims to Put Every WordPress Theme in One Place </a></li>\n<li><a title=\"WordPress Co-Founder Mike Little Gets His Own Wikipedia Page\" href=\"http://wptavern.com/wordpress-co-founder-mike-little-gets-his-own-wikipedia-page\">WordPress Co-Founder Mike Little Gets His Own Wikipedia Page </a></li>\n<li><a title=\"WordCamp Norway 2014: WordPress In a Winter Wonderland\" href=\"http://wptavern.com/wordcamp-norway-2014-wordpress-in-a-winter-wonderland\">WordCamp Norway 2014: WordPress In a Winter Wonderland </a></li>\n<li><a title=\"Aesop WordPress Storytelling Plugin Is Now Fully Funded\" href=\"http://wptavern.com/aesop-wordpress-storytelling-plugin-is-now-fully-funded\">Aesop WordPress Storytelling Plugin Is Now Fully Funded </a></li>\n<li><a title=\"High Demand For WordPress Education Prompts Treehouse to Launch New Beginner\'s Course\" href=\"http://wptavern.com/high-demand-for-wordpress-education-prompts-treehouse-to-launch-new-beginners-course\">High Demand For WordPress Education Prompts Treehouse to Launch New Beginner&#8217;s Course </a></li>\n<li><a title=\"WordPress Trac Gets New Core Components Overview Page for Filtering Tickets \" href=\"http://wptavern.com/wordpress-trac-gets-new-core-components-overview-page-for-filtering-tickets\">WordPress Trac Gets New Core Components Overview Page for Filtering Tickets </a></li>\n<li><a title=\"Why Post By Email Is Still Available In WordPress\" href=\"http://wptavern.com/why-post-by-email-is-still-available-in-wordpress\">Why Post By Email Is Still Available In WordPress </a></li>\n<li><a title=\"How WordPress Obtained The W.org Domain\" href=\"http://wptavern.com/how-wordpress-obtained-the-w-org-domain\">How WordPress Obtained The W.org Domain </a></li>\n<li><a title=\"Jetpack 2.8 Introduces Markdown Module and Adds Publicize Support for Custom Post Types\" href=\"http://wptavern.com/jetpack-2-8-introduces-markdown-module-and-adds-publicize-support-for-custom-post-types\">Jetpack 2.8 Introduces Markdown Module and Adds Publicize Support for Custom Post Types </a></li>\n</ul>\n<h2>February</h2>\n<ul>\n<li><a title=\"Try To Locate WordPress On The Map\" href=\"http://wptavern.com/try-to-locate-wordpress-on-the-map\">Try To Locate WordPress On The Map </a></li>\n<li><a title=\"New Site Highlights Acts Of Kindness In The WordPress Community\" href=\"http://wptavern.com/new-site-highlights-acts-of-kindness-in-the-wordpress-community\">New Site Highlights Acts Of Kindness In The WordPress Community </a></li>\n<li><a title=\"Gust Plugin Brings the Ghost Admin Panel Into WordPress\" href=\"http://wptavern.com/gust-plugin-brings-the-ghost-admin-panel-into-wordpress\">Gust Plugin Brings the Ghost Admin Panel Into WordPress </a></li>\n<li><a title=\"How to Set Up Email Alerts For Topics on WordPress.org\" href=\"http://wptavern.com/how-to-set-up-email-alerts-for-topics-on-wordpress-org\">How to Set Up Email Alerts For Topics on WordPress.org </a></li>\n<li><a title=\"WiredTree To Sponsor All North American WordCamps In 2014\" href=\"http://wptavern.com/wiredtree-to-sponsor-all-north-american-wordcamps-in-2014\">WiredTree To Sponsor All North American WordCamps In 2014 </a></li>\n<li><a title=\"WordPress Service Provider BruteProtect Secures Funding, Forms Parka LLC\" href=\"http://wptavern.com/wordpress-service-provider-bruteprotect-secures-funding-forms-parka-llc\">WordPress Service Provider BruteProtect Secures Funding, Forms Parka LLC </a></li>\n<li><a title=\"Fine-Grained WordPress Trac Notifications Help Core Contributors to Specialize\" href=\"http://wptavern.com/fine-grained-wordpress-trac-notifications-help-core-contributors-to-specialize\">Fine-Grained WordPress Trac Notifications Help Core Contributors to Specialize </a></li>\n<li><a title=\"WordPress.org Plugin Authors Receive Suspicious Requests For Repository Access\" href=\"http://wptavern.com/wordpress-org-plugin-authors-receive-suspicious-requests-for-repository-access\">WordPress.org Plugin Authors Receive Suspicious Requests For Repository Access </a></li>\n<li><a title=\"Piklist WordPress Development Framework Rebrands, Plans to Launch Commercial Products\" href=\"http://wptavern.com/piklist-wordpress-development-framework-rebrands-plans-to-launch-commercial-products\">Piklist WordPress Development Framework Rebrands, Plans to Launch Commercial Products </a></li>\n<li><a title=\"Joost de Valk Author Of The WordPress SEO Plugin Acquires WPForce.com\" href=\"http://wptavern.com/joost-de-valk-author-of-the-wordpress-seo-plugin-acquires-wpforce-com\">Joost de Valk Author Of The WordPress SEO Plugin Acquires WPForce.com </a></li>\n<li><a title=\"WPCollab Provides Collaborative Opportunity For New WordPress Plugin Developers\" href=\"http://wptavern.com/wpcollab-provides-collaborative-opportunity-for-new-wordpress-plugin-developers\">WPCollab Provides Collaborative Opportunity For New WordPress Plugin Developers </a></li>\n<li><a title=\"UpThemes Publishes Open Letter, Sounds Wakeup Call To Other WordPress Theme Shops\" href=\"http://wptavern.com/upthemes-publishes-open-letter-sounds-wakeup-call-to-other-wordpress-theme-shops\">UpThemes Publishes Open Letter, Sounds Wakeup Call To Other WordPress Theme Shops </a></li>\n<li><a title=\"WordPress.com Joins Google, Reddit and Tumblr in Protesting NSA Surveillance\" href=\"http://wptavern.com/wordpress-com-joins-google-reddit-and-tumblr-in-protesting-nsa-surveillance\">WordPress.com Joins Google, Reddit and Tumblr in Protesting NSA Surveillance </a></li>\n<li><a title=\"WordPress E-Commerce Plugins Update to Support Stripe\'s Global Expansion of Currencies\" href=\"http://wptavern.com/wordpress-e-commerce-plugins-update-to-support-stripes-global-expansion-of-currencies\">WordPress E-Commerce Plugins Update to Support Stripe&#8217;s Global Expansion of Currencies </a></li>\n<li><a title=\"How One Police Chief Is Using WordPress and Jetpack to Fight Crime\" href=\"http://wptavern.com/how-one-police-chief-is-using-wordpress-and-jetpack-to-fight-crime\">How One Police Chief Is Using WordPress and Jetpack to Fight Crime </a></li>\n<li><a title=\"First Steps Taken To Add WordCamp Data To WordPress.org User Profiles\" href=\"http://wptavern.com/first-steps-taken-to-add-wordcamp-data-to-wordpress-org-user-profiles\">First Steps Taken To Add WordCamp Data To WordPress.org User Profiles </a></li>\n<li><a title=\"WooThemes Replaces Theme Club With All Themes Package\" href=\"http://wptavern.com/woothemes-replaces-theme-club-with-all-themes-package\">WooThemes Replaces Theme Club With All Themes Package </a></li>\n<li><a title=\"Open Source Federal Learning Registry Offers A Plugin For WordPress Integration\" href=\"http://wptavern.com/open-source-federal-learning-registry-offers-a-plugin-for-wordpress-integration\">Open Source Federal Learning Registry Offers A Plugin For WordPress Integration </a></li>\n<li><a title=\"Aesop Story Engine Now Available On WordPress.org\" href=\"http://wptavern.com/aesop-story-engine-now-available-on-wordpress-org\">Aesop Story Engine Now Available On WordPress.org </a></li>\n<li><a title=\"Own Your Content: Postcard Social Sharing App Launches With WordPress Integration \" href=\"http://wptavern.com/own-your-content-postcard-social-sharing-app-launches-with-wordpress-integration\">Own Your Content: Postcard Social Sharing App Launches With WordPress Integration </a></li>\n<li><a title=\"WordPress Theme Shops Move Toward Preserving Data Portability\" href=\"http://wptavern.com/wordpress-theme-shops-move-towards-preserving-data-portability\">WordPress Theme Shops Move Toward Preserving Data Portability </a></li>\n<li><a title=\"Bob Dunn Launches New WordPress Learning Site\" href=\"http://wptavern.com/bob-dunn-launches-new-wordpress-learning-site\">Bob Dunn Launches New WordPress Learning Site </a></li>\n<li><a title=\"\" href=\"http://wptavern.com/adopt-me-plugin-tag-is-now-in-use-on-wordpress-org\">&#8220;Adopt-Me&#8221; Plugin Tag Is Now in Use in the WordPress Plugin Directory </a></li>\n<li><a title=\"WordPress.org Profiles On Track to Be Totally Revamped\" href=\"http://wptavern.com/wordpress-org-profiles-on-track-to-be-totally-revamped\">WordPress.org Profiles On Track to Be Totally Revamped </a></li>\n<li><a title=\"Jetpack 2.9 Introduces Multisite Support and Related Posts Module\" href=\"http://wptavern.com/jetpack-2-9-introduces-multisite-support-and-related-posts-module\">Jetpack 2.9 Introduces Multisite Support and Related Posts Module </a></li>\n<li><a title=\"Theme Foundry Partners With Typekit to Add Commercial Fonts to WordPress Themes\" href=\"http://wptavern.com/theme-foundry-partners-with-typekit-to-add-commerical-fonts-to-wordpress-themes\">Theme Foundry Partners With Typekit to Add Commercial Fonts to WordPress Themes </a></li>\n<li><a title=\"Better WordPress Security Plugin Gets Major Update To Address Security Vulnerabilities\" href=\"http://wptavern.com/better-wordpress-security-plugin-gets-major-update-to-address-security-vulnerabilities\">Better WordPress Security Plugin Gets Major Update To Address Security Vulnerabilities </a></li>\n<li><a title=\"WordPress.com Partners With Hosted E-Commerce Solutions to Launch Online Stores\" href=\"http://wptavern.com/wordpress-com-partners-with-hosted-e-commerce-solutions-to-launch-online-stores\">WordPress.com Partners With Hosted E-Commerce Solutions to Launch Online Stores </a></li>\n</ul>\n<h2>March</h2>\n<ul>\n<li><a title=\"BuddyPress to Adopt Features-As-Plugins Model to Develop New Media Component\" href=\"http://wptavern.com/buddypress-to-adopt-features-as-plugins-model-to-develop-new-media-component\">BuddyPress to Adopt Features-As-Plugins Model to Develop New Media Component </a></li>\n<li><a title=\"WordPress.com Featured On Jeopardy\" href=\"http://wptavern.com/wordpress-com-featured-on-jeopardy\">WordPress.com Featured On Jeopardy </a></li>\n<li><a title=\"MediaTemple Launches WordPress Managed Hosting Package\" href=\"http://wptavern.com/mediatemple-launches-wordpress-managed-hosting-package\">MediaTemple Launches WordPress Managed Hosting Package </a></li>\n<li><a title=\"CampusPress Launches Managed WordPress Hosting For Multisite Networks\" href=\"http://wptavern.com/campuspress-launches-managed-wordpress-hosting-for-multisite-networks\">CampusPress Launches Managed WordPress Hosting For Multisite Networks </a></li>\n<li><a title=\"Widget Customizer Officially Merged Into Core for WordPress 3.9\" href=\"http://wptavern.com/widget-customizer-officially-merged-into-core-for-wordpress-3-9\">Widget Customizer Officially Merged Into Core for WordPress 3.9 </a></li>\n<li><a title=\"BuddyPress and bbPress Websites Are Now Open Source: Contributions Welcome\" href=\"http://wptavern.com/buddypress-and-bbpress-websites-are-now-open-source-contributions-welcome\">BuddyPress and bbPress Websites Are Now Open Source: Contributions Welcome </a></li>\n<li><a title=\"What Is The Future Of Comments In WordPress?\" href=\"http://wptavern.com/what-is-the-future-of-comments-in-wordpress\">What Is The Future Of Comments In WordPress? </a></li>\n<li><a title=\"A Look Behind PropsPress: A Site Dedicated to WordPress Contributors\" href=\"http://wptavern.com/a-look-behind-propspress-a-site-dedicated-to-wordpress-contributors\">A Look Behind PropsPress: A Site Dedicated to WordPress Contributors </a></li>\n<li><a title=\"First WordCamp Dayton A Flying Success\" href=\"http://wptavern.com/first-wordcamp-dayton-a-flying-success\">First WordCamp Dayton A Flying Success </a></li>\n<li><a title=\"Aesop Story Engine Launches Commercial WordPress Themes\" href=\"http://wptavern.com/aesop-story-engine-launches-commercial-wordpress-themes\">Aesop Story Engine Launches Commercial WordPress Themes </a></li>\n<li><a title=\"WordPress\' Personality Shines Through Again\" href=\"http://wptavern.com/wordpress-personality-shines-through-again\">WordPress&#8217; Personality Shines Through Again </a></li>\n<li><a title=\"The Importance of Mentors: How a High School Student Became a Professional WordPress Developer\" href=\"http://wptavern.com/the-importance-of-mentors-how-a-high-school-student-became-a-professional-wordpress-developer\">The Importance of Mentors: How a High School Student Became a Professional WordPress Developer </a></li>\n<li><a title=\"10up Hires CEO To Help Take Company To The Next Level\" href=\"http://wptavern.com/10up-hires-ceo-to-help-take-company-to-the-next-level\">10up Hires CEO To Help Take Company To The Next Level </a></li>\n<li><a title=\"Treehouse Expands WordPress Education to Include BuddyPress Beginners Course\" href=\"http://wptavern.com/treehouse-expands-wordpress-education-to-include-buddypress-beginners-course\">Treehouse Expands WordPress Education to Include BuddyPress Beginners Course </a></li>\n<li><a title=\"Better WP Security To Be Renamed, Undergoes Major Changes\" href=\"http://wptavern.com/better-wp-security-to-be-renamed-undergoes-major-changes\">Better WP Security To Be Renamed, Undergoes Major Changes </a></li>\n<li><a title=\"WordPress.com Developer Site Gets a Fresh Look and Updated Documentation\" href=\"http://wptavern.com/wordpress-com-developer-site-gets-a-fresh-look-and-updated-documentation\">WordPress.com Developer Site Gets a Fresh Look and Updated Documentation </a></li>\n<li><a title=\"WordPress.com Formally Opens Its Marketplace to Theme Developers\" href=\"http://wptavern.com/wordpress-com-formally-opens-its-marketplace-to-theme-developers\">WordPress.com Formally Opens Its Marketplace to Theme Developers </a></li>\n<li><a title=\"WordPress Plugin Repository Now Hosts Over 30,000 Plugins\" href=\"http://wptavern.com/wordpress-plugin-repository-now-hosts-over-30000-plugins\">WordPress Plugin Repository Now Hosts Over 30,000 Plugins </a></li>\n<li><a title=\"CreativeMarket Acquired By The Makers Of AutoCAD\" href=\"http://wptavern.com/creativemarket-acquired-by-the-makers-of-autocad\">CreativeMarket Acquired By The Makers Of AutoCAD </a></li>\n<li><a title=\"PhpStorm 8 To Add Official Support for WordPress\" href=\"http://wptavern.com/phpstorm-8-to-add-official-support-for-wordpress\">PhpStorm 8 To Add Official Support for WordPress </a></li>\n<li><a title=\"WordPress.com Gets New Standard and Secret Emoticons\" href=\"http://wptavern.com/wordpress-com-gets-new-standard-and-secret-emoticons\">WordPress.com Gets New Standard and Secret Emoticons </a></li>\n<li><a title=\"Qik Is Shutting Down, How To Save Your Videos\" href=\"http://wptavern.com/qik-is-shutting-down-how-to-save-your-videos\">Qik Is Shutting Down, How To Save Your Videos </a></li>\n<li><a title=\"WordPress Smiley Wars: Will Core Adopt New Emoticons?\" href=\"http://wptavern.com/wordpress-smiley-wars-will-core-adopt-new-emoticons\">WordPress Smiley Wars: Will Core Adopt New Emoticons? </a></li>\n<li><a title=\"Why Showing The WordPress Username Is Not A Security Risk\" href=\"http://wptavern.com/why-showing-the-wordpress-username-is-not-a-security-risk\">Why Showing The WordPress Username Is Not A Security Risk </a></li>\n<li><a title=\"Pressgram 2.0 Removes Social Layer to Focus on Publishing\" href=\"http://wptavern.com/pressgram-2-0-removes-social-layer-to-focus-on-publishing\">Pressgram 2.0 Removes Social Layer to Focus on Publishing </a></li>\n<li><a title=\"iThemes Working Fast To Fix Users Upgrade Woes\" href=\"http://wptavern.com/ithemes-working-fast-to-fix-users-upgrade-woes\">iThemes Working Fast To Fix Users Upgrade Woes </a></li>\n<li><a title=\"VagrantPress: A WordPress Development Environment for Themes and Plugins\" href=\"http://wptavern.com/vagrantpress-a-wordpress-development-environment-for-themes-and-plugins\">VagrantPress: A WordPress Development Environment for Themes and Plugins </a></li>\n</ul>\n<h2>April</h2>\n<ul>\n<li><a title=\"Okay Themes Pulls Out of Themeforest, Rebrands as Array\" href=\"http://wptavern.com/okay-themes-pulls-out-of-themeforest-rebrands-as-array\">Okay Themes Pulls Out of Themeforest, Rebrands as Array </a></li>\n<li><a title=\"Introduction To Underscores: A WordPress Starter Theme With Konstantin Obenland\" href=\"http://wptavern.com/introduction-to-underscores-a-wordpress-starter-theme-with-konstantin-obenland\">Introduction To Underscores: A WordPress Starter Theme With Konstantin Obenland </a></li>\n<li><a title=\"The Combination Of Jetpack and Dreamhost Security Settings Lead To Lost Comments\" href=\"http://wptavern.com/the-combination-of-jetpack-and-dreamhost-security-settings-lead-to-lost-comments\">The Combination Of Jetpack and Dreamhost Security Settings Lead To Lost Comments </a></li>\n<li><a title=\"WordPress.org Profile Redesign is Live\" href=\"http://wptavern.com/wordpress-org-profile-redesign-is-live\">WordPress.org Profile Redesign is Live </a></li>\n<li><a title=\"DevPress Sold To Unknown Buyer For $14k\" href=\"http://wptavern.com/devpress-sold-to-unknown-buyer-for-14k\">DevPress Sold To Unknown Buyer For $14k </a></li>\n<li><a title=\"The Idea Of Sponsored Comments Disqusts Me\" href=\"http://wptavern.com/the-idea-of-sponsored-comments-disqusts-me\">The Idea Of Sponsored Comments Disqusts Me </a></li>\n<li><a title=\"Introducing Hookr.io: A New Resource For WordPress Developers\" href=\"http://wptavern.com/introducing-hookr-io-a-new-resource-for-wordpress-developers\">Introducing Hookr.io: A New Resource For WordPress Developers </a></li>\n<li><a title=\"WordPress 3.8.2: First Security Release Shipped as a Background Update\" href=\"http://wptavern.com/wordpress-3-8-2-first-security-release-shipped-as-a-background-update\">WordPress 3.8.2: First Security Release Shipped as a Background Update </a></li>\n<li><a title=\"Automattic Acquires Longreads, Invests in Digital Longform Publishing\" href=\"http://wptavern.com/automattic-acquires-longreads-invests-in-digital-longform-publishing\">Automattic Acquires Longreads, Invests in Digital Longform Publishing </a></li>\n<li><a title=\"Breaking: Jetpack Releases Critical Security Update, Immediate Action Required\" href=\"http://wptavern.com/breaking-jetpack-releases-critical-security-update-immediate-action-required\">Breaking: Jetpack Releases Critical Security Update, Immediate Action Required </a></li>\n<li><a title=\"Major Milestone For BuddyPress: 2 Million Downloads and Counting\" href=\"http://wptavern.com/major-milestone-for-buddypress-2-million-downloads-and-counting\">Major Milestone For BuddyPress: 2 Million Downloads and Counting </a></li>\n<li><a title=\"WordPress Plugin CoSchedule Secures $500K In Funding\" href=\"http://wptavern.com/wordpress-plugin-coschedule-secures-500k-in-funding\">WordPress Plugin CoSchedule Secures $500K In Funding </a></li>\n<li><a title=\"Why WordPress Theme Developers Are Moving Functionality Into Plugins\" href=\"http://wptavern.com/why-wordpress-theme-developers-are-moving-functionality-into-plugins\">Why WordPress Theme Developers Are Moving Functionality Into Plugins </a></li>\n<li><a title=\"WordPress 3.8.3 Released, Fixes Quick Draft Bug\" href=\"http://wptavern.com/wordpress-3-8-3-released-fixes-quick-draft-bug\">WordPress 3.8.3 Released, Fixes Quick Draft Bug </a></li>\n<li><a title=\"BuddyPress 2.0 Released: Big Performance Improvements and New Administration Tools\" href=\"http://wptavern.com/buddypress-2-0-released-big-performance-improvements-and-new-administration-tools\">BuddyPress 2.0 Released: Big Performance Improvements and New Administration Tools </a></li>\n<li><a title=\"WordPress 3.9 \" href=\"http://wptavern.com/wordpress-3-9-smith-released\">WordPress 3.9 &#8220;Smith&#8221; Released </a></li>\n<li><a title=\"BuddyPress Development Trunk to Adopt a Grunt-Powered Build System\" href=\"http://wptavern.com/buddypress-development-trunk-to-adopt-a-grunt-powered-build-system\">BuddyPress Development Trunk to Adopt a Grunt-Powered Build System </a></li>\n<li><a title=\"Automattic Publishes Transparency Report, Reaffirms Support for Freedom of Speech\" href=\"http://wptavern.com/automattic-publishes-transparency-report-reaffirms-support-for-freedom-of-speech\">Automattic Publishes Transparency Report, Reaffirms Support for Freedom of Speech </a></li>\n<li><a title=\"Automattic Introduces Postbot App for Scheduling Photo Posts\" href=\"http://wptavern.com/automattic-introduces-postbot-app-for-scheduling-photo-posts\">Automattic Introduces Postbot App for Scheduling Photo Posts</a></li>\n<li><a title=\"Have You Turned On Akismet 3.0\'s Silent Discard Feature?\" href=\"http://wptavern.com/have-you-turned-on-akismet-3-0s-silent-discard-feature\">Have You Turned On Akismet 3.0&#8217;s Silent Discard Feature? </a></li>\n<li><a title=\"ThemeLab Acquired By Syed Balkhi\" href=\"http://wptavern.com/themelab-acquired-by-syed-balkhi\">ThemeLab Acquired By Syed Balkhi </a></li>\n<li><a title=\"Automattic Snaps Up Scroll Kit to Add to the WordPress.com Product Team\" href=\"http://wptavern.com/automattic-snaps-up-scroll-kit-to-add-to-the-wordpress-com-product-team\">Automattic Snaps Up Scroll Kit to Add to the WordPress.com Product Team </a></li>\n<li><a title=\"WordPress Code Reference is Now Live\" href=\"http://wptavern.com/wordpress-code-reference-is-now-live\">WordPress Code Reference is Now Live </a></li>\n<li><a title=\"WordPress 4.0 Kicks Off Development Today, Helen Hou-Sandí to Lead Release\" href=\"http://wptavern.com/wordpress-4-0-kicks-off-development-today-helen-hou-sandi-to-lead-release\">WordPress 4.0 Kicks Off Development Today, Helen Hou-Sandí to Lead Release </a></li>\n<li><a title=\"WordPress Commercial Theme Businesses Offer Advice On Hiring Support Staff  \" href=\"http://wptavern.com/wordpress-commercial-theme-businesses-offer-advice-on-hiring-support-staff\">WordPress Commercial Theme Businesses Offer Advice On Hiring Support Staff </a></li>\n</ul>\n<h2>May</h2>\n<ul>\n<li><a title=\"WP Rocket Launches Commercial Caching Plugin for WordPress\" href=\"http://wptavern.com/wp-rocket-launches-commercial-caching-plugin-for-wordpress\">WP Rocket Launches Commercial Caching Plugin for WordPress </a></li>\n<li><a title=\"The Mina Olen Free WordPress Theme Experiment\" href=\"http://wptavern.com/the-mina-olen-free-wordpress-theme-experiment\">The Mina Olen Free WordPress Theme Experiment </a></li>\n<li><a title=\"WordPress Query Monitor Plugin Crosses 10,000 Downloads\" href=\"http://wptavern.com/wordpress-query-monitor-plugin-crosses-10000-downloads\">WordPress Query Monitor Plugin Crosses 10,000 Downloads </a></li>\n<li><a title=\"GoDaddy Removes Ticketing and Email Support In Favor Of Phone and Live Chat\" href=\"http://wptavern.com/godaddy-removes-ticketing-and-email-support-in-favor-of-phone-and-live-chat\">GoDaddy Removes Ticketing and Email Support In Favor Of Phone and Live Chat </a></li>\n<li><a title=\"Automattic Is Raising $160M in New Funding\" href=\"http://wptavern.com/automattic-is-raising-160m-in-new-funding\">Automattic Is Raising $160M in New Funding </a></li>\n<li><a title=\"New wptheory Service Launches WordPress Websites in a Day\" href=\"http://wptavern.com/new-wptheory-service-launches-wordpress-websites-in-a-day\">New wptheory Service Launches WordPress Websites in a Day </a></li>\n<li><a title=\"WordPress Contributors Move Toward Automating Accessibility Testing\" href=\"http://wptavern.com/wordpress-contributors-move-toward-automating-accessibility-testing\">WordPress Contributors Move Toward Automating Accessibility Testing </a></li>\n<li><a title=\"AppPresser Debuts AppBuddy Mobile App at BuddyCamp Miami\" href=\"http://wptavern.com/apppresser-debuts-appbuddy-mobile-app-at-buddycamp-miami\">AppPresser Debuts AppBuddy Mobile App at BuddyCamp Miami </a></li>\n<li><a title=\"More Than 97% of Updates to WordPress 3.9.1 Were Automatic\" href=\"http://wptavern.com/more-than-97-of-updates-to-wordpress-3-9-1-were-automatic\">More Than 97% of Updates to WordPress 3.9.1 Were Automatic </a></li>\n<li><a title=\"BuddyCamp Miami 2014 In Review: Presentations and Slides From the Event\" href=\"http://wptavern.com/buddycamp-miami-2014-in-review-presentations-and-slides-from-the-event\">BuddyCamp Miami 2014 In Review: Presentations and Slides From the Event </a></li>\n<li><a title=\"Recap Of WordCamp Miami 2014\" href=\"http://wptavern.com/recap-of-wordcamp-miami-2014\">Recap Of WordCamp Miami 2014 </a></li>\n<li><a title=\"WooThemes Continuing To Investigate Reports Of Fraudulent Activity\" href=\"http://wptavern.com/woothemes-continuing-to-investigate-reports-of-fraudulent-activity\">WooThemes Continuing To Investigate Reports Of Fraudulent Activity </a></li>\n<li><a title=\"The Ability To Anonymously Complain About WordPress May Soon Disappear\" href=\"http://wptavern.com/the-ability-to-anonymously-complain-about-wordpress-may-soon-disappear\">The Ability To Anonymously Complain About WordPress May Soon Disappear </a></li>\n<li><a title=\"WP Ninjas Launch Ninja Demo: A Complete Demo Solution for WordPress Products\" href=\"http://wptavern.com/wp-ninjas-launch-ninja-demo-a-complete-demo-solution-for-wordpress-products\">WP Ninjas Launch Ninja Demo: A Complete Demo Solution for WordPress Products </a></li>\n<li><a title=\"Why BuddyPress and bbPress Themes Don\'t Exist\" href=\"http://wptavern.com/why-buddypress-and-bbpress-themes-dont-exist\">Why BuddyPress and bbPress Themes Don&#8217;t Exist </a></li>\n<li><a title=\"Font Awesome Finally Adds WordPress Icon in 4.1 Release\" href=\"http://wptavern.com/font-awesome-wordpress-icon\">Font Awesome Finally Adds WordPress Icon in 4.1 Release </a></li>\n<li><a title=\"Automattic Doesn\'t Claim Copyright On Their APIs\" href=\"http://wptavern.com/automattic-doesnt-claim-copyright-on-their-apis\">Automattic Doesn&#8217;t Claim Copyright On Their APIs </a></li>\n<li><a title=\"WordCamp Miami Kids\' Workshop Launches the Next Generation of Bloggers\" href=\"http://wptavern.com/wordcamp-miami-kids-workshop-launches-the-next-generation-of-bloggers\">WordCamp Miami Kids&#8217; Workshop Launches the Next Generation of Bloggers </a></li>\n<li><a title=\"WordPress for Android Will No Longer Support Gingerbread\" href=\"http://wptavern.com/wordpress-for-android-will-no-longer-support-gingerbread\">WordPress for Android Will No Longer Support Gingerbread </a></li>\n<li><a title=\"Jetpack 3.0 Released, Adds Bulk Module Management, Site Verification and Twitter Open Graph Support\" href=\"http://wptavern.com/jetpack-3-0-released-adds-bulk-module-management-site-verification-and-twitter-open-graph-support\">Jetpack 3.0 Released, Adds Bulk Module Management, Site Verification and Twitter Open Graph Support </a></li>\n<li><a title=\"WP Engine Addresses Critics Following Damaging Exposé of Its Customer Support\" href=\"http://wptavern.com/wp-engine-addresses-critics-following-damaging-expose-of-its-customer-support\">WP Engine Addresses Critics Following Damaging Exposé of Its Customer Support </a></li>\n<li><a title=\"WordPress Entrepreneurs Group Reaches 500+ Members\" href=\"http://wptavern.com/wordpress-entrepreneurs-group-reaches-500-members\">WordPress Entrepreneurs Group Reaches 500+ Members </a></li>\n<li><a title=\"The WordPress Training Initiative \" href=\"http://wptavern.com/the-wordpress-training-initiative\">The WordPress Training Initiative </a></li>\n<li><a title=\"WordPress JSON REST API Version 1.0 Released\" href=\"http://wptavern.com/wordpress-json-rest-api-version-1-0-released\">WordPress JSON REST API Version 1.0 Released </a></li>\n<li><a title=\"bbPress 2014 Survey Results Show Users Are Still Disappointed with Lack of Features\" href=\"http://wptavern.com/bbpress-2014-survey-results-show-users-are-still-disappointed-with-lack-of-features\">bbPress 2014 Survey Results Show Users Are Still Disappointed with Lack of Features </a></li>\n<li><a title=\"WordPress for iOS Featured in Apple\'s New iPad Advertising Campaign\" href=\"http://wptavern.com/wordpress-for-ios-featured-in-apples-new-ipad-advertising-campaign\">WordPress for iOS Featured in Apple&#8217;s New iPad Advertising Campaign </a></li>\n<li><a title=\"WordPress Celebrates Its 11th Birthday\" href=\"http://wptavern.com/wordpress-celebrates-its-11th-birthday\">WordPress Celebrates Its 11th Birthday </a></li>\n<li><a title=\"TeslaThemes Celebrates One Year Of Being In Business\" href=\"http://wptavern.com/teslathemes-celebrates-one-year-of-being-in-business\">TeslaThemes Celebrates One Year Of Being In Business </a></li>\n<li><a title=\"Alex Shiels Proposal For Improving The WordPress Plugin Management Page\" href=\"http://wptavern.com/alex-shiels-proposal-for-improving-the-wordpress-plugin-management-page\">Alex Shiels Proposal For Improving The WordPress Plugin Management Page </a></li>\n<li><a title=\"Feuilles App Aims to Replace Editorially, Offers Publishing to Github, WordPress, and Dropbox\" href=\"http://wptavern.com/feuilles-app-aims-to-replace-editorially-offers-publishing-to-github-wordpress-and-dropbox\">Feuilles App Aims to Replace Editorially, Offers Publishing to Github, WordPress, and Dropbox </a></li>\n<li><a title=\"WordPress Plugin All In One SEO Releases Important Security Update\" href=\"http://wptavern.com/wordpress-plugin-all-in-one-seo-releases-important-security-update\">WordPress Plugin All In One SEO Releases Important Security Update </a></li>\n</ul>\n<h2>June</h2>\n<ul>\n<li><a title=\"Press75 Acquired by Westwerk for Undisclosed Amount\" href=\"http://wptavern.com/press75-acquired-by-westwerk-for-undisclosed-amount\">Press75 Acquired by Westwerk for Undisclosed Amount </a></li>\n<li><a title=\"WordPress.com VIP Releases Presentation Documents and Resources Under Creative Commons License\" href=\"http://wptavern.com/wordpress-com-vip-releases-presentation-documents-and-resources-under-creative-commons-license\">WordPress.com VIP Releases Presentation Documents and Resources Under Creative Commons License </a></li>\n<li><a title=\"WordPress in Vietnamese: Now 100% Translated\" href=\"http://wptavern.com/wordpress-in-vietnamese-now-100-translated\">WordPress in Vietnamese: Now 100% Translated </a></li>\n<li><a title=\"WordPress.com to Implement SSL for All Subdomains, Joins the Fight Against Mass Surveillance\" href=\"http://wptavern.com/wordpress-com-to-implement-ssl-for-all-subdomains-joins-the-fight-against-mass-surveillance\">WordPress.com to Implement SSL for All Subdomains, Joins the Fight Against Mass Surveillance </a></li>\n<li><a title=\"bbPress 2.5.4 Security Release Available: Immediate Update Recommended\" href=\"http://wptavern.com/bbpress-2-5-4-security-release-available-immediate-update-recommended\">bbPress 2.5.4 Security Release Available: Immediate Update Recommended </a></li>\n<li><a title=\"DMCA Takedown Notice Issued Against Fork Of WP Migrate DB Pro\" href=\"http://wptavern.com/dmca-takedown-notice-issued-against-fork-of-wp-migrate-db-pro\">DMCA Takedown Notice Issued Against Fork Of WP Migrate DB Pro </a></li>\n<li><a title=\"Why Comments Still Matter\" href=\"http://wptavern.com/why-comments-still-matter\">Why Comments Still Matter </a></li>\n<li><a title=\"WP Engine to Sponsor Two Full-Time WordPress Core Contributors\" href=\"http://wptavern.com/wp-engine-to-sponsor-two-full-time-wordpress-core-contributors\">WP Engine to Sponsor Two Full-Time WordPress Core Contributors </a></li>\n<li><a title=\"Michael Oeser of DER PRiNZ Acquires WordPress Theme Company ThemeShift\" href=\"http://wptavern.com/michael-oeser-of-der-prinz-acquires-wordpress-theme-company-themeshift\">Michael Oeser of DER PRiNZ Acquires WordPress Theme Company ThemeShift </a></li>\n<li><a title=\"New Data Shows WordPress Support Forum Registrations Surged Between 2009 and 2012\" href=\"http://wptavern.com/new-data-shows-wordpress-support-forum-registrations-surged-between-2009-and-2012\">New Data Shows WordPress Support Forum Registrations Surged Between 2009 and 2012 </a></li>\n<li><a title=\"PressWork to Relaunch Under New Ownership\" href=\"http://wptavern.com/presswork-to-relaunch-under-new-ownership\">PressWork to Relaunch Under New Ownership </a></li>\n<li><a title=\"Clef Partners With Softaculous To Provide 2-Step Authentication For Automated WordPress Installs\" href=\"http://wptavern.com/clef-partners-with-softaculous-to-provide-2-step-authentication-for-automated-wordpress-installs\">Clef Partners With Softaculous To Provide 2-Step Authentication For Automated WordPress Installs </a></li>\n<li><a title=\"VersionPress Aims To Bring Version Control To The Masses\" href=\"http://wptavern.com/versionpress-hopes-to-bring-version-control-to-the-masses\">VersionPress Aims To Bring Version Control To The Masses </a></li>\n<li><a title=\"ThemeFurnace Relaunches, Introduces Lifetime Club Membership\" href=\"http://wptavern.com/themefurnace-relaunches-introduces-lifetime-club-membership\">ThemeFurnace Relaunches, Introduces Lifetime Club Membership </a></li>\n<li><a title=\"WordPress Trunk Adds New Beta Testing Tab to Plugins Screen\" href=\"http://wptavern.com/wordpress-trunk-adds-new-beta-testing-tab-to-plugins-screen\">WordPress Trunk Adds New Beta Testing Tab to Plugins Screen </a></li>\n<li><a title=\"Forbes Publishes Transcript Of Extended Interview With Matt Mullenweg\" href=\"http://wptavern.com/forbes-publishes-transcript-of-extended-interview-with-matt-mullenweg\">Forbes Publishes Transcript Of Extended Interview With Matt Mullenweg </a></li>\n<li><a title=\"VersionPress Adopts The GPL Software License\" href=\"http://wptavern.com/versionpress-adopts-the-gpl-software-license\">VersionPress Adopts The GPL Software License </a></li>\n<li><a title=\"WordPress Themes Suck at Accessibility: It\'s Time to Fix It\" href=\"http://wptavern.com/wordpress-themes-suck-at-accessibility-its-time-to-fix-it\">WordPress Themes Suck at Accessibility: It&#8217;s Time to Fix It </a></li>\n<li><a title=\"What\'s Your Perception Of ThemeForest?\" href=\"http://wptavern.com/whats-your-perception-of-themeforest\">What&#8217;s Your Perception Of ThemeForest? </a></li>\n<li><a title=\"WordPress JSON REST API Version 1.1 Released with New Authentication Documentation\" href=\"http://wptavern.com/wordpress-json-rest-api-version-1-1-released-with-new-authentication-documentation\">WordPress JSON REST API Version 1.1 Released with New Authentication Documentation </a></li>\n<li><a title=\"WordPress Security Alert: New Zero-Day Vulnerability Discovered in TimThumb Script\" href=\"http://wptavern.com/wordpress-security-alert-new-zero-day-vulnerability-discovered-in-timthumb-script\">WordPress Security Alert: New Zero-Day Vulnerability Discovered in TimThumb Script </a></li>\n<li><a title=\"Pods Framework For WordPress Releases Update To Patch Security Vulnerability\" href=\"http://wptavern.com/pods-framework-for-wordpress-releases-update-to-patch-security-vulnerability\">Pods Framework For WordPress Releases Update To Patch Security Vulnerability </a></li>\n<li><a title=\"The GPL License Doesn\'t Provide The Freedom To Infringe Registered Trademarks\" href=\"http://wptavern.com/the-gpl-license-doesnt-provide-the-freedom-to-infringe-registered-trademarks\">The GPL License Doesn&#8217;t Provide The Freedom To Infringe Registered Trademarks</a></li>\n<li><a title=\"WPSeek Mobile: A WordPress Function Reference on the Go\" href=\"http://wptavern.com/wpseek-mobile-a-wordpress-function-reference-on-the-go\">WPSeek Mobile: A WordPress Function Reference on the Go </a></li>\n</ul>\n<p>Tomorrow, we&#8217;ll look at the list of posts from July-December. Which stories of 2014 do you remember most and are there any that you would add or remove from the list?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Dec 2014 01:20:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Manage Code Snippets in WordPress with the Code Snippets Custom Post Type Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36269\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"http://wptavern.com/manage-code-snippets-in-wordpress-with-the-code-snippets-custom-post-type-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3686:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/code-snippets-cpt.png\" rel=\"prettyphoto[36269]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/code-snippets-cpt.png?resize=772%2C250\" alt=\"code-snippets-cpt\" class=\"aligncenter size-full wp-image-36427\" /></a></p>\n<p>Maintaining a library of code snippets can save you time when coding similar tasks in the future. Although there are countless sites online where you can host code snippets, it&#8217;s more convenient to have them at your fingertips when writing a blog that includes code.</p>\n<p>Plugin developer <a href=\"http://jtsternberg.com/\" target=\"_blank\">Justin Sternberg</a> recently released <a href=\"https://wordpress.org/plugins/code-snippets-cpt/\" target=\"_blank\">Code Snippets CPT</a>, a plugin that allows you to manage and display code snippets in WordPress. This unique use of custom post types stores code snippets as their own individual posts, which can be pulled into content via a handy shortcode.</p>\n<p>The plugin uses <a href=\"https://code.google.com/p/google-code-prettify/\" target=\"_blank\">Google Code Prettify</a> to add syntax highlighting to your snippets. When creating a new snippet, you simply select the language from the dropdown at the top of the post editor. Write a description, add your snippet, and click publish.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/code-snippets-cpt-edit-post.jpg\" rel=\"prettyphoto[36269]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/code-snippets-cpt-edit-post.jpg?resize=1018%2C566\" alt=\"code-snippets-cpt-edit-post\" class=\"aligncenter size-full wp-image-36439\" /></a></p>\n<p>Code Snippets CPT also includes custom taxonomies for classifying your snippets. You can add both snippet categories and snippet tags, which will then allow for some unique ways of organizing and displaying your library of snippets.</p>\n<p>When you want to display a snippet within a post or page, click on the &#8220;Add Snippet&#8221; button in the visual or text editor to launch the shortcode finder. You can select whether or not you want to display line numbers for the snippet that you are embedding.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/code-snippets-shortcode.jpg\" rel=\"prettyphoto[36269]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/code-snippets-shortcode.jpg?resize=1015%2C569\" alt=\"code-snippets-shortcode\" class=\"aligncenter size-full wp-image-36448\" /></a></p>\n<p>Sternberg&#8217;s site is running the plugin, if you want to view a <a href=\"http://dsgnwrks.pro/the-basics/primer-on-globals-php-classes-or-oop/\" target=\"_blank\">few</a> <a href=\"http://dsgnwrks.pro/tools/twitterwp-a-wordpress-tool-to-get-you-connected-to-the-twitter-1-1-api/\" target=\"_blank\">live</a> <a href=\"http://dsgnwrks.pro/tools/sublime-text-2-wordpress-debugging-snippets/\" target=\"_blank\">examples</a> of snippets in posts.</p>\n<p>Code Snippets CPT allows you to create a searchable archive of code snippets on your own site, without having to host snippets with a third party service. The advantage of hosting your own snippets is that you can keep your code library centralized and back it up as part of your WordPress site.</p>\n<p>Having code snippets stored as custom post types is a step up from simply using a syntax highlighter plugin, because it gives you the flexibility to sort and display snippets using their own snippet-specific taxonomies. If you want to get your code library organized in 2015, check out the <a href=\"https://wordpress.org/plugins/code-snippets-cpt/\" target=\"_blank\">Code Snippets CPT</a> plugin on WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Dec 2014 19:40:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Matt: How Paul Graham Is Wrong\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44544\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"http://ma.tt/2014/12/how-paul-graham-is-wrong/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2198:\"<p>I love Paul Graham&#8217;s essays and his latest is no exception: <a href=\"http://paulgraham.com/95.html\">Let the Other 95% of Great Programmers In</a>. I agree that the US deserves dramatically better immigration policies, but in the meantime I&#8217;m confused with the head-in-the-sand approach most tech companies are taking simultaneously complaining that there are lots of great people they can&#8217;t bring into the US, but being stubborn on keeping a company culture that requires people to be physically co-located.</p>\n<p>In a region that prides itself on disruption and working from first principles, San Francisco&#8217;s scaling problem is pretty humorous if you look at it from the outside: otherwise smart and inventive founders continue to set up offices and try to hire or move people in the most overheated environment since there were carphones in Cadillac Allantes. This is where I feel like Paul Graham misses the most obvious solution to the problem.</p>\n<p>If 95% of great programmers aren&#8217;t in the US, and an even higher percentage not in the Bay Area, set up your company to take advantage of that fact as a strength, not a weakness. Use <a href=\"http://wordpress.com/\">WordPress</a> and <a href=\"http://p2theme.com/\">P2</a>, use <a href=\"http://slack.com/\">Slack</a>, use <a href=\"http://www.google.com/+/learnmore/hangouts/\">G+ Hangout</a>s, use <a href=\"http://skype.com/\">Skype</a>, use any of the amazing technology that allows us to collaborate as effectively online as previous generations of company did offline. Let people <a href=\"https://nomadlist.io/\">live someplace remarkable</a> instead of paying $2,800 a month for a mediocre one bedroom rental in San Francisco. Or don&#8217;t, and let companies like <a href=\"http://automattic.com/\">Automattic</a> and <a href=\"http://github.com/\">Github</a> hire the best and brightest and <a href=\"http://toni.org/2010/03/08/5-reasons-why-your-company-should-be-distributed/\">let them live and work wherever they like</a>.</p>\n<p><ins datetime=\"2014-12-30T21:05:36+00:00\">Update: There is a <a href=\"https://news.ycombinator.com/item?id=8811019\">vigorous discussion also happening on Hacker News</a>.</ins></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Dec 2014 18:07:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: Top 15 Free WordPress Themes Released in 2014\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36361\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/top-15-free-wordpress-themes-released-in-2014\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8302:\"<p>Looking back on the theme landscape of 2014, a clear design trend emerged that highlights WordPress&#8217; roots as a blogging platform. Minimalist, content-centric themes took center stage in the official <a href=\"https://wordpress.org/themes/\" target=\"_blank\">WordPress Themes Directory</a>, outpacing their more visually-bloated commercial counterparts.</p>\n<p>This past year saw a major renaissance in themes for the personal blogger, particularly designs that showcase large, featured images. Many theme designers opted to hide navigation menus and sidebars behind a slideout menu, which also works well for mobile displays.</p>\n<p>WordPress&#8217; newest default theme, <a href=\"https://wordpress.org/themes/twentyfifteen\" target=\"_blank\">Twenty Fifteen</a>, is the culmination of this trend towards simplicity. The vast majority of our top picks from 2014 were designed for personal blogs. For years, technology experts have been eager to declare that the blog medium is dead, but the steady growth of economic activity surrounding themes continues to grow in tandem with <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">WordPress&#8217; marketshare</a>.</p>\n<p>The spirit of independent publishing is growing stronger, and free WordPress themes are a crucial entry point for writers, photographers, and other creatives who are new to self-publishing. All of the outstanding selections featured here are available in the official WordPress Themes Directory.</p>\n<h2>Editor</h2>\n<p><a href=\"http://wptavern.com/editor-a-beautiful-free-wordpress-theme-for-writers\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/editor.jpg?resize=880%2C660\" alt=\"editor\" class=\"aligncenter size-full wp-image-24477\" /></a></p>\n<p><strong><a href=\"https://preview.arraythemes.com/editor/\" target=\"_blank\">Demo</a> | <a href=\"http://wordpress.org/themes/editor\" target=\"_blank\">Download</a></strong></p>\n<h2>Fukasawa</h2>\n<p><a href=\"http://wptavern.com/fukasawa-a-free-masonry-wordpress-theme-for-photographers-and-collectors\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/09/fukasawa.png?resize=880%2C660\" alt=\"fukasawa\" class=\"aligncenter size-full wp-image-31049\" /></a></p>\n<p><strong><a href=\"http://www.andersnoren.se/themes/fukasawa/\" target=\"_blank\">Demo</a> | <a href=\"https://wordpress.org/themes/fukasawa\" target=\"_blank\">Download</a></strong></p>\n<h2>Saga</h2>\n<p><a href=\"http://wptavern.com/saga-a-free-wordpress-theme-for-writers-from-theme-hybrid\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/saga.png?resize=880%2C660\" alt=\"saga\" class=\"aligncenter size-full wp-image-29607\" /></a></p>\n<p><strong><a href=\"http://locallylost.com/saga/\" title=\"Saga demo\" target=\"_blank\">Demo</a> | <a href=\"https://wordpress.org/themes/saga\" target=\"_blank\">Download</a></strong></p>\n<h2>Eighties</h2>\n<p><a href=\"http://wptavern.com/eighties-a-bold-free-wordpress-theme-focused-on-content\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/eighties.png?resize=880%2C660\" alt=\"eighties\" class=\"aligncenter size-full wp-image-24821\" /></a></p>\n<p><strong><a href=\"http://eighties.me/\" target=\"_blank\">Demo</a> | <a href=\"http://wordpress.org/themes/eighties\" target=\"_blank\">Download</a></strong></p>\n<h2>Rams</h2>\n<p><a href=\"http://wptavern.com/rams-a-free-wordpress-blogging-theme-with-zero-fluff\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/09/rams.png?resize=880%2C660\" alt=\"rams\" class=\"aligncenter size-full wp-image-29904\" /></a></p>\n<p><strong><a href=\"http://www.andersnoren.se/themes/rams/\" target=\"_blank\">Demo</a> | <a href=\"http://wordpress.org/themes/rams\" target=\"_blank\">Download</a></strong></p>\n<h2>Sorbet</h2>\n<p><a href=\"http://wptavern.com/sorbet-a-free-wordpress-theme-from-automattic\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/02/sorbet.png?resize=880%2C660\" alt=\"sorbet\" class=\"aligncenter size-full wp-image-16602\" /></a></p>\n<p><strong><a href=\"http://sorbetdemo.wordpress.com/\" target=\"_blank\">Demo</a> | <a href=\"http://wordpress.org/themes/sorbet\" target=\"_blank\">Download</a></strong></p>\n<h2>Tracks</h2>\n<p><a href=\"http://wptavern.com/tracks-a-free-bold-wordpress-theme-for-personal-blogs\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/05/tracks.jpg?resize=1000%2C600\" alt=\"tracks\" class=\"aligncenter size-full wp-image-23832\" /></a></p>\n<p><strong><a href=\"https://www.competethemes.com/tracks-live-demo/\" target=\"_blank\">Demo</a> | <a href=\"http://wordpress.org/themes/tracks\" target=\"_blank\">Download</a></strong></p>\n<h2>Hemingway</h2>\n<p><a href=\"http://wptavern.com/anders-noren-on-achieving-simplicity-in-wordpress-theme-design\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/hemingway.png?resize=880%2C660\" alt=\"hemingway\" class=\"aligncenter size-full wp-image-36371\" /></a></p>\n<p><strong><a href=\"http://andersnoren.se/themes/hemingway/\" target=\"_blank\">Demo</a> | <a href=\"https://wordpress.org/themes/hemingway\" target=\"_blank\">Download</a></strong></p>\n<h2>Clear Tranquil</h2>\n<p><a href=\"http://wptavern.com/clear-tranquil-a-free-minimalist-wordpress-theme-for-bloggers\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/08/clear-tranquil.png?resize=600%2C450\" alt=\"clear-tranquil\" class=\"aligncenter size-full wp-image-28372\" /></a></p>\n<p><strong><a href=\"https://wordpress.org/themes/clear-tranquil\" target=\"_blank\">Demo</a> | <a href=\"https://wordpress.org/themes/clear-tranquil\" target=\"_blank\">Download</a></strong></p>\n<h2>JustWrite</h2>\n<p><a href=\"http://wptavern.com/justwrite-a-free-wordpress-magazine-theme-with-a-bold-design\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/03/justwrite.png?resize=880%2C660\" alt=\"justwrite\" class=\"aligncenter size-full wp-image-19351\" /></a></p>\n<p><strong><a href=\"http://demo.acosmin.com/?theme=justwrite\" target=\"_blank\">Demo</a> | <a href=\"http://wordpress.org/themes/justwrite\" target=\"_blank\">Download</a></strong></p>\n<h2>Intergalactic</h2>\n<p><a href=\"http://wptavern.com/intergalactic-a-bold-free-wordpress-theme-from-automattic\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/intergalactic.png?resize=880%2C660\" alt=\"intergalactic\" class=\"aligncenter size-full wp-image-35902\" /></a></p>\n<p><strong><a href=\"http://intergalacticdemo.wordpress.com/\" target=\"_blank\">Demo</a> | <a href=\"https://wordpress.org/themes/intergalactic\" target=\"_blank\">Download</a></strong></p>\n<h2>Wilson</h2>\n<p><a href=\"http://wptavern.com/anders-noren-on-achieving-simplicity-in-wordpress-theme-design\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/wilson.png?resize=880%2C660\" alt=\"wilson\" class=\"aligncenter size-full wp-image-36414\" /></a></p>\n<p><strong><a href=\"http://www.andersnoren.se/themes/wilson/\">Demo</a> | <a href=\"https://wordpress.org/themes/wilson\" target=\"_blank\">Download</a></strong></p>\n<h2>Nulis</h2>\n<p><a href=\"http://wptavern.com/nulis-a-free-minimalist-wordpress-theme-with-a-unique-twist\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/Nulis-screenshot.png?resize=880%2C660\" alt=\"Nulis-screenshot\" class=\"aligncenter size-full wp-image-36136\" /></a></p>\n<p><strong><a href=\"https://wp-themes.com/nulis/\" target=\"_blank\">Demo</a> | <a href=\"https://wordpress.org/themes/nulis\" target=\"_blank\">Download</a></strong></p>\n<h2>Edin</h2>\n<p><a href=\"http://wptavern.com/edin-a-beautiful-free-business-theme-for-wordpress\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/09/edin-grid-page.jpg?resize=660%2C781\" alt=\"edin-grid-page\" class=\"aligncenter size-full wp-image-30333\" /></a></p>\n<p><strong><a href=\"https://edindemo.wordpress.com/\" target=\"_blank\">Demo</a> | <a href=\"http://wordpress.org/themes/edin\" target=\"_blank\">Download</a></strong></p>\n<h2>Twenty Fifteen</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-1-dinah-released\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/twenty-fifteen.png?resize=1024%2C825\" alt=\"twenty-fifteen\" class=\"aligncenter size-full wp-image-30226\" /></a></p>\n<p><strong><a href=\"http://twentyfifteendemo.wordpress.com/\" target=\"_blank\">Demo</a> | <a href=\"https://wordpress.org/themes/twentyfifteen\" target=\"_blank\">Download</a></strong></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Dec 2014 06:25:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: We Are Young Acoustic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=44542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"http://ma.tt/2014/12/we-are-young-acoustic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"<p>Janelle Monae is always amazing.</p>\n<p><span class=\"embed-youtube\"></span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 27 Dec 2014 06:06:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Typography Project Beautifully Illustrates Complimentary Google Web Fonts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36261\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/typography-project-beautifully-illustrates-complimentary-google-web-fonts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4185:\"<p>The <a title=\"https://www.google.com/fonts\" href=\"https://www.google.com/fonts\">Google web fonts library</a> has over 650 fonts and without a keen eye for design, it can be difficult to find complimentary fonts. After we highlighted how you can <a title=\"http://wptavern.com/customize-twenty-fifteen-with-more-than-650-fonts-with-typecase\" href=\"http://wptavern.com/customize-twenty-fifteen-with-more-than-650-fonts-with-typecase\">customize Twenty Fifteen with over 650 free fonts</a>, some readers questioned whether customizing fonts should be left up to designers. Typography Project Beautifully Illustrates Complimentary Google Web Fonts</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/StephenCronin\">@StephenCronin</a> <a href=\"https://twitter.com/wptavern\">@wptavern</a> \"one thing it lacks is the option to customize fonts.\" Isn\'t that why we have designers for decisions like that?</p>\n<p>&mdash; Jan Dembowski (@jan_dembowski) <a href=\"https://twitter.com/jan_dembowski/status/547372410471985152\">December 23, 2014</a></p></blockquote>\n<p></p>\n<p>This is a valid concern and with over 650 to choose from, you can easily turn a site into a mess. However, there are a couple of tools and projects available that make it easier to discover complimentary fonts.</p>\n<h2>Google Fonts Typography</h2>\n<p><a title=\"http://25x52.com/Google-Fonts-Typography/\" href=\"http://25x52.com/Google-Fonts-Typography/\">Google Fonts Typography </a>is part of the <a title=\"http://25x52.com/\" href=\"http://25x52.com/\">25X52 initiative</a> and is a beautiful way to discover complimentary fonts. The project uses passages from the <a title=\"http://www.gutenberg.org/ebooks/11339\" href=\"http://www.gutenberg.org/ebooks/11339\">Project Gutenberg transcript</a> of Æsop’s Fables. This collaborative, ongoing project helps provide typographic inspiration for using Google’s free web fonts.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/GoogleTypographyProjectSample.png\" rel=\"prettyphoto[36261]\"><img class=\"size-full wp-image-36330\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/GoogleTypographyProjectSample.png?resize=1025%2C488\" alt=\"Google Typography Project\" /></a>Google Typography Project\n<p>Each post features a large image from <a title=\"http://unsplash.com/\" href=\"http://unsplash.com/\">Unsplash.com</a> with two or more web fonts used for headlines and content. Each web font is labeled and links to its corresponding page on <a title=\"https://www.google.com/fonts\" href=\"https://www.google.com/fonts\">Google Fonts</a>. If you know of a combination that looks great, the project is <a title=\"https://github.com/femmebot/google-type\" href=\"https://github.com/femmebot/google-type\">hosted on Github</a> where you can submit a pull request.</p>\n<h2>Font Combinator</h2>\n<p>Created by <a title=\"http://chipcullen.com/\" href=\"http://chipcullen.com/\">Chip Cullen</a>, <a title=\"http://font-combinator.com/\" href=\"http://font-combinator.com/\">Font Combinator </a>has a simple page where you can assign a Google web font to a headline, subheading, body text, and control the background color. Each area of the document is editable enabling you to add your own text. Although it doesn&#8217;t beautifully illustrate combinations like the Google Fonts Typography project, it&#8217;s a quick and easy way to view them.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/UsingFontCombinator.png\" rel=\"prettyphoto[36261]\"><img class=\"size-full wp-image-36331\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/UsingFontCombinator.png?resize=1025%2C387\" alt=\"Font Combinator in Action\" /></a>Font Combinator in Action\n<p>In most cases, you don&#8217;t need to worry about editing the typography of a theme since designer&#8217;s usually do a good job of finding fonts that work within a design. However, it doesn&#8217;t mean you can&#8217;t experiment to obtain a different look and feel. Just keep in mind that typography is one element of a design, but it&#8217;s often the most important.</p>\n<p>What tools or services do you use and recommend for discovering complimentary web fonts?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Dec 2014 18:48:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Without Notifying Customers, GoDaddy and MediaTemple Auto Activate SIDEKICK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36339\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wptavern.com/without-notifying-customers-godaddy-and-mediatemple-auto-activate-sidekick\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5842:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/01/CommunicationFeaturedImage.jpg\" rel=\"prettyphoto[36339]\"><img class=\"size-full wp-image-15569\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/01/CommunicationFeaturedImage.jpg?resize=637%2C200\" alt=\"Communication Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/elycefeliz/3224486233/\">elycefeliz</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>Those who use a Managed WordPress hosting plan from either GoDaddy or MediaTemple might have noticed a new addition to the WordPress Dashboard. If you saw a bright orange button with the text <strong>Help Me,</strong> it wasn&#8217;t a hack, but is part of the <a title=\"https://wordpress.org/plugins/sidekick/\" href=\"https://wordpress.org/plugins/sidekick/\">SIDEKICK plugin</a>. However, at least one customer thought it was a hack and published a concerning post in the <a title=\"https://www.facebook.com/groups/advancedwp/permalink/872478909480991/\" href=\"https://www.facebook.com/groups/advancedwp/permalink/872478909480991/\">Advanced WordPress Facebook group</a>.</p>\n<blockquote><p>I&#8217;ve just logged into WordPress and I see a bright orange &#8220;HELP ME&#8221; icon with a strange face icon next to it in the bottom left of my dashboard &#8211; and a message saying &#8220;Need help with WordPress? Click HELP ME&#8230;&#8221; at the top of the screen! What is that?! Have I just been hacked? There&#8217;s no way I&#8217;m clicking on that without checking what it is!?!</p></blockquote>\n<p>The orange icon noticed is related to the <a title=\"http://www.sidekick.pro/\" href=\"http://www.sidekick.pro/\">SIDEKICK plugin</a>. After clicking the button, it gives customers an opportunity to watch WordPress training videos from within the dashboard.</p>\n<p>The post generated a healthy discussion with several people weighing in including representatives from GoDaddy, MediaTemple, and SIDEKICK. The project manager in charge of the blunder also participated in the discussion and promptly apologized for his actions.</p>\n<p>GoDaddy Evangelist, Mendel Kurland, responded to the Facebook post explaining what happened from GoDaddy&#8217;s perspective.</p>\n<blockquote><p>Hey everyone, I&#8217;m currently in the middle of sending rabid pythons to the Project Manager for GoDaddy Managed WordPress (and we&#8217;re chatting with our brothers and sisters at MediaTemple too). On a managed platform, we take care of updates, but until now haven&#8217;t really installed a plugin to all existing sites en mass. Fact is, we were excited to get the plugin out there to help people (and tested and re-tested), but should have been more thoughtful, and consulted you all when it came to installing to existing sites.</p></blockquote>\n<p>SIDEKICK Co-Founder, Ben Fox, <a title=\"http://www.sidekick.pro/blog/learn-through-doing/quick-word-sidekick-go-daddy-media-temple/\" href=\"http://www.sidekick.pro/blog/learn-through-doing/quick-word-sidekick-go-daddy-media-temple/\">explains in an official blog post </a>that the premium SIDEKICK license was being auto-installed without letting users know.</p>\n<blockquote><p>If you were surprised or at all concerned about the appearance of SIDEKICK on your Dashboard, I apologize. The bright orange Help Me button isn’t a promotion or spam. It’s not malicious and it’s not bloatware, although I can empathize that it’s sudden appearance can cause one to jump to one or all of those conclusions. It’s an <a href=\"http://wordpress.org/plugins/sidekick\" target=\"_blank\">approved repository plugin</a> meant to provide exactly what the button indicates, help (and learning, training, onboarding) with WordPress.</p></blockquote>\n<p>Needless to say, auto installs of SIDEKICK are suspended for the time being until the team comes up with a better strategy.</p>\n<h2>Valuable Lessons Learned</h2>\n<p>As the number of products in the WordPress ecosystem increases, it&#8217;s becoming more difficult to differentiate from the competition. Establishing relationships with webhosting companies that host millions of sites is a great way to get a product in front of a lot of people. However, there are risks involved and if not executed properly, can seriously damage a company&#8217;s reputation.</p>\n<p>There are a few lessons to take away from this story.</p>\n<ol>\n<li>Communication is critical.</li>\n<li>If you have a product and establish a relationship with a webhosting company to push it to their customers, make sure everyone is on the same page.</li>\n<li>Let customers decide if they want what&#8217;s being pushed to them.</li>\n</ol>\n<h2>What Does it Mean to be Managed?</h2>\n<p>I&#8217;m not a fan of webhosts taking it upon themselves to automatically install and activate plugins on existing customer sites. However, I&#8217;m fine with bundling plugins for fresh installs of WordPress. With that said, If you&#8217;re using a managed host, should actions like these be expected if they&#8217;re done in the act of managing an account? Isn&#8217;t that what you&#8217;re paying for, to be managed?</p>\n<p>Based on the circumstance, it might make sense for a host to do one thing or another to manage the account. But on my list of things a webhost shouldn&#8217;t do is installing and activating a plugin on a customer&#8217;s site without their consent.</p>\n<p>This leads to the question, should managed WordPress hosts offer various levels of account management? If so, what would you like to see offered in each tier of service?</p>\n<p>If you&#8217;re a MediaTemple or GoDaddy customer and are concerned, you can contact <a title=\"mailto:ben@sidekick.pro\" href=\"mailto:ben@sidekick.pro\">ben@sidekick.pro</a> or <a title=\"mendel@godaddy.com\" href=\"mailto:mendel@godaddy.com\">mendel@godaddy.com</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Dec 2014 18:22:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Varying Vagrant Vagrants Adopts Open Source MIT License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=27531\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/varying-vagrant-vagrants-adopts-open-source-mit-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2658:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/open-source.jpg\" rel=\"prettyphoto[27531]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/open-source.jpg?resize=1025%2C482\" alt=\"photo credit: opensource.com\" class=\"size-full wp-image-36320\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/davedehetre/4965410048/in/photostream/\">opensource.com</a>\n<p><a href=\"https://github.com/Varying-Vagrant-Vagrants/VVV\" target=\"_blank\">Varying Vagrant Vagrants</a> 1.2.0 was released last week after nine months in development. As of VVV 1.2.0, new instances of VVV will have the database entirely contained inside the virtual machine, as opposed to previous versions where it was mapped to a persistent local location.</p>\n<p>VVV project leader <a href=\"https://jeremyfelt.com/\" target=\"_blank\">Jeremy Felt</a> recommends a full <code>vagrant destroy</code> and the removal of MySQL data from {vvv-dir}/database/data/ in order to keep a clean workflow in the future. &#8220;If database files already exist from an earlier version of VVV, data will continue to be mapped locally until removed,&#8221; he said, explaining the backward compatibility included in the release. &#8220;Anybody currently running VVV 1.1 may not even notice the change.&#8221;</p>\n<p>One of the most important updates in VVV 1.2 is the addition of a license. The project has adopted the open source <a href=\"https://github.com/varying-vagrant-vagrants/vvv/blob/master/LICENSE\" target=\"_blank\">MIT license</a> after a six-month long <a href=\"https://github.com/Varying-Vagrant-Vagrants/VVV/issues/346\" target=\"_blank\">discussion</a> with participation from more than 50 contributors on the project.</p>\n<p>&#8220;This is a big deal and we waited entirely too long as an open source project before choosing one,&#8221; Felt said. &#8220;In fact, you could say we weren&#8217;t really an open source project at all until that point. If there’s any lesson I learned from this, it’s to start with a license before anything else.&#8221;</p>\n<p>Ultimately, the project went with the more permissive MIT license over the GPL for a number of practical reasons. Since the MIT license is GPL-compatible, anyone who forks VVV can distribute a fork as GPL-licensed, if desired. It also allows for more contributions back to the project from representatives of corporations or government entities that are not as GPL-friendly.</p>\n<p>For more details on the technical improvements included in VVV 1.2.0, check out the full <a href=\"https://github.com/Varying-Vagrant-Vagrants/VVV/blob/master/CHANGELOG.md\" target=\"_blank\">changelog</a> for the release.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Dec 2014 22:33:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: Historic WordPress Project Seeks Contributors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36256\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/historic-wordpress-project-seeks-contributors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4651:\"<p>Have you ever wondered what WordPress looked like back in the early days, before it was used by millions of website around the web? Ryan Hellyer has created a series of static representations of the very early versions of WordPress. The <a href=\"https://geek.hellyer.kiwi/products/historic-wordpress/\" target=\"_blank\">Historic WordPress project</a> aims to showcase both the frontend and backend of the software for each release.</p>\n<p>Viewing the old versions is like opening a time capsule from 10 years ago. It&#8217;s amazing to see how much the interface has changed, and yet the basics of publishing to the web remain the same. For example, take a look at the post editor from WordPress 0.71 Gold, released May 27, 2003:</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/wordpress-post-editor-071.png\" rel=\"prettyphoto[36256]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/wordpress-post-editor-071.png?resize=990%2C641\" alt=\"wordpress-post-editor-071\" class=\"aligncenter size-full wp-image-36280\" /></a></p>\n<p>If you make your way through each release chronologically, you&#8217;ll see subtle changes in WordPress over the years, along with a few big design shifts. Hellyer has created the static sites up through version 2.7 and is hoping to add contributors to help finish out the rest.</p>\n<p>&#8220;There are a bunch of them which are missing and I&#8217;m now looking for people to help out with the project,&#8221; he said. &#8220;I have a <a href=\"https://github.com/ryanhellyer/historic-wordpress/\" target=\"_blank\">GitHub repository</a>, and I just need people to send patches/pull requests, etc. to beef it up with newer versions and iron out any bugs they may find.&#8221;</p>\n<p>The sites are static representations and not actual installations, due to security reasons. However, many of the links still click through so that you can navigate around to explore other admin pages. When creating the sites, Hellyer saves the live page as raw static HTML, CSS and JavaScript so that they it&#8217;s still able to be viewed in the browser. The process isn&#8217;t very difficult, but it is time-consuming:</p>\n<blockquote><p>To create each one, I install the relevant version of WordPress and then go through and export static pages for the main admin pages, plus some on the frontend. Once I have the page in it&#8217;s static form, I go through and fix as many URL&#8217;s as possible to make them reference other static pages I create. I try to add as many different admin pages as possible so that you can click through them all, but each one takes some time, so many are missing.</p></blockquote>\n<p>Hellyer is optimistic that new contributors may have a more automated way of creating the sites, as the current manual procedure is quite slow. He plans to keep the project only to static pages until that part is complete but may expand to add more information in the future.</p>\n<h3>The Importance of WordPress History</h3>\n<p>For those who have been involved in building WordPress for a long time, the importance of historic resources might seem to be self-evident. However, as the software continues to blaze forward, some newcomers may look at the historic project and wonder what use it is to have these static sites available.</p>\n<p>Hellyer believes that the project is a valuable resource for both new WordPress users and long-time experts alike.</p>\n<p>&#8220;I enjoy being able to look back on what things looked like and see how far we&#8217;ve come,&#8221; he said. &#8220;My <a href=\"https://ryan.hellyer.kiwi/\">own blog</a> is basically a look back on my own life, so I guess that sort of thing interests me. I also think it&#8217;s important for new folks in the WordPress community to see where some of the software&#8217;s internal logic comes from.&#8221;</p>\n<p>Hellyer had the idea for the project for a long time but became more motivated after a discussion with Siobhan McKeown. He recently transferred the site over to its own subdomain and made the interactive static sites public for all to enjoy.</p>\n<p>If you have any feedback or would like to get involved in preparing these small slices of WordPress history, Hellyer encourages you to get in touch. &#8220;I&#8217;m happy to add contributors to the <a href=\"https://github.com/ryanhellyer/historic-wordpress/\">GitHub repository</a> so that they can update the Historic WordPress website automatically. (I&#8217;ll set up an automatic Git deployment for this),&#8221; he said. &#8220;I&#8217;m keen on as many people as possible contributing by preparing new versions and fixing existing bugs.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Dec 2014 19:49:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Customize Twenty Fifteen With More Than 650 Fonts With Typecase\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36239\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/customize-twenty-fifteen-with-more-than-650-fonts-with-typecase\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3926:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/TypecaseFeaturedImage.png\" rel=\"prettyphoto[36239]\"><img class=\"aligncenter size-full wp-image-36253\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/TypecaseFeaturedImage.png?resize=733%2C234\" alt=\"Typecase Featured Image\" /></a>The new WordPress default theme, <a title=\"https://wordpress.org/themes/twentyfifteen\" href=\"https://wordpress.org/themes/twentyfifteen\">Twenty Fifteen</a>, looks great and provides a lot of flexibility, but one thing it lacks is the option to customize fonts. A free plugin called <a title=\"https://wordpress.org/plugins/typecase/\" href=\"https://wordpress.org/plugins/typecase/\">Typecase, </a>by <a title=\"https://upthemes.com/\" href=\"https://upthemes.com/\">UpThemes</a>, solves this problem by giving users easy access to over 650 different fonts.</p>\n<p>Typecase uses the <a title=\"https://www.google.com/fonts\" href=\"https://www.google.com/fonts\">Google webfonts library</a>, which has slowly increased in the past few years, making it a popular resource among theme developers.</p>\n<h2>Getting Started</h2>\n<p>Start by downloading and activating <a title=\"https://wordpress.org/plugins/typecase/\" href=\"https://wordpress.org/plugins/typecase/\">Typecase</a> from the WordPress plugin directory. After it&#8217;s activated, look for the Typecase admin menu. While on the settings screen, scroll to the bottom and browse through the list of available fonts. You won&#8217;t be able to apply fonts through the Theme customizer unless you select a few font families.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/TypecaseConfigurationPage.png\" rel=\"prettyphoto[36239]\"><img class=\"size-full wp-image-36249\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/TypecaseConfigurationPage.png?resize=1025%2C576\" alt=\"Typecast Configuration Page\" /></a>Typecast Configuration Page\n<p>After you select a few fonts, click the save button. Browse to the customizer via <em>Appearance &gt; Customize</em> and select the Theme Fonts panel.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/ThemeFontsPanel.png\" rel=\"prettyphoto[36239]\"><img class=\"size-full wp-image-36250\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/ThemeFontsPanel.png?resize=680%2C575\" alt=\"Theme Fonts Panel\" /></a>Theme Fonts Panel\n<p>From here you&#8217;ll be able to assign fonts you selected in Typecase to various elements of the site such as, the sidebar, content, site title, site description, etc. Once you find a font that you like, click the Save and Publish button to see the changes on the live site.</p>\n<h2>Beyond The Customizer</h2>\n<p>If you&#8217;d like to assign a font to a specific CSS Selector, you can add one from the Typecase settings page. This enables you to customize fonts for any theme without writing code or modifying your theme in any way.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/TypecaseSelectors.png\" rel=\"prettyphoto[36239]\"><img class=\"size-full wp-image-36251\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/TypecaseSelectors.png?resize=359%2C320\" alt=\"Typecase CSS Selectors\" /></a>Typecase CSS Selectors\n<h2>Add Typecase Support to Any Theme</h2>\n<p>Typecase has built-in support for every default theme since Twenty Ten. However, if you&#8217;d like to add support to a custom theme, you&#8217;ll need to <a title=\"https://upthemes.com/blog/2014/12/customize-fonts-twenty-fifteen-theme/\" href=\"https://upthemes.com/blog/2014/12/customize-fonts-twenty-fifteen-theme/\">follow these directions</a> as it involves adding a few lines of code.</p>\n<p>If you&#8217;re using any of the default themes available for WordPress, Typecase is an easy way to expand the customization options available to you. With over 650 fonts to choose from, the hardest part of using it is deciding which ones to use.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Dec 2014 05:09:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: WordPress 4.1 Includes More Than 20 New Dashicons\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36178\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/wordpress-4-1-includes-more-than-20-new-dashicons\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2095:\"<p><a title=\"https://developer.wordpress.org/resource/dashicons/#smiley\" href=\"https://developer.wordpress.org/resource/dashicons/#smiley\">Dashicons</a> is an icon font that first shipped with WordPress 3.8. Since then, the core development team has routinely added new icons as necessary. WordPress 4.1 includes <a title=\"https://make.wordpress.org/core/2014/12/20/dashicons-in-wordpress-4-1/\" href=\"https://make.wordpress.org/core/2014/12/20/dashicons-in-wordpress-4-1/\">more than 20 new icons,</a> specifically for the built-in media player and inline image editing tools.</p>\n<p>There&#8217;s also a few miscellaneous icons including, a palm tree, tickets, a building, and money.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/NewDashiconsinWP41.png\" rel=\"prettyphoto[36178]\"><img class=\"size-full wp-image-36195\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/12/NewDashiconsinWP41.png?resize=664%2C457\" alt=\"New Dashicons in WordPress 4.1\" /></a>New Dashicons in WordPress 4.1\n<p>Dashicons are shipped with WordPress which makes it a convenient option for developers. They&#8217;re also licensed under <a href=\"http://www.gnu.org/licenses/gpl-2.0.html\">GPLv2, </a>or any later version using <a title=\"http://en.wikipedia.org/wiki/GPL_font_exception\" href=\"http://en.wikipedia.org/wiki/GPL_font_exception\">the font exception</a>. To request a new icon, keep an eye on Trac <a title=\"https://core.trac.wordpress.org/search?q=%22create+new+dashicons%22&noquickjump=1&ticket=on\" href=\"https://core.trac.wordpress.org/search?q=%22create+new+dashicons%22&noquickjump=1&ticket=on\">for the ticket</a> that covers WordPress 4.2.</p>\n<p>If you encounter an issue using Dashicons, please <a href=\"https://core.trac.wordpress.org/newticket\">create a new ticket on trac</a>. Use the “administration” component and the “UI” focus when creating the ticket and be sure to include “Dashicons” somewhere in the text of the ticket.</p>\n<p>What other icons would you like to see added? Also, in what circumstance does it make sense to use the palm tree icon?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Dec 2014 20:14:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: New WordPress Customizer Import/Export Plugin Migrates Theme and Plugin Settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36166\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/new-wordpress-customizer-importexport-plugin-migrates-theme-and-plugin-settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5893:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/customizer-import-export.jpg\" rel=\"prettyphoto[36166]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/customizer-import-export.jpg?resize=657%2C250\" alt=\"customizer-import-export\" class=\"aligncenter size-full wp-image-36214\" /></a></p>\n<p>The WordPress project is charging full steam ahead with improvements to the customizer. The most recent release featured the addition of dynamic and contextual controls, sections, and panels. As WordPress 4.2 is kicking off development, core contributors are looking to <a href=\"http://wptavern.com/menu-customizer-now-in-development-for-wordpress-4-2\" target=\"_blank\">add menus to the customizer</a> for easy management from the frontend.</p>\n<p>More WordPress theme developers are adopting the native customizer to add options to themes, as it provides a standard interface with which users are familiar. One feature that is missing is the ability export and import customizer settings, an option that many pre-customizer theme panels have readily available.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/customizer-export-import-settings.jpg\" rel=\"prettyphoto[36166]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/customizer-export-import-settings.jpg?resize=299%2C392\" alt=\"customizer-export-import-settings\" class=\"alignright size-full wp-image-36229\" /></a><a href=\"https://wordpress.org/plugins/customizer-export-import/\" target=\"_blank\">Customizer Export/Import</a> is a plugin that addresses this need by adding the ability for users to export/import settings from any theme or plugin that makes use of the customizer. You&#8217;ll need to have the same theme (or plugin) installed on both sites where you are performing the export/import. The export file is named after your theme and you can use it to import the settings for the same theme (or child theme) on another site.</p>\n<p>The plugin was created by <a href=\"http://www.wpbeaverbuilder.com/\" target=\"_blank\">Justin Busa</a>, a web developer and co-founder at <a href=\"http://www.fastlinemedia.com/\" target=\"_blank\">FastLine Media</a>. After spending quite a bit of time with the customizer while migrating a theme options page over to it, Busa was inspired to solve the problem of import/export.</p>\n<p>&#8220;One of the pieces that had to be migrated was the ability for users to export or import their theme settings,&#8221; he said. &#8220;That’s a pretty common feature of themes that have a custom options page, but not one that can be standardized since each theme typically has its own way of handling options.&#8221;</p>\n<p>As he began building export/import functionality for his own theme, he found that it could benefit more developers as a general tool. &#8220;I quickly realized that was something that could actually work with any theme. I did some research to see if something like this already existed and it turns out that it didn&#8217;t.&#8221;</p>\n<h3>Reusable Configurations for Themes and Plugins</h3>\n<p>Busa believes that developers who build WordPress sites are most likely to be the ideal users of this plugin as a tool to streamline the process. &#8220;This plugin will allow people building many WordPress sites to save different configurations for their favorite themes and reuse them again and again,&#8221; he said. &#8220;It could also be as simple as exporting the settings you used on a previous site to start a new similar site.&#8221;</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/export-import-message.jpg\" rel=\"prettyphoto[36166]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/12/export-import-message.jpg?resize=300%2C170\" alt=\"export-import-message\" class=\"alignright size-full wp-image-36232\" /></a>Theme authors can also add support for the plugin in order to avoid having to spin up their own export/import functionality, as Busa is doing with his current theme. The Export/Import panel in the customizer will prompt the user to install the plugin if he hasn&#8217;t already. &#8220;Additionally, theme authors could potentially offer any number of presets for their themes that users could import by leveraging this plugin,&#8221; Busa said.</p>\n<p>Customizer Export/Import is designed to work with any theme or plugin that makes use of the customizer. Busa notes that it does not, however, export settings that aren&#8217;t stored in the database as theme mods, which means that it doesn&#8217;t currently export widgets, menus or settings such as the built-in “Site Title &amp; Tagline”. The export file output by the plugin contains a serialized dump of mods retrieved using the <a href=\"https://developer.wordpress.org/reference/functions/get_theme_mods/\" target=\"_blank\">get_theme_mods</a> function.</p>\n<p>&#8220;We&#8217;ve tested it with many popular themes that use the customizer, including Genesis, Make, and Twenty Fifteen, and it works great,&#8221; he said. Busa is not sure if adding the ability to import widgets and menus from other sites makes sense.</p>\n<p>&#8220;For example, the pages in a menu might not be on the destination site or the widgets in a sidebar might not be installed,&#8221; he said. &#8220;My initial thinking is that if you need that level of export/import functionality, you’re probably better off with a heavier solution like WP Migrate DB Pro. I’ll be keeping an eye on feedback before making a decision there.&#8221;</p>\n<p>The <a href=\"https://wordpress.org/plugins/customizer-export-import/\" target=\"_blank\">Customizer Export/Import</a> plugin is available on WordPress.org. If you are a theme developer or user who finds the plugin to be valuable, make sure to send Busa feedback via the project page on <a href=\"https://github.com/fastlinemedia/customizer-export-import\" target=\"_blank\">GitHub</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Dec 2014 20:12:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Post Status: Website micro services provider, Elto, is shutting down for now\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://www.poststat.us/?p=7258\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://www.poststat.us/elto-shutting-down-temporarily/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4784:\"<p><img src=\"http://www.poststat.us/wp-content/uploads/2014/12/elto-752x301.jpg\" alt=\"elto\" width=\"627\" height=\"251\" class=\"aligncenter size-large wp-image-7260\" /><br />\n<a href=\"http://elto.com\">Elto</a>, formerly Tweaky, is a micro services provider, for lack of a better term. They started with $25 tweaks, which until they <a href=\"http://www.elto.com/blog/well-be-back/\">shut down services today</a>, worked it&#8217;s way to a $199 minimum.</p>\n<p>WordPress is a high focus vertical for Elto&#8217;s, and I presume it&#8217;s their largest as well. Elto is one of several such providers of micro services like this; others still running are <a href=\"https://codeable.io/\">Codeable</a> and <a href=\"http://studio.envato.com/\">Envato Studio</a> (formerly Microlancer). These are besides the longstanding generic types (with rather poor reputations, in my opinion) such as oDesk and Elance.</p>\n<p>I have always kept track of Elto, as I started referring folks to them from my own contact form for small projects, in order to narrow the leads I was getting. When I got the email today from Ned Dwyer, Elto&#8217;s founder, I went to my dashboard to see how many folks had used my referral and what those services were:<br />\n<img src=\"http://www.poststat.us/wp-content/uploads/2014/12/elto-services1-752x261.png\" alt=\"elto-services\" width=\"627\" height=\"218\" class=\"aligncenter size-large wp-image-7264\" /></p>\n<p>In the time I was referring folks to Elto, I sent them nearly $2,000 in business and got a 25% referral fee. That&#8217;s not a lot; more interesting is that of these referrals, there was an 8.5 / 10 satisfaction rate. I wouldn&#8217;t say that&#8217;s outstanding, but it&#8217;s not bad either. It&#8217;s probably better or close to the satisfaction of more traditional web services providers.</p>\n<p>I emailed Ned to see if he could offer any more insight into this decision. He responded with the following:</p>\n<blockquote><p>\nIt was something we thought long and hard about before making this change.</p>\n<p>The challenge is that the current model was working well &#8211; customers rate us on average 8.7 out of 10, thousands of new customers every month etc &#8211; but it wasn&#8217;t delivering the kinds of results we wanted. This will become clearer when we launch the new version.</p>\n<p>While we could have kept going with this model while working on the next version in the background, the current model has significant customer support challenges. This puts a burden on our team to maintain the current app and customer base which draws resources away from us working on what&#8217;s important.</p>\n<p>We have the full support of our team and investors in making these changes and we&#8217;re excited about what&#8217;s next.</p></blockquote>\n<p>So it appears that this is a temporary stop for Elto. I&#8217;m sure &#8212; with investors to answer to &#8212; rising support challenges makes change inevitable.</p>\n<p>I&#8217;ve always liked the idea of companies like Elto from a developer standpoint. As long as the company values the developers they are mediating for, it can be a nice way for junior developers or just folks that don&#8217;t want to interact with clients much to be able to get work. It can also be a way to fill in the gaps in someone&#8217;s own freelance work.</p>\n<p>I&#8217;m not sure what the next version of Elto will look like, but it seems they&#8217;re aiming to be more in the product business and less in the service business.</p>\n<p>From what I can gather, they raised at least a seed round in 2012, <a href=\"http://thenextweb.com/insider/2012/07/17/99design-founders-invest-460000-in-tweaky-a-marketplace-for-minor-website-customizations/\">reported at $460,000</a>, and perhaps <a href=\"http://www.startupsmart.com.au/growth/growth-strategy/introducing-elto-tweaky-founder-shares-about-their-major-pivot-brand-change-and-latest-investment-round/2014020311615.html\">another round in 2013</a> from Blackbird Ventures.</p>\n<p>I guess my primary takeaway from a change like this is that even when companies are productizing services, doing work for cheap isn&#8217;t easy. Support struggles, maintaining customer expectations, managing developers &#8212; it&#8217;s all tough. I am curious if Codeable and other what I&#8217;d call &#8220;progressive&#8221; members of this style market can relate to Elto&#8217;s struggles, or if they have somehow managed to get past those.</p>\n<p>For some additional reading on Elto&#8217;s journey, Ned&#8217;s post about <a href=\"http://www.elto.com/blog/lessons-weve-learned-from-2-years-of-running-elto/\">what they learned in their first two years</a> was insightful. He also hints they considered a pause even then; so I guess today shouldn&#8217;t be too much of a surprise.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Dec 2014 17:39:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: WordSesh 3 Attracts 3,000 Unique Viewers From 89 Countries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36174\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/wordsesh-3-attracts-3000-unique-viewers-from-89-countries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3577:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/WordSesh3FeaturedImage.png\" rel=\"prettyphoto[36174]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/WordSesh3FeaturedImage.png?resize=650%2C266\" alt=\"WordSesh 3 Featured Image\" class=\"aligncenter size-full wp-image-32961\" /></a></p>\n<p><a href=\"http://wordsesh.org/\" target=\"_blank\">WordSesh 3</a> took the WordPress world by storm over the weekend. With more than 3,000 unique viewers, the event attracted roughly three times the number of people who attended <a href=\"http://wptavern.com/wordpress-beyond-boundaries-a-recap-of-wordcamp-europe-2014\" target=\"_blank\">WordCamp Europe 2014</a>. This makes WordSesh one of the largest WordPress events of the year.</p>\n<p>WordSesh is essentially an online WordCamp where viewers don&#8217;t have to obtain a visa or make travel arrangements. This accounts for the large number of participants, along with the 45 high quality speakers and panelists. Those who tuned in for the full 24 hours used the <a href=\"https://twitter.com/search?q=%23pressomnia&src=typd\" target=\"_blank\">#pressomnia</a> hashtag to share thoughts and and updates throughout the event.</p>\n<p>According to organizer <a href=\"http://scottbasgaard.com/\" target=\"_blank\">Scott Basgaard</a>, live session stats were not easy to track with both the WordSesh.org and direct Crowdcast links in circulation. Nevertheless, he was able to gather some solid information about WordSesh viewership. The stats that came out of the event reflect a diverse audience in terms of geographic location:</p>\n<ul>\n<li>19 new countries tuned into WordSesh compared to last year.</li>\n<li>Between 90-200 people were watching every session over 24 hours.</li>\n<li>In the span of 24 hours there were nearly 3,000 unique viewers on WordSesh.org</li>\n<li>People across 89 different countries tuned in to watch WordSesh 3. </li>\n<li>Top 10 countries that tuned in: USA, UK, Australia, Canada, Netherlands, Bulgaria, Germany, Sweden, India and Norway.</li>\n<li>Top 10 cities by viewers: Sofia, Melbourne, London, New York, Los Angeles, Philadelphia, Sydney, Brisbane and San Francisco.</li>\n</ul>\n<p>Sofia once again came out on top for the city with the most viewers, followed by half a dozen cities with much larger populations. The overall stats are very similar to <a href=\"http://wptavern.com/wordsesh-recap-global-wordpress-event-pulls-3000-unique-viewers-from-85-countries\" target=\"_blank\">WordSesh 2</a>, last year&#8217;s event, which pulled in 3,000 unique viewers from 85 countries.</p>\n<p>The most lively sessions were the six round tables that gathered top experts around specific topics, such as WordPress community, conferences, and news. Basgaard was able to ramp up the interaction during the panels using <a href=\"http://www.crowdcast.io/\" target=\"_blank\">Crowdcast.io</a>:</p>\n<blockquote><p>The round table format is by far my favorite and the moderators / panelists this year did an outstanding job. Crowdcast.io proved to be an incredible tool for our event and it’s ability to have user submitted questions, up voting and polling was very helpful to tie in interaction with our round tables and speakers. Topics included themes, plugins, the WordPress community, WordPress conferences, business and WordPress news.</p></blockquote>\n<p>If you were not able to tune into WordSesh 3 live, you haven&#8217;t been left out. Every single session was recorded and is available on YouTube in a playlist for you to watch at your leisure.</p>\n<p><span class=\"embed-youtube\"></span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Dec 2014 17:00:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: What’s Your First Impression of Distraction-free Writing in WordPress 4.1?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=36183\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/whats-your-first-impression-of-distraction-free-writing-in-wordpress-4-1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1715:\"<p>With the <a title=\"http://wptavern.com/wordpress-4-1-dinah-released\" href=\"http://wptavern.com/wordpress-4-1-dinah-released\">release of WordPress 4.1</a> just a few days ago, <a title=\"https://wordpress.org/download/counter/\" href=\"https://wordpress.org/download/counter/\">millions of people</a> have had the opportunity to use the improved Distraction-free Writing Mode. I rarely use this mode, but I&#8217;ve used it to write every post since updating to 4.1 and it&#8217;s growing on me.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/DistractionFreeWriting41.png\" rel=\"prettyphoto[36183]\"><img class=\"size-full wp-image-35707\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/12/DistractionFreeWriting41.png?resize=1025%2C501\" alt=\"Distraction Free Writing in WordPress 4.1\" /></a>Distraction Free Writing in WordPress 4.1\n<p>The improved mode works great on my Macbook Pro which has a 15&#8243; screen. I&#8217;m still not sure whether I like how the admin menu on the left hand side slides in and out of view. Sometimes it&#8217;s a distraction and sometimes I don&#8217;t notice it.</p>\n<p>The rest of the interface fades in and out of view. The animation is fast enough to not hinder my ability to quickly access meta boxes. As an experiment, I&#8217;d like to try DFW where the interface shares one animation to see what the experience is like.</p>\n<p>Having access to the full toolbar while everything else fades off the screen is a nice change of pace. I didn&#8217;t use the original DFW, but the new and improved version is winning me over. How about you?</p>\nNote: There is a poll embedded within this post, please visit the site to participate in this post\'s poll.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Dec 2014 02:43:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 07 Jan 2015 22:32:42 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"356059\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Wed, 07 Jan 2015 22:15:16 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20141124234515\";}", "no");
INSERT INTO `wp_options` VALUES("452", "_transient_timeout_feed_mod_867bd5c64f85878d03a060509cd2f92c", "1420713163", "no");
INSERT INTO `wp_options` VALUES("453", "_transient_feed_mod_867bd5c64f85878d03a060509cd2f92c", "1420669963", "no");
INSERT INTO `wp_options` VALUES("454", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1420713163", "no");
INSERT INTO `wp_options` VALUES("455", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jan 2015 22:25:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:15:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"WordPress SEO by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast&#039;s WordPress SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"arnee\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Displays Google Analytics reports and real-time statistics in your WordPress Dashboard. Inserts the latest tracking code in every page of your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 10 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"The easiest, most effective way to secure WordPress in seconds.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 07 Jan 2015 22:32:43 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:7:\"expires\";s:29:\"Wed, 07 Jan 2015 23:00:13 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Wed, 07 Jan 2015 22:25:13 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20141124234515\";}", "no");
INSERT INTO `wp_options` VALUES("456", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1420713163", "no");
INSERT INTO `wp_options` VALUES("457", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1420669963", "no");
INSERT INTO `wp_options` VALUES("458", "_transient_timeout_plugin_slugs", "1420758306", "no");
INSERT INTO `wp_options` VALUES("459", "_transient_plugin_slugs", "a:11:{i:0;s:19:\"akismet/akismet.php\";i:1;s:48:\"clickbank-ads-clickbank-widget/clickbank-ads.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:44:\"featured-content-gallery/content-gallery.php\";i:4;s:21:\"hello-dolly/hello.php\";i:5;s:19:\"jetpack/jetpack.php\";i:6;s:40:\"mojo-marketplace-hg/mojo-marketplace.php\";i:7;s:33:\"privacy-policy/privacy-policy.php\";i:8;s:23:\"tubepress/tubepress.php\";i:9;s:34:\"wp-contact-form/wp-contactform.php\";i:10;s:27:\"wp-super-cache/wp-cache.php\";}", "no");
INSERT INTO `wp_options` VALUES("460", "_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51", "1420713163", "no");
INSERT INTO `wp_options` VALUES("461", "_transient_dash_4077549d03da2e451c8b5f002294ff51", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2014/12/dinah/\'>WordPress 4.1 “Dinah”</a> <span class=\"rss-date\">December 18, 2014</span><div class=\"rssSummary\">Version 4.1 of WordPress, named “Dinah” in honor of jazz singer Dinah Washington, is available for download or update in your WordPress dashboard. New features in WordPress 4.1 help you focus on your writing, and the new default theme lets you show it off in style. Introducing Twenty Fifteen Our newest default theme, Twenty Fifteen, is [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wptavern.com/better-search-replace-a-new-plugin-for-updating-urls-and-text-in-wordpress-databases\'>WPTavern: Better Search Replace: A New Plugin for Updating URLs and Text in WordPress Databases</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/happy-joe-to-host-wp-boot-camp-january-23-a-free-training-event-for-military-veterans\'>WPTavern: Happy Joe to Host WP Boot Camp January 23: A Free Training Event for Military Veterans</a></li><li><a class=\'rsswidget\' href=\'http://ma.tt/2015/01/wp-com-year-in-review/\'>Matt: WP.com Year in Review</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/woocommerce/\' class=\'dashboard-news-plugin-link\'>WooCommerce - excelling eCommerce</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=woocommerce&amp;_wpnonce=9775e466d7&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'WooCommerce - excelling eCommerce\'>Install</a>)</span></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("506", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1420671905;s:7:\"checked\";a:11:{s:19:\"akismet/akismet.php\";s:5:\"3.0.4\";s:48:\"clickbank-ads-clickbank-widget/clickbank-ads.php\";s:3:\"1.5\";s:25:\"duplicator/duplicator.php\";s:6:\"0.5.10\";s:44:\"featured-content-gallery/content-gallery.php\";s:5:\"3.2.0\";s:21:\"hello-dolly/hello.php\";s:3:\"1.6\";s:19:\"jetpack/jetpack.php\";s:3:\"3.3\";s:40:\"mojo-marketplace-hg/mojo-marketplace.php\";s:5:\"0.5.9\";s:33:\"privacy-policy/privacy-policy.php\";s:3:\"1.1\";s:23:\"tubepress/tubepress.php\";s:5:\"3.1.6\";s:34:\"wp-contact-form/wp-contactform.php\";s:3:\"1.6\";s:27:\"wp-super-cache/wp-cache.php\";s:5:\"1.4.2\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:9:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.0.4\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.0.4.zip\";}s:48:\"clickbank-ads-clickbank-widget/clickbank-ads.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"53172\";s:4:\"slug\";s:30:\"clickbank-ads-clickbank-widget\";s:6:\"plugin\";s:48:\"clickbank-ads-clickbank-widget/clickbank-ads.php\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:61:\"https://wordpress.org/plugins/clickbank-ads-clickbank-widget/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/clickbank-ads-clickbank-widget.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.10\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.10.zip\";}s:44:\"featured-content-gallery/content-gallery.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"6292\";s:4:\"slug\";s:24:\"featured-content-gallery\";s:6:\"plugin\";s:44:\"featured-content-gallery/content-gallery.php\";s:11:\"new_version\";s:5:\"3.2.0\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/featured-content-gallery/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/featured-content-gallery.3.2.0.zip\";}s:21:\"hello-dolly/hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:21:\"hello-dolly/hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:3:\"3.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.3.3.zip\";}s:23:\"tubepress/tubepress.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"312\";s:4:\"slug\";s:9:\"tubepress\";s:6:\"plugin\";s:23:\"tubepress/tubepress.php\";s:11:\"new_version\";s:5:\"3.1.6\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/tubepress/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/tubepress.3.1.6.zip\";}s:34:\"wp-contact-form/wp-contactform.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"337\";s:4:\"slug\";s:15:\"wp-contact-form\";s:6:\"plugin\";s:34:\"wp-contact-form/wp-contactform.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/wp-contact-form/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wp-contact-form.1.6.zip\";}s:27:\"wp-super-cache/wp-cache.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"1221\";s:4:\"slug\";s:14:\"wp-super-cache\";s:6:\"plugin\";s:27:\"wp-super-cache/wp-cache.php\";s:11:\"new_version\";s:5:\"1.4.2\";s:14:\"upgrade_notice\";s:91:\"Fixed &quot;acceptable file list&quot; and no caching for GET queries bugs in last release.\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-super-cache/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-super-cache.1.4.2.zip\";}}}", "yes");
INSERT INTO `wp_options` VALUES("503", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("505", "ClickBankWEC3", "a:14:{s:5:\"title\";s:14:\"Related eBooks\";s:4:\"name\";s:8:\"anton343\";s:15:\"keywordbytitle2\";s:5:\"Title\";s:8:\"keywords\";s:0:\"\";s:8:\"adformat\";s:1:\"1\";s:6:\"width2\";s:4:\"100%\";s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:3:\"220\";s:3:\"pos\";s:3:\"Top\";s:9:\"bordstyle\";s:1:\"1\";s:9:\"bordcolor\";s:6:\"CCCCCC\";s:9:\"linkcolor\";s:6:\"0000FF\";s:9:\"runplugin\";s:1:\"1\";s:8:\"homepage\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("507", "duplicator_settings", "a:9:{s:7:\"version\";s:6:\"0.5.10\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("508", "duplicator_version_plugin", "0.5.10", "yes");
INSERT INTO `wp_options` VALUES("509", "duplicator_ui_view_state", "a:1:{s:14:\"dup-wpnotice01\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("510", "duplicator_package_active", "O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:36:\"20150107_carsblogeverythingyoushould\";s:4:\"Hash\";s:29:\"54adbba95381c4249150107230513\";s:8:\"NameHash\";s:66:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513\";s:7:\"Version\";s:6:\"0.5.10\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/home1/anton241/public_html/demobay.info/cars/wp-snapshots/tmp\";s:8:\"StoreURL\";s:38:\"http://demobay.info/cars/wp-snapshots/\";s:8:\"ScanFile\";s:76:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/home1/anton241/public_html/demobay.info/cars\";s:4:\"Size\";i:0;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:36:\"20150107_carsblogeverythingyoushould\";s:4:\"Hash\";s:29:\"54adbba95381c4249150107230513\";s:8:\"NameHash\";s:66:\"20150107_carsblogeverythingyoushould_54adbba95381c4249150107230513\";s:7:\"Version\";s:6:\"0.5.10\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/home1/anton241/public_html/demobay.info/cars/wp-snapshots/tmp\";s:8:\"StoreURL\";s:38:\"http://demobay.info/cars/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:30;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:30;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";r:45;s:8:\"Database\";r:57;}", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("151", "63", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:160;s:6:\"height\";i:600;s:4:\"file\";s:27:\"2015/01/160x600-highres.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"160x600-highres-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"160x600-highres-80x300.png\";s:5:\"width\";i:80;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("150", "63", "_wp_attached_file", "2015/01/160x600-highres.png");
INSERT INTO `wp_postmeta` VALUES("5", "5", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("11", "7", "_edit_lock", "1289864300");
INSERT INTO `wp_postmeta` VALUES("10", "7", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("8", "5", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("9", "5", "_edit_lock", "1289864281");
INSERT INTO `wp_postmeta` VALUES("33", "15", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("14", "7", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("15", "9", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("16", "9", "_edit_lock", "1289864313");
INSERT INTO `wp_postmeta` VALUES("35", "17", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("19", "9", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("20", "11", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("68", "29", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("23", "11", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("24", "11", "_edit_lock", "1289864325");
INSERT INTO `wp_postmeta` VALUES("25", "13", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("26", "13", "_edit_lock", "1289864339");
INSERT INTO `wp_postmeta` VALUES("34", "15", "_edit_lock", "1289864358");
INSERT INTO `wp_postmeta` VALUES("30", "15", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("29", "13", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("36", "17", "_edit_lock", "1289864393");
INSERT INTO `wp_postmeta` VALUES("69", "29", "_edit_lock", "1289865400");
INSERT INTO `wp_postmeta` VALUES("46", "21", "_edit_lock", "1289865407");
INSERT INTO `wp_postmeta` VALUES("39", "17", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("40", "19", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("124", "43", "thumbnail", "i/1.png");
INSERT INTO `wp_postmeta` VALUES("45", "21", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("43", "19", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("44", "19", "_edit_lock", "1289864405");
INSERT INTO `wp_postmeta` VALUES("49", "21", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("50", "23", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("51", "23", "_edit_lock", "1289865405");
INSERT INTO `wp_postmeta` VALUES("54", "23", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("55", "25", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("70", "31", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("125", "41", "thumbnail", "i/2.png");
INSERT INTO `wp_postmeta` VALUES("58", "25", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("59", "25", "_edit_lock", "1289865403");
INSERT INTO `wp_postmeta` VALUES("60", "27", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("61", "27", "_edit_lock", "1289865401");
INSERT INTO `wp_postmeta` VALUES("65", "29", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("64", "27", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("123", "43", "articleimg", "i/13.png");
INSERT INTO `wp_postmeta` VALUES("73", "31", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("74", "31", "_edit_lock", "1289865398");
INSERT INTO `wp_postmeta` VALUES("75", "33", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("78", "33", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("79", "33", "_edit_lock", "1289865313");
INSERT INTO `wp_postmeta` VALUES("80", "35", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("95", "41", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("91", "39", "_edit_lock", "1289865308");
INSERT INTO `wp_postmeta` VALUES("83", "35", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("84", "35", "_edit_lock", "1289865311");
INSERT INTO `wp_postmeta` VALUES("85", "37", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("94", "39", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("90", "39", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("88", "37", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("89", "37", "_edit_lock", "1289865310");
INSERT INTO `wp_postmeta` VALUES("98", "41", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("99", "41", "_edit_lock", "1289865307");
INSERT INTO `wp_postmeta` VALUES("100", "43", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("101", "43", "_edit_lock", "1289865306");
INSERT INTO `wp_postmeta` VALUES("128", "37", "thumbnail", "i/4.png");
INSERT INTO `wp_postmeta` VALUES("104", "43", "_wp_old_slug", "");
INSERT INTO `wp_postmeta` VALUES("129", "37", "articleimg", "i/15.png");
INSERT INTO `wp_postmeta` VALUES("127", "39", "articleimg", "i/14.png");
INSERT INTO `wp_postmeta` VALUES("126", "39", "thumbnail", "i/3.png");
INSERT INTO `wp_postmeta` VALUES("130", "35", "thumbnail", "i/5.png");
INSERT INTO `wp_postmeta` VALUES("131", "33", "thumbnail", "i/6.png");
INSERT INTO `wp_postmeta` VALUES("132", "31", "hpbottom", "i/7.png");
INSERT INTO `wp_postmeta` VALUES("133", "29", "hpbottom", "i/8.png");
INSERT INTO `wp_postmeta` VALUES("134", "27", "hpbottom", "i/9.png");
INSERT INTO `wp_postmeta` VALUES("135", "25", "hpbottom", "i/10.png");
INSERT INTO `wp_postmeta` VALUES("136", "23", "hpbottom", "i/11.png");
INSERT INTO `wp_postmeta` VALUES("137", "21", "hpbottom", "i/12.png");
INSERT INTO `wp_postmeta` VALUES("138", "54", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("139", "54", "_edit_lock", "1290986247");
INSERT INTO `wp_postmeta` VALUES("140", "54", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("141", "56", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("142", "56", "_edit_lock", "1290986259");
INSERT INTO `wp_postmeta` VALUES("143", "56", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("144", "58", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("145", "58", "_edit_lock", "1290986284");
INSERT INTO `wp_postmeta` VALUES("146", "58", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("147", "60", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("148", "60", "_edit_lock", "1290986302");
INSERT INTO `wp_postmeta` VALUES("149", "60", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("152", "64", "_wp_attached_file", "2015/01/120x600.spraypaint.jpg");
INSERT INTO `wp_postmeta` VALUES("153", "64", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:120;s:6:\"height\";i:449;s:4:\"file\";s:30:\"2015/01/120x600.spraypaint.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"120x600.spraypaint-120x150.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"120x600.spraypaint-80x300.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("2", "1", "2010-11-15 17:34:15", "2010-11-15 23:34:15", "This is an example of a WordPress page, you could edit this to put information about yourself or your site so readers know where you are coming from. You can create as many pages like this one or sub-pages as you like and manage all of your content inside of WordPress.", "About", "", "publish", "open", "open", "", "about", "", "", "2010-11-15 17:34:15", "2010-11-15 17:34:15", "", "0", "http://mywaytoprofits.com/cars/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2010-11-28 23:17:27", "2010-11-28 23:17:27", "<iframe src=\"http://astore.amazon.com/ascdsfyiuo987ujiolp-20\" width=\"90%\" height=\"4000\" frameborder=\"0\" scrolling=\"no\"></iframe>\r\n\r\n", "Store", "", "publish", "open", "open", "", "store", "", "", "2010-11-28 23:17:27", "2010-11-28 23:17:27", "", "0", "http://mywaytoprofits.com/cars/?page_id=54", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5", "1", "2010-11-15 23:38:00", "2010-11-15 23:38:00", "Although in real terms it is just a means of traveling, the car has taken on a completely iconic role in modern life. For some people, a car is just a car, a conveyance to get you from A to B, and maybe on to C if you are feeling adventurous. For many others, though, a car is as defining a symbol as any other, and says a lot about the person driving it. \r\n\r\nMany people purchase a car with this in mind – sitting behind the wheel of a particular car is endlessly interwoven with status. For some people, the first thing they will do when they become definably rich is to buy the car of their dreams. Look at the players\' car park at any major sporting stadium and you will get an idea of how significant this is. \r\n\r\nThe car has had a fairly major role to play in popular culture. Particularly in cop shows and movies, the car that a central character drives will have as much significance for the viewer as the character\'s wife and family and indeed the place where the show is set. Just look at the Dukes of Hazzard and Starsky and Hutch for two examples of how iconic a TV car can become. \r\n\r\nIt could be said that we fetishise the car in Western society. It is definitely true that we make a big thing out of the kind of car someone drives. Frequently, a politician will even be judged on the car they drive – is it made domestically, does it get decent gas mileage, what are my taxes paying for? The car is a source of endless fascination even for those who do not drive.", "The Way We Look At Cars ", "", "publish", "open", "open", "", "the-way-we-look-at-cars", "", "", "2010-11-15 23:38:00", "2010-11-15 23:38:00", "", "0", "http://mywaytoprofits.com/cars/?p=5", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2010-11-15 23:37:51", "2010-11-15 23:37:51", "", "Auto Draft", "", "inherit", "open", "open", "", "5-revision", "", "", "2010-11-15 23:37:51", "2010-11-15 23:37:51", "", "5", "http://mywaytoprofits.com/cars/?p=6", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2010-11-15 23:38:20", "2010-11-15 23:38:20", "The discussion of what is the best car in the world is a pretty futile one unless you lay down certain parameters as to what the “best” really is. Do we mean the one that moves fastest, the one that looks best or the one which lasts the longest? These are just three criteria which can either be the most important or entirely irrelevant, depending upon your point of view. \r\n\r\nFor some people, the best car is the one that runs the most smoothly. Some cars, though technically excellent and pleasant to look at, have just one small fault which dogs the driver from the moment they take it home to the day they trade it in. The fault may not even be a particularly severe one, but if it keeps happening it can make the car impossible to run. \r\n\r\nFor those of an environmental frame of mind, the kind of gas mileage the car gets is also important. Many sports cars are beautiful to look at and purr like a tiger when they are on the open road, but they require refuelling so often that they are impossible to run economically and ecologically. A less “exciting” car that gets more mileage for a full tank of gas will be less likely to send you crazy. \r\n\r\nSometimes, the dream car is one that you just fall in love with for no reason that can be easily explained. From childhood, many of us see a car just once and think that we will be truly happy the day we can drive it off a forecourt. Sometimes, we need to be careful what we wish for.", "Your Dream Drive – What Makes The Perfect Car? ", "", "publish", "open", "open", "", "your-dream-drive-%e2%80%93-what-makes-the-perfect-car", "", "", "2010-11-15 23:38:20", "2010-11-15 23:38:20", "", "0", "http://mywaytoprofits.com/cars/?p=7", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2010-11-15 23:38:15", "2010-11-15 23:38:15", "", "Your Dream Drive – What Makes The Perfect Car? ", "", "inherit", "open", "open", "", "7-revision", "", "", "2010-11-15 23:38:15", "2010-11-15 23:38:15", "", "7", "http://mywaytoprofits.com/cars/?p=8", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2010-11-15 23:38:33", "2010-11-15 23:38:33", "A common discussion among motoring aficionados is the one about which country produces the best vehicles. Of course, it is a subjective argument. One person may have different views about what actually makes for the best car, and their preference may be reflected by a choice of cars from a specific nation. \r\n\r\nSomeone who likes efficiency in their automobiles will be likely to wave the flag for Germany. The country\'s most noted manufacturers – BMW, Audi and Mercedes Benz among them – are a byword for sleek class and reliability. Then again, you may be bored by efficiency and want a bit more bang for your buck, which may lead you to the Italian manufacturers such as Ferrari and Lamborghini. \r\n\r\nOf course, there are certain anomalies which make it difficult to ascribe any specific characteristic to all a nation\'s cars. Germany did, after all, produce the Porsche and Italy the Fiat. Some people will say that the best nation of car manufacturers is neither of these two, pointing to France\'s fine track record with Citroen and Renault among others. \r\n\r\nAs two of the world\'s predominant cultural influences, we might expect the US and the UK to be big hitters in the car industry, but it would be a stretch to put them up there with the aforementioned. Of the more recent arrivals on the scene, Japan has some fine manufacturers – but for most people it will come down to Germany vs Italy. A quick look at the grid for a Formula One race will back this up.", "Which Nation Makes The Best Cars? ", "", "publish", "open", "open", "", "which-nation-makes-the-best-cars", "", "", "2010-11-15 23:38:33", "2010-11-15 23:38:33", "", "0", "http://mywaytoprofits.com/cars/?p=9", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2010-11-15 23:38:27", "2010-11-15 23:38:27", "", "Which Nation Makes The Best Cars? ", "", "inherit", "open", "open", "", "9-revision", "", "", "2010-11-15 23:38:27", "2010-11-15 23:38:27", "", "9", "http://mywaytoprofits.com/cars/?p=10", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2010-11-15 23:38:44", "2010-11-15 23:38:44", "When we are young, we look at cars on the road and long for the day we can drive one of them. Just think – no more riding the bus, go where you want when you want and be in control of the habitat in which you travel. Sure, the car will cost some money up front, but after that it\'s all good. It all sounds pretty sweet. \r\n\r\nIt is only in adulthood that we see how the costs stack up. Sure, as kids we may have some understanding that we will need to fill the tank up every once in a while and that that will cost money. But you don\'t realize just how much it costs until you\'re driving to work and back every day and using the car for shopping and more. \r\n\r\nIf it were just the car and the gas that you had to pay for that would be one thing. However, for many people, the car has to be taken for a tune-up too often altogether. Some cars which look good and drive well for most of the time have a habit of developing a specific fault that cannot be conclusively repaired, merely taken care of. \r\n\r\nAnother cost which can drive you mad is the price of parking. It does not occur to a non-motorist just how much it can cost to leave your car somewhere safe. Some car parking charges are so expensive that they put motorists off any kind of visit that is not immediately vital – just another hidden cost of motoring.", "The Unseen Costs Of Motoring ", "", "publish", "open", "open", "", "the-unseen-costs-of-motoring", "", "", "2010-11-15 23:38:44", "2010-11-15 23:38:44", "", "0", "http://mywaytoprofits.com/cars/?p=11", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2010-11-15 23:38:37", "2010-11-15 23:38:37", "", "Auto Draft", "", "inherit", "open", "open", "", "11-revision", "", "", "2010-11-15 23:38:37", "2010-11-15 23:38:37", "", "11", "http://mywaytoprofits.com/cars/?p=12", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2010-11-15 23:38:59", "2010-11-15 23:38:59", "There are people among the environmental movement who will flat-out forswear ever driving a car because of the cost to the planet. It can admittedly be taxing on the environment to run a car, be it because of the fumes that are passed through the exhaust or the toll taken on the planet to build and fuel the car.  \r\n\r\nMost environmentalists will, however, reach some sort of compromise which entails driving a car that is more green than others. The first thing to look for in this respect is fuel economy. A car which gives you more miles per gallon of fuel will be more friendly to the environment, as the use of fossil fuels takes a toll on the planet. \r\n\r\nIn this light, it may be worth looking at some of the hybrid or alternative-fuel vehicles on the market. As the environmental movement grows in size and strength, these cars are becoming more prominent and choice is becoming greater. Some interesting new developments are taking place in the alternative fuels market, and these may make it more economical and more “green” to drive. \r\n\r\nSometimes, the deal with automobiles and the environment is not so much what you drive as how often you drive it. If you don\'t need to drive and the weather is good, walking can be pretty good fun anyway. Obviously, this is hardly going to win around the most hardened enviroskeptic, but when you realise that the trade-off is “fewer journeys = better performance” it\'s something to hold on to.", "The Environmental Issue Of Motoring ", "", "publish", "open", "open", "", "the-environmental-issue-of-motoring", "", "", "2010-11-15 23:38:59", "2010-11-15 23:38:59", "", "0", "http://mywaytoprofits.com/cars/?p=13", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2010-11-15 23:38:54", "2010-11-15 23:38:54", "", "The Environmental Issue Of Motoring ", "", "inherit", "open", "open", "", "13-revision", "", "", "2010-11-15 23:38:54", "2010-11-15 23:38:54", "", "13", "http://mywaytoprofits.com/cars/?p=14", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2010-11-15 23:39:18", "2010-11-15 23:39:18", "The car is, behind the human being at any rate, one of the most prominent features of both film and TV show. As famous as an actor can become for appearing on screen, some vehicles are not far behind them. Indeed, appearing in a TV show can give a car and its manufacturer a new commercial lease of life and make the vehicle iconic in a way which has little to do with its performance. \r\n\r\nPerhaps the most famous onscreen vehicle of all time is Herbie, the Volkswagen Beetle with a mind of its own. Star of films such as The Love Bug, Herbie Goes Bananas and the more recent Fully Loaded, the white Beetle with the number 53 on his bonnet was the central character in films featuring such Hollywood luminaries as Dean Jones and Lindsay Lohan. \r\n\r\nAlso famous, though more for an appearance in a TV show than in the less successful movie, is KITT (short for Knight Industries Two Thousand). In the original TV show, KITT was an artificially intelligent Pontiac Trans Am, who provided guidance and companionship for Michael Knight, a crime fighter played by a young David Hasselhoff. \r\n\r\nThere have of course been other famous vehicles of stage and screen. The General Lee, a 1969 Dodge Charger driven by the Hazzard brothers in the popular movei and TV show Dukes of Hazzard. The doors for the car were welded shut, meaning that the brothers had to enter via the window – something that every fan of the show will be able to tell you within a minute of talking about it.", "The Car Is The Star – Great Vehicles Of Hollywood ", "", "publish", "open", "open", "", "the-car-is-the-star-%e2%80%93-great-vehicles-of-hollywood", "", "", "2010-11-15 23:39:18", "2010-11-15 23:39:18", "", "0", "http://mywaytoprofits.com/cars/?p=15", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2010-11-15 23:39:11", "2010-11-15 23:39:11", "", "Auto Draft", "", "inherit", "open", "open", "", "15-revision", "", "", "2010-11-15 23:39:11", "2010-11-15 23:39:11", "", "15", "http://mywaytoprofits.com/cars/?p=16", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2010-11-15 23:39:52", "2010-11-15 23:39:52", "Ask around a number of car aficionados to find out which vehicle they would most like to have in their garage, and a suitably large number will state that the Bugatti Veyron is a very strong contender. It is not difficult to see why – the car itself looks like a sleek monster, and that\'s before the key goes anywhere near the ignition. \r\n\r\nWhat really sets the Veyron apart from any other car, apart from its million-dollar price tag, is the insane top speed of more than 267 miles per hour. This is a speed that can of course only be reached on particularly long stretches of open road, such as a race track, but the Veyron is a road-legal car, and its performance even at that high speed is noted as being incredibly stable. \r\n\r\nThe popular UK TV series Top Gear dubbed the original Veyron, with its comparatively slow top speed of nearly 254 mph, as the Car of the Decade. One of the few cars universally loved by all three presenters of the show (who disagree more than they agree), the Veyron is a brainchild of the German Volkswagen group and features ten radiators, sixteen valves, and more than a thousand horsepower. \r\n\r\nThe higher-end Veyron Super Sport clocks in at a price tage of $2,700,000/£1,665,000, meaning that as far as it being the ideal car goes, it is more or less a hypothetical issue for most of us. However, for those who are able to spend that kind of money on a car, the 0-60 speed of just two and a half seconds has to be something of a coup.", "Luxury Cars: The Bugatti Veyron ", "", "publish", "open", "open", "", "luxury-cars-the-bugatti-veyron", "", "", "2010-11-15 23:39:52", "2010-11-15 23:39:52", "", "0", "http://mywaytoprofits.com/cars/?p=17", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2010-11-15 23:39:47", "2010-11-15 23:39:47", "", "Luxury Cars: The Bugatti Veyron ", "", "inherit", "open", "open", "", "17-revision", "", "", "2010-11-15 23:39:47", "2010-11-15 23:39:47", "", "17", "http://mywaytoprofits.com/cars/?p=18", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2010-11-15 23:40:04", "2010-11-15 23:40:04", "Nitrous oxide is one of the most divisive issues for car enthusiasts in this day and age. As an add-on for souped-up cars, its most notable contribution is to take the top speed of the car a few notches higher, making it a popular inclusion for people who take part in drag races. However, there are many who caution against its use, saying that it makes the performance of a car dangerously unstable. \r\n\r\nThe skeptics most likely have a point. When a car is designed, the idea behind its top speed is that that speed is sustainable for at least a while, and that the car can be controlled while at that speed. Adding to that top speed makes the car less stable and is not good for the engine. If you have a car merely for drag races and have somewhere safe to race, then you may choose to go for it. Otherwise, “nitro” as it is commonly dubbed is a pretty bad idea. \r\n\r\nOf course we enjoy high speed in our cars, but the distinction between sustainable high speeds and unsustainable ones has to be made. A burst of nitro will only last for a few seconds, and that may suggest that its sparing use will not have implications for your vehicle, but the most concerning fact must be that at the speeds gained by nitro, it becomes a lot harder to control your vehicle, meaning that the first time you use it can be the last time you drive.", "Putting The Pedal To The Metal – Do You Want Nitro With That? ", "", "publish", "open", "open", "", "putting-the-pedal-to-the-metal-%e2%80%93-do-you-want-nitro-with-that", "", "", "2010-11-15 23:40:04", "2010-11-15 23:40:04", "", "0", "http://mywaytoprofits.com/cars/?p=19", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2010-11-15 23:39:57", "2010-11-15 23:39:57", "", "Auto Draft", "", "inherit", "open", "open", "", "19-revision", "", "", "2010-11-15 23:39:57", "2010-11-15 23:39:57", "", "19", "http://mywaytoprofits.com/cars/?p=20", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2010-11-15 23:40:18", "2010-11-15 23:40:18", "Can a car be a work of art? There are some who would suggest that the best automobiles out there are an example of art at its most practical. A lot of design goes into making a car aerodynamic and aesthetically pleasing, and fans of sports cars will often make the point that the car gets high speeds and performs well while looking beautiful enough to be exhibited in a museum. \r\n\r\nThe idea of a car as art has been taken to greater lengths by the art car movement, who take no chances with the aesthetic beauty of the original models by making additions that turn the car into something completely different. The movement is particularly strong in areas such as Houston and Minneapolis, with Houston being home to the world\'s first Art Car Museum. \r\n\r\nSeen by many as the father of the Art Car movement, Harrod Blank has made a number of films about the Art Car as well as writing books and articles, running a blog and curating the Art Car Fest, an art-car based parade held in the San Francisco bay area once a year and also has a hand in an art car camp at the Burning Man festival in Nevada. \r\n\r\nTo make an art car, all you need is a car, an idea and the materials to make it come to life. Of course, if you want the car to be road legal you need to make sure that it adheres to the laws that govern the roads you are driving on. Ideally, this means nothing blocking the driver\'s sight line and nothing that makes the vehicle unstable.", "A Touch Of Art – The Art Car  ", "", "publish", "open", "open", "", "a-touch-of-art-%e2%80%93-the-art-car", "", "", "2010-11-15 23:40:18", "2010-11-15 23:40:18", "", "0", "http://mywaytoprofits.com/cars/?p=21", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2010-11-15 23:40:12", "2010-11-15 23:40:12", "", "A Touch Of Art – The Art Car  ", "", "inherit", "open", "open", "", "21-revision", "", "", "2010-11-15 23:40:12", "2010-11-15 23:40:12", "", "21", "http://mywaytoprofits.com/cars/?p=22", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2010-11-15 23:40:29", "2010-11-15 23:40:29", "One of the most troubling issues regarding motoring, in any country, is that of people driving their cars while under the influence of alcohol. The laws governing acceptable drinking and driving differ in many countries, but just about every country in the world has a law regarding drinking and driving. The base point seems to be that it is something you just should not do. \r\n\r\nThe problem with drinking alcohol before getting behind the wheel of a car is that alcohol impairs reaction times and judgement. Many people will utter the oft-heard sentence “Well, I actually drive better when I have had a few.”. Even if this is objectively true, and it rarely is, it fails to take into account the fact that other drivers use the road too. \r\n\r\nTherefore, a driver who is technically intoxicated may be in better control of their own vehicle than you might expect, but their reaction times will be compromised. Therefore, if another road user has a problem which outs other drivers at risk, the driver who has had a few drinks will be less likely to succeed in pulling a manoeuvre that avoids a crash. \r\n\r\nThere can be any number of debating points made about the safety or otherwise of drinking and driving, but the key point is that if you make a mistake or are unable to perform a safety manoeuvre because your judgement is impaired by alcohol, you are at least partially responsible for the crash. So if you are out drinking, leave the car at home.", "Drinking And Driving – It\'s Never OK ", "", "publish", "open", "open", "", "drinking-and-driving-%e2%80%93-its-never-ok", "", "", "2010-11-15 23:40:29", "2010-11-15 23:40:29", "", "0", "http://mywaytoprofits.com/cars/?p=23", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("24", "1", "2010-11-15 23:40:25", "2010-11-15 23:40:25", "", "Drinking And Driving – It\'s Never OK ", "", "inherit", "open", "open", "", "23-revision", "", "", "2010-11-15 23:40:25", "2010-11-15 23:40:25", "", "23", "http://mywaytoprofits.com/cars/?p=24", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2010-11-15 23:40:41", "2010-11-15 23:40:41", "Laws governing drivers are often controversial, as one driver may be more skilful than others and less likely to make mistakes that will cause danger to other road users. This leads to the situation where a driver will say “I don\'t see why I should be penalised because I\'m a better driver than someone else”. To which the only reaction is: Sit down, shut up and deal with it. \r\n\r\nThis may be seen as an authoritarian response to a fair point, but the issue here is that a law must apply to everyone (within reason) in order to be in any way enforceable. If you happen to be really good at controlling a car even at high speeds, then pat yourself on the back and enjoy the adulation – but the fact is that in residential areas and other spots with high traffic, it is dangerous to drive above a certain speed. \r\n\r\nWe all like traveling at higher speeds. For one thing, it gets us where we are going in less time. But it does not take a scientist to recognise that a car traveling at 50 mph will do more damage to anything or anyone it hits than one traveling at 30. You can be as careful and as skilful as you like, but things happen in split seconds, and a line needs to be drawn somewhere. \r\n\r\nSome countries have no speed restrictions on their motorways, highways or autobahns, and this can work well in practice, but there is a necessity to keep speeds to a reasonable level on roads that are not designed for high speeds. ", "Road Safety: Kill Your Speed, Not A Person ", "", "publish", "open", "open", "", "road-safety-kill-your-speed-not-a-person", "", "", "2010-11-15 23:40:41", "2010-11-15 23:40:41", "", "0", "http://mywaytoprofits.com/cars/?p=25", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2010-11-15 23:40:33", "2010-11-15 23:40:33", "", "Auto Draft", "", "inherit", "open", "open", "", "25-revision", "", "", "2010-11-15 23:40:33", "2010-11-15 23:40:33", "", "25", "http://mywaytoprofits.com/cars/?p=26", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2010-11-15 23:41:07", "2010-11-15 23:41:07", "Some people drive the same car from the day they pass their test to the day that they decide to stop driving, or have that decision made for them. Others, and these are the larger group, will update their car on a more or less regular basis. There is a reason for this, and it is fairly simple. As cars get older, they become more prone to faults and some features may become obsolete. \r\n\r\nThere is a lot that you can to to keep your car more up to date, especially on the inside of the car. Any car in the world can accommodate a GPS satellite navigation system, although the newer models come with one already installed. Seatbelts were, once upon a time, optional in a car, but now they are compulsory with good reason. \r\n\r\nNewer cars are, in the main, cleaner and safer to drive than the older ones. This can be balanced against the fact that a driver may feel more comfortable, more at ease and therefore a better driver in a car they have driven for many years. But many of us will trade in for a newer model simply because it is less prone to faults. \r\n\r\nIn such cases it may be a good idea to trade your old car in for a small part of the cost of the newer model. There is always something that can be salvaged from an older car, and it may even be modified to make it more up to date.", "Trading In For A Younger Model ", "", "publish", "open", "open", "", "trading-in-for-a-younger-model", "", "", "2010-11-15 23:41:07", "2010-11-15 23:41:07", "", "0", "http://mywaytoprofits.com/cars/?p=27", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2010-11-15 23:41:02", "2010-11-15 23:41:02", "", "Trading In For A Younger Model ", "", "inherit", "open", "open", "", "27-revision", "", "", "2010-11-15 23:41:02", "2010-11-15 23:41:02", "", "27", "http://mywaytoprofits.com/cars/?p=28", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("29", "1", "2010-11-15 23:41:20", "2010-11-15 23:41:20", "Cars are like people, in many ways. They need to have the proper care taken of them and to be treated in a certain way if they are to keep running smoothly. The longer they are in service, the more likely they will be to develop faults. Eventually, they need to be retired before they do some harm to themselves or others. \r\n\r\nNumerous governments are now creating schemes whereby an older car can be traded in for money against the purchase of a new one. The thinking behind this is that older cars are both less safe and worse for the environment than newer ones, and the government can save money on future environmental protection by spending a small amount of money up front to ensure cleaner air. \r\n\r\nThe benefit for the motorist who trades in their car is that they save money on a newer car which they might otherwise not have been able to afford. It is an incentive which works to reduce the amount of pollution in the air and make the roads safer. The cash paid for the older cars, too, can be recouped in scrap costs and recycling. \r\n\r\nThere is some amount of controversy over such programs, with people arguing that it is a waste of government money that could be better spent elsewhere or not spent at all. In the end, any such program is best judged by its success, and these programs have been judged successful on balance. How often they will be repeated in future will depend on the economic climate.", "Cash For Clunkers: Trading In An Older Car For Cash ", "", "publish", "open", "open", "", "cash-for-clunkers-trading-in-an-older-car-for-cash", "", "", "2010-11-15 23:41:20", "2010-11-15 23:41:20", "", "0", "http://mywaytoprofits.com/cars/?p=29", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2010-11-15 23:41:12", "2010-11-15 23:41:12", "", "Auto Draft", "", "inherit", "open", "open", "", "29-revision", "", "", "2010-11-15 23:41:12", "2010-11-15 23:41:12", "", "29", "http://mywaytoprofits.com/cars/?p=30", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2010-11-15 23:41:31", "2010-11-15 23:41:31", "There will always be a number of people who enjoy taking their cars on to the open road and seeing just how fast they can go, something which has led to a fairly large number of unofficial “drag races” taking place on public roads. The argument usually made by the drivers in such races is that they only race on quiet roads, usually at times when no-one else is likely to be on the road. \r\n\r\nOne potential argument against this is that you can never be certain who will be on the road. After all, it is there for a reason – people need to get from one place to another. It is no use saying after you have crashed into another car that you thought the road would be deserted. It wasn\'t, and what you expected has absolutely no relevance to anyone killed or injured. \r\n\r\nAnother reason why drag races can be dangerous is in their very unregulated nature. Most car racing is carried out at tracks which have safety features as well as full emergency services – and professional car racers have still been known to die in high-speed crashes. When you are driving in an illegal drag race you have no such security to call on, and you can end up in real trouble as a result. \r\n\r\nAlthough it is often the illegal and unsanctioned nature of drag races that attracts people to drive in them, a certain amount of this bravado is born out of a sense that you\'ll be lucky. But you only have to be unlucky once to kill or injure yourself, a friend or another road user. Drag races, as fun as they may be, should be kept to race tracks.", "Road Safety: The Drag Race ", "", "publish", "open", "open", "", "road-safety-the-drag-race", "", "", "2010-11-15 23:41:31", "2010-11-15 23:41:31", "", "0", "http://mywaytoprofits.com/cars/?p=31", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2010-11-15 23:41:24", "2010-11-15 23:41:24", "", "Auto Draft", "", "inherit", "open", "open", "", "31-revision", "", "", "2010-11-15 23:41:24", "2010-11-15 23:41:24", "", "31", "http://mywaytoprofits.com/cars/?p=32", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2010-11-15 23:41:43", "2010-11-15 23:41:43", "The single word “car”  can be used to describe any one of a number of different kinds of vehicle, from the comfortable family sedan to the armored people carrier, and indeed to the sports cars that are driven around tracks by professional drivers. You\'ll never see a Formula One car on a public road outside of special circumstances, but it\'s a car all right. \r\n\r\nThe Formula One car has little in common with a road legal vehicle. The shape is different –  it is much lower and more aerodynamically proportioned. It is as small as it can safely be while containing a driver and the necessary safety features, and it is built for high speeds – faster than any road legal car. \r\n\r\nThe best Formula One drivers over the years have been the likes of Juan Manuel Fangio, Gilles Villeneuve, Ayrton Senna and Michael Schumacher. Although in many cases, these drivers have been helped by having the best car on the circuit, an uncommon level of skill and determination to win has set these men apart. Senna was tragically killed while competing in the San Marino Grand Prix in 1994, but statistically Formula One has had a low level of fatalities for all the speed of the races. \r\n\r\nFormula One is similar in many ways to its American cousin, Indycar racing. However, it is felt that the drivers at Formula One level are slightly more technically gifted and the cars more conducive to fast lapping than Indycars. Many young Indycar drivers will make a move to Formula One after succeeding in the States, while few will move the other way.", "Racing For Sport – Formula One Motor Racing", "", "publish", "open", "open", "", "racing-for-sport-%e2%80%93-formula-one-motor-racing", "", "", "2010-11-15 23:45:29", "2010-11-15 23:45:29", "", "0", "http://mywaytoprofits.com/cars/?p=33", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2010-11-15 23:41:35", "2010-11-15 23:41:35", "", "Auto Draft", "", "inherit", "open", "open", "", "33-revision", "", "", "2010-11-15 23:41:35", "2010-11-15 23:41:35", "", "33", "http://mywaytoprofits.com/cars/?p=34", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2010-11-15 23:41:54", "2010-11-15 23:41:54", "The popular US TV series Pimp Your Ride, which has been exported to other TV markets in recent years, is a logical conclusion to the popular hobby of auto modification. People all over the world look at their cars and think “I can make this better – faster and better looking, and it will corner better when I\'m done, too”. Basically, it\'s The Six Million Dollar Man but with cars. \r\n\r\nYou can modify your car to a greater or lesser extent. Some people will settle for a new paint job and perhaps some new wheels and hubcaps. There may be some improvement in the car\'s performance as a result, but the less modification you do, the less the improvement will be – in theory, at least. \r\n\r\nThere is, after all, such a thing as too much modification. You can tune up the engine, add things and take them away, and even – if you are inclined towards a daredevil approach – add nitrous oxide to the mix. You can add spoilers and tail fins to the car as well, for better road holding, but sometimes the theory and the practicalities do not match. \r\n\r\nThe basic message is that modification can be a mixed bag. If you know what to do and how to do it, then you can give a previously staid car a new lease of life, or bring an older car into line with some newer models. Or you might just settle for a cooler interior and a louder sound system. The choice is up to you, but please bear in mind that professionals make big money doing this for a reason – they\'re good at it and you might not be.", "Pimping Your Ride – Or Making Your Car Look And Drive Better", "", "publish", "open", "open", "", "pimping-your-ride-%e2%80%93-or-making-your-car-look-and-drive-better", "", "", "2010-11-15 23:45:24", "2010-11-15 23:45:24", "", "0", "http://mywaytoprofits.com/cars/?p=35", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2010-11-15 23:41:47", "2010-11-15 23:41:47", "", "Auto Draft", "", "inherit", "open", "open", "", "35-revision", "", "", "2010-11-15 23:41:47", "2010-11-15 23:41:47", "", "35", "http://mywaytoprofits.com/cars/?p=36", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2010-11-15 23:42:04", "2010-11-15 23:42:04", "Everyone likes a holiday every now and again, and if you can bring your car along then it can be even better. Knowing that you can go off the beaten track and holiday the way you want to has its attractions, ones nobody can deny. On the flip side, if you are holidaying in a country or a state where the laws are different from the ones you are used to, you need to be very careful. \r\n\r\nSome countries have quite radically different road laws than others. For example, British drivers may well find themselves overwhelmed on a German autobahn because, while the top speed on a British motorway is (technically) seventy miles an hour, German autobahns have no speed restrictions. This can make for a very steep learning curve. \r\n\r\nIf you are American and you visit London on holiday, you might also find that its takes some getting used to that British drivers drive on the left hand side of the road. It is something you learn quickly if you want to stay alive, of course, because everyone else is doing it – but it can make for some tricky moments at junctions and similar situations. \r\n\r\nThere are various other laws which can lead to drivers becoming unstuck, such as the French law which requires drivers to have high visibility vests in their cars at all times in case of breakdowns. In the main, you just need to do your research and acclimatise quickly to different laws. Once you\'ve done so, driving abroad is a blast.", "Driving Abroad – Know Your Laws", "", "publish", "open", "open", "", "driving-abroad-%e2%80%93-know-your-laws", "", "", "2010-11-15 23:55:03", "2010-11-15 23:55:03", "", "0", "http://mywaytoprofits.com/cars/?p=37", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2010-11-15 23:41:58", "2010-11-15 23:41:58", "", "Auto Draft", "", "inherit", "open", "open", "", "37-revision", "", "", "2010-11-15 23:41:58", "2010-11-15 23:41:58", "", "37", "http://mywaytoprofits.com/cars/?p=38", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2010-11-15 23:42:17", "2010-11-15 23:42:17", "It is a sad state of affairs that ordinary motoring is outside the reach of many a person in today\'s society because of the cost of automobiles. Even when bought on a finance plan, spreading the cost over years, it can still be tricky for someone on a low income to buy a car and drive it – not to mention the inherent instability of financing plans (lost your job? Lose your car, too!). \r\n\r\nHowever, there is the beginning of a movement to cheaper motoring taking place at the moment, and how successful this is may well govern whether the movement picks up pace and is joined by all or most vehicle manufacturers. The Tata Nano is believed by many to be the cheapest new-model motor car on the market and is bringing new cars within the price range of less well-off drivers. \r\n\r\nA low cost automobile will necessarily be less advanced than a mid-price or expensive model, but in order to get off the assembly line it will need to be safe to drive and workable as an option for motorists. If enough people drive the cheaper models – which are after all cheaper to make, too – then more companies will build similar models. \r\n\r\nHow many people want to drive budget vehicles is another matter. In a world where the car is often a status symbol, it is indeed tricky to take to the road in something that everyone knows was cheap. Additionally, most governments would agree that what they want is fewer cars on the road and not more. But for those who want it, at least one option is now there.", "The Cheapest Car On The Market?", "", "publish", "open", "open", "", "the-cheapest-car-on-the-market", "", "", "2010-11-15 23:54:58", "2010-11-15 23:54:58", "", "0", "http://mywaytoprofits.com/cars/?p=39", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2010-11-15 23:42:13", "2010-11-15 23:42:13", "", "The Cheapest Car On The Market? ", "", "inherit", "open", "open", "", "39-revision", "", "", "2010-11-15 23:42:13", "2010-11-15 23:42:13", "", "39", "http://mywaytoprofits.com/cars/?p=40", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2010-11-15 23:42:29", "2010-11-15 23:42:29", "Anyone who has played a reasonable number of video games will no doubt have played at least one which involves motor vehicles. The humble – or not so humble, as the case may be – automobile is the star of many video games and a supporting cast member in many others. Starting with motor racing games and continuing on through a great number of others, most of us have driven a video game car. \r\n\r\nThe wide range of sports car games reflects the number of sports which include automobiles. There are games which replicate Nascar, Formula One, Indycar, Touring Car and even Go-Karting. These are all fun to play and can give the player a real appreciation of the skill involved in these sports. Every player has their own favorites, and there are official tie-ins with all the major motor sports. \r\n\r\nThen again, there are other games which involve driving a car as one part of the game, of which the most famous would have to be Grand Theft Auto. In this series of games, you play a character (different games feature different ones) who has to carry out a range of tasks, many of which fall outside the law. In each of the games, as the name suggests, you can steal cars to aid you in carrying out the tasks. \r\n\r\nWhat these games permit you is the chance to indulge a wilder side. Certainly you cannot expect to get away with stealing a car in real life, and using it to drive into a crowd of enemies is completely inexcusable. But on a video game screen it doesn\'t matter – unless you have difficulty separating what is real from what is not.", "Cars In Video Games – Instilling A Passion For Driving", "", "publish", "open", "open", "", "cars-in-video-games-%e2%80%93-instilling-a-passion-for-driving", "", "", "2010-11-15 23:45:11", "2010-11-15 23:45:11", "", "0", "http://mywaytoprofits.com/cars/?p=41", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2010-11-15 23:42:22", "2010-11-15 23:42:22", "", "Auto Draft", "", "inherit", "open", "open", "", "41-revision", "", "", "2010-11-15 23:42:22", "2010-11-15 23:42:22", "", "41", "http://mywaytoprofits.com/cars/?p=42", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2010-11-15 23:42:47", "2010-11-15 23:42:47", "Although the legal age for driving differs between countries, one thing which they all have in common is that from an early age we all want to get behind the wheel of a car and drive it around. Indeed, many kids have a collection of toy cars at an early age, imbuing them with a desire to drive for real one day, and giving them an appreciation of which car they want it to be in. \r\n\r\nWhat is it that grabs us about cars before we are old enough to understand anything about them? For many of us, it is the fact that they allow us to travel so fast from one place to another, and the freedom that they seem to give. Faraway places have a powerful hold over us as children, and anything that gets us to them whenever we want to go will seem like a dream. The same fascination applies to aeroplanes. \r\n\r\nAdditionally, we see cars in virtually every TV show we like as older children. Whether it is a cop show that features a kick-ass law enforcer or anything else with a charismatic central character, we will want to be that person and want to drive what they drive. Herbie, KITT and the General Lee are three examples, and most of us between the ages of thirty and fifty can remember having one or more of these cars as toys. \r\n\r\nAs we get older, the car loses some of its mystique. If they have not done before the first time we take them in to have the clutch repaired, cars will certainly start to pale in terms of excitement when we have to pay for repairs. Nonetheless, we will still love them. Heck, many of us even name our cars.", "How We Fall In Love With Cars At An Early Age", "", "publish", "open", "open", "", "how-we-fall-in-love-with-cars-at-an-early-age", "", "", "2010-11-15 23:54:52", "2010-11-15 23:54:52", "", "0", "http://mywaytoprofits.com/cars/?p=43", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("44", "1", "2010-11-15 23:42:42", "2010-11-15 23:42:42", "", "How We Fall In Love With Cars At An Early Age ", "", "inherit", "open", "open", "", "43-revision", "", "", "2010-11-15 23:42:42", "2010-11-15 23:42:42", "", "43", "http://mywaytoprofits.com/cars/?p=44", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("45", "1", "2010-11-15 23:42:47", "2010-11-15 23:42:47", "Although the legal age for driving differs between countries, one thing which they all have in common is that from an early age we all want to get behind the wheel of a car and drive it around. Indeed, many kids have a collection of toy cars at an early age, imbuing them with a desire to drive for real one day, and giving them an appreciation of which car they want it to be in. \r\n\r\nWhat is it that grabs us about cars before we are old enough to understand anything about them? For many of us, it is the fact that they allow us to travel so fast from one place to another, and the freedom that they seem to give. Faraway places have a powerful hold over us as children, and anything that gets us to them whenever we want to go will seem like a dream. The same fascination applies to aeroplanes. \r\n\r\nAdditionally, we see cars in virtually every TV show we like as older children. Whether it is a cop show that features a kick-ass law enforcer or anything else with a charismatic central character, we will want to be that person and want to drive what they drive. Herbie, KITT and the General Lee are three examples, and most of us between the ages of thirty and fifty can remember having one or more of these cars as toys. \r\n\r\nAs we get older, the car loses some of its mystique. If they have not done before the first time we take them in to have the clutch repaired, cars will certainly start to pale in terms of excitement when we have to pay for repairs. Nonetheless, we will still love them. Heck, many of us even name our cars.", "How We Fall In Love With Cars At An Early Age ", "", "inherit", "open", "open", "", "43-revision-2", "", "", "2010-11-15 23:42:47", "2010-11-15 23:42:47", "", "43", "http://mywaytoprofits.com/cars/?p=45", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2010-11-15 23:42:29", "2010-11-15 23:42:29", "Anyone who has played a reasonable number of video games will no doubt have played at least one which involves motor vehicles. The humble – or not so humble, as the case may be – automobile is the star of many video games and a supporting cast member in many others. Starting with motor racing games and continuing on through a great number of others, most of us have driven a video game car. \r\n\r\nThe wide range of sports car games reflects the number of sports which include automobiles. There are games which replicate Nascar, Formula One, Indycar, Touring Car and even Go-Karting. These are all fun to play and can give the player a real appreciation of the skill involved in these sports. Every player has their own favorites, and there are official tie-ins with all the major motor sports. \r\n\r\nThen again, there are other games which involve driving a car as one part of the game, of which the most famous would have to be Grand Theft Auto. In this series of games, you play a character (different games feature different ones) who has to carry out a range of tasks, many of which fall outside the law. In each of the games, as the name suggests, you can steal cars to aid you in carrying out the tasks. \r\n\r\nWhat these games permit you is the chance to indulge a wilder side. Certainly you cannot expect to get away with stealing a car in real life, and using it to drive into a crowd of enemies is completely inexcusable. But on a video game screen it doesn\'t matter – unless you have difficulty separating what is real from what is not.", "Cars In Video Games – Instilling A Passion For Driving ", "", "inherit", "open", "open", "", "41-revision-2", "", "", "2010-11-15 23:42:29", "2010-11-15 23:42:29", "", "41", "http://mywaytoprofits.com/cars/?p=46", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2010-11-15 23:42:17", "2010-11-15 23:42:17", "It is a sad state of affairs that ordinary motoring is outside the reach of many a person in today\'s society because of the cost of automobiles. Even when bought on a finance plan, spreading the cost over years, it can still be tricky for someone on a low income to buy a car and drive it – not to mention the inherent instability of financing plans (lost your job? Lose your car, too!). \r\n\r\nHowever, there is the beginning of a movement to cheaper motoring taking place at the moment, and how successful this is may well govern whether the movement picks up pace and is joined by all or most vehicle manufacturers. The Tata Nano is believed by many to be the cheapest new-model motor car on the market and is bringing new cars within the price range of less well-off drivers. \r\n\r\nA low cost automobile will necessarily be less advanced than a mid-price or expensive model, but in order to get off the assembly line it will need to be safe to drive and workable as an option for motorists. If enough people drive the cheaper models – which are after all cheaper to make, too – then more companies will build similar models. \r\n\r\nHow many people want to drive budget vehicles is another matter. In a world where the car is often a status symbol, it is indeed tricky to take to the road in something that everyone knows was cheap. Additionally, most governments would agree that what they want is fewer cars on the road and not more. But for those who want it, at least one option is now there.", "The Cheapest Car On The Market? ", "", "inherit", "open", "open", "", "39-revision-2", "", "", "2010-11-15 23:42:17", "2010-11-15 23:42:17", "", "39", "http://mywaytoprofits.com/cars/?p=47", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2010-11-15 23:42:04", "2010-11-15 23:42:04", "Everyone likes a holiday every now and again, and if you can bring your car along then it can be even better. Knowing that you can go off the beaten track and holiday the way you want to has its attractions, ones nobody can deny. On the flip side, if you are holidaying in a country or a state where the laws are different from the ones you are used to, you need to be very careful. \r\n\r\nSome countries have quite radically different road laws than others. For example, British drivers may well find themselves overwhelmed on a German autobahn because, while the top speed on a British motorway is (technically) seventy miles an hour, German autobahns have no speed restrictions. This can make for a very steep learning curve. \r\n\r\nIf you are American and you visit London on holiday, you might also find that its takes some getting used to that British drivers drive on the left hand side of the road. It is something you learn quickly if you want to stay alive, of course, because everyone else is doing it – but it can make for some tricky moments at junctions and similar situations. \r\n\r\nThere are various other laws which can lead to drivers becoming unstuck, such as the French law which requires drivers to have high visibility vests in their cars at all times in case of breakdowns. In the main, you just need to do your research and acclimatise quickly to different laws. Once you\'ve done so, driving abroad is a blast.", "Driving Abroad – Know Your Laws ", "", "inherit", "open", "open", "", "37-revision-2", "", "", "2010-11-15 23:42:04", "2010-11-15 23:42:04", "", "37", "http://mywaytoprofits.com/cars/?p=48", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2010-11-15 23:41:54", "2010-11-15 23:41:54", "The popular US TV series Pimp Your Ride, which has been exported to other TV markets in recent years, is a logical conclusion to the popular hobby of auto modification. People all over the world look at their cars and think “I can make this better – faster and better looking, and it will corner better when I\'m done, too”. Basically, it\'s The Six Million Dollar Man but with cars. \r\n\r\nYou can modify your car to a greater or lesser extent. Some people will settle for a new paint job and perhaps some new wheels and hubcaps. There may be some improvement in the car\'s performance as a result, but the less modification you do, the less the improvement will be – in theory, at least. \r\n\r\nThere is, after all, such a thing as too much modification. You can tune up the engine, add things and take them away, and even – if you are inclined towards a daredevil approach – add nitrous oxide to the mix. You can add spoilers and tail fins to the car as well, for better road holding, but sometimes the theory and the practicalities do not match. \r\n\r\nThe basic message is that modification can be a mixed bag. If you know what to do and how to do it, then you can give a previously staid car a new lease of life, or bring an older car into line with some newer models. Or you might just settle for a cooler interior and a louder sound system. The choice is up to you, but please bear in mind that professionals make big money doing this for a reason – they\'re good at it and you might not be.", "Pimping Your Ride – Or Making Your Car Look And Drive Better ", "", "inherit", "open", "open", "", "35-revision-2", "", "", "2010-11-15 23:41:54", "2010-11-15 23:41:54", "", "35", "http://mywaytoprofits.com/cars/?p=49", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2010-11-15 23:41:43", "2010-11-15 23:41:43", "The single word “car”  can be used to describe any one of a number of different kinds of vehicle, from the comfortable family sedan to the armored people carrier, and indeed to the sports cars that are driven around tracks by professional drivers. You\'ll never see a Formula One car on a public road outside of special circumstances, but it\'s a car all right. \r\n\r\nThe Formula One car has little in common with a road legal vehicle. The shape is different –  it is much lower and more aerodynamically proportioned. It is as small as it can safely be while containing a driver and the necessary safety features, and it is built for high speeds – faster than any road legal car. \r\n\r\nThe best Formula One drivers over the years have been the likes of Juan Manuel Fangio, Gilles Villeneuve, Ayrton Senna and Michael Schumacher. Although in many cases, these drivers have been helped by having the best car on the circuit, an uncommon level of skill and determination to win has set these men apart. Senna was tragically killed while competing in the San Marino Grand Prix in 1994, but statistically Formula One has had a low level of fatalities for all the speed of the races. \r\n\r\nFormula One is similar in many ways to its American cousin, Indycar racing. However, it is felt that the drivers at Formula One level are slightly more technically gifted and the cars more conducive to fast lapping than Indycars. Many young Indycar drivers will make a move to Formula One after succeeding in the States, while few will move the other way.", "Racing For Sport – Formula One Motor Racing ", "", "inherit", "open", "open", "", "33-revision-2", "", "", "2010-11-15 23:41:43", "2010-11-15 23:41:43", "", "33", "http://mywaytoprofits.com/cars/?p=50", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2010-11-15 23:45:06", "2010-11-15 23:45:06", "Although the legal age for driving differs between countries, one thing which they all have in common is that from an early age we all want to get behind the wheel of a car and drive it around. Indeed, many kids have a collection of toy cars at an early age, imbuing them with a desire to drive for real one day, and giving them an appreciation of which car they want it to be in. \r\n\r\nWhat is it that grabs us about cars before we are old enough to understand anything about them? For many of us, it is the fact that they allow us to travel so fast from one place to another, and the freedom that they seem to give. Faraway places have a powerful hold over us as children, and anything that gets us to them whenever we want to go will seem like a dream. The same fascination applies to aeroplanes. \r\n\r\nAdditionally, we see cars in virtually every TV show we like as older children. Whether it is a cop show that features a kick-ass law enforcer or anything else with a charismatic central character, we will want to be that person and want to drive what they drive. Herbie, KITT and the General Lee are three examples, and most of us between the ages of thirty and fifty can remember having one or more of these cars as toys. \r\n\r\nAs we get older, the car loses some of its mystique. If they have not done before the first time we take them in to have the clutch repaired, cars will certainly start to pale in terms of excitement when we have to pay for repairs. Nonetheless, we will still love them. Heck, many of us even name our cars.", "How We Fall In Love With Cars At An Early Age", "", "inherit", "open", "open", "", "43-revision-3", "", "", "2010-11-15 23:45:06", "2010-11-15 23:45:06", "", "43", "http://mywaytoprofits.com/cars/?p=51", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2010-11-15 23:45:15", "2010-11-15 23:45:15", "It is a sad state of affairs that ordinary motoring is outside the reach of many a person in today\'s society because of the cost of automobiles. Even when bought on a finance plan, spreading the cost over years, it can still be tricky for someone on a low income to buy a car and drive it – not to mention the inherent instability of financing plans (lost your job? Lose your car, too!). \r\n\r\nHowever, there is the beginning of a movement to cheaper motoring taking place at the moment, and how successful this is may well govern whether the movement picks up pace and is joined by all or most vehicle manufacturers. The Tata Nano is believed by many to be the cheapest new-model motor car on the market and is bringing new cars within the price range of less well-off drivers. \r\n\r\nA low cost automobile will necessarily be less advanced than a mid-price or expensive model, but in order to get off the assembly line it will need to be safe to drive and workable as an option for motorists. If enough people drive the cheaper models – which are after all cheaper to make, too – then more companies will build similar models. \r\n\r\nHow many people want to drive budget vehicles is another matter. In a world where the car is often a status symbol, it is indeed tricky to take to the road in something that everyone knows was cheap. Additionally, most governments would agree that what they want is fewer cars on the road and not more. But for those who want it, at least one option is now there.", "The Cheapest Car On The Market?", "", "inherit", "open", "open", "", "39-revision-3", "", "", "2010-11-15 23:45:15", "2010-11-15 23:45:15", "", "39", "http://mywaytoprofits.com/cars/?p=52", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2010-11-15 23:45:19", "2010-11-15 23:45:19", "Everyone likes a holiday every now and again, and if you can bring your car along then it can be even better. Knowing that you can go off the beaten track and holiday the way you want to has its attractions, ones nobody can deny. On the flip side, if you are holidaying in a country or a state where the laws are different from the ones you are used to, you need to be very careful. \r\n\r\nSome countries have quite radically different road laws than others. For example, British drivers may well find themselves overwhelmed on a German autobahn because, while the top speed on a British motorway is (technically) seventy miles an hour, German autobahns have no speed restrictions. This can make for a very steep learning curve. \r\n\r\nIf you are American and you visit London on holiday, you might also find that its takes some getting used to that British drivers drive on the left hand side of the road. It is something you learn quickly if you want to stay alive, of course, because everyone else is doing it – but it can make for some tricky moments at junctions and similar situations. \r\n\r\nThere are various other laws which can lead to drivers becoming unstuck, such as the French law which requires drivers to have high visibility vests in their cars at all times in case of breakdowns. In the main, you just need to do your research and acclimatise quickly to different laws. Once you\'ve done so, driving abroad is a blast.", "Driving Abroad – Know Your Laws", "", "inherit", "open", "open", "", "37-revision-3", "", "", "2010-11-15 23:45:19", "2010-11-15 23:45:19", "", "37", "http://mywaytoprofits.com/cars/?p=53", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2010-11-28 23:17:25", "2010-11-28 23:17:25", "", "Store", "", "inherit", "open", "open", "", "54-revision", "", "", "2010-11-28 23:17:25", "2010-11-28 23:17:25", "", "54", "http://mywaytoprofits.com/cars/?p=55", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2010-11-28 23:17:38", "2010-11-28 23:17:38", "[tubepress]", "Cars Videos", "", "publish", "open", "open", "", "cars-videos", "", "", "2010-11-28 23:17:38", "2010-11-28 23:17:38", "", "0", "http://mywaytoprofits.com/cars/?page_id=56", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2010-11-28 23:17:34", "2010-11-28 23:17:34", "", "Cars Videos", "", "inherit", "open", "open", "", "56-revision", "", "", "2010-11-28 23:17:34", "2010-11-28 23:17:34", "", "56", "http://mywaytoprofits.com/cars/?p=57", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2010-11-28 23:18:03", "2010-11-28 23:18:03", "<!--contact form-->", "Contact Us", "", "publish", "open", "open", "", "contact-us", "", "", "2010-11-28 23:18:03", "2010-11-28 23:18:03", "", "0", "http://mywaytoprofits.com/cars/?page_id=58", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2010-11-28 23:17:45", "2010-11-28 23:17:45", "", "Contact Us", "", "inherit", "open", "open", "", "58-revision", "", "", "2010-11-28 23:17:45", "2010-11-28 23:17:45", "", "58", "http://mywaytoprofits.com/cars/?p=59", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("60", "1", "2010-11-28 23:18:21", "2010-11-28 23:18:21", " <!-- privacy-policy -->", "Privacy Policy", "", "publish", "open", "open", "", "privacy-policy", "", "", "2010-11-28 23:18:21", "2010-11-28 23:18:21", "", "0", "http://mywaytoprofits.com/cars/?page_id=60", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("61", "1", "2010-11-28 23:18:19", "2010-11-28 23:18:19", "", "Privacy Policy", "", "inherit", "open", "open", "", "60-revision", "", "", "2010-11-28 23:18:19", "2010-11-28 23:18:19", "", "60", "http://mywaytoprofits.com/cars/?p=61", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("62", "1", "2015-01-07 22:32:39", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "open", "open", "", "", "", "", "2015-01-07 22:32:39", "0000-00-00 00:00:00", "", "0", "http://demobay.com/cars/?p=62", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("63", "1", "2015-01-07 22:49:37", "2015-01-07 22:49:37", "", "160x600-highres", "", "inherit", "open", "open", "", "160x600-highres", "", "", "2015-01-07 22:49:37", "2015-01-07 22:49:37", "", "0", "http://demobay.info/cars/wp-content/uploads/2015/01/160x600-highres.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2015-01-07 22:55:51", "2015-01-07 22:55:51", "", "120x600.spraypaint", "", "inherit", "open", "open", "", "120x600-spraypaint", "", "", "2015-01-07 22:55:51", "2015-01-07 22:55:51", "", "0", "http://demobay.info/cars/wp-content/uploads/2015/01/120x600.spraypaint.jpg", "0", "attachment", "image/jpeg", "0");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("1", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("2", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("3", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("4", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("5", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("6", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("7", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("5", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("7", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("9", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("11", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("13", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("15", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("17", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("19", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("21", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("23", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("25", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("27", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("29", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("31", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("43", "5", "0");
INSERT INTO `wp_term_relationships` VALUES("33", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("35", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("39", "4", "0");
INSERT INTO `wp_term_relationships` VALUES("41", "4", "0");
INSERT INTO `wp_term_relationships` VALUES("43", "4", "0");
INSERT INTO `wp_term_relationships` VALUES("39", "5", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "5", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "14");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "link_category", "", "0", "7");
INSERT INTO `wp_term_taxonomy` VALUES("3", "3", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("4", "4", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("5", "5", "category", "", "0", "3");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "Everything About Cars", "everything-about-cars", "0");
INSERT INTO `wp_terms` VALUES("2", "Blogroll", "blogroll", "0");
INSERT INTO `wp_terms` VALUES("3", "Things You Should Know...", "things-you-should-know", "0");
INSERT INTO `wp_terms` VALUES("4", "How to Tips...", "how-to-tips", "0");
INSERT INTO `wp_terms` VALUES("5", "Featured", "featured", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("2", "1", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("3", "1", "nickname", "admin");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("7", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("8", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("9", "1", "aim", "");
INSERT INTO `wp_usermeta` VALUES("10", "1", "yim", "");
INSERT INTO `wp_usermeta` VALUES("11", "1", "jabber", "");
INSERT INTO `wp_usermeta` VALUES("12", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";s:1:\"1\";}");
INSERT INTO `wp_usermeta` VALUES("13", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("14", "1", "wp_dashboard_quick_press_last_post_id", "62");
INSERT INTO `wp_usermeta` VALUES("15", "1", "wp_user-settings", "m1=c&editor=html&m5=c&m6=c&m9=c&m0=c&m4=o");
INSERT INTO `wp_usermeta` VALUES("16", "1", "wp_user-settings-time", "1290986088");
INSERT INTO `wp_usermeta` VALUES("17", "1", "session_tokens", "a:1:{s:64:\"b8d8cf86bedab8ed65d1ee5e45a1e4c1cce561292326ebd9b7efd6155abb66bb\";i:1421879557;}");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "admin", "$P$BKuSdTMUQrfwABw9iZLTHruk4Gprrg/", "Admin", "plrboy@plrtruoi654boy.com", "", "2010-11-15 23:34:15", "", "0", "Admin");

SET FOREIGN_KEY_CHECKS = 1; 

/* DUPLICATOR MYSQL SCRIPT END ON : January 7, 2015, 11:05 pm */

/* DUPLICATOR_MYSQLDUMP_EOF */

